/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.config;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChangeListener;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;

public class AnalyzerSettingsDialog
extends ClosableDialog
implements ConfigurationChangeListener {
    private Component configPanel;
    private ConfigurationChanger confChanger;

    public AnalyzerSettingsDialog(Dialog owner, Component configPanel, List<ConfigurationChangeListener> ccList) throws HeadlessException {
        super(owner, true);
        this.configPanel = configPanel;
        this.initListeners(ccList);
        this.initComponents();
    }

    public AnalyzerSettingsDialog(Frame owner, Component configPanel, List<ConfigurationChangeListener> ccList) throws HeadlessException {
        super(owner, true);
        this.configPanel = configPanel;
        this.initListeners(ccList);
        this.initComponents();
    }

    private void initListeners(List<ConfigurationChangeListener> ccList) {
        if (this.configPanel instanceof ConfigurationChanger) {
            this.confChanger = (ConfigurationChanger)this.configPanel;
            this.confChanger.addConfigurationChangeListener((ConfigurationChangeListener)this);
            if (ccList != null) {
                for (ConfigurationChangeListener ccl : ccList) {
                    this.confChanger.addConfigurationChangeListener(ccl);
                }
            }
        }
    }

    private void initComponents() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        EmptyBorder marginBorder = new EmptyBorder(4, 6, 4, 6);
        TitledBorder titledBorder = new TitledBorder(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureSettings"));
        contentPane.setBorder(new CompoundBorder(marginBorder, titledBorder));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        contentPane.add((Component)new JScrollPane(this.configPanel), gbc);
        this.setContentPane(contentPane);
    }

    public void configurationChanged(final ConfigurationChanger cc) {
        this.setVisible(false);
        this.dispose();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                cc.removeAllListeners();
            }
        });
    }
}

