/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTNode;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTNodeRenderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

public class IGTAnnotation
implements IGTNode {
    private IGTNode parent;
    private IGTTier igtTier;
    private List<IGTNode> children;
    private IGTNodeRenderInfo renderInfo;
    private String text;
    private AbstractAnnotation annotation;
    private int hashCodeOfText;

    public IGTAnnotation(AbstractAnnotation aa) {
        this.annotation = aa;
        this.renderInfo = new IGTNodeRenderInfo();
    }

    public IGTAnnotation(String text) {
        this.annotation = null;
        this.text = text;
        this.renderInfo = new IGTNodeRenderInfo();
    }

    public AbstractAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(AbstractAnnotation aa) {
        this.annotation = aa;
        this.text = null;
        this.hashCodeOfText = 0;
    }

    public String getTextValue() {
        if (this.annotation != null) {
            return this.annotation.getValue();
        }
        if (this.text != null) {
            return this.text;
        }
        return "";
    }

    public void setTextForNode(String text) {
        this.text = text;
        this.annotation = null;
        this.hashCodeOfText = 0;
    }

    @Override
    public IGTNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IGTNode node) {
        this.parent = node;
    }

    @Override
    public List<IGTNode> getChildren() {
        return this.children;
    }

    @Override
    public Map<IGTTier, List<IGTNode>> getChildrenPerTier() {
        if (this.children != null) {
            HashMap<IGTTier, List<IGTNode>> nodeMap = new HashMap<IGTTier, List<IGTNode>>();
            for (IGTNode n : this.children) {
                if (!nodeMap.containsKey(n.getIGTTier())) {
                    nodeMap.put(n.getIGTTier(), new ArrayList());
                }
                ((List)nodeMap.get(n.getIGTTier())).add(n);
            }
            return nodeMap;
        }
        return null;
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public int getIndex(IGTNode node) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(node);
    }

    @Override
    public IGTNode getChildAfter(IGTNode node) {
        if (this.children != null) {
            int index = this.children.indexOf(node);
            if (index == -1) {
                return null;
            }
            if (index < this.children.size() - 1) {
                return this.children.get(index + 1);
            }
        }
        return null;
    }

    @Override
    public IGTNode getChildBefore(IGTNode node) {
        if (this.children != null) {
            int index = this.children.indexOf(node);
            if (index == -1) {
                return null;
            }
            if (index > 0) {
                return this.children.get(index - 1);
            }
        }
        return null;
    }

    @Override
    public boolean addChild(IGTNode node) {
        if (node == null) {
            return false;
        }
        if (this.children == null) {
            this.children = new ArrayList<IGTNode>();
        }
        if (this.children.contains(node)) {
            return false;
        }
        this.children.add(node);
        node.setParent(this);
        this.hashCodeOfText = 0;
        return true;
    }

    @Override
    public boolean removeChild(IGTNode node) {
        if (this.children == null) {
            return false;
        }
        node.setParent(null);
        this.hashCodeOfText = 0;
        return this.children.remove(node);
    }

    @Override
    public boolean insertChild(IGTNode node, int index) {
        if (node == null || index < 0) {
            return false;
        }
        if (this.children == null) {
            this.children = new ArrayList<IGTNode>();
        }
        if (index > this.children.size()) {
            return false;
        }
        node.setParent(this);
        this.children.add(index, node);
        this.hashCodeOfText = 0;
        return true;
    }

    @Override
    public IGTTier getIGTTier() {
        return this.igtTier;
    }

    @Override
    public void setIGTTier(IGTTier igtTier) {
        this.igtTier = igtTier;
    }

    @Override
    public void setRenderInfo(IGTNodeRenderInfo renderInfo) {
        this.renderInfo = renderInfo;
    }

    @Override
    public IGTNodeRenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    @Override
    public int hashCodeOfText() {
        if (this.hashCodeOfText == 0) {
            int result = this.getTextValue().hashCode();
            if (this.children != null) {
                for (IGTNode child : this.children) {
                    long m = (long)result * 37L;
                    result = (int)(m & 0xFFFFFFFFFFFFFFFFL) + child.hashCodeOfText() + (int)(m >>> 32);
                }
            }
            this.hashCodeOfText = result;
        }
        return this.hashCodeOfText;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("IGTAnnotation:['");
        buf.append(this.getTextValue());
        IGTNodeRenderInfo ri = this.getRenderInfo();
        buf.append("' x=");
        buf.append(String.valueOf(ri.x));
        buf.append(" y=");
        buf.append(String.valueOf(ri.y));
        buf.append(" w=");
        buf.append(String.valueOf(ri.width));
        buf.append(" h=");
        buf.append(String.valueOf(ri.height));
        buf.append(" realW=");
        buf.append(String.valueOf(ri.realWidth));
        buf.append(" calcW=");
        buf.append(String.valueOf(ri.calcWidth));
        buf.append(" children=");
        buf.append(String.valueOf(this.children));
        buf.append("]");
        return buf.toString();
    }
}

