/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.interlinear.IGTTierType;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTDataModelEvent;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTDataModelListener;
import mpi.eudico.client.annotator.interlinear.edit.event.ModelEventType;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAbstractDataModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTNode;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTRowHeader;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTBlockRenderInfo;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.util.TimeFormatter;

public class IGTDefaultModel
extends IGTAbstractDataModel {
    private int numInitializedSpecialTiers = 0;
    private long beginTime;
    private long endTime;

    public IGTDefaultModel(AlignableAnnotation rootAnnotation, Collection<String> hiddenTiers) {
        this(rootAnnotation, hiddenTiers, null);
    }

    public IGTDefaultModel(AlignableAnnotation rootAnnotation, Collection<String> hiddenTiers, Collection<IGTTierType> hiddenSpecialTiers) {
        this.rowData = new ArrayList();
        this.rowHeader = new IGTRowHeader();
        this.renderInfo = new IGTBlockRenderInfo();
        this.listeners = new ArrayList(4);
        this.fillTable(rootAnnotation, hiddenTiers, hiddenSpecialTiers);
    }

    private void fillTable(AlignableAnnotation rootAnnotation, Collection<String> hiddenTiers, Collection<IGTTierType> hiddenSpecialTiers) {
        this.beginTime = rootAnnotation.getBeginTimeBoundary();
        this.endTime = rootAnnotation.getEndTimeBoundary();
        IGTAnnotation rootIA = new IGTAnnotation(rootAnnotation);
        IGTTier rootTier = new IGTTier(((TierImpl)rootAnnotation.getTier()).getName(), IGTTierType.ROOT);
        this.rowData.add(rootTier);
        this.rowHeader.addHeader(rootTier.getTierName());
        rootTier.addAnnotation(rootIA);
        this.addDependingTiersNodes(rootTier, (TierImpl)rootAnnotation.getTier(), hiddenTiers);
        this.addChildrenToNode(rootAnnotation.getParentListeners(), rootIA, false);
        this.addSpecialTiers(rootIA, hiddenSpecialTiers);
    }

    private void addDependingTiersNodes(IGTTier parentTierNode, TierImpl parentTier, Collection<String> hiddenTiers) {
        List<TierImpl> depTiers = parentTier.getChildTiers();
        if (depTiers != null) {
            for (TierImpl dt : depTiers) {
                if (hiddenTiers != null && hiddenTiers.contains(dt.getName())) continue;
                IGTTier igtTier = this.createIGTTier(dt.getName(), parentTierNode, dt);
                if (this.numInitializedSpecialTiers > 0) {
                    int insertIndex = this.rowData.size() - this.numInitializedSpecialTiers;
                    this.rowData.add(insertIndex, igtTier);
                    this.rowHeader.addHeader(insertIndex, igtTier.getTierName());
                } else {
                    this.rowData.add(igtTier);
                    this.rowHeader.addHeader(igtTier.getTierName());
                }
                this.addDependingTiersNodes(igtTier, dt, hiddenTiers);
            }
        }
    }

    private IGTTier createIGTTier(String tierName, IGTTier parentTier, TierImpl tier) {
        boolean inWLBlock;
        IGTTierType type;
        Constraint c = tier.getLinguisticType().getConstraints();
        switch (c.getStereoType()) {
            case 4: {
                if (parentTier.getType() == IGTTierType.ROOT) {
                    type = IGTTierType.FIRST_LEVEL_ASSOCIATION;
                    inWLBlock = false;
                    break;
                }
                type = IGTTierType.DEEPER_LEVEL_ASSOCIATION;
                inWLBlock = parentTier.isInWordLevelBlock();
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                if (!parentTier.isInWordLevelBlock()) {
                    type = IGTTierType.WORD_LEVEL_ROOT;
                    inWLBlock = true;
                    break;
                }
                type = IGTTierType.SUBDIVISION;
                inWLBlock = true;
                break;
            }
            default: {
                type = IGTTierType.ASSOCIATION;
                inWLBlock = parentTier.isInWordLevelBlock();
            }
        }
        IGTTier igtTier = new IGTTier(tierName, type, inWLBlock);
        parentTier.addChildTier(igtTier);
        igtTier.setParentTier(parentTier);
        return igtTier;
    }

    private void addChildrenToNode(List<Annotation> childAnnos, IGTAnnotation parentNode, boolean createTiersWhenMissing) {
        ArrayList<AbstractAnnotation> group;
        String tierName;
        if (childAnnos == null || parentNode == null) {
            return;
        }
        IGTTier parentTier = parentNode.getIGTTier();
        HashMap<String, ArrayList<AbstractAnnotation>> amap = new HashMap<String, ArrayList<AbstractAnnotation>>();
        for (int i = 0; i < childAnnos.size(); ++i) {
            AbstractAnnotation aa = (AbstractAnnotation)childAnnos.get(i);
            tierName = aa.getTier().getName();
            group = (ArrayList<AbstractAnnotation>)amap.get(tierName);
            if (group == null) {
                group = new ArrayList<AbstractAnnotation>();
                amap.put(tierName, group);
            }
            group.add(aa);
        }
        for (Map.Entry e : amap.entrySet()) {
            IGTTier igtTier;
            tierName = (String)e.getKey();
            group = (List)e.getValue();
            int tierIndex = this.getRowIndexForTier(tierName);
            if (tierIndex == -1) {
                if (!createTiersWhenMissing) continue;
                igtTier = null;
            } else {
                igtTier = (IGTTier)this.rowData.get(tierIndex);
            }
            if (group.size() > 1) {
                Collections.sort(group, new AAComparator());
            }
            for (AbstractAnnotation aa : group) {
                if (igtTier == null) {
                    igtTier = this.createIGTTier(tierName, parentTier, (TierImpl)aa.getTier());
                    this.rowData.add(igtTier);
                    this.rowHeader.addHeader(tierName);
                }
                IGTAnnotation ia = new IGTAnnotation(aa);
                igtTier.addAnnotation(ia);
                parentNode.addChild(ia);
                List<Annotation> nextChildren = aa.getParentListeners();
                if (nextChildren.size() <= 0) continue;
                this.addChildrenToNode(nextChildren, ia, createTiersWhenMissing);
            }
        }
    }

    private void addSpecialTiers(IGTAnnotation root, Collection<IGTTierType> hiddenSpecialTiers) {
        long bt = this.getBeginTime();
        long et = this.getEndTime();
        if (hiddenSpecialTiers == null || !hiddenSpecialTiers.contains((Object)IGTTierType.SPEAKER_LABEL)) {
            String speaker = ((TierImpl)root.getAnnotation().getTier()).getParticipant();
            if (speaker == null) {
                speaker = "   ";
            }
            this.addSpecialTier(root, IGTTierType.SPEAKER_LABEL, speaker);
        }
        if (hiddenSpecialTiers == null || !hiddenSpecialTiers.contains((Object)IGTTierType.TIME_CODE)) {
            this.addSpecialTier(root, IGTTierType.TIME_CODE, TimeFormatter.toString(bt) + " - " + TimeFormatter.toString(et));
        }
    }

    private void addSpecialTier(IGTAnnotation root, IGTTierType tierType, String annotationText) {
        IGTAnnotation annNode = new IGTAnnotation(annotationText);
        root.addChild(annNode);
        IGTTier tierNode = new IGTTier(tierType.label(), tierType);
        tierNode.addAnnotation(annNode);
        if (tierType == IGTTierType.SPEAKER_LABEL && this.numInitializedSpecialTiers > 0) {
            int insertIndex = this.rowData.size() - this.numInitializedSpecialTiers;
            this.rowData.add(insertIndex, tierNode);
            this.rowHeader.addHeader(insertIndex, tierType.label());
        } else {
            this.rowData.add(tierNode);
            this.rowHeader.addHeader(tierType.label());
        }
        root.getIGTTier().addChildTier(tierNode);
        tierNode.setParentTier(root.getIGTTier());
        ++this.numInitializedSpecialTiers;
    }

    private void removeSpecialTier(IGTAnnotation rootIA, IGTTierType tierType) {
        IGTTier specTier = this.getRowDataForTier(tierType.label());
        if (specTier != null && specTier.isSpecial()) {
            rootIA.removeChild(specTier.getAnnotations().get(0));
            if (specTier.getParentTier() != null) {
                specTier.getParentTier().removeChildTier(specTier);
                specTier.setParentTier(null);
            }
            this.rowData.remove(specTier);
            this.rowHeader.removeHeader(specTier.getTierName());
            --this.numInitializedSpecialTiers;
        }
    }

    private void updateTimeCodeTier() {
        IGTTier tcTier = this.getRowDataForTier(IGTTierType.TIME_CODE.label());
        if (tcTier != null) {
            IGTAnnotation tcAnn = tcTier.getAnnotations().get(0);
            String text = TimeFormatter.toString(this.getBeginTime()) + " - " + TimeFormatter.toString(this.getEndTime());
            tcAnn.setTextForNode(text);
        }
    }

    @Override
    public long getBeginTime() {
        return this.beginTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setSpecialTierVisibility(IGTTierType specialTier, boolean visible) {
        String annotationText = null;
        IGTAnnotation rootIA = this.getRootRow().getAnnotations().get(0);
        switch (specialTier) {
            case TIME_CODE: {
                if (!visible) break;
                annotationText = String.format("%s - %s", TimeFormatter.toString(this.getBeginTime()), TimeFormatter.toString(this.getEndTime()));
                break;
            }
            case SPEAKER_LABEL: {
                if (!visible || (annotationText = rootIA.getAnnotation().getTier().getParticipant()) != null) break;
                annotationText = "   ";
                break;
            }
            default: {
                return;
            }
        }
        if (!visible) {
            this.removeSpecialTier(rootIA, specialTier);
        } else {
            IGTTier specTier = this.getRowDataForTier(specialTier.label());
            if (specTier == null) {
                this.addSpecialTier(rootIA, specialTier, annotationText);
            }
        }
    }

    @Override
    public boolean getSpecialTierVisibility(IGTTierType specialTier) {
        return this.getRowDataForTier(specialTier.label()) != null;
    }

    public void annotationAdded(AbstractAnnotation annotation) {
        if (annotation != null) {
            IGTTier chTier = this.getRowDataForTier(annotation.getTier().getName());
            if (chTier == null) {
                return;
            }
            IGTTier parTier = chTier.getParentTier();
            if (parTier == null) {
                return;
            }
            ArrayList<IGTAnnotation> parAnns = parTier.getAnnotations();
            for (IGTAnnotation parAnn : parAnns) {
                if (parAnn.getAnnotation().getBeginTimeBoundary() > annotation.getBeginTimeBoundary() || parAnn.getAnnotation().getEndTimeBoundary() < annotation.getEndTimeBoundary()) continue;
                this.annotationAdded(chTier, annotation, parAnn);
                break;
            }
        }
    }

    private void annotationAdded(IGTTier annotationIGTTier, AbstractAnnotation addedAnnotation, IGTAnnotation parAnn) {
        IGTAnnotation addedIgtAnn = new IGTAnnotation(addedAnnotation);
        boolean inserted = false;
        Map<IGTTier, List<IGTNode>> childMap = parAnn.getChildrenPerTier();
        if (childMap != null) {
            List<IGTNode> childList = childMap.get(annotationIGTTier);
            if (childList != null) {
                int childListSize = childList.size();
                for (int k = 0; k < childListSize; ++k) {
                    IGTAnnotation child = (IGTAnnotation)childList.get(k);
                    if (child.getAnnotation().getBeginTimeBoundary() >= addedAnnotation.getEndTimeBoundary()) {
                        inserted = parAnn.insertChild(addedIgtAnn, k);
                        continue;
                    }
                    if (k != childListSize - 1) continue;
                    inserted = parAnn.addChild(addedIgtAnn);
                }
            } else {
                inserted = parAnn.addChild(addedIgtAnn);
            }
        } else {
            inserted = parAnn.addChild(addedIgtAnn);
        }
        if (inserted) {
            if (annotationIGTTier.getAnnotations().isEmpty()) {
                annotationIGTTier.addAnnotation(addedIgtAnn);
            } else {
                for (int n = 0; n < annotationIGTTier.getAnnotations().size(); ++n) {
                    IGTAnnotation child = annotationIGTTier.getAnnotations().get(n);
                    if (child.getAnnotation().getBeginTimeBoundary() >= addedAnnotation.getEndTimeBoundary()) {
                        annotationIGTTier.insertAnnotation(addedIgtAnn, n);
                        break;
                    }
                    if (n != annotationIGTTier.getAnnotations().size() - 1) continue;
                    annotationIGTTier.addAnnotation(addedIgtAnn);
                    break;
                }
            }
            IGTDataModelEvent event = new IGTDataModelEvent(this, annotationIGTTier, addedIgtAnn, ModelEventType.ADD);
            this.postEvent(event);
            this.addChildrenOfNewAnnotation(addedAnnotation, addedIgtAnn);
        }
    }

    private void addChildrenOfNewAnnotation(AbstractAnnotation addedAnnotation, IGTAnnotation addedIgtAnn) {
        List<Annotation> newChildren = addedAnnotation.getParentListeners();
        for (Annotation child : newChildren) {
            IGTTier igtTier = this.getRowDataForTier(child.getTier().getName());
            if (igtTier == null) continue;
            this.annotationAdded(igtTier, (AbstractAnnotation)child, addedIgtAnn);
        }
    }

    public void annotationAddedAfter(AbstractAnnotation addedAnnotation, AbstractAnnotation afterThis) {
        IGTTier chTier;
        if (addedAnnotation != null && afterThis != null && (chTier = this.getRowDataForTier(addedAnnotation.getTier().getName())) != null) {
            int numAnns = chTier.getAnnotations().size();
            for (int i = 0; i < numAnns; ++i) {
                IGTAnnotation afterAnn = chTier.getAnnotations().get(i);
                if (afterAnn.getAnnotation() != afterThis) continue;
                IGTAnnotation addedIgtAnn = new IGTAnnotation(addedAnnotation);
                boolean inserted = false;
                IGTAnnotation parAnn = (IGTAnnotation)afterAnn.getParent();
                int afterIndex = parAnn.getIndex(afterAnn);
                if (afterIndex > -1) {
                    inserted = afterIndex < parAnn.getChildCount() ? parAnn.insertChild(addedIgtAnn, afterIndex + 1) : parAnn.addChild(addedIgtAnn);
                }
                if (!inserted) continue;
                if (i < numAnns - 2) {
                    chTier.insertAnnotation(addedIgtAnn, i + 1);
                } else {
                    chTier.addAnnotation(addedIgtAnn);
                }
                IGTDataModelEvent event = new IGTDataModelEvent(this, chTier, addedIgtAnn, ModelEventType.ADD);
                this.postEvent(event);
                this.addChildrenOfNewAnnotation(addedAnnotation, addedIgtAnn);
                break;
            }
        }
    }

    public void annotationAddedBefore(AbstractAnnotation addedAnnotation, AbstractAnnotation beforeThis) {
        IGTTier chTier;
        if (addedAnnotation != null && beforeThis != null && (chTier = this.getRowDataForTier(addedAnnotation.getTier().getName())) != null) {
            int numAnns = chTier.getAnnotations().size();
            for (int i = 0; i < numAnns; ++i) {
                IGTAnnotation beforeAnn = chTier.getAnnotations().get(i);
                if (beforeAnn.getAnnotation() != beforeThis) continue;
                IGTAnnotation addedIgtAnn = new IGTAnnotation(addedAnnotation);
                boolean inserted = false;
                IGTAnnotation parAnn = (IGTAnnotation)beforeAnn.getParent();
                int beforeIndex = parAnn.getIndex(beforeAnn);
                if (beforeIndex > -1) {
                    inserted = parAnn.insertChild(addedIgtAnn, beforeIndex);
                }
                if (!inserted) continue;
                chTier.insertAnnotation(addedIgtAnn, i);
                IGTDataModelEvent event = new IGTDataModelEvent(this, chTier, addedIgtAnn, ModelEventType.ADD);
                this.postEvent(event);
                this.addChildrenOfNewAnnotation(addedAnnotation, addedIgtAnn);
                break;
            }
        }
    }

    public void annotationValueChanged(AbstractAnnotation annotation) {
        IGTTier chTier;
        if (annotation != null && (chTier = this.getRowDataForTier(annotation.getTier().getName())) != null) {
            int numAnns = chTier.getAnnotations().size();
            for (int i = 0; i < numAnns; ++i) {
                IGTAnnotation igtAnn = chTier.getAnnotations().get(i);
                if (igtAnn.getAnnotation() != annotation) continue;
                if (numAnns == 1 && chTier == this.getRootRow()) {
                    long newBeginTime = annotation.getBeginTimeBoundary();
                    long newEndTime = annotation.getEndTimeBoundary();
                    if (newBeginTime != this.beginTime || newEndTime != this.endTime) {
                        this.beginTime = newBeginTime;
                        this.endTime = newEndTime;
                        this.updateTimeCodeTier();
                    }
                }
                IGTDataModelEvent event = new IGTDataModelEvent(this, chTier, igtAnn, ModelEventType.CHANGE);
                this.postEvent(event);
                break;
            }
        }
    }

    public void annotationRemoved(AbstractAnnotation annotation) {
        IGTTier chTier;
        if (annotation != null && (chTier = this.getRowDataForTier(annotation.getTier().getName())) != null) {
            int numAnns = chTier.getAnnotations().size();
            for (int i = 0; i < numAnns; ++i) {
                IGTAnnotation igtAnn = chTier.getAnnotations().get(i);
                if (igtAnn.getAnnotation() != annotation) continue;
                this.removeChildren(igtAnn);
                if (igtAnn.getParent() != null) {
                    igtAnn.getParent().removeChild(igtAnn);
                }
                chTier.removeAnnotation(igtAnn);
                IGTDataModelEvent event = new IGTDataModelEvent(this, chTier, igtAnn, ModelEventType.REMOVE);
                this.postEvent(event);
                break;
            }
        }
    }

    public void tierAdded(TierImpl tier, Collection<String> hiddenTiers) {
        if (tier != null) {
            for (int i = this.rowData.size() - 3; i > 0; --i) {
                this.rowData.remove(i);
            }
            IGTTier igtTier = this.getRowDataForTier(tier.getRootTier().getName());
            this.addDependingTiersNodes(igtTier, tier.getRootTier(), hiddenTiers);
            for (IGTAnnotation ann : igtTier.getAnnotations()) {
                this.addChildrenToNode(ann.getAnnotation().getParentListeners(), ann, false);
            }
        }
    }

    public void tierRemoved(String tierName) {
        IGTTier igtTier;
        if (tierName != null && (igtTier = this.getRowDataForTier(tierName)) != null) {
            if (igtTier.getParentTier() != null) {
                igtTier.getParentTier().removeChildTier(igtTier);
            }
            this.rowData.remove(igtTier);
            this.rowHeader.removeHeader(tierName);
            this.removeChildTiers(igtTier);
        }
    }

    private void removeChildTiers(IGTTier igtTier) {
        if (igtTier != null) {
            int numChildren = igtTier.getChildTiers().size();
            for (int i = numChildren - 1; i >= 0; --i) {
                IGTTier child = igtTier.getChildTiers().get(i);
                this.rowData.remove(child);
                this.rowHeader.removeHeader(child.getTierName());
                this.removeChildTiers(child);
            }
        }
    }

    private void removeChildren(IGTAnnotation igtAnnotation) {
        if (igtAnnotation != null) {
            int numChildren = igtAnnotation.getChildCount();
            for (int i = numChildren - 1; i >= 0; --i) {
                IGTAnnotation child = (IGTAnnotation)igtAnnotation.getChildren().get(i);
                igtAnnotation.removeChild(child);
                child.getIGTTier().removeAnnotation(child);
                this.removeChildren(child);
            }
        }
    }

    @Override
    protected void notifyRowAdded() {
        IGTDataModelEvent event = new IGTDataModelEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((IGTDataModelListener)this.listeners.get(i)).dataModelChanged(event);
        }
    }

    private class AAComparator
    implements Comparator<AbstractAnnotation> {
        private AAComparator() {
        }

        @Override
        public int compare(AbstractAnnotation arg0, AbstractAnnotation arg1) {
            long beginTimeBoundary1;
            long beginTimeBoundary0 = arg0.getBeginTimeBoundary();
            if (beginTimeBoundary0 < (beginTimeBoundary1 = arg1.getBeginTimeBoundary())) {
                return -1;
            }
            if (beginTimeBoundary0 > beginTimeBoundary1) {
                return 1;
            }
            return 0;
        }
    }
}

