/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.model;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTRowHeaderItem;

public class IGTRowHeader {
    private List<IGTRowHeaderItem> rowData = new ArrayList<IGTRowHeaderItem>();

    public int getIndexForLabel(String rowLabel) {
        int size = this.rowData.size();
        for (int i = 0; i < size; ++i) {
            IGTRowHeaderItem item = this.rowData.get(i);
            if (!item.getFullHeaderText().equals(rowLabel)) continue;
            return i;
        }
        return -1;
    }

    public String getLabelForIndex(int row) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("The row index is < 0");
        }
        if (row > this.rowData.size() - 1) {
            throw new IndexOutOfBoundsException("The row index is > the size of the list: " + row + " > " + this.rowData.size());
        }
        return this.rowData.get(row).getFullHeaderText();
    }

    public String getHeaderText(int row) {
        return this.rowData.get(row).getHeaderText();
    }

    public String getFullHeaderText(int row) {
        return this.rowData.get(row).getFullHeaderText();
    }

    public void setHeaderText(int row, String cutoffText) {
        this.rowData.get(row).setHeaderText(cutoffText);
    }

    public void setFullHeaderText(int row, String fullText) {
        this.rowData.get(row).setFullHeaderText(fullText);
    }

    public void addHeader(String fullText) {
        this.rowData.add(new IGTRowHeaderItem(fullText));
    }

    public void removeHeader(String fullText) {
        for (int i = 0; i < this.rowData.size(); ++i) {
            IGTRowHeaderItem item = this.rowData.get(i);
            if (!item.getFullHeaderText().equals(fullText)) continue;
            this.rowData.remove(item);
        }
    }

    public void addHeader(int index, String fullText) throws ArrayIndexOutOfBoundsException {
        this.rowData.add(index, new IGTRowHeaderItem(fullText));
    }

    public String toString() {
        return "IGTRowHeader:[" + String.valueOf(this.rowData) + "]";
    }
}

