/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.render;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.FontSizer;
import mpi.eudico.client.annotator.interlinear.edit.IGTConstants;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTRenderInfo;

public class IGTViewerRenderInfo
extends IGTRenderInfo
implements FontSizer {
    public int vertRowMargin = 4;
    public int vertLineMargin = 2;
    public int headerWidth;
    public Insets annBBoxInsets;
    public boolean showAnnoBorders = true;
    public boolean showAnnoBackground = false;
    public int whitespaceWidth = 8;
    public Font defaultFont = Constants.DEFAULTFONT;
    public Color foregroundColor = Constants.DEFAULTFOREGROUNDCOLOR;
    public Color backgroundColor = IGTConstants.TABLE_BACKGROUND_COLOR1;
    public Color backgroundColor2 = IGTConstants.TABLE_BACKGROUND_COLOR2;
    public Color annoBorderColor = IGTConstants.ANNO_BORDER_COLOR;
    public Color annoBackgroundColor = IGTConstants.ANNO_BACKGROUND_COLOR;
    private Map<String, Font> tierFontMap = new HashMap<String, Font>();
    private Map<String, Color> tierColorMap = new HashMap<String, Color>();
    private Map<String, Color> prefTierColorMap = new HashMap<String, Color>();

    public IGTViewerRenderInfo() {
        this.annBBoxInsets = new Insets(2, 4, 2, 4);
    }

    public void setTierColorMap(Map<String, Color> colorMap) {
        if (colorMap != null) {
            this.prefTierColorMap.clear();
            this.prefTierColorMap.putAll(colorMap);
            this.tierColorMap.clear();
            this.tierColorMap.putAll(this.prefTierColorMap);
        }
    }

    public void setTierFontMap(Map<String, Font> fontMap) {
        if (fontMap != null) {
            this.tierFontMap.clear();
            this.tierFontMap.putAll(fontMap);
            for (Map.Entry<String, Font> e : fontMap.entrySet()) {
                String key = e.getKey();
                Font ft = e.getValue();
                if (key == null || ft == null) continue;
                this.tierFontMap.put(key, new Font(ft.getName(), ft.getStyle(), this.defaultFont.getSize()));
            }
        }
    }

    public Color getColorForTier(IGTTier tier) {
        Color c = null;
        if (tier.isSpecial()) {
            c = this.tierColorMap.get(tier.getRootTier().getTierName());
        } else {
            c = this.tierColorMap.get(tier.getTierName());
            if (c == null) {
                c = this.prefTierColorMap.get(tier.getTierName());
                if (c == null) {
                    if (tier.getParentTier() != null && (c = this.tierColorMap.get(tier.getRootTier().getTierName())) != null) {
                        this.tierColorMap.put(tier.getTierName(), c);
                    }
                } else {
                    this.tierColorMap.put(tier.getTierName(), c);
                }
            }
        }
        if (c != null) {
            return c;
        }
        return this.foregroundColor;
    }

    public Font getFontForTier(String tierName) {
        Font f = this.tierFontMap.get(tierName);
        if (f != null) {
            return f;
        }
        return this.defaultFont;
    }

    public void setFontForTier(String tierName, Font f) {
        this.tierFontMap.put(tierName, new Font(f.getName(), f.getStyle(), this.defaultFont.getSize()));
    }

    @Override
    public void setFontSize(int size) {
        this.defaultFont = new Font(this.defaultFont.getName(), this.defaultFont.getStyle(), size);
        Iterator<String> keyIt = this.tierFontMap.keySet().iterator();
        String key = null;
        Font ft = null;
        while (keyIt.hasNext()) {
            key = keyIt.next();
            ft = this.tierFontMap.get(key);
            if (key == null || ft == null) continue;
            this.tierFontMap.put(key, new Font(ft.getName(), ft.getStyle(), this.defaultFont.getSize()));
        }
    }

    @Override
    public int getFontSize() {
        return this.defaultFont.getSize();
    }

    public int getFontSizeForTier(String tierName) {
        Font f = this.tierFontMap.get(tierName);
        if (f != null) {
            return f.getSize();
        }
        return this.defaultFont.getSize();
    }

    public int getHeightForTier(Graphics g2d, String tierName) {
        Font f = this.tierFontMap.get(tierName);
        if (f == null) {
            f = this.defaultFont;
        }
        return g2d.getFontMetrics(f).getHeight() + this.getVerticalBBoxInsets();
    }

    public int getBaselineForTier(Graphics g2d, String tierName) {
        Font f = this.tierFontMap.get(tierName);
        if (f == null) {
            f = this.defaultFont;
        }
        return g2d.getFontMetrics(f).getDescent();
    }

    public int getHorizontalBBoxInsets() {
        return this.annBBoxInsets.left + this.annBBoxInsets.right;
    }

    public int getVerticalBBoxInsets() {
        return this.annBBoxInsets.top + this.annBBoxInsets.bottom;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append(" vertRowMargin=");
        buf.append(String.valueOf(this.vertRowMargin));
        buf.append(" vertLineMargin=");
        buf.append(String.valueOf(this.vertLineMargin));
        buf.append(" headerWidth=");
        buf.append(String.valueOf(this.headerWidth));
        buf.append(" whitespaceWidth=");
        buf.append(String.valueOf(this.whitespaceWidth));
        if (this.annBBoxInsets != null) {
            buf.append(" boundingBoxMargins=");
            buf.append(this.annBBoxInsets.toString());
        }
        return buf.toString();
    }
}

