/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.render;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JViewport;

public class SuggestionFlowLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int MIN_WIDTH = 120;
    public static final int MIN_HEIGHT = 75;
    private int width = 120;
    private int height = 75;
    int newAlign;
    int hgap;
    int vgap;

    public SuggestionFlowLayout() {
        this(1, 5, 5);
    }

    public SuggestionFlowLayout(int align) {
        this(align, 5, 5);
    }

    public SuggestionFlowLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public void setAlignment(int align) {
        this.newAlign = align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Location ml = null;
                if (m instanceof Location) {
                    ml = (Location)((Object)m);
                }
                Dimension d = ml != null ? ml.getPreferredSize(i, 0) : m.getPreferredSize();
                dim.height = Math.max(dim.height, d.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                dim.height = Math.max(dim.height, d.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    private int moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        switch (this.newAlign) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
            }
        }
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            int cy = y + (height - m.getHeight()) / 2;
            if (ltr) {
                this.setLocation(m, x, cy);
            } else {
                this.setLocation(m, target.getWidth() - x - m.getWidth(), cy);
            }
            x += m.getWidth() + this.hgap;
        }
        return height;
    }

    private void setLocation(Component c, int x, int y) {
        Point p = c.getLocation();
        if (p.x != x || p.y != y) {
            c.setLocation(x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            Container scrollpane = target.getParent();
            if (!(scrollpane instanceof JViewport)) {
                scrollpane = target;
            }
            int maxwidth = scrollpane.getWidth() - (insets.left + insets.right + this.hgap);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top;
            int rowh = 0;
            int start = 0;
            int row = 0;
            int col = 0;
            this.width = 120;
            this.height = 75;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Location ml = null;
                if (m instanceof Location) {
                    ml = (Location)((Object)m);
                }
                Dimension d = ml != null ? ml.getPreferredSize(col, row) : m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += this.hgap;
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                } else {
                    rowh = this.moveComponents(target, insets.left, y, maxwidth - x, rowh, start, i, ltr);
                    col = 0;
                    ++row;
                    if (ml != null) {
                        d = ml.getPreferredSize(col, row);
                    }
                    x = d.width;
                    y += this.vgap + rowh;
                    rowh = d.height;
                    start = i;
                }
                if (ml != null) {
                    ml.setGrid(col, row);
                }
                ++col;
                this.width = Math.max(this.width, x);
            }
            rowh = this.moveComponents(target, insets.left, y, maxwidth - x, rowh, start, nmembers, ltr);
            this.height = Math.max(this.height, y + rowh);
            this.width = Math.max(this.width, x);
        }
    }

    public String toString() {
        String str = "";
        switch (this.newAlign) {
            case 0: {
                str = ",align=left";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=right";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public static interface Location {
        public void setGrid(int var1, int var2);

        public Dimension getPreferredSize(int var1, int var2);
    }
}

