/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Component;
import mpi.eudico.client.annotator.DetachedFrame;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.player.NeedsCreateNewVisualComponent;
import mpi.eudico.client.annotator.player.SyncPlayer;

public class PlayerLayoutModel {
    public ElanMediaPlayer player;
    private ElanLayoutManager layoutManager;
    private boolean attached;
    public DetachedFrame detachedFrame;
    public Component visualComponent;
    private boolean displayedFirst;
    private boolean syncOnly = false;

    public PlayerLayoutModel(ElanMediaPlayer player, ElanLayoutManager layoutManager) {
        this.player = player;
        this.layoutManager = layoutManager;
        this.visualComponent = player.getVisualComponent();
        this.attached = true;
        this.detachedFrame = null;
        this.displayedFirst = false;
    }

    public void setSyncOnly(boolean bool) {
        this.syncOnly = bool;
    }

    public boolean isSyncOnly() {
        return this.syncOnly;
    }

    public void setDisplayedFirst(boolean first) {
        this.displayedFirst = first;
    }

    public boolean isDisplayedFirst() {
        return this.displayedFirst;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public boolean isVisual() {
        if (this.player instanceof EmptyMediaPlayer && !(this.player instanceof SyncPlayer)) {
            return false;
        }
        return this.visualComponent != null;
    }

    public void detach() {
        if (!this.attached || !this.isVisual()) {
            return;
        }
        if (this.player instanceof NeedsCreateNewVisualComponent) {
            this.visualComponent = ((NeedsCreateNewVisualComponent)((Object)this.player)).createNewVisualComponent();
        }
        this.detachedFrame = new DetachedFrame(this.layoutManager, this.visualComponent, this.player.getMediaDescriptor().mediaURL);
        this.detachedFrame.setAspectRatio(this.player.getAspectRatio());
        this.detachedFrame.setSize(400, 400);
        this.detachedFrame.setVisible(true);
        this.attached = false;
    }

    public void attach() {
        if (this.attached || !this.isVisual() || this.detachedFrame == null) {
            return;
        }
        this.detachedFrame.getContentPane().remove(this.visualComponent);
        this.detachedFrame.setVisible(false);
        this.detachedFrame.dispose();
        this.detachedFrame = null;
        this.attached = true;
        if (this.player instanceof NeedsCreateNewVisualComponent) {
            this.visualComponent = ((NeedsCreateNewVisualComponent)((Object)this.player)).createNewVisualComponent();
        }
    }
}

