/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.Zoomable;
import mpi.eudico.client.annotator.layout.ModeLayoutManager;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.MultiSourcePlayer;
import mpi.eudico.client.annotator.player.SyncPlayer;
import mpi.eudico.client.annotator.timeseries.TSViewerPlayer;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.SignalPlayerView;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;
import mpi.eudico.client.mediacontrol.Controller;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.util.MediaDescriptorUtility;
import mpi.eudico.util.TimeFormatter;
import nl.mpi.util.FileUtility;

public class SyncManager
implements ActionListener,
ItemListener,
ChangeListener,
ModeLayoutManager {
    private ViewerManager2 viewerManager;
    private ElanLayoutManager layoutManager;
    private ElanMediaPlayer playerInFocus;
    private Map<ElanMediaPlayer, String> nameForPlayer;
    private Map<String, ElanMediaPlayer> playerForName;
    private Map<ElanMediaPlayer, JPanel> labelForPlayer;
    private Map<ElanMediaPlayer, JRadioButton> playerButtons;
    private Map<ElanMediaPlayer, SignalPlayerView> viewForSyncPlayer;
    private Map<ElanMediaPlayer, Controller> controllerForView;
    private Map<ElanMediaPlayer, Long> lastSyncPositionForPlayer;
    private ButtonGroup buttonGroup;
    private JRadioButton absOffsetRB;
    private JRadioButton relOffsetRB;
    private JRadioButton allPlayersRB;
    private JPanel contentPanel;
    private JPanel playerPanel;
    private JPanel offsetPanel;
    private ButtonGroup playerGroup;
    private JButton applyButton;
    private JButton resetButton;
    private boolean connected;
    private boolean relative;
    private boolean allPlayerMode = true;
    private List<PlayerLayoutModel> playerList;
    private Container container;
    private JPanel volRatePanel;
    private JLabel volNameLabel;
    private JLabel volValueLabel;
    private JLabel rateNameLabel;
    private JLabel rateValueLabel;
    private JSlider volSlider;
    private JSlider rateSlider;
    private ElanMediaPlayerController mediaPlayerController;
    private int COMP_MARGIN = 5;
    private static int CONTROLS_MARGIN = 20;

    public SyncManager(ViewerManager2 viewerManager, ElanLayoutManager layoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = layoutManager;
        this.playerList = new ArrayList<PlayerLayoutModel>(layoutManager.getPlayerList());
        this.container = layoutManager.getElanFrame().getContentPane();
        this.nameForPlayer = new HashMap<ElanMediaPlayer, String>();
        this.playerForName = new HashMap<String, ElanMediaPlayer>();
        this.labelForPlayer = new HashMap<ElanMediaPlayer, JPanel>();
        this.playerButtons = new HashMap<ElanMediaPlayer, JRadioButton>();
        this.viewForSyncPlayer = new HashMap<ElanMediaPlayer, SignalPlayerView>(6);
        this.controllerForView = new HashMap<ElanMediaPlayer, Controller>(4);
        this.lastSyncPositionForPlayer = new HashMap<ElanMediaPlayer, Long>(8);
        this.buttonGroup = new ButtonGroup();
        this.contentPanel = new JPanel(new GridLayout(1, 2));
        this.playerPanel = new JPanel();
        this.playerPanel.setLayout(new BoxLayout(this.playerPanel, 1));
        this.offsetPanel = new JPanel();
        this.offsetPanel.setLayout(new BoxLayout(this.offsetPanel, 1));
        this.absOffsetRB = new JRadioButton();
        this.absOffsetRB.setFont(this.absOffsetRB.getFont().deriveFont(0, 10.0f));
        this.absOffsetRB.setSelected(true);
        this.absOffsetRB.addItemListener(this);
        this.buttonGroup.add(this.absOffsetRB);
        this.offsetPanel.add(this.absOffsetRB);
        this.relOffsetRB = new JRadioButton();
        this.relOffsetRB.setFont(this.relOffsetRB.getFont().deriveFont(0, 10.0f));
        this.relOffsetRB.setSelected(false);
        this.relOffsetRB.addItemListener(this);
        this.buttonGroup.add(this.relOffsetRB);
        this.offsetPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        this.offsetPanel.add(this.relOffsetRB);
        this.applyButton = new JButton();
        this.applyButton.setFont(this.applyButton.getFont().deriveFont(0, 10.0f));
        this.applyButton.addActionListener(this);
        this.offsetPanel.add(Box.createRigidArea(new Dimension(0, 12)));
        this.offsetPanel.add(this.applyButton);
        this.connected = true;
        this.resetButton = new JButton();
        this.resetButton.setFont(this.resetButton.getFont().deriveFont(0, 10.0f));
        this.resetButton.addActionListener(this);
        this.offsetPanel.add(this.resetButton);
        this.playerGroup = new ButtonGroup();
        this.allPlayersRB = new JRadioButton();
        this.allPlayersRB.setFont(this.allPlayersRB.getFont().deriveFont(0, 10.0f));
        this.allPlayersRB.setSelected(true);
        this.allPlayersRB.addItemListener(this);
        this.playerGroup.add(this.allPlayersRB);
        this.playerPanel.add(this.allPlayersRB);
        this.contentPanel.add(this.offsetPanel);
        this.contentPanel.add(this.playerPanel);
        this.container.add(this.getPlayerSelectionPanel());
    }

    @Override
    public void add(Object object) {
        if (object instanceof PlayerLayoutModel) {
            PlayerLayoutModel plm = (PlayerLayoutModel)object;
            PlayerLayoutModel model = null;
            for (int i = 0; i < this.playerList.size(); ++i) {
                model = this.playerList.get(i);
                if (model == plm || model.player == plm.player) {
                    return;
                }
                if (model.player.getMediaDescriptor() == null || plm.player.getMediaDescriptor() == null || !plm.player.getMediaDescriptor().mediaURL.equals(model.player.getMediaDescriptor().mediaURL)) continue;
                return;
            }
            this.playerList.add(plm);
            this.addInternal(plm);
            this.doLayout();
        } else if (object instanceof ElanMediaPlayer) {
            ElanMediaPlayer player = (ElanMediaPlayer)object;
            PlayerLayoutModel model = null;
            for (int i = 0; i < this.playerList.size(); ++i) {
                model = this.playerList.get(i);
                if (model.player == player) {
                    return;
                }
                if (model.player.getMediaDescriptor() == null || player.getMediaDescriptor() == null || !player.getMediaDescriptor().mediaURL.equals(model.player.getMediaDescriptor().mediaURL)) continue;
                return;
            }
            player.setLayoutManager(this.layoutManager);
            PlayerLayoutModel plModel = new PlayerLayoutModel(player, this.layoutManager);
            this.playerList.add(plModel);
            this.addInternal(plModel);
            this.doLayout();
        } else if (object instanceof ElanMediaPlayerController) {
            this.mediaPlayerController = (ElanMediaPlayerController)object;
            this.container.add(this.mediaPlayerController.getPlayButtonsPanel());
            this.container.add(this.mediaPlayerController.getSliderPanel());
            this.container.add(this.mediaPlayerController.getTimePanel());
            this.container.add(this.mediaPlayerController.getSelectionPanel());
            this.container.add(this.mediaPlayerController.getSelectionButtonsPanel());
            this.container.add(this.getVolumeRatePanel());
        } else if (object instanceof TimeSeriesViewer) {
            TimeSeriesViewer tsViewer = (TimeSeriesViewer)object;
            tsViewer.setTimeScaleConnected(false);
            TSViewerPlayer tsSyncPlayer = new TSViewerPlayer(tsViewer, this.viewerManager.getMasterMediaPlayer().getMediaDuration());
            tsSyncPlayer.setTrackManager(tsViewer.getTrackManager());
            tsSyncPlayer.setMediaTime(this.viewerManager.getMasterMediaPlayer().getMediaTime());
            tsViewer.setSyncModeViewer(true);
            this.viewerManager.addMediaPlayer(tsSyncPlayer);
            PlayerLayoutModel plModel = new PlayerLayoutModel(tsSyncPlayer, this.layoutManager);
            plModel.setSyncOnly(true);
            this.playerList.add(plModel);
            this.addInternal(plModel);
        }
    }

    private void addInternal(Object object) {
        if (object instanceof PlayerLayoutModel) {
            PlayerLayoutModel plm = (PlayerLayoutModel)object;
            if (plm.player.getMediaDescriptor() != null && "audio/x-wav".equals(plm.player.getMediaDescriptor().mimeType)) {
                SignalPlayerView spv = new SignalPlayerView(plm.player);
                this.viewerManager.connectListener(spv);
                spv.setSelectionObject(this.viewerManager.getSelection());
                this.viewerManager.getSelection().addSelectionListener(spv);
                spv.setViewerManager(this.viewerManager);
                this.container.add(spv);
                this.viewForSyncPlayer.put(plm.player, spv);
            }
            this.addInternal(plm.player);
            this.container.add(this.getPlayerLabel(plm.player));
            if (plm.isSyncOnly()) {
                this.viewerManager.addMediaPlayer(plm.player);
                if (plm.player.getVisualComponent() != null) {
                    this.container.add(plm.player.getVisualComponent());
                }
                if (plm.player instanceof SyncPlayer) {
                    ((SyncPlayer)((Object)plm.player)).setSyncConnected(true);
                    plm.player.setMediaTime(this.viewerManager.getMasterMediaPlayer().getMediaTime());
                }
            }
        } else if (object instanceof ElanMediaPlayer) {
            ElanMediaPlayer player = (ElanMediaPlayer)object;
            int size = 1;
            while (this.playerForName.containsKey(String.valueOf(size))) {
                ++size;
            }
            String name = String.valueOf(size);
            this.nameForPlayer.put(player, name);
            this.playerForName.put(name, player);
            this.labelForPlayer.put(player, this.createLabelPanel(player));
            this.lastSyncPositionForPlayer.put(player, -1L);
            JRadioButton button = new JRadioButton(ElanLocale.getString("SyncMode.Label.Player") + " " + name);
            button.setFont(Constants.deriveSmallFont(button.getFont()));
            button.addItemListener(this);
            this.playerButtons.put(player, button);
            this.playerGroup.add(button);
            this.playerPanel.add(Box.createRigidArea(new Dimension(0, 2)));
            this.playerPanel.add(button);
        } else if (object instanceof ElanMediaPlayerController) {
            this.mediaPlayerController = (ElanMediaPlayerController)object;
            this.container.add(this.mediaPlayerController.getPlayButtonsPanel());
            this.container.add(this.mediaPlayerController.getSliderPanel());
            this.container.add(this.mediaPlayerController.getTimePanel());
            this.container.add(this.mediaPlayerController.getSelectionPanel());
            this.container.add(this.mediaPlayerController.getSelectionButtonsPanel());
            this.container.add(this.getVolumeRatePanel());
        }
    }

    @Override
    public void remove(Object object) {
        if (object instanceof ElanMediaPlayer) {
            ElanMediaPlayer player = (ElanMediaPlayer)object;
            this.container.remove(this.getPlayerLabel(player));
            if (this.nameForPlayer.containsKey(player)) {
                this.playerForName.remove(this.nameForPlayer.get(player));
                this.nameForPlayer.remove(player);
                this.labelForPlayer.remove(player);
                this.playerButtons.get(player).removeItemListener(this);
                this.buttonGroup.remove(this.playerButtons.get(player));
                this.playerPanel.remove(this.playerButtons.get(player));
                this.playerButtons.remove(player);
                if (this.viewForSyncPlayer.containsKey(player)) {
                    SignalPlayerView spv = this.viewForSyncPlayer.get(player);
                    this.container.remove(spv);
                    this.viewForSyncPlayer.remove(player);
                    Controller c = this.controllerForView.get(player);
                    if (c != null) {
                        c.removeControllerListener(spv);
                        player.removeController(c);
                    }
                    this.viewerManager.disconnectListener(spv);
                    spv.setSelectionObject(null);
                    this.viewerManager.getSelection().removeSelectionListener(spv);
                    spv.setViewerManager(null);
                } else if (player instanceof SyncPlayer) {
                    Controller c;
                    if (player.getVisualComponent() != null) {
                        this.container.remove(player.getVisualComponent());
                    }
                    if ((c = this.controllerForView.get(player)) != null) {
                        player.removeController(c);
                    }
                    this.viewerManager.destroyMediaPlayer(player);
                }
            }
        } else if (object instanceof PlayerLayoutModel) {
            PlayerLayoutModel plModel = (PlayerLayoutModel)object;
            this.playerList.remove(plModel);
            this.remove(plModel.player);
        }
    }

    public JPanel getPlayerSelectionPanel() {
        return this.contentPanel;
    }

    public JPanel getPlayerLabel(ElanMediaPlayer player) {
        if (!this.nameForPlayer.containsKey(player)) {
            return null;
        }
        JPanel panel = this.labelForPlayer.get(player);
        if (panel == null) {
            panel = this.createLabelPanel(player);
            this.labelForPlayer.put(player, panel);
            return panel;
        }
        Container playPanel = (Container)panel.getComponent(0);
        Component nameComp = playPanel.getComponent(0);
        if (nameComp instanceof JLabel) {
            JLabel nameLabel = (JLabel)nameComp;
            String name = ElanLocale.getString("SyncMode.Label.Player") + " " + this.nameForPlayer.get(player) + " " + ElanLocale.getString("SyncMode.Label.Offset") + ": ";
            nameLabel.setText(name);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridx = 1;
        gbc.anchor = 16;
        gbc.insets = new Insets(1, 1, 1, 1);
        if (playPanel.getComponentCount() > 1) {
            playPanel.remove(1);
        }
        if (player == this.playerInFocus) {
            playPanel.add((Component)this.viewerManager.getTimePanel(), gbc);
        } else {
            JLabel offsetLabel = new JLabel();
            offsetLabel.setText(TimeFormatter.toString(player.getOffset()));
            playPanel.add((Component)offsetLabel, gbc);
        }
        if (player instanceof MultiSourcePlayer) {
            JComboBox box = null;
            JLabel fileLabel = null;
            Component[] comps = panel.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof JComboBox) {
                    box = (JComboBox)comps[i];
                }
                if (!(comps[i] instanceof JLabel)) continue;
                fileLabel = (JLabel)comps[i];
            }
            String[] sources = ((MultiSourcePlayer)((Object)player)).getDescriptorStrings();
            if (box != null) {
                block1: for (int i = 0; i < sources.length; ++i) {
                    for (int j = 0; j < box.getItemCount(); ++j) {
                        if (box.getItemAt(j).equals(sources[i])) continue block1;
                    }
                    box.addItem(sources[i]);
                }
                block3: for (int j = 0; j < box.getItemCount(); ++j) {
                    for (int i = 0; i < sources.length; ++i) {
                        if (box.getItemAt(j).equals(sources[i])) continue block3;
                    }
                    box.removeItemAt(j);
                }
                if (fileLabel != null) {
                    fileLabel.setText((String)box.getSelectedItem());
                }
            }
        }
        return panel;
    }

    private JPanel createLabelPanel(ElanMediaPlayer player) {
        JPanel panel = new JPanel(new GridBagLayout());
        if (!this.nameForPlayer.containsKey(player)) {
            return panel;
        }
        JLabel nameLabel = new JLabel();
        JPanel playPanel = new JPanel(new GridBagLayout());
        String name = ElanLocale.getString("SyncMode.Label.Player") + " " + this.nameForPlayer.get(player) + " " + ElanLocale.getString("SyncMode.Label.Offset") + ": ";
        nameLabel.setText(name);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 14;
        gbc.insets = new Insets(1, 1, 1, 1);
        playPanel.add((Component)nameLabel, gbc);
        gbc.gridx = 1;
        gbc.anchor = 16;
        if (player == this.playerInFocus) {
            playPanel.add((Component)this.viewerManager.getTimePanel(), gbc);
        } else {
            JLabel offsetLabel = new JLabel();
            offsetLabel.setText(TimeFormatter.toString(player.getOffset()));
            playPanel.add((Component)offsetLabel, gbc);
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        panel.add((Component)playPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        JLabel fileLabel = new JLabel();
        fileLabel.setFont(Constants.deriveSmallFont(fileLabel.getFont()));
        if (player.getMediaDescriptor() != null) {
            fileLabel.setText(FileUtility.fileNameFromPath(player.getMediaDescriptor().mediaURL));
        } else {
            fileLabel.setText("-");
        }
        panel.add((Component)fileLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 10;
        if (player instanceof MultiSourcePlayer) {
            String[] sources = ((MultiSourcePlayer)((Object)player)).getDescriptorStrings();
            if (sources.length > 1) {
                JComboBox<String> box = new JComboBox<String>();
                for (int i = 0; i < sources.length; ++i) {
                    box.addItem(sources[i]);
                    if (i != 0) continue;
                    fileLabel.setText(sources[i]);
                }
                box.addItemListener(this);
                panel.add(box, gbc);
            } else {
                fileLabel.setText(sources[0]);
            }
        }
        return panel;
    }

    private JPanel getVolumeRatePanel() {
        Insets insets;
        if (this.volRatePanel != null) {
            return this.volRatePanel;
        }
        this.volRatePanel = new JPanel(new GridBagLayout());
        this.volNameLabel = new JLabel(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Volume"));
        int volume = (int)(this.viewerManager.getVolumeManager().getMasterVolume() * 100.0f);
        Float value = Preferences.getFloat("MediaControlVolume", this.viewerManager.getTranscription());
        if (value != null) {
            volume = (int)(value.floatValue() * 100.0f);
        }
        this.volValueLabel = new JLabel(String.valueOf(volume));
        this.volValueLabel.setFont(this.volValueLabel.getFont().deriveFont(0, 10.0f));
        this.volSlider = new JSlider(0, 100, volume);
        this.volSlider.addChangeListener(this);
        this.rateNameLabel = new JLabel(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Rate"));
        int rate = (int)(this.viewerManager.getMasterMediaPlayer().getRate() * 100.0f);
        value = Preferences.getFloat("MediaControlRate", this.viewerManager.getTranscription());
        if (value != null) {
            rate = (int)(value.floatValue() * 100.0f);
        }
        this.rateValueLabel = new JLabel(String.valueOf(rate));
        this.rateValueLabel.setFont(this.rateValueLabel.getFont().deriveFont(0, 10.0f));
        this.rateSlider = new JSlider(0, 200, rate);
        this.rateSlider.addChangeListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets = new Insets(1, 1, 1, 1);
        gbc.anchor = 16;
        this.volRatePanel.add((Component)this.volNameLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(1, 6, 1, 1);
        this.volRatePanel.add((Component)this.volValueLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.volRatePanel.add((Component)this.volSlider, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(10, 1, 1, 1);
        this.volRatePanel.add((Component)this.rateNameLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(1, 6, 1, 1);
        this.volRatePanel.add((Component)this.rateValueLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.volRatePanel.add((Component)this.rateSlider, gbc);
        gbc.gridy = 4;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.volRatePanel.add((Component)new JPanel(), gbc);
        this.volRatePanel.setBorder(new TitledBorder(""));
        return this.volRatePanel;
    }

    public boolean connectedPlayers() {
        return this.connected;
    }

    private void setOffset() {
        if (this.playerInFocus != null) {
            if (this.viewForSyncPlayer.containsKey(this.playerInFocus)) {
                this.viewForSyncPlayer.get(this.playerInFocus).setOffset(this.playerInFocus.getMediaTime());
                this.viewForSyncPlayer.get(this.playerInFocus).setSyncConnected(false);
            }
            this.lastSyncPositionForPlayer.put(this.playerInFocus, this.playerInFocus.getMediaTime());
            this.viewerManager.setOffset(this.playerInFocus, this.playerInFocus.getMediaTime());
            if (this.playerInFocus instanceof SyncPlayer) {
                if (this.playerInFocus instanceof TSViewerPlayer) {
                    ((TSViewerPlayer)this.playerInFocus).getViewer().setPlayer(this.viewerManager.getMasterMediaPlayer());
                }
                ((SyncPlayer)((Object)this.playerInFocus)).setSyncConnected(false);
            }
        }
    }

    private void setRelativeOffsets() {
        long minOffset = Long.MAX_VALUE;
        for (ElanMediaPlayer player : this.playerForName.values()) {
            if (player.getOffset() >= minOffset) continue;
            minOffset = player.getOffset();
        }
        for (ElanMediaPlayer player : this.playerForName.values()) {
            long offset = player.getOffset();
            this.viewerManager.setOffset(player, offset - minOffset);
            if (!this.viewForSyncPlayer.containsKey(player)) continue;
            this.viewForSyncPlayer.get(player).setOffset(offset - minOffset);
        }
        this.viewerManager.getMasterMediaPlayer().setMediaTime(minOffset);
        this.relative = true;
    }

    private void setAbsoluteOffsets() {
        for (ElanMediaPlayer player : this.playerForName.values()) {
            long offset = player.getOffset();
            this.viewerManager.setOffset(player, offset);
            if (!this.viewForSyncPlayer.containsKey(player)) continue;
            this.viewForSyncPlayer.get(player).setOffset(offset);
        }
        this.viewerManager.getMasterMediaPlayer().setMediaTime(0L);
        this.relative = false;
    }

    private void resetOffsets() {
        long curTime = 0L;
        if (this.playerInFocus != null) {
            curTime = this.playerInFocus.getMediaTime();
        }
        this.allPlayersRB.setSelected(true);
        this.reconnect();
        for (ElanMediaPlayer player : this.playerForName.values()) {
            this.viewerManager.setOffset(player, 0L);
        }
        for (SignalPlayerView spv : this.viewForSyncPlayer.values()) {
            spv.setOffset(0L);
        }
        this.viewerManager.getMasterMediaPlayer().setMediaTime(curTime);
        this.doLayout();
    }

    public void reconnect() {
        this.setOffset();
        this.playerInFocus = null;
        if (this.playerList.size() > 0) {
            this.viewerManager.setMasterMediaPlayer(this.playerList.get((int)0).player);
            this.viewerManager.enableDisabledMediaPlayers();
        }
        this.connected = true;
        this.allPlayersRB.removeItemListener(this);
        this.allPlayersRB.setSelected(true);
        this.allPlayersRB.addItemListener(this);
        for (ElanMediaPlayer player : this.playerForName.values()) {
            if (!(player instanceof TSViewerPlayer)) continue;
            ((TSViewerPlayer)player).getViewer().setPlayer(this.viewerManager.getMasterMediaPlayer());
        }
    }

    private void stop() {
        if (this.viewerManager.getMasterMediaPlayer().isPlaying()) {
            this.viewerManager.getMasterMediaPlayer().stop();
        }
    }

    private void setFocusedPlayer(ElanMediaPlayer elanPlayer) {
        long offset;
        if (elanPlayer == null) {
            return;
        }
        this.setOffset();
        this.playerInFocus = elanPlayer;
        this.viewerManager.enableDisabledMediaPlayers();
        this.viewerManager.setMasterMediaPlayer(this.playerInFocus);
        this.viewerManager.disableConnectedMediaPlayers();
        for (ElanMediaPlayer player : this.playerForName.values()) {
            if (!(player instanceof TSViewerPlayer) || player == this.playerInFocus) continue;
            ((TSViewerPlayer)player).getViewer().setPlayer(player);
        }
        if (this.playerInFocus instanceof SyncPlayer) {
            ((SyncPlayer)((Object)this.playerInFocus)).setSyncConnected(true);
        }
        if ((offset = this.lastSyncPositionForPlayer.get(this.playerInFocus).longValue()) < 0L) {
            offset = this.playerInFocus.getOffset();
        }
        long mediaTime = this.playerInFocus.getMediaTime();
        this.playerInFocus.setOffset(0L);
        this.playerInFocus.setMediaTime(offset != 0L ? offset : mediaTime);
        if (this.viewForSyncPlayer.containsKey(this.playerInFocus)) {
            SignalPlayerView spv = this.viewForSyncPlayer.get(this.playerInFocus);
            spv.setOffset(0L);
            spv.setMediaTime(offset != 0L ? offset : mediaTime);
            spv.setSyncConnected(true);
        }
        this.connected = false;
        this.doLayout();
    }

    private void updateMultiPlayer(JComboBox sourceComponent) {
        Iterator<ElanMediaPlayer> playIt = this.labelForPlayer.keySet().iterator();
        ElanMediaPlayer playerObj = null;
        JPanel panel = null;
        block0: while (playIt.hasNext()) {
            playerObj = playIt.next();
            panel = this.labelForPlayer.get(playerObj);
            Component[] comps = panel.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] == sourceComponent) break block0;
            }
            panel = null;
            playerObj = null;
        }
        if (panel != null && playerObj instanceof MultiSourcePlayer) {
            MultiSourcePlayer player = (MultiSourcePlayer)((Object)playerObj);
            String source = (String)sourceComponent.getSelectedItem();
            if (source != null) {
                player.setCurrentSource(source);
                this.layoutManager.doLayout();
            }
        }
    }

    private int[] getNumberOfColumnsAndRows(int availableWidth, int availableHeight, int labelHeight) {
        float averageAspectRatio = 0.0f;
        int visualCount = 0;
        for (int i = 0; i < this.playerList.size(); ++i) {
            PlayerLayoutModel plModel = this.playerList.get(i);
            if (!plModel.isVisual() || !plModel.isAttached()) continue;
            averageAspectRatio += plModel.player.getAspectRatio();
            ++visualCount;
        }
        averageAspectRatio += (float)(2 * this.viewForSyncPlayer.size());
        averageAspectRatio = (visualCount += this.viewForSyncPlayer.size()) > 0 ? (averageAspectRatio /= (float)visualCount) : 1.3f;
        if (visualCount == 0 || visualCount == 1) {
            return new int[]{visualCount, visualCount};
        }
        if (availableWidth <= 0 || availableHeight <= 0 || availableHeight <= labelHeight) {
            return new int[]{0, 0};
        }
        int maxArea = 0;
        int maxWidth = 0;
        int maxHeight = 0;
        int numColumns = 0;
        int numRows = 0;
        for (int i = 1; i <= visualCount; ++i) {
            for (int j = visualCount; j >= 1 && i * j >= visualCount; --j) {
                int area;
                maxHeight = (availableHeight - j * labelHeight) / j;
                maxWidth = availableWidth / i;
                if ((float)maxHeight > (float)maxWidth * (1.0f / averageAspectRatio)) {
                    maxHeight = (int)((float)maxWidth * (1.0f / averageAspectRatio));
                }
                if ((float)maxWidth > (float)maxHeight * averageAspectRatio) {
                    maxWidth = (int)((float)maxHeight * averageAspectRatio);
                }
                if (maxWidth <= 0 || maxHeight <= 0 || (area = maxWidth * maxHeight) <= maxArea) continue;
                maxArea = area;
                numColumns = i;
                numRows = j;
            }
        }
        return new int[]{numColumns, numRows};
    }

    private void checkUnequalOffsets() {
        if (this.playerList.size() < 2) {
            return;
        }
        StringBuilder mesBuf = null;
        block0: for (int i = 0; i < this.playerList.size(); ++i) {
            PlayerLayoutModel amodel = this.playerList.get(i);
            MediaDescriptor amd = amodel.player.getMediaDescriptor();
            if (amd == null || !amd.mimeType.equals("audio/x-wav")) continue;
            for (int j = 0; j < this.playerList.size(); ++j) {
                PlayerLayoutModel vmodel = this.playerList.get(j);
                MediaDescriptor vmd = vmodel.player.getMediaDescriptor();
                if (vmd == null || !MediaDescriptorUtility.isVideoType(vmd) || !vmd.mediaURL.equals(amd.extractedFrom) || j == 0 || vmd.timeOrigin == amd.timeOrigin) continue;
                if (mesBuf == null) {
                    mesBuf = new StringBuilder(ElanLocale.getString("LinkedFilesDialog.Message.OffsetNotEqual") + "\n\n");
                }
                mesBuf.append("- " + vmd.mediaURL + "\n");
                mesBuf.append("- " + amd.mediaURL + "\n\n");
                continue block0;
            }
        }
        if (mesBuf != null) {
            JOptionPane.showMessageDialog(this.container, mesBuf.toString(), ElanLocale.getString("Message.Warning"), 2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.applyButton) {
            if (!this.allPlayersRB.isSelected()) {
                this.allPlayersRB.setSelected(true);
            } else {
                if (this.relative) {
                    this.setRelativeOffsets();
                } else {
                    this.setAbsoluteOffsets();
                }
                this.doLayout();
            }
        } else if (event.getSource() == this.resetButton) {
            this.resetOffsets();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() instanceof JComboBox) {
                this.updateMultiPlayer((JComboBox)e.getSource());
            } else if (e.getSource() == this.absOffsetRB) {
                this.stop();
                this.relative = false;
                if (!this.allPlayersRB.isSelected()) {
                    this.allPlayersRB.setSelected(true);
                }
            } else if (e.getSource() == this.relOffsetRB) {
                this.stop();
                this.relative = true;
                if (!this.allPlayersRB.isSelected()) {
                    this.allPlayersRB.setEnabled(true);
                }
            } else if (e.getSource() == this.allPlayersRB) {
                this.stop();
                this.reconnect();
                this.allPlayerMode = true;
                if (this.relative) {
                    this.setRelativeOffsets();
                } else {
                    this.setAbsoluteOffsets();
                }
                this.doLayout();
            } else {
                boolean oldAllMode = this.allPlayerMode;
                if (this.playerButtons.containsValue(e.getSource())) {
                    this.stop();
                    for (ElanMediaPlayer player : this.playerButtons.keySet()) {
                        if (this.playerButtons.get(player) != e.getSource()) continue;
                        this.setFocusedPlayer(player);
                        this.allPlayerMode = false;
                        break;
                    }
                }
                this.doLayout();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.volSlider) {
            int volume = this.volSlider.getValue();
            this.volValueLabel.setText(String.valueOf(volume));
            this.viewerManager.getVolumeManager().setMasterVolume((float)volume / 100.0f);
        } else if (e.getSource() == this.rateSlider) {
            int rate = this.rateSlider.getValue();
            this.rateValueLabel.setText(String.valueOf(rate));
            this.viewerManager.getMasterMediaPlayer().setRate((float)rate / 100.0f);
        }
    }

    @Override
    public void updateLocale() {
        this.contentPanel.setBorder(new TitledBorder(""));
        this.offsetPanel.setBorder(new TitledBorder(ElanLocale.getString("SyncMode.Label.Offset")));
        this.absOffsetRB.setText(ElanLocale.getString("SyncMode.Label.Absolute"));
        this.relOffsetRB.setText(ElanLocale.getString("SyncMode.Label.Relative"));
        this.applyButton.setText(ElanLocale.getString("SyncMode.Button.Apply"));
        this.resetButton.setText(ElanLocale.getString("SyncMode.Button.Reset"));
        this.playerPanel.setBorder(new TitledBorder(ElanLocale.getString("SyncMode.Label.Player")));
        this.allPlayersRB.setText(ElanLocale.getString("SyncMode.Label.AllPlayers"));
        this.volNameLabel.setText(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Volume"));
        this.rateNameLabel.setText(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Rate"));
        for (ElanMediaPlayer player : this.nameForPlayer.keySet()) {
            JRadioButton b = this.playerButtons.get(player);
            b.setText(ElanLocale.getString("SyncMode.Label.Player") + " " + this.nameForPlayer.get(player));
            JPanel p = this.labelForPlayer.get(player);
            try {
                JLabel l = (JLabel)p.getComponent(0);
                String name = ElanLocale.getString("SyncMode.Label.Player") + " " + this.nameForPlayer.get(player) + " " + ElanLocale.getString("SyncMode.Label.Offset") + ": ";
                l.setText(name);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void detach(Object object) {
        if (object instanceof PlayerLayoutModel) {
            PlayerLayoutModel m = (PlayerLayoutModel)object;
            this.container.remove(this.getPlayerLabel(m.player));
        } else if (object instanceof AbstractViewer) {
            // empty if block
        }
    }

    @Override
    public void attach(Object object) {
        if (object instanceof PlayerLayoutModel) {
            PlayerLayoutModel m = (PlayerLayoutModel)object;
            this.container.add(this.getPlayerLabel(m.player));
        }
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public void doLayout() {
        if (!this.layoutManager.isIntialized()) {
            return;
        }
        int containerWidth = this.container.getWidth();
        int containerHeight = this.container.getHeight();
        int labelHeight = 20;
        int numVisible = 0;
        if (this.playerList.size() > 0) {
            for (int i = 0; i < this.playerList.size(); ++i) {
                PlayerLayoutModel m = this.playerList.get(i);
                if (m.isAttached()) {
                    ++numVisible;
                }
                Dimension prefSize = this.getPlayerLabel(m.player).getPreferredSize();
                if (prefSize.height <= labelHeight) continue;
                labelHeight = prefSize.height;
            }
        }
        numVisible += this.viewForSyncPlayer.size();
        labelHeight += 3;
        int playerSelectionWidth = 130;
        int playerSelectionHeight = 80;
        Dimension playerSelectionSize = this.getPlayerSelectionPanel().getPreferredSize();
        playerSelectionWidth = Math.max(playerSelectionWidth, playerSelectionSize.width);
        playerSelectionHeight = Math.max(playerSelectionHeight, playerSelectionSize.height);
        int controlsHeight = 2 * this.COMP_MARGIN + this.mediaPlayerController.getSliderPanel().getPreferredSize().height + playerSelectionHeight;
        int totalPlayerWidth = containerWidth - 6;
        int totalPlayerHeight = containerHeight - 3 - controlsHeight;
        int[] colrow = this.getNumberOfColumnsAndRows(totalPlayerWidth, totalPlayerHeight, labelHeight);
        int mediaY = 3;
        int mediaX = 3;
        if (colrow[0] > 0 && colrow[1] > 0) {
            int maxMediaWidth = totalPlayerWidth / colrow[0] - this.COMP_MARGIN;
            int maxMediaHeight = totalPlayerHeight / colrow[1] - labelHeight - this.COMP_MARGIN;
            if (maxMediaWidth > 0 && maxMediaHeight > 0) {
                int playerIndex = 0;
                for (int i = 0; i < colrow[1]; ++i) {
                    mediaY += i * (maxMediaHeight + labelHeight);
                    for (int j = 0; j < colrow[0]; ++j) {
                        PlayerLayoutModel model = null;
                        ElanMediaPlayer player = null;
                        do {
                            if (!(model = this.playerList.get(playerIndex)).isAttached()) continue;
                            player = model.player;
                            break;
                        } while (++playerIndex < this.playerList.size());
                        JPanel label = this.getPlayerLabel(player);
                        int curX = mediaX + j * (maxMediaWidth + this.COMP_MARGIN);
                        int curY = mediaY;
                        int curW = maxMediaWidth;
                        int curH = maxMediaHeight;
                        if (label != null) {
                            Dimension prefLabelSize = ((Component)label).getPreferredSize();
                            if (prefLabelSize.width <= maxMediaWidth) {
                                label.setBounds(curX, curY + curH, curW, labelHeight);
                            } else {
                                label.setBounds(curX, curY + curH, maxMediaWidth, labelHeight);
                            }
                        }
                        Component videoComp = null;
                        float aspectRatio = 1.0f;
                        if (model.isSyncOnly()) {
                            videoComp = model.player.getVisualComponent();
                        } else if (model.isVisual() && model.isAttached()) {
                            videoComp = model.visualComponent;
                            aspectRatio = model.player.getAspectRatio();
                        } else if (this.viewForSyncPlayer.containsKey(model.player)) {
                            videoComp = this.viewForSyncPlayer.get(model.player);
                        }
                        if (videoComp != null) {
                            curH = (int)((float)curW / aspectRatio);
                            if (curH > maxMediaHeight) {
                                curH = maxMediaHeight;
                                curW = (int)((float)curH * aspectRatio);
                                if (model.isSyncOnly() || this.viewForSyncPlayer.containsKey(model.player)) {
                                    curW = maxMediaWidth;
                                }
                                curX += (maxMediaWidth - curW) / 2;
                            }
                            videoComp.setBounds(curX, curY, curW, curH);
                            if (((Component)label).getY() > curY + curH + 3) {
                                label.setBounds(((Component)label).getX(), curY + curH + 3, ((Component)label).getWidth(), ((Component)label).getHeight());
                            }
                        }
                        if (++playerIndex >= this.playerList.size() || playerIndex >= numVisible) break;
                    }
                    if (playerIndex < this.playerList.size() && playerIndex < numVisible) continue;
                    mediaY += maxMediaHeight + labelHeight + this.COMP_MARGIN;
                    break;
                }
            }
        }
        int controlsY = mediaY;
        int sliderPanelX = 3 + CONTROLS_MARGIN;
        int sliderPanelY = controlsY;
        int sliderPanelWidth = 0;
        int sliderPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            sliderPanelWidth = containerWidth - 6 - 2 * CONTROLS_MARGIN;
            sliderPanelHeight = this.mediaPlayerController.getSliderPanel().getPreferredSize().height;
            this.mediaPlayerController.getSliderPanel().setBounds(sliderPanelX, sliderPanelY, sliderPanelWidth, sliderPanelHeight);
        }
        int timePanelX = 0;
        int timePanelY = sliderPanelY + sliderPanelHeight + this.COMP_MARGIN;
        int timePanelWidth = 0;
        int timePanelHeight = 0;
        int playButtonsX = 0;
        if (this.mediaPlayerController != null) {
            timePanelX = containerWidth / 2 - this.mediaPlayerController.getTimePanel().getPreferredSize().width / 2;
            timePanelWidth = this.mediaPlayerController.getTimePanel().getPreferredSize().width;
            timePanelHeight = this.mediaPlayerController.getTimePanel().getPreferredSize().height;
            this.mediaPlayerController.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
            int playButtonsY = timePanelY + timePanelHeight + 4;
            int playButtonsWidth = 0;
            int playButtonsHeight = 0;
            playButtonsX = containerWidth / 2 - this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().width / 2;
            playButtonsWidth = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().width;
            playButtonsHeight = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().height;
            if (playButtonsX < sliderPanelX + playerSelectionWidth + this.COMP_MARGIN) {
                playButtonsX = sliderPanelX + playerSelectionWidth + this.COMP_MARGIN;
                int adjTimePanelX = playButtonsX + (playButtonsWidth - timePanelWidth) / 2;
                this.mediaPlayerController.getTimePanel().setBounds(adjTimePanelX, timePanelY, timePanelWidth, timePanelHeight);
            }
            this.mediaPlayerController.getPlayButtonsPanel().setBounds(playButtonsX, playButtonsY, playButtonsWidth, playButtonsHeight);
            int selPanelY = playButtonsY + playButtonsHeight + 8;
            int selPanelWidth = this.mediaPlayerController.getSelectionPanel().getPreferredSize().width;
            int selPanelX = playButtonsX + playButtonsWidth / 2 - selPanelWidth / 2;
            int selPanelHeight = this.mediaPlayerController.getSelectionPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionPanel().setBounds(selPanelX, selPanelY, selPanelWidth, selPanelHeight);
            int selButtonY = selPanelY + selPanelHeight + 4;
            int selButtonWidth = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().width;
            int selButtonX = playButtonsX + playButtonsWidth / 2 - selButtonWidth / 2;
            int selButtonHeight = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionButtonsPanel().setBounds(selButtonX, selButtonY, selButtonWidth, selButtonHeight);
        }
        int playerSelectionX = sliderPanelX;
        int playerSelectionY = timePanelY;
        this.getPlayerSelectionPanel().setBounds(playerSelectionX, playerSelectionY, playButtonsX - this.COMP_MARGIN - 3 - playerSelectionX, playerSelectionHeight);
        this.getVolumeRatePanel().setBounds(playButtonsX + this.mediaPlayerController.getPlayButtonsPanel().getWidth() + this.COMP_MARGIN + 3, sliderPanelY + sliderPanelHeight + this.COMP_MARGIN, sliderPanelX + sliderPanelWidth - (playButtonsX + this.mediaPlayerController.getPlayButtonsPanel().getWidth() + this.COMP_MARGIN), playerSelectionHeight);
        this.container.validate();
        this.container.repaint();
    }

    @Override
    public void clearLayout() {
        this.checkUnequalOffsets();
        for (int i = 0; i < this.playerList.size(); ++i) {
            PlayerLayoutModel plm = this.playerList.get(i);
            if (this.viewForSyncPlayer.containsKey(plm.player)) {
                SignalPlayerView spv = this.viewForSyncPlayer.get(plm.player);
                this.container.remove(spv);
                this.viewForSyncPlayer.remove(plm.player);
                Controller c = this.controllerForView.get(spv);
                if (c != null) {
                    c.removeControllerListener(spv);
                    plm.player.removeController(c);
                }
                this.viewerManager.disconnectListener(spv);
                spv.setSelectionObject(null);
                this.viewerManager.getSelection().removeSelectionListener(spv);
                spv.setViewerManager(null);
            } else if (plm.isSyncOnly()) {
                Controller c;
                if (plm.player instanceof TSViewerPlayer) {
                    ((TSViewerPlayer)plm.player).getViewer().setSyncModeViewer(false);
                    ((TSViewerPlayer)plm.player).getViewer().setPlayer(this.viewerManager.getMasterMediaPlayer());
                }
                if (plm.player.getVisualComponent() != null) {
                    this.container.remove(plm.player.getVisualComponent());
                }
                if ((c = this.controllerForView.get(plm.player)) != null) {
                    plm.player.removeController(c);
                }
                this.viewerManager.destroyMediaPlayer(plm.player);
            }
            this.container.remove(this.getPlayerLabel(plm.player));
        }
        this.container.remove(this.mediaPlayerController.getPlayButtonsPanel());
        this.container.remove(this.mediaPlayerController.getSliderPanel());
        this.viewerManager.destroyMediaPlayerControlSlider();
        this.container.remove(this.mediaPlayerController.getTimePanel());
        this.viewerManager.destroyTimePanel();
        this.container.remove(this.mediaPlayerController.getSelectionPanel());
        this.container.remove(this.mediaPlayerController.getSelectionButtonsPanel());
        this.viewerManager.destroyViewer(this.mediaPlayerController);
        this.mediaPlayerController = null;
        this.container.remove(this.getPlayerSelectionPanel());
        this.container.remove(this.getVolumeRatePanel());
        this.reconnect();
        this.playerButtons.clear();
        this.playerForName.clear();
        this.nameForPlayer.clear();
        this.labelForPlayer.clear();
        this.playerButtons.clear();
        this.viewForSyncPlayer.clear();
        this.container.repaint();
        if (this.layoutManager.getSignalViewer() != null) {
            this.viewerManager.connectViewer(this.layoutManager.getSignalViewer(), true);
        }
    }

    @Override
    public void initComponents() {
        this.layoutManager.add(this.viewerManager.getMediaPlayerController());
        for (int i = 0; i < this.playerList.size(); ++i) {
            PlayerLayoutModel plm = this.playerList.get(i);
            this.addInternal(plm);
        }
        if (this.layoutManager.getTimeSeriesViewer() != null) {
            TimeSeriesViewer tsViewer = this.layoutManager.getTimeSeriesViewer();
            tsViewer.setTimeScaleConnected(false);
            tsViewer.setTrackManager(this.layoutManager.getTimeSeriesViewer().getTrackManager());
            TSViewerPlayer tsSyncPlayer = new TSViewerPlayer(tsViewer, this.viewerManager.getMasterMediaPlayer().getMediaDuration());
            tsSyncPlayer.setTrackManager(tsViewer.getTrackManager());
            tsSyncPlayer.setMediaTime(this.viewerManager.getMasterMediaPlayer().getMediaTime());
            this.viewerManager.addMediaPlayer(tsSyncPlayer);
            PlayerLayoutModel plModel = new PlayerLayoutModel(tsSyncPlayer, this.layoutManager);
            plModel.setSyncOnly(true);
            this.playerList.add(plModel);
            this.addInternal(plModel);
            if (this.layoutManager.getSignalViewer() != null) {
                this.viewerManager.connectViewer(this.layoutManager.getSignalViewer(), false);
            }
        }
        this.updateLocale();
        this.viewerManager.getActiveAnnotation().setAnnotation(null);
    }

    @Override
    public void enableOrDisableMenus(boolean enabled) {
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(null, 200, enabled);
        ArrayList<String> actions = new ArrayList<String>(8);
        actions.add("CommandActions.NextActiveTier");
        actions.add("CommandActions.PreviousActiveTier");
        actions.add("CommandActions.NextAnnotation");
        actions.add("CommandActions.NextAnnotationEdit");
        actions.add("CommandActions.PreviousAnnotation");
        actions.add("CommandActions.PreviousAnnotationEdit");
        actions.add("CommandActions.AnnotationUp");
        actions.add("CommandActions.AnnotationDown");
        actions.add("Menu.Edit.LinkedFiles");
        this.layoutManager.enableOrDisableActions(actions, enabled);
    }

    @Override
    public void cleanUpOnClose() {
    }

    @Override
    public void shortcutsChanged() {
    }

    @Override
    public void createAndAddViewer(String viewerName) {
    }

    @Override
    public boolean destroyAndRemoveViewer(String viewerName) {
        return false;
    }

    @Override
    public void isClosing() {
        Preferences.set("MediaControlRate", Float.valueOf((float)this.rateSlider.getValue() / 100.0f), this.viewerManager.getTranscription());
        Preferences.set("MediaControlVolume", Float.valueOf((float)this.volSlider.getValue() / 100.0f), this.viewerManager.getTranscription());
    }

    @Override
    public List<Zoomable> getZoomableViewers() {
        return null;
    }
}

