/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.Zoomable;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ResizeComponent;
import mpi.eudico.client.annotator.layout.ModeLayoutManager;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.transcriptionMode.PossibleTypesExtractor;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionModePlayerController;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionModeSettingsDlg;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionViewer;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class TranscriptionManager
implements ModeLayoutManager,
ActionListener {
    private ElanLayoutManager layoutManager;
    private Container container;
    private ViewerManager2 viewerManager;
    private Transcription transcription;
    private SignalViewer signalViewer;
    private ResizeComponent horMediaResizer;
    private TranscriptionModePlayerController playerController;
    private TranscriptionViewer transViewer;
    private JScrollPane settingsScrollPane;
    private JCheckBox autoPlayBackCB;
    private JCheckBox autoCreateAnnCB;
    private JCheckBox showTierNamesCB;
    private JCheckBox showColorOnlyOnNoColumnCB;
    private JCheckBox moveViaColumnCB;
    private JCheckBox showActiveCellInCenterCB;
    private JButton changeTypesButton;
    private final String toopTipAlignLeft = ElanLocale.getString("TranscriptionManager.AlignVideoLeft");
    private final String toopTipAlignRight = ElanLocale.getString("TranscriptionManager.AlignVideoRight");
    private Icon alignLeftIcon;
    private Icon alignRightIcon;
    private JButton butAlignVideoToRight;
    private boolean videoInRight = false;
    private boolean initialized = false;
    private int numVisualPlayers;
    private static int DEF_SIGNAL_HEIGHT = 200;
    private static final Dimension BUTTON_SIZE = new Dimension(30, 20);
    public static final String COMBOBOX_DEFAULT_STRING = ElanLocale.getString("TranscriptionManager.ComboBoxDefaultString");
    private float zoomLevelSignalViewer = -1.0f;
    private MouseListener mouseListener;
    private MouseMotionListener motionListener;

    public TranscriptionManager(ViewerManager2 viewerManager, ElanLayoutManager elanLayoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = elanLayoutManager;
        this.transcription = viewerManager.getTranscription();
        if (viewerManager.getMasterMediaPlayer() != null) {
            viewerManager.getMasterMediaPlayer().setMediaTime(0L);
        }
        this.container = this.layoutManager.getContainer();
        this.horMediaResizer = new ResizeComponent(this.layoutManager, 0);
        this.horMediaResizer.setBorder(new SoftBevelBorder(0));
        this.horMediaResizer.setPreferredSize(new Dimension(7, this.container.getHeight()));
        Component n = this.horMediaResizer.getComponent(0);
        this.horMediaResizer.remove(n);
        this.horMediaResizer.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 20;
        gbc.weighty = 1.0;
        this.horMediaResizer.add(n, gbc);
        this.container.add(this.horMediaResizer);
    }

    @Override
    public void add(Object object) {
        if (object instanceof SignalViewer) {
            this.setSignalViewer((SignalViewer)object);
        } else if (object instanceof TranscriptionModePlayerController) {
            this.setMediaPlayerController((TranscriptionModePlayerController)object);
        }
    }

    private void setSignalViewer(SignalViewer sigViewer) {
        this.signalViewer = sigViewer;
        this.signalViewer.removeMouseListener(this.signalViewer);
        this.signalViewer.removeMouseMotionListener(this.signalViewer);
        this.signalViewer.setEnabled(false);
        this.signalViewer.setMediaTime(0L);
        this.signalViewer.setSelection(0L, 0L);
        this.signalViewer.setLoadTranscriptionMode(true);
        this.container.add(this.signalViewer);
        this.signalViewer.setBorder(new SoftBevelBorder(1));
        if (this.initialized) {
            this.doLayout();
            this.transViewer.updateSignalViewer(this.signalViewer);
        }
        this.initializeMouseListener();
        this.signalViewer.addMouseListener(this.mouseListener);
        this.signalViewer.addMouseMotionListener(this.motionListener);
    }

    private void initializeMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (TranscriptionManager.this.playerIsPlaying()) {
                        TranscriptionManager.this.stopPlayer();
                    }
                    TranscriptionManager.this.signalViewer.mouseClicked(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (TranscriptionManager.this.playerIsPlaying()) {
                        TranscriptionManager.this.stopPlayer();
                    }
                    TranscriptionManager.this.signalViewer.mousePressed(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    TranscriptionManager.this.signalViewer.mouseReleased(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    TranscriptionManager.this.signalViewer.mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TranscriptionManager.this.signalViewer.mouseExited(e);
                }
            };
        }
        if (this.motionListener == null) {
            this.motionListener = new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (TranscriptionManager.this.playerIsPlaying()) {
                        TranscriptionManager.this.stopPlayer();
                    }
                    TranscriptionManager.this.signalViewer.mouseDragged(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    TranscriptionManager.this.signalViewer.mouseMoved(e);
                }
            };
        }
    }

    private boolean playerIsPlaying() {
        return this.viewerManager.getMasterMediaPlayer().isPlaying();
    }

    private void stopPlayer() {
        if (this.playerController != null) {
            this.playerController.stopLoop();
        }
        this.viewerManager.getMasterMediaPlayer().stop();
    }

    private void setMediaPlayerController(TranscriptionModePlayerController mediaPlayerController) {
        if (mediaPlayerController == null) {
            return;
        }
        this.playerController = mediaPlayerController;
        this.container.add(this.playerController.getVolumeRatePanel());
        this.container.add(this.playerController.getPlayButtonsPanel());
        this.container.add(this.playerController.getModePanel());
        this.container.add(this.playerController.getSelectionButtonsPanel());
        this.container.add(this.playerController.getSelectionPanel());
    }

    private void destroyMediaPlayerController() {
        if (this.playerController == null) {
            return;
        }
        this.container.remove(this.playerController.getVolumeRatePanel());
        this.container.remove(this.playerController.getPlayButtonsPanel());
        this.container.remove(this.playerController.getSelectionButtonsPanel());
        this.container.remove(this.playerController.getSelectionPanel());
        this.container.remove(this.playerController.getModePanel());
        this.playerController = null;
    }

    @Override
    public void remove(Object object) {
        if (object instanceof SignalViewer && this.signalViewer != null) {
            this.container.remove(this.signalViewer);
            this.signalViewer = null;
        }
    }

    @Override
    public void doLayout() {
        float thirdAR;
        float secondAR;
        Component secondVisualComp;
        float aspectRatio;
        int containerWidth = this.container.getWidth();
        int containerHeight = this.container.getHeight();
        int containerMargin = 3;
        int componentMargin = 5;
        int mediaAreaWidth = this.layoutManager.getMediaAreaWidth();
        int visibleMediaX = containerMargin;
        int visibleMediaY = containerMargin;
        PlayerLayoutModel[] visualPlayers = this.layoutManager.getAttachedVisualPlayers();
        this.numVisualPlayers = visualPlayers.length;
        if (this.numVisualPlayers == 0 && this.videoInRight) {
            visibleMediaX = containerWidth - (mediaAreaWidth + containerMargin);
        }
        if (this.numVisualPlayers >= 1) {
            Component firstVisualComp = visualPlayers[0].visualComponent;
            aspectRatio = visualPlayers[0].player.getAspectRatio();
            if (aspectRatio == 0.0f) {
                aspectRatio = 1.0f;
            }
            int firstMediaHeight = (int)((float)mediaAreaWidth / aspectRatio);
            if (this.videoInRight) {
                visibleMediaX = containerWidth - (mediaAreaWidth + containerMargin);
            }
            firstVisualComp.setBounds(visibleMediaX, visibleMediaY, mediaAreaWidth, firstMediaHeight);
            visibleMediaY += firstMediaHeight;
        }
        if (this.numVisualPlayers == 2) {
            secondVisualComp = visualPlayers[1].visualComponent;
            aspectRatio = visualPlayers[1].player.getAspectRatio();
            if (aspectRatio == 0.0f) {
                aspectRatio = 1.0f;
            }
            int secondMediaHeight = (int)((float)mediaAreaWidth / aspectRatio);
            secondVisualComp.setBounds(visibleMediaX, visibleMediaY += componentMargin, mediaAreaWidth, secondMediaHeight);
            visibleMediaY += secondMediaHeight;
        } else if (this.numVisualPlayers == 3) {
            secondVisualComp = visualPlayers[1].visualComponent;
            secondAR = visualPlayers[1].player.getAspectRatio();
            if (secondAR == 0.0f) {
                secondAR = 1.0f;
            }
            Component thirdVisualComp = visualPlayers[2].visualComponent;
            thirdAR = visualPlayers[2].player.getAspectRatio();
            if (thirdAR == 0.0f) {
                thirdAR = 1.0f;
            }
            int widthPerPlayer = (mediaAreaWidth - componentMargin) / 2;
            int secondHeight = (int)((float)widthPerPlayer / secondAR);
            int thirdHeight = (int)((float)widthPerPlayer / thirdAR);
            int heightPerPlayer = Math.max(secondHeight, thirdHeight);
            secondVisualComp.setBounds(visibleMediaX, visibleMediaY += componentMargin, widthPerPlayer, secondHeight);
            thirdVisualComp.setBounds(visibleMediaX + widthPerPlayer + componentMargin, visibleMediaY, widthPerPlayer, thirdHeight);
            visibleMediaY += heightPerPlayer;
        } else if (this.numVisualPlayers >= 4) {
            secondVisualComp = visualPlayers[1].visualComponent;
            secondAR = visualPlayers[1].player.getAspectRatio();
            if (secondAR == 0.0f) {
                secondAR = 1.0f;
            }
            Component thirdVisualComp = visualPlayers[2].visualComponent;
            thirdAR = visualPlayers[2].player.getAspectRatio();
            if (thirdAR == 0.0f) {
                thirdAR = 1.0f;
            }
            Component fourthVisualComp = visualPlayers[3].visualComponent;
            float fourthAR = visualPlayers[3].player.getAspectRatio();
            if (fourthAR == 0.0f) {
                fourthAR = 1.0f;
            }
            int widthPerPlayer = (mediaAreaWidth - 2 * componentMargin) / 3;
            int secondHeight = (int)((float)widthPerPlayer / secondAR);
            int thirdHeight = (int)((float)widthPerPlayer / thirdAR);
            int fourthHeight = (int)((float)widthPerPlayer / fourthAR);
            int heightPerPlayer = Math.max(secondHeight, thirdHeight);
            heightPerPlayer = Math.max(heightPerPlayer, fourthHeight);
            secondVisualComp.setBounds(visibleMediaX, visibleMediaY += componentMargin, widthPerPlayer, secondHeight);
            thirdVisualComp.setBounds(visibleMediaX + widthPerPlayer + componentMargin, visibleMediaY, widthPerPlayer, thirdHeight);
            fourthVisualComp.setBounds(visibleMediaX + 2 * widthPerPlayer + 2 * componentMargin, visibleMediaY, widthPerPlayer, fourthHeight);
            visibleMediaY += heightPerPlayer;
        }
        int timePanelX = visibleMediaX;
        int timePanelY = visibleMediaY + 2;
        int timePanelWidth = 0;
        int timePanelHeight = 0;
        if (this.viewerManager != null) {
            timePanelWidth = this.viewerManager.getTimePanel().getPreferredSize().width;
            timePanelHeight = this.viewerManager.getTimePanel().getPreferredSize().height;
            if (this.numVisualPlayers > 0) {
                timePanelX = visibleMediaX + mediaAreaWidth / 2 - timePanelWidth / 2;
            }
            this.viewerManager.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
        }
        int butAlignVideoX = visibleMediaX;
        int butAlignVideoY = timePanelY + timePanelHeight + 4;
        int butAlignVideoWidth = this.butAlignVideoToRight.getPreferredSize().width;
        int butAlignVideoHeight = this.butAlignVideoToRight.getPreferredSize().height;
        this.butAlignVideoToRight.setBounds(butAlignVideoX, butAlignVideoY, butAlignVideoWidth, butAlignVideoHeight);
        int playButtonX = butAlignVideoX + butAlignVideoWidth;
        int playButtonY = butAlignVideoY;
        int playButtonWidth = 0;
        int playButtonHeight = 0;
        if (this.playerController != null) {
            playButtonWidth = this.playerController.getPlayButtonsPanel().getPreferredSize().width;
            playButtonHeight = this.playerController.getPlayButtonsPanel().getPreferredSize().height;
            if (this.numVisualPlayers > 0) {
                playButtonX = visibleMediaX + mediaAreaWidth / 2 - playButtonWidth * 4 / 2;
            }
            if (playButtonX < butAlignVideoX + butAlignVideoWidth) {
                playButtonX = butAlignVideoX + butAlignVideoWidth;
            }
            this.playerController.getPlayButtonsPanel().setBounds(playButtonX, playButtonY, playButtonWidth, playButtonHeight);
        }
        int selButtonPanelX = playButtonX + playButtonWidth;
        int selButtonPanelY = playButtonY;
        int selButtonPanelWidth = 0;
        int selButtonPanelHeight = 0;
        if (this.playerController != null) {
            selButtonPanelWidth = this.playerController.getSelectionButtonsPanel().getPreferredSize().width;
            selButtonPanelHeight = this.playerController.getSelectionButtonsPanel().getPreferredSize().height;
            this.playerController.getSelectionButtonsPanel().setBounds(selButtonPanelX, selButtonPanelY, selButtonPanelWidth, selButtonPanelHeight);
        }
        int loopModeCBX = selButtonPanelX + selButtonPanelWidth;
        int loopModeCBY = selButtonPanelY;
        int loopModeCBWidth = 0;
        int loopModeCBHeight = 0;
        if (this.playerController != null) {
            loopModeCBWidth = this.playerController.getModePanel().getPreferredSize().width;
            loopModeCBHeight = this.playerController.getModePanel().getPreferredSize().height;
            if (this.numVisualPlayers > 0 || this.signalViewer != null) {
                loopModeCBX = visibleMediaX + mediaAreaWidth - loopModeCBWidth;
            }
            if (loopModeCBX < selButtonPanelX + selButtonPanelHeight) {
                loopModeCBX = visibleMediaX;
                loopModeCBY = selButtonPanelY + selButtonPanelHeight + 5;
            }
            this.playerController.getModePanel().setBounds(loopModeCBX, loopModeCBY, loopModeCBWidth, loopModeCBHeight);
        }
        int selPanelX = visibleMediaX;
        int selPanelY = loopModeCBY + loopModeCBHeight + 10;
        int selPanelWidth = 0;
        int selPanelHeight = 0;
        if (this.playerController != null) {
            selPanelWidth = this.playerController.getSelectionPanel().getPreferredSize().width;
            selPanelHeight = this.playerController.getSelectionPanel().getPreferredSize().height;
            if (this.signalViewer != null) {
                selPanelX = visibleMediaX + mediaAreaWidth / 2 - selPanelWidth / 2;
            }
            this.playerController.getSelectionPanel().setBounds(selPanelX, selPanelY, selPanelWidth, selPanelHeight);
        }
        int signalX = visibleMediaX;
        int signalY = selPanelY + selPanelHeight + 10;
        int signalWidth = mediaAreaWidth;
        int signalHeight = 0;
        if (this.signalViewer != null) {
            signalHeight = DEF_SIGNAL_HEIGHT / 2;
            this.signalViewer.setBounds(signalX, signalY, signalWidth, signalHeight);
        }
        int volX = visibleMediaX;
        int volY = signalY + signalHeight + 10;
        int volWidth = mediaAreaWidth;
        int volHeight = DEF_SIGNAL_HEIGHT / 2;
        if (this.playerController != null) {
            this.playerController.getVolumeRatePanel().setBounds(volX, volY, volWidth, volHeight);
        }
        int settingsPanelX = visibleMediaX;
        int settingsPanelY = volY + volHeight + 10;
        int settingsPanelWidth = mediaAreaWidth;
        int settingsPanelHeight = this.getSettingsScrollPane().getPreferredSize().height + this.getSettingsScrollPane().getHorizontalScrollBar().getPreferredSize().height;
        int availableSpace = containerHeight - containerMargin - settingsPanelY;
        if (settingsPanelHeight > availableSpace) {
            settingsPanelHeight = availableSpace;
        }
        this.getSettingsScrollPane().setBounds(settingsPanelX, settingsPanelY, settingsPanelWidth, settingsPanelHeight);
        int divX = visibleMediaX + mediaAreaWidth + containerMargin;
        int divY = 0;
        int divWidth = this.horMediaResizer.getPreferredSize().width;
        if (this.videoInRight) {
            divX = visibleMediaX - containerMargin - divWidth;
        }
        this.horMediaResizer.setBounds(divX, divY, divWidth, containerHeight);
        if (this.viewerManager.getMasterMediaPlayer() instanceof EmptyMediaPlayer && this.signalViewer == null) {
            if (this.viewerManager.getTimePanel() != null) {
                this.viewerManager.getTimePanel().setBounds(0, 0, 0, 0);
            }
            if (this.playerController != null) {
                this.playerController.getPlayButtonsPanel().setBounds(0, 0, 0, 0);
                this.playerController.getVolumeRatePanel().setBounds(0, 0, 0, 0);
                this.playerController.getModePanel().setBounds(0, 0, 0, 0);
                this.playerController.getSelectionButtonsPanel().setBounds(0, 0, 0, 0);
                this.playerController.getSelectionPanel().setBounds(0, 0, 0, 0);
            }
            settingsPanelY = butAlignVideoY + butAlignVideoHeight + 4;
            this.getSettingsScrollPane().setBounds(settingsPanelX, settingsPanelY, settingsPanelWidth, settingsPanelHeight);
        }
        int transPanelX = divX + divWidth + containerMargin;
        int transPanelY = containerMargin;
        int transPanelWidth = containerWidth - transPanelX - containerMargin;
        int transPanelHeight = containerHeight - transPanelY - containerMargin;
        if (this.videoInRight) {
            transPanelX = containerMargin;
            transPanelWidth = containerWidth - mediaAreaWidth - 3 * containerMargin - divWidth;
        }
        this.transViewer.setBounds(transPanelX, transPanelY, transPanelWidth, transPanelHeight);
        this.transViewer.setScrollerSize(transPanelWidth, transPanelHeight);
        this.container.validate();
    }

    @Override
    public void detach(Object object) {
        this.transViewer.focusTable();
    }

    @Override
    public void attach(Object object) {
        this.transViewer.focusTable();
    }

    @Override
    public void updateLocale() {
        if (this.settingsScrollPane != null) {
            this.changeTypesButton.setText(ElanLocale.getString("TranscriptionManager.ChangeSettings"));
            this.autoPlayBackCB.setText(ElanLocale.getString("TranscriptionManager.AutoPlayBack"));
            this.autoCreateAnnCB.setText(ElanLocale.getString("TranscriptionManager.AutoCreateAnnotations"));
            this.showActiveCellInCenterCB.setText(ElanLocale.getString("TranscriptionManager.ShowActiveCellInCenter"));
            this.showTierNamesCB.setText(ElanLocale.getString("TranscriptionManager.ShowTierNames"));
            this.showColorOnlyOnNoColumnCB.setText(ElanLocale.getString("TranscriptionManager.ShowColorOnlyOnNoColumn"));
            this.moveViaColumnCB.setText(ElanLocale.getString("TranscriptionManager.MoveViaColumn"));
        }
    }

    @Override
    public void clearLayout() {
        this.container.remove(this.horMediaResizer);
        this.container.remove(this.transViewer);
        this.container.remove(this.butAlignVideoToRight);
        this.container.remove(this.getSettingsScrollPane());
        this.container.remove(this.viewerManager.getTimePanel());
        this.viewerManager.destroyTimePanel();
        this.viewerManager.destroyViewerByName("Menu.View.Viewers.Transcription");
        this.destroyMediaPlayerController();
        this.transViewer = null;
        if (this.signalViewer != null) {
            this.container.remove(this.signalViewer);
        }
        this.container.repaint();
    }

    @Override
    public void cleanUpOnClose() {
    }

    @Override
    public void initComponents() {
        Float zoom = Preferences.getFloat("SignalViewer.ZoomLevel", this.transcription);
        this.zoomLevelSignalViewer = zoom != null ? zoom.floatValue() : -1.0f;
        this.transViewer = this.viewerManager.createTranscriptionViewer();
        this.transViewer.intializeViewer(this);
        this.container.add(this.transViewer);
        this.playerController = new TranscriptionModePlayerController(this.viewerManager, this.transViewer);
        this.add(this.playerController);
        this.container.add(this.viewerManager.getTimePanel());
        this.container.add(this.getSettingsScrollPane());
        this.alignLeftIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/AlignLeft16.gif"));
        this.alignRightIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/AlignRight16.gif"));
        this.butAlignVideoToRight = new JButton();
        this.butAlignVideoToRight.setIcon(this.alignRightIcon);
        this.butAlignVideoToRight.setPreferredSize(BUTTON_SIZE);
        this.butAlignVideoToRight.addActionListener(this);
        this.butAlignVideoToRight.setToolTipText(this.toopTipAlignRight);
        this.container.add(this.butAlignVideoToRight);
        this.createAndAddViewer("Menu.View.Viewers.Signal");
        Boolean val = Preferences.getBool("TranscriptionManager.PlaceVideoInRight", this.transcription);
        if (val != null && val.booleanValue()) {
            this.alignVideo();
        }
        this.doLayout();
        this.loadPreferences();
        this.initialized = true;
    }

    public ElanLayoutManager getElanLayoutManager() {
        return this.layoutManager;
    }

    public TranscriptionModePlayerController getTranscriptionModePlayerController() {
        return this.playerController;
    }

    private JScrollPane getSettingsScrollPane() {
        if (this.settingsScrollPane != null) {
            return this.settingsScrollPane;
        }
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        this.changeTypesButton = new JButton(ElanLocale.getString("TranscriptionManager.ChangeSettings"));
        this.changeTypesButton.addActionListener(this);
        this.autoPlayBackCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.AutoPlayBack"));
        this.autoPlayBackCB.setSelected(true);
        this.autoPlayBackCB.addActionListener(this);
        this.autoCreateAnnCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.AutoCreateAnnotations"));
        this.autoCreateAnnCB.setSelected(true);
        this.autoCreateAnnCB.addActionListener(this);
        this.showActiveCellInCenterCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.ShowActiveCellInCenter"));
        this.showActiveCellInCenterCB.setSelected(false);
        this.showActiveCellInCenterCB.addActionListener(this);
        this.showTierNamesCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.ShowTierNames"));
        this.showTierNamesCB.setSelected(true);
        this.showTierNamesCB.addActionListener(this);
        this.showColorOnlyOnNoColumnCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.ShowColorOnlyOnNoColumn"));
        this.showColorOnlyOnNoColumnCB.setSelected(false);
        this.showColorOnlyOnNoColumnCB.setEnabled(false);
        this.showColorOnlyOnNoColumnCB.addActionListener(this);
        this.moveViaColumnCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.MoveViaColumn"));
        this.moveViaColumnCB.addActionListener(this);
        Insets insets = new Insets(1, 1, 1, 1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridy = 0;
        settingsPanel.add((Component)this.autoPlayBackCB, gbc);
        ++gbc.gridy;
        settingsPanel.add((Component)this.autoCreateAnnCB, gbc);
        ++gbc.gridy;
        settingsPanel.add((Component)this.showTierNamesCB, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(1, 22, 1, 1);
        settingsPanel.add((Component)this.showColorOnlyOnNoColumnCB, gbc);
        ++gbc.gridy;
        gbc.insets = insets;
        settingsPanel.add((Component)this.moveViaColumnCB, gbc);
        ++gbc.gridy;
        settingsPanel.add((Component)this.showActiveCellInCenterCB, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        settingsPanel.add((Component)this.changeTypesButton, gbc);
        settingsPanel.setBorder(null);
        this.settingsScrollPane = new JScrollPane(settingsPanel);
        this.settingsScrollPane.setBorder(new TitledBorder(ElanLocale.getString("TranscriptionManager.ChangeSettingsDlg.Title")));
        this.settingsScrollPane.setBackground(settingsPanel.getBackground());
        return this.settingsScrollPane;
    }

    private void loadPreferences() {
        PossibleTypesExtractor computeTypes;
        List<String> possibleTypes;
        this.transViewer.loadPreferences();
        Boolean val = Preferences.getBool("TranscriptionManager.MoveViaColumn", null);
        if (val != null) {
            this.moveViaColumnCB.setSelected(val);
            this.transViewer.moveViaColumn(val);
        }
        if ((val = Preferences.getBool("TranscriptionManager.AutoPlayBack", null)) != null) {
            this.autoPlayBackCB.setSelected(val);
            this.transViewer.setAutoPlayBack(val);
        }
        if ((val = Preferences.getBool("TranscriptionManager.AutoCreateAnnotation", null)) != null) {
            this.autoCreateAnnCB.setSelected(val);
            this.transViewer.autoCreateAnnotations(val);
        }
        if ((val = Preferences.getBool("TranscriptionManager.ScrollToCenter", null)) != null) {
            this.showActiveCellInCenterCB.setSelected(val);
            this.transViewer.scrollActiveCellInCenter(val);
        }
        if ((val = Preferences.getBool("TranscriptionManager.ShowTierNames", null)) != null) {
            this.showTierNamesCB.setSelected(val);
            this.transViewer.showTierNames(val);
            if (this.showTierNamesCB.isSelected()) {
                this.showColorOnlyOnNoColumnCB.setEnabled(false);
            } else {
                this.showColorOnlyOnNoColumnCB.setEnabled(true);
            }
        }
        if ((val = Preferences.getBool("TranscriptionManager.ShowColorOnlyOnNoColumn", null)) != null) {
            this.showColorOnlyOnNoColumnCB.setSelected(val);
            this.transViewer.showColorOnlyOnNoColumn(val);
        }
        List<String> types = null;
        types = Preferences.getListOfString("TranscriptionTable.ColumnTypes", this.transcription);
        if (types == null) {
            ArrayList<String> colTypes = new ArrayList<String>();
            String stringPref = Preferences.getString("TranscriptionTable.Column1Type", this.transcription);
            if (stringPref != null) {
                colTypes.add(stringPref);
                stringPref = Preferences.getString("TranscriptionTable.Column2Type", this.transcription);
                if (stringPref != null) {
                    colTypes.add(stringPref);
                    stringPref = Preferences.getString("TranscriptionTable.Column3Type", this.transcription);
                    if (stringPref != null) {
                        colTypes.add(stringPref);
                    }
                }
            }
            if (!colTypes.isEmpty()) {
                types = colTypes;
            }
        }
        ArrayList<String> validTypes = new ArrayList<String>();
        ArrayList<Integer> deletedTypeIndexList = new ArrayList<Integer>();
        if (types != null && types.size() > 0 && (possibleTypes = (computeTypes = new PossibleTypesExtractor((TranscriptionImpl)this.viewerManager.getTranscription())).getPossibleTypesForColumn(1, validTypes)).contains(types.get(0))) {
            validTypes.add(types.get(0));
            for (int i = 1; i < types.size(); ++i) {
                possibleTypes = computeTypes.getPossibleTypesForColumn(validTypes.size() + 1, validTypes);
                if (possibleTypes.contains(types.get(i))) {
                    validTypes.add(types.get(i));
                    continue;
                }
                deletedTypeIndexList.add(i);
            }
        }
        Integer intPref = Preferences.getInt("TranscriptionTable.FontSize", null);
        if (validTypes == null || validTypes.size() <= 0) {
            TranscriptionModeSettingsDlg settingsDialog = new TranscriptionModeSettingsDlg(this.layoutManager, null, null, null, intPref);
            settingsDialog.setVisible(true);
            this.applyChanges(settingsDialog.getTierMap(), settingsDialog.getHiddenTiersList(), settingsDialog.getColumnTypeList(), settingsDialog.getFontSize(), settingsDialog.isValueChanged());
        } else {
            Map<TierImpl, List<TierImpl>> tierMap = null;
            List<String> hiddenTiersList = null;
            Map<String, List<String>> map = Preferences.getMap("TranscriptionTable.TierMap", this.viewerManager.getTranscription());
            if (map != null) {
                tierMap = this.getValidatedTierMap(map, deletedTypeIndexList);
            }
            if (tierMap != null) {
                List<String> valList = Preferences.getListOfString("TranscriptionTable.HiddenTiers", this.viewerManager.getTranscription());
                if (valList != null) {
                    hiddenTiersList = this.getValidatedTierList(valList);
                }
                if ((valList = Preferences.getListOfString("TranscriptionTable.NonEditableTiers", this.viewerManager.getTranscription())) != null) {
                    this.transViewer.setNoneditableTier(this.getValidatedTierList(valList));
                }
            }
            this.applyChanges(tierMap, hiddenTiersList, validTypes, intPref, true);
            this.transViewer.updateTable();
        }
    }

    private Map<TierImpl, List<TierImpl>> getValidatedTierMap(Map<String, List<String>> map, List<Integer> deletedTypeIndexList) {
        HashMap<TierImpl, List<TierImpl>> validMap = new HashMap<TierImpl, List<TierImpl>>();
        List<String> tierNamesList = null;
        ArrayList<TierImpl> tierList = null;
        Iterator<String> keyIt = map.keySet().iterator();
        TierImpl referenceTier = null;
        while (keyIt.hasNext()) {
            String keyObj = keyIt.next();
            referenceTier = null;
            if (!(map.get(keyObj) instanceof List)) continue;
            tierNamesList = map.get(keyObj);
            referenceTier = (TierImpl)this.viewerManager.getTranscription().getTierWithId(keyObj);
            if (referenceTier == null) continue;
            tierList = new ArrayList<TierImpl>();
            for (int i = 0; i < tierNamesList.size(); ++i) {
                if (deletedTypeIndexList.contains(i)) continue;
                String tierName = tierNamesList.get(i);
                if (tierName.equals("No tier")) {
                    tierList.add(null);
                    continue;
                }
                if (tierName.equals(keyObj)) {
                    tierList.add(referenceTier);
                    continue;
                }
                tierList.add((TierImpl)this.viewerManager.getTranscription().getTierWithId(tierName));
            }
            validMap.put(referenceTier, tierList);
        }
        if (validMap.keySet().size() <= 0) {
            return null;
        }
        return validMap;
    }

    private List<String> getValidatedTierList(List<String> tierNames) {
        ArrayList<String> tierList = new ArrayList<String>();
        for (int i = 0; i < tierNames.size(); ++i) {
            String tierName = tierNames.get(i);
            if (this.viewerManager.getTranscription().getTierWithId(tierName) == null) continue;
            tierList.add(tierNames.get(i));
        }
        return tierList;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void editInAnnotationMode() {
        ((ElanFrame2)this.layoutManager.getElanFrame()).setMenuSelected("Menu.Options.AnnotationMode", 700);
        this.layoutManager.changeMode(1);
    }

    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    private void applyChanges(Map<TierImpl, List<TierImpl>> hashMap, List<String> hiddenTiers, List<String> types, Integer size, boolean valueChanged) {
        if (types == null) {
            this.transViewer.focusTable();
            return;
        }
        if (valueChanged) {
            this.transViewer.setColumnTypeList(types);
            this.transViewer.setTierMap(hashMap);
            this.transViewer.setHiddenTiersList(hiddenTiers);
        }
        if (size != null) {
            if (size != this.transViewer.getFontSize()) {
                this.transViewer.setFontSize(size);
            }
            this.setPreference("TranscriptionTable.FontSize", this.transViewer.getFontSize(), null);
        }
        if (valueChanged) {
            this.transViewer.loadTable();
            this.transViewer.checkForMerge();
        }
        this.transViewer.reValidateTable();
        this.transViewer.focusTable();
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public void enableOrDisableMenus(boolean enabled) {
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(null, 200, enabled);
        CommandAction act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.DeleteAnnotation");
        if (act != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.MergeWithNext")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.MergeWithBefore")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.ClearSelection")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.ToggleCrosshairInSelection")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.MoveCrosshairToCenterOfSelection")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.PlayPause")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.PlaySelection")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "CommandActions.PlayAroundSelection")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.1PixelLeft")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.1PixelRight")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.Previous")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.Next")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.1SecLeft")) != null) {
            act.setEnabled(enabled);
        }
        if ((act = ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.1SecRight")) != null) {
            act.setEnabled(enabled);
        }
    }

    private void alignVideo() {
        this.videoInRight = !this.videoInRight;
        this.horMediaResizer.changeBehaviourToDecrease(this.videoInRight);
        if (this.videoInRight) {
            this.butAlignVideoToRight.setToolTipText(this.toopTipAlignLeft);
            this.butAlignVideoToRight.setIcon(this.alignLeftIcon);
        } else {
            this.butAlignVideoToRight.setToolTipText(this.toopTipAlignRight);
            this.butAlignVideoToRight.setIcon(this.alignRightIcon);
        }
        this.doLayout();
        this.setPreference("TranscriptionManager.PlaceVideoInRight", this.videoInRight, this.transcription);
        this.transViewer.focusTable();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butAlignVideoToRight) {
            this.alignVideo();
        } else if (e.getSource() == this.changeTypesButton) {
            this.viewerManager.getMasterMediaPlayer().stop();
            TranscriptionModeSettingsDlg settingsDialog = new TranscriptionModeSettingsDlg(this.layoutManager, this.transViewer.getColumnTypes(), this.transViewer.getTierMap(), this.transViewer.getHiddenTiers(), this.transViewer.getFontSize());
            settingsDialog.setVisible(true);
            this.applyChanges(settingsDialog.getTierMap(), settingsDialog.getHiddenTiersList(), settingsDialog.getColumnTypeList(), settingsDialog.getFontSize(), settingsDialog.isValueChanged());
        } else {
            if (e.getSource() == this.showTierNamesCB) {
                this.transViewer.showTierNames(this.showTierNamesCB.isSelected());
                this.setPreference("TranscriptionManager.ShowTierNames", this.showTierNamesCB.isSelected(), null);
                if (this.showTierNamesCB.isSelected()) {
                    this.showColorOnlyOnNoColumnCB.setEnabled(false);
                } else {
                    this.showColorOnlyOnNoColumnCB.setEnabled(true);
                }
            } else if (e.getSource() == this.showColorOnlyOnNoColumnCB) {
                this.transViewer.showColorOnlyOnNoColumn(this.showColorOnlyOnNoColumnCB.isSelected());
                this.setPreference("TranscriptionManager.ShowColorOnlyOnNoColumn", this.showColorOnlyOnNoColumnCB.isSelected(), null);
            } else if (e.getSource() == this.moveViaColumnCB) {
                this.transViewer.moveViaColumn(this.moveViaColumnCB.isSelected());
                this.setPreference("TranscriptionManager.MoveViaColumn", this.moveViaColumnCB.isSelected(), null);
            } else if (e.getSource() == this.autoPlayBackCB) {
                this.transViewer.setAutoPlayBack(this.autoPlayBackCB.isSelected());
                this.setPreference("TranscriptionManager.AutoPlayBack", this.autoPlayBackCB.isSelected(), null);
            } else if (e.getSource() == this.autoCreateAnnCB) {
                this.transViewer.autoCreateAnnotations(this.autoCreateAnnCB.isSelected());
                this.setPreference("TranscriptionManager.AutoCreateAnnotation", this.autoCreateAnnCB.isSelected(), null);
            } else if (e.getSource() == this.showActiveCellInCenterCB) {
                this.transViewer.scrollActiveCellInCenter(this.showActiveCellInCenterCB.isSelected());
                this.setPreference("TranscriptionManager.ScrollToCenter", this.showActiveCellInCenterCB.isSelected(), null);
            }
            this.transViewer.focusTable();
        }
    }

    @Override
    public void shortcutsChanged() {
        this.transViewer.shortcutsChanged();
        this.playerController.updateLocale();
    }

    @Override
    public void createAndAddViewer(String viewerName) {
        if (viewerName == null) {
            return;
        }
        if (viewerName.equals("Menu.View.Viewers.Signal")) {
            this.layoutManager.add(this.viewerManager.createSignalViewer());
        }
    }

    @Override
    public boolean destroyAndRemoveViewer(String viewerName) {
        if (viewerName == null) {
            return false;
        }
        if (viewerName.equals("Menu.View.Viewers.Signal") && this.signalViewer != null) {
            this.container.remove(this.signalViewer);
            this.signalViewer = null;
            this.viewerManager.destroyViewerByName("Menu.View.Viewers.Signal");
            return true;
        }
        return false;
    }

    @Override
    public void isClosing() {
        this.playerController.isClosing();
        this.transViewer.isClosing();
        if (this.signalViewer != null) {
            this.signalViewer.removeMouseListener(this.mouseListener);
            this.signalViewer.removeMouseMotionListener(this.motionListener);
            this.signalViewer.addMouseListener(this.signalViewer);
            this.signalViewer.addMouseMotionListener(this.signalViewer);
            this.signalViewer.setRecalculateInterval(true);
            this.signalViewer.setBorder(null);
            this.signalViewer.updateInterval(0L, this.viewerManager.getMasterMediaPlayer().getMediaDuration());
            this.signalViewer.setMediaTime(this.viewerManager.getMasterMediaPlayer().getMediaTime());
            this.signalViewer.setEnabled(true);
            Float zoom = Preferences.getFloat("SignalViewer.ZoomLevel", this.transcription);
            if (zoom != null) {
                this.setPreference("TM.SignalViewer.ZoomLevel", Float.valueOf(zoom.floatValue()), this.transcription);
            }
            if (this.zoomLevelSignalViewer > -1.0f) {
                this.setPreference("SignalViewer.ZoomLevel", Float.valueOf(this.zoomLevelSignalViewer), this.transcription);
            } else {
                this.setPreference("SignalViewer.ZoomLevel", Float.valueOf(100.0f), this.transcription);
            }
            this.signalViewer.preferencesChanged();
            this.signalViewer.setLoadTranscriptionMode(false);
        }
        this.transViewer.setActiveAnnotation();
    }

    @Override
    public List<Zoomable> getZoomableViewers() {
        ArrayList<Zoomable> zoomList = new ArrayList<Zoomable>(2);
        if (this.transViewer != null) {
            zoomList.add(this.transViewer);
        }
        if (this.signalViewer != null) {
            // empty if block
        }
        return zoomList;
    }
}

