/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import mpi.eudico.client.annotator.lexicon.api.Param;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LexSrvcClntParser
extends DefaultHandler {
    private InputStream inputStream;
    public ArrayList<Param> paramList;
    public String type;
    public boolean curOsSupported;
    public String name;
    public String implementor;
    public String description;
    String curContent = "";
    Param curParam;

    public LexSrvcClntParser(InputStream inputStream) {
        this.inputStream = inputStream;
        this.paramList = new ArrayList(10);
    }

    public void parse() throws SAXException {
        if (this.inputStream != null) {
            try {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setNamespaceAware(true);
                parserFactory.setValidating(false);
                parserFactory.newSAXParser().parse(this.inputStream, (DefaultHandler)this);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
            catch (ParserConfigurationException pce) {
                throw new SAXException(pce);
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        throw new SAXException("No input stream specified");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.curContent = this.curContent + new String(ch, start, length);
    }

    @Override
    public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
        if (name.equals("lexiconserviceclient")) {
            this.description = attributes.getValue("info");
            this.implementor = attributes.getValue("spiClass");
            this.curOsSupported = true;
        } else if (name.equals("param")) {
            this.curParam = new Param();
            this.curParam.setType(attributes.getValue("type"));
        }
    }

    @Override
    public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
        if (this.curContent != null && this.curContent.length() > 0) {
            if (name.equals("lexiconserviceclient")) {
                this.name = this.curContent.trim();
            } else if (name.equals("param")) {
                this.curParam.setContent(this.curContent.trim());
                this.paramList.add(this.curParam);
            }
        }
        this.curContent = "";
    }
}

