/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.linkedmedia;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.recognizer.gui.RecognizerPanel;
import mpi.eudico.client.annotator.timeseries.TSTrackManager;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.io.TSConfigurationParser;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceRegistry;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.MetadataViewer;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import nl.mpi.util.FileExtension;
import nl.mpi.util.FileUtility;

public class LinkedFileDescriptorUtil {
    public static LinkedFileDescriptor createLFDescriptor(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        String linkURL = FileUtility.pathToURLString(filePath);
        if (linkURL == null) {
            return null;
        }
        String mimeType = null;
        String extension = "";
        if (linkURL.indexOf(46) > -1) {
            extension = linkURL.substring(linkURL.lastIndexOf(46) + 1);
        }
        mimeType = LinkedFileDescriptorUtil.mimeTypeForExtension(extension);
        LinkedFileDescriptor md = new LinkedFileDescriptor(linkURL, mimeType);
        return md;
    }

    public static String mimeTypeForExtension(String extension) {
        int i;
        if (extension == null || extension.length() < 3) {
            return "unknown";
        }
        String lowExt = extension.toLowerCase();
        for (i = 0; i < FileExtension.TEXT_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.TEXT_EXT[i])) continue;
            return "text/plain";
        }
        for (i = 0; i < FileExtension.LOG_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.LOG_EXT[i])) continue;
            return "text/plain";
        }
        for (i = 0; i < FileExtension.XML_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.XML_EXT[i])) continue;
            return "text/xml";
        }
        for (i = 0; i < FileExtension.SVG_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.SVG_EXT[i])) continue;
            return "image/svg+xml";
        }
        for (i = 0; i < FileExtension.CMDI_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.CMDI_EXT[i])) continue;
            return "application/x-cmdi+xml";
        }
        for (i = 0; i < FileExtension.IMDI_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.IMDI_EXT[i])) continue;
            return "application/x-imdi+xml";
        }
        return "unknown";
    }

    public static void initLinkedFiles(TranscriptionImpl transcription) {
        LinkedFileDescriptor lfd;
        int i;
        if (transcription == null || transcription.getLinkedFileDescriptors() == null) {
            return;
        }
        boolean isChanged = transcription.isChanged();
        List<LinkedFileDescriptor> lfDescs = transcription.getLinkedFileDescriptors();
        TSServiceRegistry registry = TSServiceRegistry.getInstance();
        TSTrackManager trackManager = null;
        ArrayList<String> handledSources = new ArrayList<String>();
        Map<String, String> urlmap = LinkedFileDescriptorUtil.checkLinkedFiles(transcription);
        if (isChanged != transcription.isChanged()) {
            isChanged = true;
        }
        for (i = 0; i < lfDescs.size(); ++i) {
            TSConfigurationParser parser;
            List<TSSourceConfiguration> confs;
            lfd = lfDescs.get(i);
            if (!lfd.linkURL.endsWith("_tsconf.xml")) continue;
            String path = lfd.linkURL;
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if ((confs = (parser = new TSConfigurationParser()).parseSourceConfigs(path)) == null || confs.size() <= 0 || trackManager != null) continue;
            trackManager = new TSTrackManager(transcription);
            ELANCommandFactory.addTrackManager(transcription, trackManager);
            TimeSeriesViewer tsViewer = ELANCommandFactory.getViewerManager(transcription).createTimeSeriesViewer();
            tsViewer.setTrackManager(trackManager);
            ELANCommandFactory.getLayoutManager(transcription).add(tsViewer);
            ArrayList<String> linkedFiles = new ArrayList<String>();
            for (int z = 0; z < lfDescs.size(); ++z) {
                String linkUrl = lfDescs.get((int)z).linkURL;
                if (linkUrl == lfd.linkURL) {
                    handledSources.add(linkUrl);
                    continue;
                }
                if (urlmap.containsKey(linkUrl)) {
                    String mappedLink = urlmap.get(linkUrl);
                    if (mappedLink != null) {
                        if (linkedFiles.contains(mappedLink)) continue;
                        linkedFiles.add(mappedLink);
                        continue;
                    }
                    handledSources.add(linkUrl);
                    continue;
                }
                if (linkedFiles.contains(linkUrl)) continue;
                linkedFiles.add(linkUrl);
            }
            for (int j = 0; j < confs.size(); ++j) {
                TSSourceConfiguration sc = confs.get(j);
                if (urlmap.containsKey(sc.getSource()) && urlmap.get(sc.getSource()) != null) {
                    sc.setSource(urlmap.get(sc.getSource()));
                    if (trackManager != null) {
                        trackManager.setChanged(true);
                    }
                }
                if (!linkedFiles.contains(sc.getSource())) continue;
                TSServiceProvider provider = null;
                if (sc.getProviderClassName() != null) {
                    provider = registry.getProviderByClassName(sc.getProviderClassName());
                }
                if (provider == null) {
                    provider = registry.getProviderForFile(sc.getSource());
                }
                if (provider != null) {
                    if (!provider.isConfigurable()) {
                        provider.autoCreateTracks(sc);
                    } else {
                        provider.createTracksFromConfiguration(sc);
                    }
                    trackManager.addTrackSource(sc, false);
                }
                handledSources.add(sc.getSource());
            }
        }
        for (i = 0; i < lfDescs.size(); ++i) {
            TSServiceProvider provider;
            lfd = lfDescs.get(i);
            if (handledSources.contains(lfd.linkURL) || lfd.mimeType.equals("image/svg+xml") || (provider = registry.getProviderForFile(lfd.linkURL)) == null) continue;
            if (trackManager == null) {
                trackManager = new TSTrackManager(transcription);
                ELANCommandFactory.addTrackManager(transcription, trackManager);
                TimeSeriesViewer tsViewer = ELANCommandFactory.getViewerManager(transcription).createTimeSeriesViewer();
                tsViewer.setTrackManager(trackManager);
                ELANCommandFactory.getLayoutManager(transcription).add(tsViewer);
            }
            TSSourceConfiguration config = new TSSourceConfiguration(lfd.linkURL);
            config.setProviderClassName(provider.getClass().getName());
            if (!provider.isConfigurable()) {
                provider.autoCreateTracks(config);
            }
            trackManager.addTrackSource(config, false);
        }
        if (!isChanged) {
            transcription.setUnchanged();
        }
        LinkedFileDescriptorUtil.updateOtherMediaPaths(transcription, true);
    }

    public static void updateLinkedFiles(TranscriptionImpl transcription, List<LinkedFileDescriptor> descriptors) {
        MetadataViewer mdv;
        LinkedFileDescriptor lfd;
        int j;
        LinkedFileDescriptor olfd;
        int i;
        if (transcription == null || descriptors == null) {
            return;
        }
        List<LinkedFileDescriptor> oldDescriptors = transcription.getLinkedFileDescriptors();
        ArrayList<LinkedFileDescriptor> removedSources = new ArrayList<LinkedFileDescriptor>(4);
        ArrayList<LinkedFileDescriptor> addedSources = new ArrayList<LinkedFileDescriptor>(4);
        block0: for (i = 0; i < oldDescriptors.size(); ++i) {
            olfd = oldDescriptors.get(i);
            if (descriptors.size() == 0) {
                removedSources.add(olfd);
                continue;
            }
            for (j = 0; j < descriptors.size(); ++j) {
                lfd = descriptors.get(j);
                if (lfd.linkURL.equals(olfd.linkURL)) continue block0;
                if (j != descriptors.size() - 1) continue;
                removedSources.add(olfd);
            }
        }
        block2: for (i = 0; i < descriptors.size(); ++i) {
            lfd = descriptors.get(i);
            if (oldDescriptors.size() == 0) {
                addedSources.add(lfd);
                continue;
            }
            for (j = 0; j < oldDescriptors.size(); ++j) {
                olfd = oldDescriptors.get(j);
                if (olfd.linkURL.equals(lfd.linkURL)) continue block2;
                if (j != oldDescriptors.size() - 1) continue;
                addedSources.add(lfd);
            }
        }
        TSTrackManager trackManager = ELANCommandFactory.getTrackManager(transcription);
        TSServiceRegistry registry = TSServiceRegistry.getInstance();
        if (removedSources.size() > 0) {
            for (int i2 = 0; i2 < removedSources.size(); ++i2) {
                lfd = (LinkedFileDescriptor)removedSources.get(i2);
                if (trackManager == null) continue;
                trackManager.removeTrackSource(lfd.linkURL);
            }
            if (descriptors.size() == 1) {
                lfd = descriptors.get(0);
                if (lfd.linkURL.endsWith("_tsconf.xml")) {
                    descriptors.remove(0);
                }
            }
        }
        if (addedSources.size() > 0) {
            boolean configFound = false;
            for (int i3 = 0; i3 < addedSources.size(); ++i3) {
                LinkedFileDescriptor configDesc;
                lfd = (LinkedFileDescriptor)addedSources.get(i3);
                TSServiceProvider provider = registry.getProviderForFile(lfd.linkURL);
                if (provider == null) continue;
                if (trackManager == null) {
                    trackManager = new TSTrackManager(transcription);
                    ELANCommandFactory.addTrackManager(transcription, trackManager);
                    TimeSeriesViewer tsViewer = ELANCommandFactory.getViewerManager(transcription).createTimeSeriesViewer();
                    tsViewer.setTrackManager(trackManager);
                    ELANCommandFactory.getLayoutManager(transcription).add(tsViewer);
                }
                TSSourceConfiguration config = new TSSourceConfiguration(lfd.linkURL);
                config.setProviderClassName(provider.getClass().getName());
                if (!provider.isConfigurable()) {
                    provider.autoCreateTracks(config);
                }
                trackManager.addTrackSource(config, true);
                if (configFound) continue;
                for (int j2 = 0; j2 < descriptors.size(); ++j2) {
                    LinkedFileDescriptor confLfd = descriptors.get(j2);
                    if (confLfd == lfd || !confLfd.linkURL.endsWith("_tsconf.xml")) continue;
                    configFound = true;
                    break;
                }
                if (configFound) continue;
                Object transPath = transcription.getFullPath();
                if (((String)transPath).toLowerCase().endsWith(".eaf")) {
                    transPath = ((String)transPath).substring(0, ((String)transPath).length() - 4);
                }
                if ((configDesc = LinkedFileDescriptorUtil.createLFDescriptor((String)(transPath = (String)transPath + "_tsconf.xml"))) == null) continue;
                descriptors.add(configDesc);
                configFound = true;
            }
        }
        transcription.setLinkedFileDescriptors(descriptors);
        transcription.setChanged();
        ViewerManager2 vm = ELANCommandFactory.getViewerManager(transcription);
        if (vm != null && (mdv = vm.getMetadataViewer()) != null) {
            mdv.linkedFilesChanged();
        }
        LinkedFileDescriptorUtil.updateOtherMediaPaths(transcription, true);
    }

    public static void updateLinkedFilesOffsets(TranscriptionImpl transcription, Map<String, Long> newLinkOffsets) {
        LinkedFileDescriptor lfd;
        if (transcription == null || newLinkOffsets == null) {
            return;
        }
        ArrayList<LinkedFileDescriptor> changedDesc = new ArrayList<LinkedFileDescriptor>(10);
        for (int i = 0; i < transcription.getLinkedFileDescriptors().size(); ++i) {
            lfd = transcription.getLinkedFileDescriptors().get(i);
            Long nextOffset = newLinkOffsets.get(lfd.linkURL);
            if (nextOffset == null || nextOffset == lfd.timeOrigin) continue;
            changedDesc.add(lfd);
            lfd.timeOrigin = nextOffset;
        }
        if (changedDesc.size() == 0) {
            return;
        }
        transcription.setChanged();
        TSTrackManager trackManager = ELANCommandFactory.getTrackManager(transcription);
        if (trackManager == null) {
            return;
        }
        for (int i = 0; i < changedDesc.size(); ++i) {
            lfd = (LinkedFileDescriptor)changedDesc.get(i);
            trackManager.setOffset(lfd.linkURL, (int)lfd.timeOrigin);
        }
        TimeSeriesViewer tsViewer = ELANCommandFactory.getLayoutManager(transcription).getTimeSeriesViewer();
        if (tsViewer != null) {
            tsViewer.repaint();
        }
    }

    private static Map<String, String> checkLinkedFiles(TranscriptionImpl transcription) {
        HashMap<String, String> linkMap = new HashMap<String, String>(2);
        if (transcription == null) {
            return linkMap;
        }
        List<LinkedFileDescriptor> lfDescs = transcription.getLinkedFileDescriptors();
        if (lfDescs == null || lfDescs.isEmpty()) {
            return linkMap;
        }
        for (int i = 0; i < lfDescs.size(); ++i) {
            String resolvedURL;
            String fallBackLocation;
            File eafFile;
            LinkedFileDescriptor lfd = lfDescs.get(i);
            if (lfd.linkURL == null) {
                ClientLogger.LOG.warning("Link url is null");
                continue;
            }
            String oldLinkURL = lfd.linkURL;
            int colonIndex = oldLinkURL.indexOf(58);
            String path = null;
            path = colonIndex > 0 && colonIndex < lfd.linkURL.length() - 1 ? lfd.linkURL.substring(colonIndex + 1) : lfd.linkURL;
            File file = new File(path = path.replace('\\', '/'));
            if (file.exists()) continue;
            int lastSlash = path.lastIndexOf(47);
            String linkName = path;
            if (lastSlash >= 0 && lastSlash < path.length() - 1) {
                linkName = path.substring(lastSlash + 1);
            }
            String linkDir = null;
            String eafFileName = transcription.getFullPath();
            colonIndex = eafFileName.indexOf(58);
            if (colonIndex > -1) {
                eafFileName = eafFileName.substring(colonIndex + 1);
            }
            if ((eafFile = new File(eafFileName)).exists() && eafFile.getParentFile() != null) {
                linkDir = eafFile.getParentFile().getAbsolutePath();
            }
            File searchFile = null;
            searchFile = linkDir != null ? new File(linkDir + "/" + linkName) : new File(linkName);
            if (searchFile.exists()) {
                lfd.linkURL = FileUtility.pathToURLString(searchFile.getAbsolutePath());
                ClientLogger.LOG.info("Updating url from: " + oldLinkURL + " to: " + lfd.linkURL);
                transcription.setChanged();
                linkMap.put(oldLinkURL, lfd.linkURL);
                continue;
            }
            if (lfd.relativeLinkURL != null) {
                File relFile;
                String absPath;
                String fullEAFURL = FileUtility.pathToURLString(transcription.getFullPath());
                String relUrl = lfd.relativeLinkURL;
                if (relUrl.startsWith("file:/")) {
                    relUrl = relUrl.substring(6);
                }
                if ((absPath = FileUtility.getAbsolutePath(fullEAFURL, relUrl)) != null && (relFile = new File(absPath)).exists()) {
                    lfd.linkURL = FileUtility.pathToURLString(relFile.getAbsolutePath());
                    ClientLogger.LOG.info("Updating url from: " + oldLinkURL + " to: " + lfd.linkURL);
                    transcription.setChanged();
                    linkMap.put(oldLinkURL, lfd.linkURL);
                    continue;
                }
            }
            if ((fallBackLocation = Preferences.getString("DefaultGeneralLinkedFilesLocation", null)) != null && (resolvedURL = LinkedFileDescriptorUtil.fallBackResolve(fallBackLocation, linkName)) != null) {
                lfd.linkURL = FileUtility.pathToURLString(resolvedURL);
                ClientLogger.LOG.info("Updating url from: " + oldLinkURL + " to: " + lfd.linkURL);
                linkMap.put(oldLinkURL, lfd.linkURL);
                continue;
            }
            FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(transcription));
            String[] extensions = null;
            if (lfd.mimeType.equals("text/xml")) {
                extensions = FileExtension.XML_EXT;
            } else if (oldLinkURL.toLowerCase().endsWith(FileExtension.LOG_EXT[0])) {
                extensions = FileExtension.LOG_EXT;
            } else if (lfd.mimeType.equals("text/plain")) {
                extensions = FileExtension.TEXT_EXT;
            } else if (lfd.mimeType.equals("image/svg+xml")) {
                extensions = FileExtension.SVG_EXT;
            }
            chooser.setCurrentDirectory(searchFile.getParentFile().getAbsolutePath());
            chooser.createAndShowFileDialog(ElanLocale.getString("LinkedFilesDialog.Message.Locate") + ": " + linkName, 0, ElanLocale.getString("Button.Select"), null, extensions, true, null, 0, linkName);
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile != null) {
                String nextUrl;
                lfd.linkURL = nextUrl = FileUtility.pathToURLString(chooser.getSelectedFile().getAbsolutePath());
                ClientLogger.LOG.info("Updating url from: " + oldLinkURL + " to: " + nextUrl);
                transcription.setChanged();
                linkMap.put(oldLinkURL, nextUrl);
                continue;
            }
            linkMap.put(oldLinkURL, null);
        }
        return linkMap;
    }

    private static String checkLinkedFile(String filePath, TranscriptionImpl transcription) {
        File eafFile;
        if (filePath == null || transcription == null) {
            return null;
        }
        String transPath = transcription.getFullPath();
        int colonIndex = filePath.indexOf(58);
        String path = null;
        path = colonIndex > 0 && colonIndex < filePath.length() - 1 ? filePath.substring(colonIndex + 1) : filePath;
        File file = new File(path = path.replace('\\', '/'));
        if (file.exists()) {
            return filePath;
        }
        int lastSlash = path.lastIndexOf(47);
        String linkName = path;
        if (lastSlash >= 0 && lastSlash < path.length() - 1) {
            linkName = path.substring(lastSlash + 1);
        }
        String linkDir = null;
        String eafFileName = transPath;
        colonIndex = eafFileName.indexOf(58);
        if (colonIndex > -1) {
            eafFileName = eafFileName.substring(colonIndex + 1);
        }
        if ((eafFile = new File(eafFileName)).exists() && eafFile.getParentFile() != null) {
            linkDir = eafFile.getParentFile().getAbsolutePath();
        }
        File searchFile = null;
        searchFile = linkDir != null ? new File(linkDir + "/" + linkName) : new File(linkName);
        if (searchFile.exists()) {
            String nextUrl = FileUtility.pathToURLString(searchFile.getAbsolutePath());
            ClientLogger.LOG.info("Updating url from: " + filePath + " to: " + nextUrl);
            return nextUrl;
        }
        FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(transcription));
        chooser.setCurrentDirectory(searchFile.getParentFile().getAbsolutePath());
        chooser.createAndShowFileDialog(ElanLocale.getString("LinkedFilesDialog.Message.Locate") + ": " + linkName, 0, ElanLocale.getString("Button.Select"), null, null, true, null, 0, linkName);
        if (chooser.getSelectedFile() != null) {
            String nextUrl = FileUtility.pathToURLString(chooser.getSelectedFile().getAbsolutePath());
            ClientLogger.LOG.info("Updating url from: " + filePath + " to: " + nextUrl);
            return nextUrl;
        }
        return filePath;
    }

    private static void updateOtherMediaPaths(TranscriptionImpl transcription, boolean isUpdate) {
        RecognizerPanel recognizerPanel;
        ArrayList<String> otherMediaPaths = new ArrayList<String>(6);
        for (LinkedFileDescriptor lfds : transcription.getLinkedFileDescriptors()) {
            String path = lfds.linkURL;
            path = FileUtility.urlToAbsPath(path);
            if (!lfds.mimeType.equals("text/plain") && !lfds.mimeType.equals("unknown") && !lfds.mimeType.equals("text/xml") || path.endsWith("_tsconf.xml") || otherMediaPaths.contains(path)) continue;
            otherMediaPaths.add(path);
        }
        ELANCommandFactory.getViewerManager(transcription).setOtherMediaPaths(otherMediaPaths);
        if (isUpdate && (recognizerPanel = ELANCommandFactory.getViewerManager(transcription).getRecognizerPanel()) != null) {
            recognizerPanel.setOtherFilePaths(otherMediaPaths);
        }
    }

    private static String fallBackResolve(String fallBackLocation, String fileName) {
        if (FileUtility.isRemoteFile(fallBackLocation)) {
            return fallBackLocation + "/" + fileName;
        }
        String localFolderName = FileUtility.urlToAbsPath(fallBackLocation);
        File localFolder = new File(localFolderName);
        if (!(localFolder.exists() && localFolder.isDirectory() && localFolder.canRead())) {
            return null;
        }
        File f = new File(localFolder, fileName);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return LinkedFileDescriptorUtil.findRecursive(localFolder.listFiles(), fileName);
    }

    private static String findRecursive(File[] fileList, String fileName) {
        if (fileList != null && fileList.length > 0) {
            for (File f : fileList) {
                if (!f.isDirectory()) continue;
                File cf = new File(f, fileName);
                if (cf.exists()) {
                    return cf.getAbsolutePath();
                }
                String recFile = LinkedFileDescriptorUtil.findRecursive(f.listFiles(), fileName);
                if (recFile == null) continue;
                return recFile;
            }
        }
        return null;
    }
}

