/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.linkedmedia;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.recognizer.gui.RecognizerPanel;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.AnnotationDensityViewer;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.util.MediaDescriptorUtility;
import nl.mpi.util.FileUtility;

public class MediaDescriptorUtil {
    public static void updateMediaPlayers(TranscriptionImpl transcription, List<MediaDescriptor> descriptors) {
        MediaDescriptor md;
        if (transcription == null || descriptors == null) {
            return;
        }
        long mediaTime = 0L;
        ViewerManager2 viewerManager = ELANCommandFactory.getViewerManager(transcription);
        ElanLayoutManager layoutManager = ELANCommandFactory.getLayoutManager(transcription);
        SignalViewer signalViewer = layoutManager.getSignalViewer();
        if (viewerManager.getMasterMediaPlayer() != null && viewerManager.getMasterMediaPlayer().isPlaying()) {
            viewerManager.getMasterMediaPlayer().stop();
        }
        mediaTime = viewerManager.getMasterMediaPlayer().getMediaTime();
        ElanMediaPlayerController empc = viewerManager.getMediaPlayerController();
        empc.deferUpdatePlayersVolumePanel(true);
        if (layoutManager.getMode() == 0) {
            layoutManager.connectAllPlayers();
        }
        viewerManager.setMasterMediaPlayer(new EmptyMediaPlayer(Integer.MAX_VALUE));
        List<ElanMediaPlayer> connectPlayers = viewerManager.getConnectedMediaPlayers();
        ArrayList<ElanMediaPlayer> remPlayers = new ArrayList<ElanMediaPlayer>(connectPlayers.size());
        remPlayers.addAll(connectPlayers);
        for (ElanMediaPlayer conPlay : remPlayers) {
            viewerManager.destroyMediaPlayer(conPlay);
        }
        for (ElanMediaPlayer conPlay : remPlayers) {
            layoutManager.remove(conPlay);
        }
        if (signalViewer != null) {
            viewerManager.destroyViewer(signalViewer);
            layoutManager.remove(signalViewer);
        }
        MediaDescriptorUtil.createMediaPlayers(transcription, descriptors);
        empc.deferUpdatePlayersVolumePanel(false);
        ArrayList<String> newAudioPaths = new ArrayList<String>(6);
        if (layoutManager.getSignalViewer() != null) {
            newAudioPaths.add(layoutManager.getSignalViewer().getMediaPath());
        }
        for (int i = 0; i < descriptors.size(); ++i) {
            md = descriptors.get(i);
            if (!md.mimeType.equals("audio/*") && !md.mimeType.equals("audio/x-wav") || newAudioPaths.contains(md.mediaURL)) continue;
            newAudioPaths.add(md.mediaURL);
        }
        RecognizerPanel recognizerPanel = viewerManager.getRecognizerPanel();
        if (recognizerPanel != null) {
            recognizerPanel.setAudioFilePaths(newAudioPaths);
        }
        viewerManager.setAudioPaths(newAudioPaths);
        ArrayList<String> newVideoPaths = new ArrayList<String>(6);
        for (int i = 0; i < descriptors.size(); ++i) {
            md = descriptors.get(i);
            if (md.mimeType.equals("audio/*") || md.mimeType.equals("audio/x-wav") || newVideoPaths.contains(md.mediaURL)) continue;
            newVideoPaths.add(md.mediaURL);
        }
        if (recognizerPanel != null) {
            recognizerPanel.setVideoFilePaths(newVideoPaths);
        }
        viewerManager.setVideoPaths(newVideoPaths);
        viewerManager.getMasterMediaPlayer().setMediaTime(mediaTime);
        transcription.setMediaDescriptors(descriptors);
        transcription.setChanged();
        layoutManager.doLayout();
    }

    public static void updateMediaPlayerOffsets(TranscriptionImpl transcription, Map<String, Long> newPlayerOffsets) {
        if (transcription == null || newPlayerOffsets == null) {
            return;
        }
        ArrayList<MediaDescriptor> changedDescs = new ArrayList<MediaDescriptor>(10);
        for (int i = 0; i < transcription.getMediaDescriptors().size(); ++i) {
            MediaDescriptor md = transcription.getMediaDescriptors().get(i);
            Long newOffset = newPlayerOffsets.get(md.mediaURL);
            if (newOffset == null || newOffset == md.timeOrigin) continue;
            changedDescs.add(md);
            md.timeOrigin = newOffset;
        }
        if (changedDescs.size() == 0) {
            return;
        }
        transcription.setChanged();
        ViewerManager2 viewerManager = ELANCommandFactory.getViewerManager(transcription);
        ElanLayoutManager layoutManager = ELANCommandFactory.getLayoutManager(transcription);
        if (viewerManager.getMasterMediaPlayer().isPlaying()) {
            viewerManager.getMasterMediaPlayer().stop();
        }
        boolean masterOffsetChanged = changedDescs.contains(viewerManager.getMasterMediaPlayer().getMediaDescriptor());
        long curMediaTime = viewerManager.getMasterMediaPlayer().getMediaTime();
        for (int i = 0; i < viewerManager.getConnectedMediaPlayers().size(); ++i) {
            ElanMediaPlayer player = viewerManager.getConnectedMediaPlayers().get(i);
            if (!changedDescs.contains(player.getMediaDescriptor())) continue;
            player.setOffset(player.getMediaDescriptor().timeOrigin);
        }
        if (layoutManager.getSignalViewer() != null) {
            if (changedDescs.contains(layoutManager.getSignalViewer().getMediaDescriptor())) {
                layoutManager.getSignalViewer().setOffset(layoutManager.getSignalViewer().getMediaDescriptor().timeOrigin);
            } else {
                String wavUrl = FileUtility.pathToURLString(layoutManager.getSignalViewer().getMediaPath());
                Long nextOffset = newPlayerOffsets.get(wavUrl);
                if (nextOffset != null) {
                    layoutManager.getSignalViewer().setOffset(nextOffset);
                }
            }
        }
        if (viewerManager.getSpectrogramViewer() != null) {
            viewerManager.getSpectrogramViewer().mediaOffsetChanged();
        }
        if (masterOffsetChanged) {
            long masterOffset = viewerManager.getMasterMediaPlayer().getMediaDescriptor().timeOrigin;
            viewerManager.getMasterMediaPlayer().setOffset(masterOffset);
            AnnotationDensityViewer viewer = viewerManager.getAnnotationDensityViewer();
            if (viewer != null) {
                ((AbstractViewer)viewer).mediaOffsetChanged();
            }
            viewerManager.getMasterMediaPlayer().setMediaTime(curMediaTime);
        }
    }

    public static void createMediaPlayers(TranscriptionImpl transcription, List<MediaDescriptor> descriptors) {
        if (transcription == null || descriptors == null) {
            return;
        }
        int numDesc = descriptors.size();
        try {
            SignalViewer newSignalViewer;
            ViewerManager2 viewerManager = ELANCommandFactory.getViewerManager(transcription);
            ElanLayoutManager layoutManager = ELANCommandFactory.getLayoutManager(transcription);
            int nrOfPlayers = 0;
            int nrVisualPlayers = 0;
            String signalSource = null;
            long signalOffset = 0L;
            viewerManager.getMediaPlayerController().deferUpdatePlayersVolumePanel(true);
            ArrayList<MediaDescriptor> failedPlayers = null;
            StringBuilder errors = new StringBuilder();
            for (int i = 0; i < numDesc; ++i) {
                MediaDescriptor curMD = descriptors.get(i);
                if (!curMD.isValid || !MediaDescriptorUtility.checkLinkStatus(curMD) || !curMD.mimeType.equals("audio/x-wav") && nrVisualPlayers == 4) continue;
                try {
                    ElanMediaPlayer player = viewerManager.createMediaPlayer(curMD);
                    if (player == null) continue;
                    if (++nrOfPlayers == 1) {
                        viewerManager.setMasterMediaPlayer(player);
                    }
                    if (signalSource == null && curMD.mimeType.equals("audio/x-wav")) {
                        signalSource = curMD.mediaURL;
                        signalOffset = curMD.timeOrigin;
                        viewerManager.setSignalSourcePlayer(player);
                    }
                    if (player.getVisualComponent() != null && !curMD.mimeType.equals("audio/x-wav")) {
                        ++nrVisualPlayers;
                    }
                    if (nrVisualPlayers > 4 && player.getVisualComponent() != null) continue;
                    layoutManager.add(player);
                    continue;
                }
                catch (NoPlayerException npe) {
                    if (failedPlayers == null) {
                        failedPlayers = new ArrayList<MediaDescriptor>();
                    }
                    errors.append(npe.getMessage() + "\n");
                    failedPlayers.add(curMD);
                }
            }
            if (nrOfPlayers == 0) {
                if (viewerManager.getMasterMediaPlayer() instanceof EmptyMediaPlayer) {
                    ((EmptyMediaPlayer)viewerManager.getMasterMediaPlayer()).setMediaDuration(transcription.getLatestTime());
                } else {
                    viewerManager.setMasterMediaPlayer(new EmptyMediaPlayer(transcription.getLatestTime()));
                }
                layoutManager.add(viewerManager.getMasterMediaPlayer());
            }
            if (signalSource == null && numDesc > 0) {
                MediaDescriptor md = descriptors.get(0);
                if (md.isValid) {
                    signalSource = md.mediaURL;
                    signalOffset = md.timeOrigin;
                }
            }
            if (signalSource != null && (newSignalViewer = viewerManager.createSignalViewer(signalSource)) != null) {
                newSignalViewer.setOffset(signalOffset);
                newSignalViewer.preferencesChanged();
                layoutManager.add(newSignalViewer);
            }
            viewerManager.getMediaPlayerController().deferUpdatePlayersVolumePanel(false);
            layoutManager.doLayout();
            if (failedPlayers != null && failedPlayers.size() > 0) {
                StringBuilder sb = new StringBuilder("No player could be created for:\n");
                for (int i = 0; i < failedPlayers.size(); ++i) {
                    sb.append("- " + ((MediaDescriptor)failedPlayers.get((int)i)).mediaURL + "\n");
                }
                sb.append(errors.toString());
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), sb.toString(), ElanLocale.getString("Message.Warning"), 2);
            }
        }
        catch (Exception rex) {
            rex.printStackTrace();
            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), "An error occurred while creating media players: " + rex.getMessage(), ElanLocale.getString("Message.Warning"), 2);
        }
    }

    public static ElanMediaPlayer createMediaPlayer(TranscriptionImpl transcription, MediaDescriptor curMD) {
        if (transcription == null || curMD == null) {
            return null;
        }
        if (!MediaDescriptorUtility.checkLinkStatus(curMD)) {
            return null;
        }
        ElanMediaPlayer player = null;
        try {
            ViewerManager2 viewerManager = ELANCommandFactory.getViewerManager(transcription);
            player = viewerManager.createMediaPlayer(curMD);
        }
        catch (NoPlayerException noPlayerException) {
            // empty catch block
        }
        return player;
    }
}

