/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.mediadisplayer;

import java.awt.Rectangle;
import java.io.File;
import javax.swing.JComponent;
import mpi.eudico.client.annotator.gui.DynamicVideoPlayer;
import mpi.eudico.client.annotator.mediadisplayer.MediaBundle;
import mpi.eudico.client.annotator.mediadisplayer.MediaDisplayer;
import mpi.eudico.client.annotator.mediadisplayer.MediaDisplayerFactory;

public class VideoDisplayer
implements MediaDisplayer {
    private Thread videoThread;
    private DynamicVideoPlayer videoPlayer = null;
    private MediaBundle mediaBundle;

    @Override
    public void setMediaBundle(MediaBundle mediaBundle) {
        this.mediaBundle = mediaBundle;
    }

    @Override
    public void displayMedia(JComponent component, Rectangle bounds, int delay, MediaDisplayerFactory.MEDIA_ORIENTATION horizontalOrientation, MediaDisplayerFactory.MEDIA_ORIENTATION verticalOrientation) {
        this.discard();
        if (this.mediaBundle == null) {
            return;
        }
        File videoFile = new File(this.mediaBundle.getMediaUrl());
        if (videoFile != null && videoFile.exists() && !videoFile.isDirectory()) {
            if (this.videoPlayer == null) {
                this.videoPlayer = new DynamicVideoPlayer(component, bounds, 500, videoFile, horizontalOrientation, verticalOrientation);
            } else {
                this.videoPlayer.setVideoFile(videoFile);
                this.videoPlayer.setBounds(bounds);
                this.videoPlayer.setOrientation(horizontalOrientation, verticalOrientation);
            }
            this.videoThread = new Thread(this.videoPlayer);
            this.videoThread.start();
        }
    }

    @Override
    public void discard() {
        if (this.videoThread != null) {
            this.videoThread.interrupt();
        }
        if (this.videoPlayer != null) {
            this.videoPlayer.cleanUp();
        }
    }
}

