/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.table.TableCellRenderer;
import mpi.eudico.client.annotator.multiplefilesedit.MFEFrame;
import mpi.eudico.client.annotator.multiplefilesedit.MFEModel;
import mpi.eudico.client.annotator.multiplefilesedit.MFETable;
import mpi.eudico.client.annotator.multiplefilesedit.TableByTypeModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;

public class MFETypeTable
extends MFETable {
    private static final long serialVersionUID = -6660589343733391482L;
    private MFEModel model;
    private CheckBoxTableCellRenderer cbRenderer;
    public final Color EVEN_LIGHT_BLUE = new Color(240, 255, 255);
    public final Color LESS_LIGHT_BLUE = new Color(200, 255, 255);
    public final Color INCONS_LIGHT_GREY = new Color(240, 240, 240);
    public final Color INCONS_DARK_GREY = new Color(150, 150, 150);

    public MFETypeTable(MFEModel model, final MFEFrame parent) {
        super(model);
        this.model = model;
        this.setModel(new TableByTypeModel(model));
        ImageIcon tickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Tick16.gif"));
        ImageIcon untickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Untick16.gif"));
        this.cbRenderer = new CheckBoxTableCellRenderer();
        this.cbRenderer.setIcon(untickIcon);
        this.cbRenderer.setSelectedIcon(tickIcon);
        this.cbRenderer.setHorizontalAlignment(0);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                parent.initCombobox();
            }
        });
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Component c = vColIndex == 2 ? super.prepareRenderer(this.cbRenderer, rowIndex, vColIndex) : super.prepareRenderer(renderer, rowIndex, vColIndex);
        if (rowIndex % 2 == 0 && !this.isCellSelected(rowIndex, vColIndex)) {
            c.setBackground(this.EVEN_LIGHT_BLUE);
        } else {
            c.setBackground(this.getBackground());
        }
        c.setForeground(Color.BLACK);
        if (rowIndex == this.getSelectedRow()) {
            c.setBackground(this.LESS_LIGHT_BLUE);
        }
        if (!this.model.isConsistentType(rowIndex)) {
            c.setBackground(this.INCONS_LIGHT_GREY);
            c.setBackground(this.INCONS_DARK_GREY);
        }
        return c;
    }
}

