/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.multiplefilesedit.MFEFrame;
import mpi.eudico.client.annotator.multiplefilesedit.MFEModel;
import mpi.eudico.client.annotator.multiplefilesedit.MFETierTable;
import mpi.eudico.client.annotator.multiplefilesedit.TableByTierModel;
import mpi.eudico.client.annotator.multiplefilesedit.TableListener;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.util.EmptyStringComparator;

public class TableByTierPanel
extends JPanel
implements ActionListener {
    private MFEModel model;
    private MFETierTable table;
    private JButton addRowButton;
    private JButton addChildTierButton;
    private JButton removeRowButton;

    public TableByTierPanel(MFEModel model) {
        this.model = model;
        this.initComponents();
        this.initCombobox();
    }

    public void initCombobox() {
        this.table.initCombobox();
    }

    private void initComponents() {
        GridBagLayout lm = new GridBagLayout();
        this.setLayout(lm);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.9;
        c.fill = 1;
        this.table = new MFETierTable(this.model);
        TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(this.table.getModel());
        EmptyStringComparator emptyComp = new EmptyStringComparator();
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            rowSorter.setComparator(i, emptyComp);
        }
        this.table.setRowSorter(rowSorter);
        JScrollPane scroll_pane = new JScrollPane(this.table);
        this.table.getModel().addTableModelListener(new TableListener());
        this.table.setRowHeight(24);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.add((Component)scroll_pane, c);
        c.gridwidth = 1;
        c.gridy = 0;
        c.weighty = 0.0;
        this.addRowButton = new JButton(ElanLocale.getString("MFE.TierTab.AddTier"));
        this.addRowButton.setActionCommand("addRow");
        this.addRowButton.addActionListener(this);
        this.add((Component)this.addRowButton, c);
        c.gridx = 1;
        this.addChildTierButton = new JButton(ElanLocale.getString("MFE.TierTab.AddDependentTier"));
        this.addChildTierButton.setActionCommand("addDependentTier");
        this.addChildTierButton.addActionListener(this);
        this.add((Component)this.addChildTierButton, c);
        c.gridx = 2;
        this.removeRowButton = new JButton(ElanLocale.getString("MFE.TierTab.RemoveTier"));
        this.removeRowButton.setActionCommand("removeRow");
        this.removeRowButton.addActionListener(this);
        this.add((Component)this.removeRowButton, c);
        this.enableUI(false);
    }

    public void updateLocale() {
    }

    public void enableUI(boolean b) {
        this.addRowButton.setEnabled(b);
        this.addChildTierButton.setEnabled(b);
        this.removeRowButton.setEnabled(b && this.model.areTiersRemovable());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (e.getActionCommand().equals("addRow")) {
                int new_row = ((TableByTierModel)this.table.getModel()).newRow();
                this.table.newRow(new_row);
                this.table.showCell(this.table.getRowCount() - 1, 0);
            } else if (e.getActionCommand().equals("addDependentTier")) {
                String[] parentTiers = this.model.getConsistentTierNames();
                if (parentTiers != null) {
                    AddChildTierDialog dlg = new AddChildTierDialog(parentTiers);
                    dlg.setVisible(true);
                    String parentName = dlg.parentName;
                    int stereotype = dlg.stereotype;
                    if (parentName != null && stereotype > -1) {
                        int new_row = ((TableByTierModel)this.table.getModel()).newRowForChildTier(parentName, stereotype);
                        this.table.newRow(new_row);
                        this.table.showCell(this.table.getRowCount() - 1, 0);
                    }
                }
            } else if (e.getActionCommand().equals("removeRow")) {
                int[] selectedRows = this.table.getSelectedRows();
                ((TableByTierModel)this.table.getModel()).removeRows(selectedRows);
            }
        }
    }

    public void rowAdded(int row_nr) {
        ((TableByTierModel)this.table.getModel()).fireTableRowsInserted(row_nr, row_nr);
    }

    private class AddChildTierDialog
    extends ClosableDialog
    implements ActionListener {
        private JComboBox parentComboBox;
        private JComboBox stereotypeComboBox;
        private JButton addButton;
        private JButton cancelButton;
        protected String parentName;
        protected int stereotype;
        private final String SELECT;

        public AddChildTierDialog(String[] parentTiers) {
            super((MFEFrame)TableByTierPanel.this.getTopLevelAncestor(), ElanLocale.getString("MFE.TierTab.AddDependentTier"), true);
            this.SELECT = ElanLocale.getString("InterlinearAnalyzerConfigDlg.ComboBoxDefaultString");
            this.initComponents(parentTiers);
            this.postInit();
        }

        private void postInit() {
            this.pack();
            this.setResizable(true);
            this.setLocationRelativeTo(this.getParent());
        }

        private void doClose() {
            this.setVisible(false);
            this.dispose();
        }

        private void initComponents(String[] parentTiers) {
            this.setLayout(new GridBagLayout());
            this.parentComboBox = new JComboBox();
            this.parentComboBox.addItem(this.SELECT);
            for (String parentTier : parentTiers) {
                this.parentComboBox.addItem(parentTier);
            }
            this.parentComboBox.addActionListener(this);
            this.stereotypeComboBox = new JComboBox();
            this.stereotypeComboBox.addItem(this.SELECT);
            this.stereotypeComboBox.setEnabled(false);
            this.stereotypeComboBox.addActionListener(this);
            this.addButton = new JButton(ElanLocale.getString("Button.Add"));
            this.addButton.addActionListener(this);
            this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
            this.cancelButton.addActionListener(this);
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.addButton);
            buttonPanel.add(this.cancelButton);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.anchor = 18;
            gbc.insets = new Insets(10, 10, 10, 10);
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 2;
            this.add((Component)new JLabel(ElanLocale.getString("MFE.TierTab.Select")), gbc);
            gbc.insets = new Insets(10, 30, 4, 6);
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            this.add((Component)new JLabel(ElanLocale.getString("MFE.TierTab.SelectParent")), gbc);
            gbc.gridx = 1;
            this.add((Component)this.parentComboBox, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            this.add((Component)new JLabel(ElanLocale.getString("OverlapsDialog.Column.Stereotype")), gbc);
            gbc.gridx = 1;
            this.add((Component)this.stereotypeComboBox, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 6, 4, 6);
            gbc.fill = 2;
            gbc.anchor = 15;
            this.add((Component)buttonPanel, gbc);
            this.addButton.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.parentComboBox.getSelectedItem().equals(this.SELECT) && !this.stereotypeComboBox.getSelectedItem().equals(this.SELECT)) {
                this.addButton.setEnabled(true);
            } else {
                this.addButton.setEnabled(false);
            }
            if (e.getSource() == this.parentComboBox) {
                Object s = this.parentComboBox.getSelectedItem();
                if (s != null && !s.equals(this.SELECT)) {
                    this.stereotypeComboBox.removeActionListener(this);
                    this.stereotypeComboBox.removeAllItems();
                    this.stereotypeComboBox.addItem(this.SELECT);
                    this.stereotypeComboBox.setEnabled(true);
                    Constraint parentConstraint = TableByTierPanel.this.model.getTierByName((String)s).getLinguisticType().getConstraints();
                    if (parentConstraint != null && (parentConstraint.getStereoType() == 3 || parentConstraint.getStereoType() == 4)) {
                        for (String cons : TableByTierPanel.this.model.getConsistentStereoTypeNames()) {
                            if (!cons.toLowerCase().startsWith("symbolic")) continue;
                            this.stereotypeComboBox.addItem(cons);
                        }
                    } else {
                        for (String cons : TableByTierPanel.this.model.getConsistentStereoTypeNames()) {
                            this.stereotypeComboBox.addItem(cons);
                        }
                    }
                    this.stereotypeComboBox.addActionListener(this);
                } else {
                    this.stereotypeComboBox.setEnabled(false);
                    this.stereotypeComboBox.removeActionListener(this);
                    this.stereotypeComboBox.removeAllItems();
                    this.stereotypeComboBox.addActionListener(this);
                    this.stereotypeComboBox.addItem(this.SELECT);
                }
            } else if (e.getSource() == this.addButton) {
                this.parentName = (String)this.parentComboBox.getSelectedItem();
                String constraint_string = (String)this.stereotypeComboBox.getSelectedItem();
                this.stereotype = -1;
                if (constraint_string == Constraint.publicStereoTypes[0]) {
                    this.stereotype = 0;
                } else if (constraint_string == Constraint.publicStereoTypes[1]) {
                    this.stereotype = 1;
                } else if (constraint_string == Constraint.publicStereoTypes[2]) {
                    this.stereotype = 3;
                } else if (constraint_string == Constraint.publicStereoTypes[3]) {
                    this.stereotype = 4;
                }
                this.doClose();
            } else if (e.getSource() == this.cancelButton) {
                this.parentName = null;
                this.stereotype = -1;
                this.doClose();
            }
        }
    }
}

