/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.multiplefilesedit.MFEFrame;
import mpi.eudico.client.annotator.multiplefilesedit.MFEModel;
import mpi.eudico.client.annotator.multiplefilesedit.MFETypeTable;
import mpi.eudico.client.annotator.multiplefilesedit.TableByTypeModel;
import mpi.eudico.client.annotator.multiplefilesedit.TableListener;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.util.EmptyStringComparator;

public class TableByTypePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 685888690974798752L;
    private MFEModel model;
    private MFEFrame parent;
    private MFETypeTable table;
    private JButton addRowButton;

    public TableByTypePanel(MFEModel model, MFEFrame parent) {
        this.model = model;
        this.parent = parent;
        this.initComponents();
    }

    private void initComponents() {
        GridBagLayout lm = new GridBagLayout();
        this.setLayout(lm);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.9;
        c.fill = 1;
        this.table = new MFETypeTable(this.model, this.parent);
        TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(this.table.getModel());
        EmptyStringComparator emptyComp = new EmptyStringComparator();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (i != 2) {
                rowSorter.setComparator(i, emptyComp);
                continue;
            }
            rowSorter.setSortable(i, false);
        }
        this.table.setRowSorter(rowSorter);
        JScrollPane scroll_pane = new JScrollPane(this.table);
        this.table.getModel().addTableModelListener(new TableListener());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.add((Component)scroll_pane, c);
        c.gridwidth = 1;
        c.gridy = 0;
        c.weighty = 0.0;
        this.addRowButton = new JButton(ElanLocale.getString("MFE.TierTab.AddType"));
        this.addRowButton.setActionCommand("addRow");
        this.addRowButton.addActionListener(this);
        this.add((Component)this.addRowButton, c);
        this.enableUI(false);
    }

    public void updateLocale() {
    }

    public void enableUI(boolean b) {
        this.addRowButton.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (e.getActionCommand().equals("addRow")) {
                ConstraintImpl constraint = null;
                ArrayList<String> constraintList = new ArrayList<String>();
                constraintList.add("None");
                constraintList.addAll(Arrays.asList(Constraint.publicStereoTypes));
                String constraint_string = (String)JOptionPane.showInputDialog(this, "Pick a stereotype", "Add Linguistic Type", -1, null, constraintList.toArray(), "ham");
                if (constraint_string != "None") {
                    if (constraint_string == Constraint.publicStereoTypes[0]) {
                        constraint = new TimeSubdivision();
                    } else if (constraint_string == Constraint.publicStereoTypes[1]) {
                        constraint = new IncludedIn();
                    } else if (constraint_string == Constraint.publicStereoTypes[2]) {
                        constraint = new SymbolicSubdivision();
                    } else if (constraint_string == Constraint.publicStereoTypes[3]) {
                        constraint = new SymbolicAssociation();
                    }
                }
                ((TableByTypeModel)this.table.getModel()).newRow(constraint);
                this.parent.initCombobox();
                this.table.showCell(this.table.getRowCount() - 1, 0);
            } else if (e.getActionCommand().equals("removeRow")) {
                // empty if block
            }
        }
    }

    public void rowAdded(int row_nr) {
        ((TableByTypeModel)this.table.getModel()).fireTableRowsInserted(row_nr, row_nr);
    }

    public void dataChanged() {
        ((TableByTypeModel)this.table.getModel()).fireTableDataChanged();
    }
}

