/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import nl.mpi.jmmf.DIBInfoHeader;

public class DIBToImage {
    public static BufferedImage DIBDataToBufferedImage(byte[] data) {
        if (data == null || data.length < 55) {
            return null;
        }
        BufferedImage image = null;
        int nbisize = (data[3] & 0xFF) << 24 | (data[2] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        int nwidth = (data[7] & 0xFF) << 24 | (data[6] & 0xFF) << 16 | (data[5] & 0xFF) << 8 | data[4] & 0xFF;
        int nheight = (data[11] & 0xFF) << 24 | (data[10] & 0xFF) << 16 | (data[9] & 0xFF) << 8 | data[8] & 0xFF;
        byte[] bi = data;
        int nbitcount = (bi[15] & 0xFF) << 8 | bi[14] & 0xFF;
        int nsizeimage = (bi[23] & 0xFF) << 24 | (bi[22] & 0xFF) << 16 | (bi[21] & 0xFF) << 8 | bi[20] & 0xFF;
        if (nbitcount == 24) {
            int npad = nsizeimage / nheight - nwidth * 3;
            if (npad == 4) {
                npad = 0;
            }
            int[] ndata = new int[nheight * nwidth];
            int nindex = nbisize;
            for (int j = 0; j < nheight; ++j) {
                for (int i = 0; i < nwidth; ++i) {
                    ndata[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (data[nindex + 2] & 0xFF) << 16 | (data[nindex + 1] & 0xFF) << 8 | data[nindex] & 0xFF;
                    nindex += 3;
                }
                nindex += npad;
            }
            Image ii = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata, 0, nwidth));
            if (ii != null) {
                image = new BufferedImage(nwidth, nheight, 1);
                Graphics2D g = image.createGraphics();
                g.drawImage(ii, 0, 0, null);
                g.dispose();
            }
        } else if (nbitcount == 32) {
            int[] ndata = new int[nheight * nwidth];
            int nindex = nbisize;
            for (int j = 0; j < nheight; ++j) {
                for (int i = 0; i < nwidth; ++i) {
                    ndata[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (data[nindex + 2] & 0xFF) << 16 | (data[nindex + 1] & 0xFF) << 8 | data[nindex] & 0xFF;
                    nindex += 4;
                }
            }
            Image ii = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata, 0, nwidth));
            if (ii != null) {
                image = new BufferedImage(nwidth, nheight, 1);
                Graphics2D g = image.createGraphics();
                g.drawImage(ii, 0, 0, null);
                g.dispose();
            }
        }
        return image;
    }

    public static BufferedImage DIBDataToBufferedImage(DIBInfoHeader header, byte[] data) {
        if (data == null || header == null) {
            return null;
        }
        BufferedImage image = null;
        int nbisize = (int)header.size;
        int nwidth = header.width;
        int nheight = header.height;
        int nbitcount = header.bitCount;
        int nsizeimage = (int)header.sizeImage;
        byte[] bi = data;
        if (nbitcount == 24) {
            int npad = nsizeimage / nheight - nwidth * 3;
            if (npad == 4) {
                npad = 0;
            }
            int[] ndata = new int[nheight * nwidth];
            int nindex = 0;
            for (int j = 0; j < nheight; ++j) {
                for (int i = 0; i < nwidth; ++i) {
                    ndata[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (data[nindex + 2] & 0xFF) << 16 | (data[nindex + 1] & 0xFF) << 8 | data[nindex] & 0xFF;
                    nindex += 3;
                }
                nindex += npad;
            }
            Image ii = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata, 0, nwidth));
            if (ii != null) {
                image = new BufferedImage(nwidth, nheight, 1);
                Graphics2D g = image.createGraphics();
                g.drawImage(ii, 0, 0, null);
                g.dispose();
            }
        } else if (nbitcount == 32) {
            int[] ndata = new int[nheight * nwidth];
            int nindex = 0;
            for (int j = 0; j < nheight; ++j) {
                for (int i = 0; i < nwidth; ++i) {
                    ndata[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (data[nindex + 2] & 0xFF) << 16 | (data[nindex + 1] & 0xFF) << 8 | data[nindex] & 0xFF;
                    nindex += 4;
                }
            }
            Image ii = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata, 0, nwidth));
            if (ii != null) {
                image = new BufferedImage(nwidth, nheight, 1);
                Graphics2D g = image.createGraphics();
                g.drawImage(ii, 0, 0, null);
                g.dispose();
            }
        }
        return image;
    }
}

