/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;

public class EndOfMediaWatcher
extends Thread {
    private final int SLEEP;
    private ElanMediaPlayer player;
    private ReentrantLock playLock;
    private Condition playCondition;
    private AtomicBoolean playingFlag;
    private long endOfMediaBufferMs = 0L;

    public EndOfMediaWatcher(ElanMediaPlayer player, ReentrantLock playLock, Condition playCondition, AtomicBoolean playingFlag, int sleepTime) {
        this.player = player;
        this.playLock = playLock;
        this.playCondition = playCondition;
        this.playingFlag = playingFlag;
        this.SLEEP = sleepTime;
    }

    public void setEndOfMediaBufferMs(long bufferMs) {
        this.endOfMediaBufferMs = bufferMs;
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.playLock.lock();
            try {
                if (!this.playingFlag.get()) {
                    try {
                        this.playCondition.await();
                        while (this.playingFlag.get()) {
                            if (this.player.getMediaTime() >= this.player.getMediaDuration() - this.endOfMediaBufferMs) {
                                this.player.stop();
                            }
                            try {
                                Thread.sleep(this.SLEEP);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.playLock.unlock();
            }
        }
    }
}

