/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel
implements ComponentListener {
    private BufferedImage image;
    private float curImgWidth;
    private float curImgHeight;
    private int curImgHorPos;
    private int curImgVertPos;
    private AffineTransform transform;
    private int numCols = 2;
    private int numRows = 2;
    private int curCell = 0;
    private BasicStroke baseStroke = new BasicStroke();
    private BasicStroke stroke = new BasicStroke(2.0f);
    private Color cursorColor = Color.GREEN;
    private Rectangle2D.Double cursor;
    private boolean cursorVisible = true;

    public ImagePanel(BufferedImage image) {
        this.image = image;
        this.cursor = new Rectangle2D.Double();
        this.addComponentListener(this);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void flush() {
        if (this.image != null) {
            this.image.flush();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            ((Graphics2D)g).drawRenderedImage(this.image, this.transform);
        }
        g.setColor(Color.DARK_GRAY);
        ((Graphics2D)g).drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (this.cursorVisible) {
            g.setColor(this.cursorColor);
            ((Graphics2D)g).setStroke(this.stroke);
            ((Graphics2D)g).draw(this.cursor);
            ((Graphics2D)g).setStroke(this.baseStroke);
        }
    }

    private void calculateSize() {
        if (this.image != null) {
            if (this.image.getWidth() > 0 && this.image.getHeight() > 0) {
                float has;
                float was = (float)this.getWidth() / (float)this.image.getWidth();
                float oas = was < (has = (float)this.getHeight() / (float)this.image.getHeight()) ? was : has;
                this.curImgWidth = oas * (float)this.image.getWidth();
                this.curImgHeight = oas * (float)this.image.getHeight();
                this.curImgHorPos = (int)(((float)this.getWidth() - this.curImgWidth) / 2.0f);
                this.curImgVertPos = (int)(((float)this.getHeight() - this.curImgHeight) / 2.0f);
                this.transform = new AffineTransform();
                this.transform.setToScale(oas, oas);
                this.transform.translate(this.curImgHorPos, this.curImgVertPos);
                if (this.cursorVisible) {
                    int row = this.curCell / this.numCols;
                    int col = this.curCell < this.numCols ? this.curCell : this.curCell % this.numCols;
                    this.cursor.setFrame((float)col * (this.curImgWidth / (float)this.numCols), (float)row * (this.curImgHeight / (float)this.numRows), this.curImgWidth / (float)this.numCols, this.curImgHeight / (float)this.numRows);
                }
            }
            this.repaint();
        }
    }

    public void setCursorGrid(int cols, int rows) {
        this.numCols = cols > 0 ? cols : 1;
        this.numRows = rows > 0 ? rows : 1;
        if (this.curCell > this.numCols * this.numRows) {
            this.curCell = this.numCols * this.numRows;
        }
        this.calculateSize();
    }

    public int[] getCursorGrid() {
        return new int[]{this.numCols, this.numRows};
    }

    public void setCursorVisible(boolean visible) {
        this.cursorVisible = visible;
        this.repaint();
    }

    public boolean isCursorVisible() {
        return this.cursorVisible;
    }

    public void setCursorProgress(float progress) {
        this.curCell = (int)((float)(this.numCols * this.numRows) * progress);
        if (this.curCell > this.numCols * this.numRows - 1) {
            this.curCell = this.numCols * this.numRows - 1;
        }
        this.calculateSize();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.calculateSize();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.calculateSize();
    }
}

