/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EndOfMediaWatcher;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.PlaySelectionThread;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.annotator.player.VideoMouseAdapter;
import mpi.eudico.client.annotator.player.VideoScaleAndMove;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;
import nl.mpi.avf.frame.AVFFrameGrabber;
import nl.mpi.avf.player.AVFBaseMediaPlayer;
import nl.mpi.avf.player.AVFNativeMediaPlayer;
import nl.mpi.avf.player.JAVFComponent;
import nl.mpi.avf.player.JAVFMediaPlayer;
import nl.mpi.avf.player.JAVFPlayerException;

public class JAVFELANMediaPlayer
extends ControllerManager
implements ElanMediaPlayer,
VideoScaleAndMove,
VideoFrameGrabber {
    private AVFBaseMediaPlayer javfPlayer;
    private AVFFrameGrabber frameGrabber;
    private boolean nativeRendering = true;
    private MediaDescriptor mediaDescriptor;
    private long offset = 0L;
    private long stopTime;
    private long duration;
    private long origDuration;
    private float cachedVolume = 1.0f;
    private float cachedRate = 1.0f;
    private float curSubVolume;
    private boolean mute;
    private float origAspectRatio = 0.0f;
    private float aspectRatio = 0.0f;
    private double millisPerSample;
    private boolean frameRateAutoDetected = true;
    private boolean frameStepsToFrameBegin = false;
    private boolean debugMode = false;
    private ElanLayoutManager layoutManager;
    private VideoMouseAdapter mouseAdapter;
    private ReentrantLock playLock = new ReentrantLock();
    private Condition playCondition;
    private AtomicBoolean playingFlag;
    private EndOfMediaWatcher endWatcher;
    private AtomicBoolean playSelectionFlag;
    private final ReentrantLock syncLock = new ReentrantLock();
    private boolean useNativeStopTime = true;

    public JAVFELANMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        this(mediaDescriptor, true);
    }

    public JAVFELANMediaPlayer(MediaDescriptor mediaDescriptor, boolean nativeRendering) throws NoPlayerException {
        this.mediaDescriptor = mediaDescriptor;
        this.nativeRendering = nativeRendering;
        this.offset = mediaDescriptor.timeOrigin;
        try {
            this.javfPlayer = this.nativeRendering ? new AVFNativeMediaPlayer(mediaDescriptor.mediaURL) : new JAVFMediaPlayer(mediaDescriptor.mediaURL);
            this.logMediaInfo();
        }
        catch (JAVFPlayerException jpe) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("JAVFMedia Player cannot handle the file: " + jpe.getMessage());
            }
            throw new NoPlayerException("JAVFMedia Player error: " + jpe.getMessage());
        }
        this.playLock = new ReentrantLock();
        this.playCondition = this.playLock.newCondition();
        this.playingFlag = new AtomicBoolean();
        this.endWatcher = new EndOfMediaWatcher(this, this.playLock, this.playCondition, this.playingFlag, 250);
        this.endWatcher.start();
        this.playSelectionFlag = new AtomicBoolean();
    }

    private void logMediaInfo() {
        if (ClientLogger.LOG.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder("JAVF Media Player:\n");
            sb.append(String.format("\tFile: %s\n", this.mediaDescriptor.mediaURL));
            sb.append(String.format("\tHas Video: %b\n", this.javfPlayer.getVisualComponent() != null));
            if (this.javfPlayer.getVisualComponent() != null) {
                Dimension origSize = this.javfPlayer.getOriginalSize();
                if (origSize != null) {
                    sb.append(String.format("\tVideo Size: %d x %d\n", origSize.width, origSize.height));
                }
                sb.append(String.format("\tFrame Duration: %.4f sec., Frame Rate: %.4f\n", this.javfPlayer.getFrameDuration(), this.javfPlayer.getFrameRate()));
            }
            sb.append(String.format("\tMedia Duration: %s", TimeFormatter.toString(this.javfPlayer.getDuration())));
            ClientLogger.LOG.info(sb.toString());
        }
    }

    @Override
    public void preferencesChanged() {
        Boolean boolPref = Preferences.getBool("NativePlayer.DebugMode", null);
        if (boolPref != null) {
            this.debugMode = boolPref;
            this.javfPlayer.setDebugMode(this.debugMode);
            if (this.frameGrabber != null) {
                AVFFrameGrabber.enableDebugMode(this.debugMode);
            }
        }
        if ((boolPref = Preferences.getBool("JAVFPlayer.UseNativeStopTime", null)) != null) {
            this.useNativeStopTime = boolPref;
        } else {
            String prop = System.getProperty("JAVFPlayer.UseNativeStopTime");
            if (prop != null) {
                this.useNativeStopTime = Boolean.parseBoolean(prop);
            }
        }
    }

    @Override
    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    @Override
    public void start() {
        if (this.javfPlayer.isPlaying()) {
            return;
        }
        this.syncLock.lock();
        try {
            this.javfPlayer.start();
            this.startControllers();
            if (this.javfPlayer.getRate() != this.cachedRate) {
                this.javfPlayer.setRate(this.cachedRate);
                this.setControllersRate(this.cachedRate);
            }
            this.playLock.lock();
            try {
                this.playingFlag.set(true);
                this.playCondition.signal();
            }
            finally {
                this.playLock.unlock();
            }
        }
        finally {
            this.syncLock.unlock();
        }
    }

    @Override
    public void stop() {
        if (!this.javfPlayer.isPlaying() && this.javfPlayer.getMediaTime() != this.javfPlayer.getDuration()) {
            if (this.playingFlag.get()) {
                this.playingFlag.set(false);
                this.stopControllers();
                if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                    ClientLogger.LOG.fine("Playing flag inconsistency: flag is true, player is not playing");
                }
            }
            this.playSelectionFlag.set(false);
            return;
        }
        this.syncLock.lock();
        try {
            this.javfPlayer.stop();
            this.stopControllers();
            this.setControllersMediaTime(this.javfPlayer.getMediaTime());
            this.playingFlag.set(false);
            this.playSelectionFlag.set(false);
        }
        finally {
            this.syncLock.unlock();
        }
    }

    @Override
    public boolean isPlaying() {
        return this.javfPlayer.isPlaying();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playInterval(long startTime, long stopTime) {
        if (this.javfPlayer.isPlaying()) {
            return;
        }
        this.syncLock.lock();
        try {
            this.setMediaTime(startTime);
            this.setStopTime(stopTime);
            this.playSelectionFlag.set(true);
            new PlaySelectionThread(this, this.playSelectionFlag, stopTime, 10).start();
            this.start();
        }
        finally {
            this.syncLock.unlock();
        }
    }

    @Override
    public boolean isPlayingInterval() {
        if (this.playSelectionFlag != null) {
            return this.playSelectionFlag.get();
        }
        return false;
    }

    @Override
    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
        if (this.useNativeStopTime) {
            this.javfPlayer.setStopTime(this.stopTime + this.offset);
        }
        this.setControllersStopTime(this.stopTime);
    }

    @Override
    public void setOffset(long offset) {
        long diff = this.offset - offset;
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
        if (this.origDuration == 0L) {
            this.origDuration = this.javfPlayer.getDuration();
        }
        this.duration = this.origDuration - offset;
        this.stopTime += diff;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void nextFrame() {
        if (this.javfPlayer.isPlaying()) {
            this.stop();
        }
        if (this.javfPlayer.getFrameDuration() > 0.0) {
            this.javfPlayer.frameForward(this.frameStepsToFrameBegin);
            long nextTime = this.javfPlayer.getMediaTime();
            this.setControllersMediaTime(nextTime - this.offset);
        } else {
            this.setMediaTime(this.getMediaTime() + (long)this.getMilliSecondsPerSample());
        }
    }

    @Override
    public void previousFrame() {
        if (this.javfPlayer.isPlaying()) {
            this.stop();
        }
        if (this.javfPlayer.getFrameDuration() > 0.0) {
            this.javfPlayer.frameBackward(this.frameStepsToFrameBegin);
            long nextTime = this.javfPlayer.getMediaTime();
            this.setControllersMediaTime(nextTime - this.offset);
        } else {
            this.setMediaTime(this.getMediaTime() - (long)this.getMilliSecondsPerSample());
        }
    }

    @Override
    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    @Override
    public void setMediaTime(long time) {
        if (this.javfPlayer.isPlaying()) {
            this.stop();
        }
        if (time < 0L) {
            time = 0L;
        }
        if (time > this.duration) {
            time = this.duration;
        }
        this.javfPlayer.setMediaTime(time + this.offset);
        this.setControllersMediaTime(time);
    }

    @Override
    public long getMediaTime() {
        return this.javfPlayer.getMediaTime() - this.offset;
    }

    @Override
    public void setRate(float rate) {
        this.cachedRate = rate;
        if (this.javfPlayer.isPlaying()) {
            this.javfPlayer.setRate(rate);
            this.setControllersRate(rate);
        }
    }

    @Override
    public float getRate() {
        float curRate = this.javfPlayer.getRate();
        if (curRate > 0.0f) {
            return curRate;
        }
        return this.cachedRate;
    }

    @Override
    public boolean isFrameRateAutoDetected() {
        return this.frameRateAutoDetected;
    }

    @Override
    public long getMediaDuration() {
        if (this.duration <= 0L) {
            if (this.origDuration == 0L) {
                this.origDuration = this.javfPlayer.getDuration();
            }
            this.duration = this.origDuration - this.offset;
        }
        return this.duration;
    }

    @Override
    public float getVolume() {
        return this.javfPlayer.getVolume();
    }

    @Override
    public void setVolume(float level) {
        this.cachedVolume = level;
        this.javfPlayer.setVolume(level);
    }

    @Override
    public void setSubVolume(float level) {
        this.curSubVolume = level;
    }

    @Override
    public float getSubVolume() {
        return this.curSubVolume;
    }

    @Override
    public void setMute(boolean mute) {
        this.mute = mute;
    }

    @Override
    public boolean getMute() {
        return this.mute;
    }

    @Override
    public void setLayoutManager(ElanLayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        if (this.javfPlayer.getVisualComponent() != null) {
            this.mouseAdapter = new VideoMouseAdapter(this, layoutManager, this.javfPlayer.getVisualComponent());
        }
    }

    @Override
    public Component getVisualComponent() {
        return this.javfPlayer.getVisualComponent();
    }

    @Override
    public int getSourceWidth() {
        Dimension d = this.javfPlayer.getOriginalSize();
        if (d != null) {
            return d.width;
        }
        return 0;
    }

    @Override
    public int getSourceHeight() {
        Dimension d = this.javfPlayer.getOriginalSize();
        if (d != null) {
            return d.height;
        }
        return 0;
    }

    @Override
    public float getAspectRatio() {
        if (this.aspectRatio != 0.0f) {
            return this.aspectRatio;
        }
        Dimension origSize = this.javfPlayer.getOriginalSize();
        if (origSize != null) {
            if (origSize.getHeight() > 0.0) {
                this.aspectRatio = this.origAspectRatio = (float)(origSize.getWidth() / origSize.getHeight());
            }
        } else if (this.javfPlayer instanceof JAVFMediaPlayer) {
            if (((JAVFMediaPlayer)this.javfPlayer).getVideoImageHeight() > 0) {
                this.origAspectRatio = (float)((JAVFMediaPlayer)this.javfPlayer).getVideoImageWidth() / (float)((JAVFMediaPlayer)this.javfPlayer).getVideoImageHeight();
            }
            this.aspectRatio = this.origAspectRatio;
        }
        return this.aspectRatio;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
        if (this.javfPlayer.getVisualComponent() instanceof JAVFComponent) {
            ((JAVFComponent)((Object)this.javfPlayer.getVisualComponent())).setAspectRatio(aspectRatio);
            if (this.layoutManager != null) {
                this.layoutManager.doLayout();
            }
        }
    }

    @Override
    public double getMilliSecondsPerSample() {
        if (this.millisPerSample == 0.0) {
            this.millisPerSample = this.javfPlayer.getFrameDuration();
            if (this.millisPerSample == 0.0) {
                this.millisPerSample = 40.0;
                this.frameRateAutoDetected = false;
            }
        }
        return this.millisPerSample;
    }

    @Override
    public void setMilliSecondsPerSample(long milliSeconds) {
        if (!this.frameRateAutoDetected) {
            this.millisPerSample = milliSeconds;
        }
    }

    @Override
    public void updateLocale() {
        if (this.mouseAdapter != null) {
            this.mouseAdapter.updateLocale();
        }
    }

    @Override
    public String getFrameworkDescription() {
        if (this.javfPlayer instanceof JAVFMediaPlayer) {
            return "AV Foundation Player with Java Rendering";
        }
        return "AV Foundation Player with Native Rendering";
    }

    @Override
    public void cleanUpOnClose() {
        if (this.javfPlayer.isPlaying()) {
            this.stop();
        }
        if (this.mouseAdapter != null) {
            this.mouseAdapter = null;
        }
        this.javfPlayer.deletePlayer();
    }

    @Override
    public float getVideoScaleFactor() {
        return this.javfPlayer.getVideoScaleFactor();
    }

    @Override
    public void setVideoScaleFactor(float scaleFactor) {
        this.javfPlayer.setVideoScaleFactor(scaleFactor);
    }

    @Override
    public void repaintVideo() {
        this.javfPlayer.repaintVideo();
    }

    @Override
    public int[] getVideoBounds() {
        return this.javfPlayer.getVideoBounds();
    }

    @Override
    public void setVideoBounds(int x, int y, int w, int h) {
        this.javfPlayer.setVideoBounds(x, y, w, h);
    }

    @Override
    public void moveVideoPos(int dx, int dy) {
        this.javfPlayer.moveVideoPos(dx, dy);
    }

    @Override
    public Image getCurrentFrameImage() {
        if (this.frameGrabber == null) {
            AVFFrameGrabber.enableDebugMode(this.debugMode);
            this.frameGrabber = new AVFFrameGrabber(this.mediaDescriptor.mediaURL);
        }
        return this.frameGrabber.getVideoFrameImage(this.getMediaTime());
    }

    @Override
    public Image getFrameImageForTime(long time) {
        if (this.frameGrabber == null) {
            AVFFrameGrabber.enableDebugMode(this.debugMode);
            this.frameGrabber = new AVFFrameGrabber(this.mediaDescriptor.mediaURL);
        }
        return this.frameGrabber.getVideoFrameImage(time);
    }
}

