/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.io.File;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.ImagePlayer;
import mpi.eudico.client.annotator.player.JAVFELANMediaPlayer;
import mpi.eudico.client.annotator.player.JDSMediaPlayer;
import mpi.eudico.client.annotator.player.JFXMediaPlayer;
import mpi.eudico.client.annotator.player.JMMFMediaPlayer;
import mpi.eudico.client.annotator.player.JavaSoundPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.VLCJ4MediaPlayer;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class PlayerFactory {
    public static final String JMF_MEDIA_FRAMEWORK = "JMF";
    public static final String QT_MEDIA_FRAMEWORK = "QT";
    public static final String COCOA_QT = "CocoaQT";
    public static final String JDS = "JDS";
    public static final String JMMF = "JMMF";
    public static final String[] MMF_EXTENSIONS = new String[]{"asf", "wma", "wmv", "m4a", "m4v", "mp4"};
    public static final String VLCJ = "VLCJ";
    public static final String JFX = "JFX";
    public static final String JAVA_SOUND = "JavaSound";
    public static final String JAVF = "JAVF";
    public static final String AVFN = "AVFN";
    private static int javaMacroVersion = SystemReporting.getJavaMacroVersion();

    public static ElanMediaPlayer createElanMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        StringBuilder sb;
        boolean jmmfTried;
        String preferredMF;
        block61: {
            String mediaURL = mediaDescriptor.mediaURL;
            if (mediaURL.startsWith("file") && !new File(mediaURL.substring(5)).exists()) {
                throw new NoPlayerException("Media File not found: " + mediaURL);
            }
            if (mediaDescriptor.mimeType != null && mediaDescriptor.mimeType.startsWith("image")) {
                return new ImagePlayer(mediaDescriptor);
            }
            preferredMF = System.getProperty("PreferredMediaFramework");
            jmmfTried = false;
            String tempPreferredMF = preferredMF;
            sb = new StringBuilder();
            try {
                if (preferredMF != null) {
                    if (preferredMF.equals(JAVF)) {
                        System.out.println("The AV Foundation player with Java rendering (JAVF) is not supported anymore");
                    }
                    if (!(preferredMF.equals(JMF_MEDIA_FRAMEWORK) || preferredMF.equals(QT_MEDIA_FRAMEWORK) || preferredMF.equals(COCOA_QT))) {
                        if (preferredMF.equals(JDS) || preferredMF.equals(JMMF)) {
                            String playerType = PlayerFactory.checkLoadJdsOrJmmf(mediaDescriptor);
                            if (playerType == JMMF) {
                                preferredMF = JMMF;
                                jmmfTried = true;
                                return PlayerFactory.createJMMFPlayer(mediaDescriptor);
                            }
                            return PlayerFactory.createJDSPlayer(mediaDescriptor);
                        }
                        if (preferredMF.equals(VLCJ)) {
                            return PlayerFactory.createVLCJPlayer(mediaDescriptor);
                        }
                        if (preferredMF.equals(JFX)) {
                            return PlayerFactory.createJavaFXPlayer(mediaDescriptor);
                        }
                        if (preferredMF.equals(JAVA_SOUND)) {
                            return PlayerFactory.createJavaSoundPlayer(mediaDescriptor);
                        }
                        if (preferredMF.equals(JAVF) || preferredMF.equals(AVFN)) {
                            return PlayerFactory.createAVFNPlayer(mediaDescriptor);
                        }
                    }
                }
            }
            catch (NoPlayerException npe) {
                System.out.println("Preferred media framework '" + preferredMF + "' can not handle the file: " + npe.getMessage());
                sb.append("Preferred media framework '" + preferredMF + "' can not handle the file: " + npe.getMessage() + "\n");
                if (!jmmfTried) break block61;
                preferredMF = tempPreferredMF;
            }
        }
        if (SystemReporting.isWindows()) {
            ElanMediaPlayer player = null;
            if (!JDS.equals(preferredMF)) {
                String playerType = PlayerFactory.checkLoadJdsOrJmmf(mediaDescriptor);
                if (playerType == JMMF && !jmmfTried) {
                    try {
                        player = PlayerFactory.createJMMFPlayer(mediaDescriptor);
                    }
                    catch (NoPlayerException npe) {
                        System.out.println("Could not create a JMMF based player: " + npe.getMessage());
                        sb.append(npe.getMessage() + "\n");
                        try {
                            player = PlayerFactory.createJDSPlayer(mediaDescriptor);
                        }
                        catch (NoPlayerException nnpe) {
                            System.out.println("Could not create a JDS based player: " + nnpe.getMessage());
                            sb.append(nnpe.getMessage() + "\n");
                        }
                    }
                } else {
                    try {
                        player = PlayerFactory.createJDSPlayer(mediaDescriptor);
                    }
                    catch (NoPlayerException npe) {
                        System.out.println("Could not create a JDS based player: " + npe.getMessage());
                        sb.append(npe.getMessage() + "\n");
                    }
                }
            }
            if (player == null && !JFX.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createJavaFXPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("Could not create a JavaFX based player: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player == null && !VLCJ.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createVLCJPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("Could not create a VLCJ based player: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player == null && !JAVA_SOUND.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createJavaSoundPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("JavaSound cannot play the file: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player != null) {
                return player;
            }
            throw new NoPlayerException(sb.toString());
        }
        if (SystemReporting.isMacOS()) {
            ElanMediaPlayer player = null;
            if (player == null && !AVFN.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createAVFNPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("Could not create a AVFN based player: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player == null && !JAVF.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createJAVFPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("Could not create a JAVF based player: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player == null && !JFX.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createJavaFXPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("Could not create a JavaFX based player... " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player == null && !VLCJ.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createVLCJPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("Could not create a VLCJ based player: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player == null && !JAVA_SOUND.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createJavaSoundPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("JavaSound cannot play the file: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player != null) {
                return player;
            }
            throw new NoPlayerException(sb.toString());
        }
        if (SystemReporting.isLinux()) {
            ElanMediaPlayer player = null;
            if (!VLCJ.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createVLCJPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("Could not create a VLCJ player for the file: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player == null && !JFX.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createJavaFXPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("Could not create a JavaFX based player... " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player == null && !JAVA_SOUND.equals(preferredMF) && mediaDescriptor.mimeType.indexOf("audio") > -1) {
                try {
                    player = PlayerFactory.createJavaSoundPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("JavaSound cannot play the file: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player != null) {
                return player;
            }
            throw new NoPlayerException(sb.toString());
        }
        return null;
    }

    public static ElanMediaPlayer createElanMediaPlayer(MediaDescriptor mediaDescriptor, String framework) throws NoPlayerException {
        if (framework == null) {
            return PlayerFactory.createElanMediaPlayer(mediaDescriptor);
        }
        if (framework.equals(JDS)) {
            if (!SystemReporting.isWindows()) {
                return null;
            }
            return PlayerFactory.createJDSPlayer(mediaDescriptor);
        }
        if (framework.equals(JMMF)) {
            if (!SystemReporting.isWindows()) {
                return null;
            }
            return PlayerFactory.createJMMFPlayer(mediaDescriptor);
        }
        if (framework.equals(JFX)) {
            return PlayerFactory.createJavaFXPlayer(mediaDescriptor);
        }
        if (framework.equals(AVFN) || framework.equals(JAVF)) {
            if (!SystemReporting.isMacOS()) {
                return null;
            }
            if (framework.equals(JAVF)) {
                System.out.println("The AV Foundation player with Java rendering (JAVF) is not supported anymore");
            }
            return PlayerFactory.createAVFNPlayer(mediaDescriptor);
        }
        if (framework.equals(JAVA_SOUND)) {
            return PlayerFactory.createJavaSoundPlayer(mediaDescriptor);
        }
        if (framework.equals(VLCJ)) {
            return PlayerFactory.createVLCJPlayer(mediaDescriptor);
        }
        return null;
    }

    public static ElanMediaPlayer createJDSPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using JDS Player for " + mediaDescriptor.mediaURL);
        return new JDSMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createJMMFPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using JMMF Player for " + mediaDescriptor.mediaURL);
        return new JMMFMediaPlayer(mediaDescriptor);
    }

    private static String checkLoadJdsOrJmmf(MediaDescriptor mediaDescriptor) {
        String lower = mediaDescriptor.mediaURL.toLowerCase();
        int extIndex = lower.lastIndexOf(46);
        if (extIndex > -1 && extIndex < lower.length() - 1) {
            String ext = lower.substring(extIndex + 1);
            int fileTypeIndex = -1;
            for (int i = 0; i < MMF_EXTENSIONS.length; ++i) {
                if (!MMF_EXTENSIONS[i].equals(ext)) continue;
                fileTypeIndex = i;
                break;
            }
            if (fileTypeIndex > -1) {
                String jmmfPref = System.getProperty("JMMFEnabled");
                if (jmmfPref != null && "false".equals(jmmfPref.toLowerCase())) {
                    return JDS;
                }
                Boolean jmmfUserPref = Preferences.getBool("Windows.JMMFEnabled", null);
                if (jmmfUserPref != null && !jmmfUserPref.booleanValue()) {
                    return JDS;
                }
                boolean isVista = SystemReporting.isWindowsVista();
                boolean isWin7 = SystemReporting.isWindows7OrHigher();
                if (isVista && fileTypeIndex <= 2) {
                    return JMMF;
                }
                if (isWin7) {
                    return JMMF;
                }
            } else {
                String forceJMMF = System.getProperty("JMMFPlayer.ForceForAllFileTypes");
                if (forceJMMF != null && "true".equals(forceJMMF)) {
                    return JMMF;
                }
            }
        } else if (lower.startsWith("http")) {
            return JMMF;
        }
        return JDS;
    }

    public static ElanMediaPlayer createVLCJPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        try {
            System.out.println("Trying VLCJ Player for " + mediaDescriptor.mediaURL);
            return new VLCJ4MediaPlayer(mediaDescriptor);
        }
        catch (UnsatisfiedLinkError le) {
            System.out.println("Failing to load VLCJ Player.");
            System.out.println("Is VLC properly installed?");
            throw new NoPlayerException("Failing to load VLCJ Player.\nIs VLC properly installed?\n" + le.toString());
        }
        catch (Throwable t) {
            throw new NoPlayerException(t.toString());
        }
    }

    public static ElanMediaPlayer createJavaFXPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using JavaFX Player for " + mediaDescriptor.mediaURL);
        if (javaMacroVersion < 8) {
            throw new NoPlayerException("The JavaFX based player requires Java 8 or higher");
        }
        return new JFXMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createJavaSoundPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        try {
            System.out.println("Using Java Sound Player for " + mediaDescriptor.mediaURL);
            return new JavaSoundPlayer(mediaDescriptor);
        }
        catch (Throwable t) {
            throw new NoPlayerException(t.getMessage());
        }
    }

    public static ElanMediaPlayer createAVFNPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using AVFN Player for " + mediaDescriptor.mediaURL);
        return new JAVFELANMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createJAVFPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using JAVF Player for " + mediaDescriptor.mediaURL);
        return new JAVFELANMediaPlayer(mediaDescriptor, false);
    }
}

