/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import mpi.eudico.client.util.WAVFromOtherSampler;
import mpi.eudico.client.util.WAVHeader;
import mpi.eudico.client.util.WAVSampler;
import mpi.eudico.client.util.WAVSamplesProvider;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import nl.mpi.media.UnsupportedMediaException;
import nl.mpi.util.FileUtility;

public class WAVSamplerFactory {
    private static final Logger LOG = Logger.getLogger("ClientLogger");
    private static boolean useNativeAudioExtractor = true;

    private WAVSamplerFactory() {
    }

    public static void setUseNativeExtractor(boolean useNativeExtractor) {
        useNativeAudioExtractor = useNativeExtractor;
    }

    public static WAVSamplesProvider createWAVSamplesProvider(String mediaPath) {
        block11: {
            block10: {
                WAVHeader header;
                short compression;
                if (mediaPath == null) {
                    return null;
                }
                boolean isLocal = false;
                if (!FileUtility.isRemoteFile(mediaPath)) {
                    isLocal = true;
                    mediaPath = FileUtility.urlToAbsPath(mediaPath);
                }
                String lcExt = FileUtility.getExtension(mediaPath, "wav").toLowerCase();
                if (isLocal && (lcExt.equals("wav") || lcExt.equals("wave")) && ((compression = (header = new WAVHeader(mediaPath)).getCompressionCode()) == 1 || compression == 6 || compression == -2) && header.getNumberOfChannels() < 3) {
                    try {
                        return new WAVSampler(mediaPath);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.WARNING)) break block10;
                        LOG.log(Level.WARNING, ioe.getMessage());
                    }
                }
            }
            if (!useNativeAudioExtractor) {
                return null;
            }
            try {
                return new WAVFromOtherSampler(mediaPath);
            }
            catch (UnsupportedMediaException ume) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, ume.getMessage());
                }
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.WARNING)) break block11;
                LOG.log(Level.WARNING, ioe.getMessage());
            }
        }
        return null;
    }

    public static WAVSamplesProvider createWAVSamplesProvider(MediaDescriptor medDescriptor) {
        block11: {
            String medPath;
            block10: {
                WAVHeader header;
                short compression;
                if (medDescriptor == null || medDescriptor.mediaURL == null) {
                    return null;
                }
                medPath = medDescriptor.mediaURL;
                boolean isLocal = false;
                if (!FileUtility.isRemoteFile(medPath)) {
                    isLocal = true;
                    medPath = FileUtility.urlToAbsPath(medPath);
                }
                if ("audio/x-wav".equals(medDescriptor.mimeType) && isLocal && ((compression = (header = new WAVHeader(medPath)).getCompressionCode()) == 1 || compression == 6 || compression == -2) && header.getNumberOfChannels() < 3) {
                    try {
                        return new WAVSampler(medPath);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.WARNING)) break block10;
                        LOG.log(Level.WARNING, ioe.getMessage());
                    }
                }
            }
            if (!useNativeAudioExtractor) {
                return null;
            }
            try {
                return new WAVFromOtherSampler(medPath);
            }
            catch (UnsupportedMediaException ume) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, ume.getMessage());
                }
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.WARNING)) break block11;
                LOG.log(Level.WARNING, ioe.getMessage());
            }
        }
        return null;
    }

    static {
        String prop = System.getProperty("AudioExtractor.UseNativeExtractor");
        if (prop != null) {
            useNativeAudioExtractor = Boolean.parseBoolean(prop);
        }
    }
}

