/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.prefs.PreferencesReader;
import mpi.eudico.client.annotator.prefs.PreferencesWriter;
import mpi.eudico.client.annotator.util.ClientLogger;

public class MultipleFileDomains {
    public static final String DIR_SUF = ".Dirs";
    public static final String PATH_SUF = ".Paths";
    private static final String DOMAINS_FILEPATH = Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + "mf_domains.pfsx";
    private static MultipleFileDomains domains;
    private static PreferencesReader xmlPrefsReader;
    private static PreferencesWriter xmlPrefsWriter;
    private static List<String> domainNames;
    private static Map<String, List<String>> domainMap;

    private MultipleFileDomains() {
        this.initDomains();
    }

    private void initDomains() {
        xmlPrefsReader = new PreferencesReader();
        xmlPrefsWriter = new PreferencesWriter();
        MultipleFileDomains.readDomain();
    }

    private static void readDomain() {
        try {
            List<String> val;
            domainMap = xmlPrefsReader.parse(DOMAINS_FILEPATH);
            if (domainMap != null && (val = domainMap.get("DomainNames")) instanceof List) {
                domainNames = val;
            }
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not load the domains preferences file");
        }
        if (domainMap == null) {
            domainMap = new HashMap<String, List<String>>(12);
        }
        if (domainNames == null) {
            domainNames = new ArrayList<String>();
            domainMap.put("DomainNames", domainNames);
        }
    }

    private static void writeDomain() {
        try {
            xmlPrefsWriter.encodeAndSave(domainMap, DOMAINS_FILEPATH);
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not save the domains preferences file");
        }
    }

    public static MultipleFileDomains getInstance() {
        if (domains == null) {
            domains = new MultipleFileDomains();
        }
        return domains;
    }

    public List<String> getDomainList() {
        return domainNames;
    }

    public void addDomain(String key, List<String> dirs, List<String> paths) {
        if (!domainNames.contains(key)) {
            domainNames.add(key);
        }
        domainMap.put(key + DIR_SUF, dirs);
        domainMap.put(key + PATH_SUF, paths);
        MultipleFileDomains.writeDomain();
    }

    public void removeDomain(String name) {
        domainNames.remove(name);
        domainMap.remove(name + DIR_SUF);
        domainMap.remove(name + PATH_SUF);
        MultipleFileDomains.writeDomain();
    }

    public Map<String, List<String>> getDomain(String key) {
        if (domainNames.contains(key)) {
            HashMap<String, List<String>> result = new HashMap<String, List<String>>(2);
            String name = key + DIR_SUF;
            result.put(name, domainMap.get(name));
            name = key + PATH_SUF;
            result.put(name, domainMap.get(name));
            return result;
        }
        return null;
    }
}

