/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.ShutdownListener;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.multilangcv.RecentLanguages;

public class RecentLanguagesPrefs
implements ShutdownListener {
    public static final String privatePreferencesFile = "RecentLanguages.xml";
    private boolean recentLanguagesLoaded = false;
    private static RecentLanguagesPrefs instance;

    public static RecentLanguagesPrefs getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new RecentLanguagesPrefs();
        return instance;
    }

    private RecentLanguagesPrefs() {
        this.loadPrivatePreferences();
    }

    private void loadPrivatePreferences() {
        block5: {
            if (this.recentLanguagesLoaded) {
                return;
            }
            this.recentLanguagesLoaded = true;
            try {
                String fileName = Constants.ELAN_DATA_DIR + File.separator + privatePreferencesFile;
                RecentLanguages.getInstance().loadRecentLanguages(fileName);
            }
            catch (IOException e) {
                if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                    ClientLogger.LOG.fine(e.getMessage());
                }
            }
            catch (Throwable t) {
                if (!ClientLogger.LOG.isLoggable(Level.FINE)) break block5;
                ClientLogger.LOG.fine(t.getMessage());
            }
        }
        FrameManager.getInstance().addWindowCloseListener(this);
    }

    private void savePrivatePreferences() {
        block4: {
            try {
                String fileName = Constants.ELAN_DATA_DIR + File.separator + privatePreferencesFile;
                RecentLanguages.getInstance().saveRecentLanguages(fileName);
            }
            catch (IOException ioe) {
                if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                    ClientLogger.LOG.fine(ioe.getMessage());
                }
            }
            catch (Throwable t) {
                if (!ClientLogger.LOG.isLoggable(Level.FINE)) break block4;
                ClientLogger.LOG.fine(t.getMessage());
            }
        }
    }

    @Override
    public void somethingIsClosing(ShutdownListener.Event e) {
        if (e.getType() == 3) {
            this.savePrivatePreferences();
        }
    }
}

