/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.prefs.gui.AbstractEditPrefsPanel;

public class CVPanel
extends AbstractEditPrefsPanel
implements PreferenceEditor,
ChangeListener {
    private JCheckBox suggestEntryContainsCB;
    private JCheckBox suggestSearchDescCB;
    private JCheckBox suggestIgnoreCaseCB;
    private JCheckBox showDescriptionCB;
    private JTextField inlineWidthTF;
    private JTextField cvWidthPercentageTF;
    private JCheckBox annotationValuePrecedenceCB;
    private int oriInlineBoxWidth = 0;
    private int oriCVWidthPercentage = 30;
    private boolean oriSuggestSearchMethodFlag = false;
    private boolean oriSuggestSearchInDescFlag = false;
    private boolean oriSuggestIgnoreCaseFlag = false;
    private boolean oriShowDescriptionFlag = true;
    private boolean oriAnnotationValuePrecedenceFlag = false;
    private int newInlineBoxWidth;
    private int newCVWidthPercentage;

    public CVPanel() {
        super(ElanLocale.getString("EditCVDialog.Label.CV"));
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Integer intPref;
        Boolean boolPref = Preferences.getBool("SuggestPanel.EntryContains", null);
        if (boolPref != null) {
            this.oriSuggestSearchMethodFlag = boolPref;
        }
        if ((boolPref = Preferences.getBool("SuggestPanel.SearchDescription", null)) != null) {
            this.oriSuggestSearchInDescFlag = boolPref;
        }
        if ((boolPref = Preferences.getBool("SuggestPanel.IgnoreCase", null)) != null) {
            this.oriSuggestIgnoreCaseFlag = boolPref;
        }
        if ((boolPref = Preferences.getBool("InlineEditBox.ShowCVDescription", null)) != null) {
            this.oriShowDescriptionFlag = boolPref;
        }
        if ((intPref = Preferences.getInt("InlineEditBoxWidth", null)) != null) {
            this.oriInlineBoxWidth = intPref;
        }
        this.newInlineBoxWidth = this.oriInlineBoxWidth;
        intPref = Preferences.getInt("InlineEditBoxCvWidthPercentage", null);
        if (intPref != null) {
            this.oriCVWidthPercentage = intPref;
        }
        this.newCVWidthPercentage = this.oriCVWidthPercentage;
        boolPref = Preferences.getBool("AnnotationValuePrecedenceOverCVERef", null);
        if (boolPref != null) {
            this.oriAnnotationValuePrecedenceFlag = boolPref;
        }
    }

    private void initComponents() {
        this.suggestEntryContainsCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SuggestEntryContains"), this.oriSuggestSearchMethodFlag);
        this.suggestSearchDescCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SuggestSearchDesc"), this.oriSuggestSearchInDescFlag);
        this.suggestIgnoreCaseCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SuggestIgnoreCase"), this.oriSuggestIgnoreCaseFlag);
        this.showDescriptionCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.CV.ShowCVDescripiton"), this.oriShowDescriptionFlag);
        this.showDescriptionCB.addChangeListener(this);
        this.inlineWidthTF = new JTextField("", 5);
        if (this.oriInlineBoxWidth > 0) {
            this.inlineWidthTF.setText(Long.toString(this.oriInlineBoxWidth));
        }
        this.cvWidthPercentageTF = new JTextField(Integer.toString(this.oriCVWidthPercentage), 5);
        this.annotationValuePrecedenceCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.CV.ECVUpdate.AnnotationPrecedence"), this.oriAnnotationValuePrecedenceFlag);
        this.suggestEntryContainsCB.setFont(this.suggestEntryContainsCB.getFont().deriveFont(0));
        this.suggestSearchDescCB.setFont(this.suggestEntryContainsCB.getFont());
        this.suggestIgnoreCaseCB.setFont(this.suggestEntryContainsCB.getFont());
        this.inlineWidthTF.setFont(this.suggestEntryContainsCB.getFont());
        this.cvWidthPercentageTF.setFont(this.suggestEntryContainsCB.getFont());
        this.annotationValuePrecedenceCB.setFont(this.suggestEntryContainsCB.getFont());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel inlineEditPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        inlineEditPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Edit.InlineEditBoxWidth")), gbc);
        gbc.gridx = 1;
        inlineEditPanel.add((Component)this.inlineWidthTF, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        inlineEditPanel.add((Component)this.showDescriptionCB, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.insets = this.singleTabInset;
        inlineEditPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Edit.InlineEditBoxCVWidthPercentage")), gbc);
        gbc.gridx = 1;
        gbc.insets = this.leftInset;
        inlineEditPanel.add((Component)this.cvWidthPercentageTF, gbc);
        this.cvWidthPercentageTF.setEnabled(this.showDescriptionCB.isSelected());
        int gy = 0;
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Edit.InlineEditBox")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalPanelInset;
        gbc.fill = 0;
        this.outerPanel.add((Component)inlineEditPanel, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        gbc.fill = 2;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Edit.SuggestPanel")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.suggestEntryContainsCB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.suggestSearchDescCB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.suggestIgnoreCaseCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.CV.ECVUpdate")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.annotationValuePrecedenceCB, gbc);
        gbc.gridy = gy++;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.outerPanel.add((Component)new JPanel(), gbc);
    }

    @Override
    public Map<String, Object> getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(3);
            if (this.suggestEntryContainsCB.isSelected() != this.oriSuggestSearchMethodFlag) {
                chMap.put("SuggestPanel.EntryContains", this.suggestEntryContainsCB.isSelected());
            }
            if (this.suggestSearchDescCB.isSelected() != this.oriSuggestSearchInDescFlag) {
                chMap.put("SuggestPanel.SearchDescription", this.suggestSearchDescCB.isSelected());
            }
            if (this.suggestIgnoreCaseCB.isSelected() != this.oriSuggestIgnoreCaseFlag) {
                chMap.put("SuggestPanel.IgnoreCase", this.suggestIgnoreCaseCB.isSelected());
            }
            if (this.showDescriptionCB.isSelected() != this.oriShowDescriptionFlag) {
                chMap.put("InlineEditBox.ShowCVDescription", this.showDescriptionCB.isSelected());
            }
            chMap.put("InlineEditBoxWidth", this.newInlineBoxWidth);
            chMap.put("InlineEditBoxCvWidthPercentage", this.newCVWidthPercentage);
            if (this.annotationValuePrecedenceCB.isSelected() != this.oriAnnotationValuePrecedenceFlag) {
                chMap.put("AnnotationValuePrecedenceOverCVERef", this.annotationValuePrecedenceCB.isSelected());
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        return this.suggestEntryContainsCB.isSelected() != this.oriSuggestSearchMethodFlag || this.suggestSearchDescCB.isSelected() != this.oriSuggestSearchInDescFlag || this.suggestIgnoreCaseCB.isSelected() != this.oriSuggestIgnoreCaseFlag || this.showDescriptionCB.isSelected() != this.oriShowDescriptionFlag || this.newInlineBoxWidth != this.oriInlineBoxWidth || this.newCVWidthPercentage != this.oriCVWidthPercentage || this.annotationValuePrecedenceCB.isSelected() != this.oriAnnotationValuePrecedenceFlag;
    }

    public boolean validateInputs() {
        if (this.inlineWidthTF.getText() != null) {
            String widthText = this.inlineWidthTF.getText().trim();
            if (widthText.length() > 0) {
                try {
                    this.newInlineBoxWidth = Integer.parseInt(this.inlineWidthTF.getText().trim());
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("PreferencesDialog.Edit.InvalidInlineWidthValue"), ElanLocale.getString("Message.Warning"), 2);
                    this.focusValue(this.inlineWidthTF);
                    return false;
                }
            } else {
                this.newInlineBoxWidth = 0;
            }
        }
        if (this.showDescriptionCB.isSelected() && this.cvWidthPercentageTF.getText() != null) {
            try {
                this.newCVWidthPercentage = Integer.parseInt(this.cvWidthPercentageTF.getText().trim());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("PreferencesDialog.Edit.InvalidInlineCVWidthValue"), ElanLocale.getString("Message.Warning"), 2);
                this.focusValue(this.cvWidthPercentageTF);
                return false;
            }
        }
        return true;
    }

    public void focusValue(JTextField tf) {
        tf.requestFocus();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.showDescriptionCB) {
            this.cvWidthPercentageTF.setEnabled(this.showDescriptionCB.isSelected());
            if (this.showDescriptionCB.isSelected()) {
                this.cvWidthPercentageTF.requestFocus();
            }
        }
    }
}

