/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.prefs.gui.AbstractEditPrefsPanel;
import mpi.eudico.client.annotator.prefs.gui.RecentLanguagesBox;

public class EditingPanel
extends AbstractEditPrefsPanel
implements PreferenceEditor,
ChangeListener {
    private JCheckBox deselectCB;
    private JCheckBox enterCommitsCB;
    private JCheckBox clearSelectionCB;
    private JCheckBox clearSelectionOnSingleClickCB;
    private JCheckBox createDependAnnCB;
    private JCheckBox snapAnnCB;
    private JLabel snapAnnLabel;
    private JCheckBox stickToFramesCB;
    private JTextField snapAnnTextField;
    private JCheckBox editInCenterCB;
    private JLabel copyOptionLabel;
    private JComboBox copyOptionComboBox;
    private JCheckBox useCopyCurrentTimeFormatCB;
    private JLabel languageLabel;
    private RecentLanguagesBox cvLanguageBox;
    private boolean origDeselectFlag = true;
    private boolean origEnterFlag = true;
    private boolean origClearSelFlag = false;
    private boolean origClearSelOnSingleClickFlag = true;
    private boolean oriCreateDependAnnFlag = false;
    private boolean oriSnapAnnotationsFlag = false;
    private boolean oriStickToFramesFlag = false;
    private long oriSnapValue = 100L;
    private long newSnapValue;
    private boolean oriAnnInCenterFlag = true;
    private static String TEXTANDTIME = ElanLocale.getString("PreferencesDialog.Edit.CopyAll");
    private static String TEXT = ElanLocale.getString("PreferencesDialog.Edit.CopyTextOnly");
    private static String TEXT_CITE = ElanLocale.getString("PreferencesDialog.Edit.CopyCite");
    private Map<String, String> tcMap = new HashMap<String, String>(4);
    private int origCopyOptionIndex;
    private String oriCopyOption = "annotation + begintime + endtime";
    private boolean origUseCopyCurrentTimeFormat = false;
    private String oriLanguageValue;
    private String newLanguageValue;

    public EditingPanel() {
        super(ElanLocale.getString("PreferencesDialog.Category.Edit"));
        this.tcMap.put(TEXTANDTIME, "annotation + begintime + endtime");
        this.tcMap.put(TEXT, "annotation only");
        this.tcMap.put(TEXT_CITE, "filename + tiername + begintime + endtime");
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Long longPref;
        Boolean boolPref = Preferences.getBool("InlineEdit.DeselectCommits", null);
        if (boolPref != null) {
            this.origDeselectFlag = boolPref;
        }
        if ((boolPref = Preferences.getBool("InlineEdit.EnterCommits", null)) != null) {
            this.origEnterFlag = boolPref;
        }
        if ((boolPref = Preferences.getBool("ClearSelectionAfterCreation", null)) != null) {
            this.origClearSelFlag = boolPref;
        }
        if ((boolPref = Preferences.getBool("ClearSelectionOnSingleClick", null)) != null) {
            this.origClearSelOnSingleClickFlag = boolPref;
        }
        if ((boolPref = Preferences.getBool("CreateDependingAnnotations", null)) != null) {
            this.oriCreateDependAnnFlag = boolPref;
        }
        if ((boolPref = Preferences.getBool("SnapAnnotations", null)) != null) {
            this.oriSnapAnnotationsFlag = boolPref;
        }
        if ((longPref = Preferences.getLong("SnapAnnotationsValue", null)) != null) {
            this.oriSnapValue = longPref;
        }
        this.newSnapValue = this.oriSnapValue;
        String stringPref = Preferences.getString("DefaultControlledVocabularyLanguage", null);
        if (stringPref != null) {
            this.oriLanguageValue = stringPref;
        }
        this.newLanguageValue = this.oriLanguageValue;
        boolPref = Preferences.getBool("StickAnnotationsWithVideoFrames", null);
        if (boolPref != null) {
            this.oriStickToFramesFlag = boolPref;
        }
        if ((boolPref = Preferences.getBool("EditingPanel.ActiveAnnotationInCenter", null)) != null) {
            this.oriAnnInCenterFlag = boolPref;
        }
        if ((stringPref = Preferences.getString("EditingPanel.CopyOption", null)) != null) {
            if (this.tcMap.containsKey(stringPref)) {
                this.oriCopyOption = this.tcMap.get(stringPref);
            } else if (this.tcMap.values().contains(stringPref)) {
                this.oriCopyOption = stringPref;
            }
        }
        if ((boolPref = Preferences.getBool("CopyAnnotation.UseCopyCurrentTimeFormat", null)) != null) {
            this.origUseCopyCurrentTimeFormat = boolPref;
        }
    }

    private void initComponents() {
        this.deselectCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.Deselect"), this.origDeselectFlag);
        this.enterCommitsCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.EnterCommits"), this.origEnterFlag);
        this.clearSelectionCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.ClearSelection"), this.origClearSelFlag);
        this.clearSelectionOnSingleClickCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.ClearSelectionOnSingleClick"), this.origClearSelOnSingleClickFlag);
        this.createDependAnnCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.CreateDependAnn"), this.oriCreateDependAnnFlag);
        this.snapAnnCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SnapAnnotations"), this.oriSnapAnnotationsFlag);
        this.snapAnnCB.addChangeListener(this);
        this.snapAnnLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Edit.SnapAnnotations.Label"));
        this.snapAnnTextField = new JTextField(Long.toString(this.oriSnapValue), 8);
        this.snapAnnTextField.setEnabled(this.oriSnapAnnotationsFlag);
        this.stickToFramesCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.StickToVideoFrames"), this.oriStickToFramesFlag);
        this.editInCenterCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.ActiveAnnotationInCenter"), this.oriAnnInCenterFlag);
        this.languageLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Edit.DefaultCVLanguage.Label"));
        this.cvLanguageBox = new RecentLanguagesBox(this.oriLanguageValue);
        this.deselectCB.setFont(this.deselectCB.getFont().deriveFont(0));
        this.enterCommitsCB.setFont(this.deselectCB.getFont());
        this.clearSelectionCB.setFont(this.deselectCB.getFont());
        this.clearSelectionOnSingleClickCB.setFont(this.deselectCB.getFont());
        this.createDependAnnCB.setFont(this.deselectCB.getFont());
        this.snapAnnCB.setFont(this.deselectCB.getFont());
        this.snapAnnLabel.setFont(this.deselectCB.getFont());
        this.snapAnnTextField.setFont(this.deselectCB.getFont());
        this.stickToFramesCB.setFont(this.deselectCB.getFont());
        this.editInCenterCB.setFont(this.deselectCB.getFont());
        this.copyOptionLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Edit.CopyOptionLabel"));
        this.copyOptionLabel.setFont(this.deselectCB.getFont());
        this.copyOptionComboBox = new JComboBox();
        this.copyOptionComboBox.addItem(TEXTANDTIME);
        this.copyOptionComboBox.addItem(TEXT);
        this.copyOptionComboBox.addItem(TEXT_CITE);
        boolean prefRestored = false;
        Iterator<String> tcIt = this.tcMap.keySet().iterator();
        String tcConst = null;
        while (tcIt.hasNext()) {
            String key = tcIt.next();
            tcConst = this.tcMap.get(key);
            if (!tcConst.equals(this.oriCopyOption)) continue;
            this.copyOptionComboBox.setSelectedItem(key);
            prefRestored = true;
            break;
        }
        if (!prefRestored) {
            this.copyOptionComboBox.setSelectedItem(TEXTANDTIME);
        }
        this.origCopyOptionIndex = this.copyOptionComboBox.getSelectedIndex();
        this.copyOptionComboBox.setSelectedItem(this.oriCopyOption);
        this.copyOptionComboBox.setFont(this.deselectCB.getFont());
        this.useCopyCurrentTimeFormatCB = new JCheckBox(String.format(ElanLocale.getString("PreferencesDialog.Edit.CopyTimeFormatLabel"), ElanLocale.getString("CommandActions.CopyCurrentTime")), this.origUseCopyCurrentTimeFormat);
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel snapPanel = new JPanel(new GridBagLayout());
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.fill = 0;
        gbc.insets = this.topInset;
        snapPanel.add((Component)this.snapAnnLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets = this.leftInset;
        snapPanel.add((Component)this.snapAnnTextField, gbc);
        JPanel copyPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets = this.topInset;
        copyPanel.add((Component)this.copyOptionLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.leftInset;
        copyPanel.add((Component)this.copyOptionComboBox, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        copyPanel.add((Component)new JPanel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = this.globalPanelInset;
        gbc.gridwidth = 2;
        copyPanel.add((Component)this.useCopyCurrentTimeFormatCB, gbc);
        JPanel languagePanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets = this.topInset;
        languagePanel.add((Component)this.languageLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.leftInset;
        languagePanel.add((Component)this.cvLanguageBox, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        languagePanel.add((Component)new JPanel(), gbc);
        int gy = 0;
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = this.globalInset;
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.deselectCB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.enterCommitsCB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.clearSelectionCB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.clearSelectionOnSingleClickCB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.createDependAnnCB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.stickToFramesCB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.snapAnnCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.singleTabInset;
        this.outerPanel.add((Component)snapPanel, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.editInCenterCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalPanelInset;
        this.outerPanel.add((Component)copyPanel, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalPanelInset;
        this.outerPanel.add((Component)languagePanel, gbc);
        gbc.gridy = gy++;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.outerPanel.add((Component)new JPanel(), gbc);
    }

    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(3);
            if (this.deselectCB.isSelected() != this.origDeselectFlag) {
                chMap.put("InlineEdit.DeselectCommits", this.deselectCB.isSelected());
            }
            if (this.enterCommitsCB.isSelected() != this.origEnterFlag) {
                chMap.put("InlineEdit.EnterCommits", this.enterCommitsCB.isSelected());
            }
            if (this.clearSelectionCB.isSelected() != this.origClearSelFlag) {
                chMap.put("ClearSelectionAfterCreation", this.clearSelectionCB.isSelected());
            }
            if (this.clearSelectionOnSingleClickCB.isSelected() != this.origClearSelOnSingleClickFlag) {
                chMap.put("ClearSelectionOnSingleClick", this.clearSelectionOnSingleClickCB.isSelected());
            }
            if (this.createDependAnnCB.isSelected() != this.oriCreateDependAnnFlag) {
                chMap.put("CreateDependingAnnotations", this.createDependAnnCB.isSelected());
            }
            if (this.snapAnnCB.isSelected() != this.oriSnapAnnotationsFlag) {
                chMap.put("SnapAnnotations", this.snapAnnCB.isSelected());
            }
            if (this.snapAnnCB.isSelected()) {
                chMap.put("SnapAnnotationsValue", this.newSnapValue);
            }
            if (!this.cvLanguageBox.getLongId().equals(this.oriLanguageValue)) {
                this.newLanguageValue = this.cvLanguageBox.getLongId();
                chMap.put("DefaultControlledVocabularyLanguage", this.newLanguageValue);
                Preferences.updateAllCVLanguages(this.newLanguageValue, false);
            }
            if (this.stickToFramesCB.isSelected() != this.oriStickToFramesFlag) {
                chMap.put("StickAnnotationsWithVideoFrames", this.stickToFramesCB.isSelected());
            }
            if (this.editInCenterCB.isSelected() != this.oriAnnInCenterFlag) {
                chMap.put("EditingPanel.ActiveAnnotationInCenter", this.editInCenterCB.isSelected());
            }
            String string = this.copyOptionComboBox.getSelectedItem().toString();
            String nonLocaleString = "annotation + begintime + endtime";
            nonLocaleString = this.tcMap.get(string);
            if (!nonLocaleString.equals(this.oriCopyOption)) {
                chMap.put("EditingPanel.CopyOption", nonLocaleString);
            }
            if (!this.useCopyCurrentTimeFormatCB.isSelected() == this.origUseCopyCurrentTimeFormat) {
                chMap.put("CopyAnnotation.UseCopyCurrentTimeFormat", this.useCopyCurrentTimeFormatCB.isSelected());
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        return this.deselectCB.isSelected() != this.origDeselectFlag || this.enterCommitsCB.isSelected() != this.origEnterFlag || this.clearSelectionCB.isSelected() != this.origClearSelFlag || this.clearSelectionOnSingleClickCB.isSelected() != this.origClearSelOnSingleClickFlag || this.createDependAnnCB.isSelected() != this.oriCreateDependAnnFlag || this.snapAnnCB.isSelected() != this.oriSnapAnnotationsFlag || this.newSnapValue != this.oriSnapValue || this.stickToFramesCB.isSelected() != this.oriStickToFramesFlag || !this.cvLanguageBox.getLongId().equals(this.oriLanguageValue) || this.editInCenterCB.isSelected() != this.oriAnnInCenterFlag || this.origCopyOptionIndex != this.copyOptionComboBox.getSelectedIndex() || this.useCopyCurrentTimeFormatCB.isSelected() != this.origUseCopyCurrentTimeFormat;
    }

    public boolean validateInputs() {
        if (this.snapAnnCB.isSelected() && this.snapAnnTextField.getText() != null) {
            try {
                this.newSnapValue = Long.parseLong(this.snapAnnTextField.getText().trim());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("PreferencesDialog.Edit.InvalidSnapValue"), ElanLocale.getString("Message.Warning"), 2);
                this.focusValue(this.snapAnnTextField);
                return false;
            }
        }
        return true;
    }

    public void focusValue(JTextField tf) {
        tf.requestFocus();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.snapAnnCB) {
            this.snapAnnTextField.setEnabled(this.snapAnnCB.isSelected());
            if (this.snapAnnCB.isSelected()) {
                this.snapAnnTextField.requestFocus();
            }
        }
    }
}

