/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.gui.MenuScroller;
import mpi.eudico.client.annotator.prefs.RecentLanguagesPrefs;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.RecentLanguageListener;
import mpi.eudico.util.multilangcv.RecentLanguages;

public class RecentLanguagesMenuItem
extends JMenu
implements ActionListener,
PreferencesListener,
RecentLanguageListener,
ElanLocaleListener {
    private String origLanguageValue;
    private ButtonGroup group;
    private boolean ignorePrefChanges = false;

    public RecentLanguagesMenuItem() {
        String stringPref = Preferences.getString("DefaultControlledVocabularyLanguage", null);
        this.origLanguageValue = stringPref != null ? stringPref : "";
        MenuScroller.setScrollerFor(this, 20, 100);
        RecentLanguagesPrefs.getInstance();
        this.group = new ButtonGroup();
        for (LangInfo li : RecentLanguages.getInstance().getRecentLanguages()) {
            this.addLanguageMenuItem(li);
        }
        Preferences.addPreferencesListener(null, this);
        RecentLanguages.getInstance().addRecentLanguageListener(this);
        ElanLocale.addElanLocaleListener(null, this);
    }

    public void isClosing() {
        RecentLanguages.getInstance().removeRecentLanguageListener(this);
        Preferences.removePreferencesListener(null, this);
        ElanLocale.removeElanLocaleListener(this);
    }

    private void addLanguageMenuItem(LangInfo li) {
        String itemString = li.getLabel() + " - " + li.getId();
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(itemString);
        String longId = li.getLongId();
        item.setActionCommand(longId);
        if (longId.equals(this.origLanguageValue)) {
            item.setSelected(true);
        }
        item.addActionListener(this);
        this.group.add(item);
        this.add(item);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String newLanguage = e.getActionCommand();
        if (newLanguage.equals(this.origLanguageValue)) {
            return;
        }
        this.ignorePrefChanges = true;
        Preferences.set("DefaultControlledVocabularyLanguage", newLanguage, null, true);
        Preferences.updateAllCVLanguages(newLanguage, false);
        this.origLanguageValue = newLanguage;
        this.ignorePrefChanges = false;
    }

    @Override
    public void preferencesChanged() {
        if (this.ignorePrefChanges) {
            return;
        }
        String val = Preferences.getString("DefaultControlledVocabularyLanguage", null);
        String languageValue = val != null ? val : "";
        if (languageValue.equals(this.origLanguageValue)) {
            return;
        }
        this.origLanguageValue = languageValue;
        this.group.clearSelection();
        Enumeration<AbstractButton> e = this.group.getElements();
        while (e.hasMoreElements()) {
            AbstractButton ab = e.nextElement();
            if (!languageValue.equals(ab.getActionCommand())) continue;
            ab.setSelected(true);
            break;
        }
    }

    @Override
    public void recentLanguageAdded(int index, LangInfo langInfo) {
        if (index < this.getItemCount()) {
            this.getItem(index).setText(langInfo.getLabel() + " - " + langInfo.getId());
        } else {
            this.addLanguageMenuItem(langInfo);
        }
    }

    @Override
    public void recentLanguageChanged(int index, LangInfo langInfo) {
        if (index >= 0 && index < this.getItemCount()) {
            if (langInfo == null) {
                this.group.remove(this.getItem(index));
                this.remove(index);
            } else {
                this.getItem(index).setText(langInfo.getLabel() + " - " + langInfo.getId());
            }
        }
    }

    @Override
    public void updateLocale() {
        this.setText(ElanLocale.getString("PreferencesDialog.Edit.DefaultCVLanguage.Menu"));
    }
}

