/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.data;

import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import mpi.eudico.client.annotator.recognizer.data.Boundary;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;

public class BoundarySegmentation {
    private static long INFINITY = Long.MAX_VALUE;
    private TreeSet<Boundary> boundaries = new TreeSet();

    public BoundarySegmentation(Segmentation segmentation) {
        ArrayList<RSelection> segments = segmentation.getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            Segment segment = (Segment)segments.get(i);
            Boundary begin = new Boundary(segment.beginTime, segment.label);
            this.boundaries.remove(begin);
            this.boundaries.add(begin);
            Boundary end = new Boundary(segment.endTime, "");
            this.boundaries.add(end);
        }
    }

    public long boundaryTimeBefore(long time) {
        Boundary bound = new Boundary(time, "");
        SortedSet<Boundary> head = this.boundaries.headSet(bound);
        if (head.size() > 0) {
            return head.last().time;
        }
        return 0L;
    }

    public long boundaryTimeAfter(long time) {
        Boundary bound = new Boundary(time, "");
        SortedSet<Boundary> tail = this.boundaries.tailSet(bound);
        if (tail.size() > 0) {
            return tail.first().time;
        }
        return INFINITY;
    }

    public Boundary boundaryBetween(long beginTime, long endTime) {
        if (beginTime >= endTime) {
            return null;
        }
        Boundary from = new Boundary(beginTime, "");
        Boundary to = new Boundary(endTime, "");
        SortedSet<Boundary> sub = this.boundaries.subSet(from, to);
        if (sub.size() == 0) {
            return null;
        }
        return sub.last();
    }
}

