/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.SegmentsToTiersCommand;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.CompoundIcon;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.HTMLViewer;
import mpi.eudico.client.annotator.recognizer.api.LocalRecognizer;
import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;
import mpi.eudico.client.annotator.recognizer.api.RecogAvailabilityDetector;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerConfigurationException;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.api.SharedRecognizer;
import mpi.eudico.client.annotator.recognizer.data.AudioSegment;
import mpi.eudico.client.annotator.recognizer.data.BoundarySegmentation;
import mpi.eudico.client.annotator.recognizer.data.MediaDescriptor;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.gui.AbstractParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.FileParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.LoadOutputPane;
import mpi.eudico.client.annotator.recognizer.gui.ParamDialog;
import mpi.eudico.client.annotator.recognizer.gui.ParamPanelContainer;
import mpi.eudico.client.annotator.recognizer.gui.TierSelectionPanel;
import mpi.eudico.client.annotator.recognizer.io.CsvTierIO;
import mpi.eudico.client.annotator.recognizer.io.CsvTimeSeriesIO;
import mpi.eudico.client.annotator.recognizer.io.ParamIO;
import mpi.eudico.client.annotator.recognizer.io.RecTierWriter;
import mpi.eudico.client.annotator.recognizer.io.XmlTierIO;
import mpi.eudico.client.annotator.recognizer.io.XmlTimeSeriesReader;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.client.util.SelectableObject;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import nl.mpi.util.FileExtension;
import nl.mpi.util.FileUtility;
import org.xml.sax.SAXException;

public abstract class AbstractRecognizerPanel
extends JComponent
implements ActionListener,
Runnable,
RecognizerHost,
ElanLocaleListener,
ItemListener,
ACMEditListener {
    protected ViewerManager2 viewerManager;
    protected JPanel controlPanel;
    protected JPanel progressPanel;
    protected JPanel recognizerAndFilesPanel;
    protected JPanel paramPanel;
    protected JScrollPane jsp;
    protected JButton detachButton;
    protected List<List<String>> mediaFilePaths;
    protected List<List<String>> supportedMediaFiles;
    protected JLabel recognizerLabel;
    protected JComboBox recognizerList;
    protected Map<String, Recognizer> recognizers;
    protected Recognizer currentRecognizer;
    protected Map<String, Segmentation> segmentations;
    protected JProgressBar progressBar;
    protected JButton startStopButton;
    protected JButton reportButton;
    protected JButton createSegButton;
    protected JPanel paramButtonPanel;
    protected JButton saveParamsButton;
    protected JButton loadParamsButton;
    protected JButton helpButton;
    protected JButton configureButton;
    protected boolean isRunning;
    protected boolean notMono;
    protected boolean reduceFilePrompt = true;
    protected long lastStartTime = 0L;
    protected Timer elapseTimer;
    protected StringBuilder progressReport;
    protected boolean needToPollProgressReport;
    protected Method getReport;
    private boolean detached = false;
    private ParamDialog detachedDialog;
    private Map<String, TierSelectionPanel> selPanelMap;
    private JTextArea progressReportTextArea;
    private ImageIcon soundIcon;
    private ImageIcon movieIcon;
    private ImageIcon otherIcon;
    private Map<String, Icon> recognizerIcon;
    static Color secondColor = new Color(234, 245, 245);

    public AbstractRecognizerPanel(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
        this.viewerManager.connectListener(this);
        this.mediaFilePaths = new ArrayList<List<String>>(3);
        this.supportedMediaFiles = new ArrayList<List<String>>(3);
        for (int i = 0; i < 3; ++i) {
            this.mediaFilePaths.add(new ArrayList());
            this.supportedMediaFiles.add(new ArrayList());
        }
        this.segmentations = new HashMap<String, Segmentation>();
        this.selPanelMap = new HashMap<String, TierSelectionPanel>();
        this.initComponents();
        this.initRecognizers();
    }

    protected void initComponents() {
        ImageIcon openIcon;
        ImageIcon icon;
        Boolean boolPref = Preferences.getBool("Recognizer.ReduceFilePrompts", null);
        if (boolPref != null) {
            this.reduceFilePrompt = boolPref;
        }
        this.setLayout(new GridBagLayout());
        this.recognizerLabel = new JLabel();
        this.recognizerList = new JComboBox();
        this.recognizerAndFilesPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 2, 0, 0);
        gbc.anchor = 17;
        this.recognizerAndFilesPanel.add((Component)this.recognizerLabel, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.recognizerAndFilesPanel.add((Component)this.recognizerList, gbc);
        JPanel progPanel = new JPanel();
        progPanel.setLayout(new BoxLayout(progPanel, 0));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        progPanel.add(Box.createHorizontalStrut(10));
        progPanel.add(this.progressBar);
        progPanel.add(Box.createHorizontalStrut(10));
        this.startStopButton = new JButton(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
        this.startStopButton.addActionListener(this);
        progPanel.add(this.startStopButton);
        this.reportButton = new JButton();
        this.reportButton.addActionListener(this);
        this.reportButton.setEnabled(false);
        progPanel.add(Box.createHorizontalStrut(15));
        progPanel.add(this.reportButton);
        this.createSegButton = new JButton();
        this.createSegButton.addActionListener(this);
        this.createSegButton.setEnabled(false);
        progPanel.add(Box.createHorizontalStrut(15));
        progPanel.add(this.createSegButton);
        this.progressPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.progressPanel.add((Component)progPanel, gbc);
        this.elapseTimer = new Timer();
        this.progressReport = new StringBuilder();
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.progressPanel.add((Component)this.elapseTimer.getTimerPanel(), gbc);
        this.paramPanel = new JPanel(new GridBagLayout());
        this.paramButtonPanel = new JPanel(new GridBagLayout());
        this.saveParamsButton = new JButton();
        this.saveParamsButton.addActionListener(this);
        try {
            icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif"));
            this.saveParamsButton.setIcon(icon);
        }
        catch (Exception ex) {
            this.saveParamsButton.setText("S");
        }
        this.loadParamsButton = new JButton();
        this.loadParamsButton.addActionListener(this);
        try {
            openIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif"));
            this.loadParamsButton.setIcon(openIcon);
        }
        catch (Exception ex) {
            this.loadParamsButton.setText("L");
        }
        this.detachButton = new JButton();
        this.detachButton.addActionListener(this);
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Detach.gif"));
            this.detachButton.setIcon(icon);
        }
        catch (Exception ex) {
            this.detachButton.setText("D");
        }
        this.configureButton = new JButton();
        this.configureButton.addActionListener(this);
        try {
            openIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Configure16.gif"));
            this.configureButton.setIcon(openIcon);
        }
        catch (Exception ex) {
            this.configureButton.setText("C");
        }
        this.helpButton = new JButton();
        this.helpButton.addActionListener(this);
        try {
            icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Help16.gif"));
            this.helpButton.setIcon(icon);
        }
        catch (Exception ex) {
            this.helpButton.setText("H");
        }
        gbc = new GridBagConstraints();
        gbc.anchor = 12;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.paramButtonPanel.add((Component)this.loadParamsButton, gbc);
        gbc.gridx = 1;
        this.paramButtonPanel.add((Component)this.saveParamsButton, gbc);
        gbc.gridx = 2;
        gbc.insets = new Insets(0, 10, 0, 2);
        this.paramButtonPanel.add((Component)this.detachButton, gbc);
        gbc.gridx = 3;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.paramButtonPanel.add((Component)this.configureButton, gbc);
        gbc.gridx = 4;
        this.paramButtonPanel.add((Component)this.helpButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        this.add((Component)this.recognizerAndFilesPanel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.paramPanel, gbc);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.progressPanel, gbc);
    }

    protected void initRecognizers() {
        Map<String, Recognizer> audio = RecogAvailabilityDetector.getAudioRecognizers();
        Map<String, Recognizer> video = RecogAvailabilityDetector.getVideoRecognizers();
        Map<String, Recognizer> other = RecogAvailabilityDetector.getOtherRecognizers();
        this.recognizers = new HashMap<String, Recognizer>(audio.size() + video.size() + other.size());
        this.recognizers.putAll(audio);
        this.recognizers.putAll(video);
        this.recognizers.putAll(other);
        if (this.currentRecognizer != null) {
            this.paramPanel.removeAll();
            this.currentRecognizer = null;
        }
        try {
            this.soundIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Notes16.gif"));
            this.movieIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/Movie16.gif"));
            this.otherIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Zoom16.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.recognizerList.removeItemListener(this);
        this.recognizerList.removeAllItems();
        this.recognizerIcon = new HashMap<String, Icon>(this.recognizers.size());
        this.recognizerList.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    Icon icon = (Icon)AbstractRecognizerPanel.this.recognizerIcon.get(value);
                    label.setIcon(icon);
                }
                return c;
            }
        });
        this.fillRecognizerList(audio, this.soundIcon);
        this.fillRecognizerList(video, this.movieIcon);
        this.fillRecognizerList(other, this.otherIcon);
        this.recognizerList.setSelectedIndex(-1);
        if (this.recognizerList.getItemCount() == 0) {
            this.recognizerList.addItem(ElanLocale.getString("Recognizer.RecognizerPanel.No.Recognizers"));
            this.jsp = new JScrollPane(this.getParamPanel(null));
            this.jsp.setBackground(this.getBackground());
            this.jsp.getViewport().setBackground(this.getBackground());
            this.jsp.getVerticalScrollBar().setUnitIncrement(20);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.paramPanel.add((Component)this.jsp, gbc);
            this.startStopButton.setEnabled(false);
            this.recognizerList.setEnabled(false);
            this.createSegButton.setEnabled(false);
            this.paramButtonPanel.setVisible(false);
        } else {
            String lastActiveRecognizer = Preferences.getString("ActiveRecognizerName", this.viewerManager.getTranscription());
            if (lastActiveRecognizer != null && this.recognizers.containsKey(lastActiveRecognizer)) {
                this.recognizerList.setSelectedItem(lastActiveRecognizer);
                this.setRecognizer(lastActiveRecognizer);
            } else if (this.recognizerList.getSelectedIndex() < 0 && this.recognizerList.getModel().getSize() > 0) {
                this.recognizerList.setSelectedIndex(0);
                this.setRecognizer((String)this.recognizerList.getSelectedItem());
                this.recognizerList.setEnabled(true);
            }
        }
        this.recognizerList.addItemListener(this);
    }

    private void fillRecognizerList(Map<String, Recognizer> toAdd, Icon typeIcon) {
        if (!toAdd.isEmpty()) {
            ArrayList<String> recognizers = new ArrayList<String>(toAdd.keySet());
            Collections.sort(recognizers);
            for (String name : recognizers) {
                this.recognizerList.addItem(name);
                Icon recogIcon = typeIcon;
                URL iconRef = RecogAvailabilityDetector.getIconURL(name);
                if (iconRef != null) {
                    ImageIcon icon2 = new ImageIcon(iconRef);
                    recogIcon = new CompoundIcon(typeIcon, icon2);
                }
                this.recognizerIcon.put(name, recogIcon);
            }
        }
    }

    protected Map<String, Recognizer> getAvailableRecognizers() {
        return this.recognizers;
    }

    protected void updateSupportedFiles() {
        for (int i = 0; i < this.mediaFilePaths.size(); ++i) {
            List<String> smfL = this.supportedMediaFiles.get(i);
            smfL.clear();
            for (String mediaFilePath : this.mediaFilePaths.get(i)) {
                if (!this.currentRecognizer.canHandleMedia(mediaFilePath)) continue;
                smfL.add(mediaFilePath);
            }
        }
    }

    public void isClosing() {
        if (this.currentRecognizer != null) {
            Map<String, Object> prefs;
            if (this.controlPanel instanceof ParamPreferences && (prefs = ((ParamPreferences)((Object)this.controlPanel)).getParamPreferences()) != null) {
                Preferences.set(this.currentRecognizer.getName(), prefs, this.viewerManager.getTranscription(), false, false);
            }
            Preferences.set("ActiveRecognizerName", this.currentRecognizer.getName(), this.viewerManager.getTranscription(), false, false);
            Preferences.set("Recognizer.ReduceFilePrompts", this.reduceFilePrompt, null, false, false);
        }
    }

    protected void setRecognizer(String name) {
        if (this.currentRecognizer != null) {
            Map<String, Object> prefs;
            if (this.currentRecognizer.getName().equals(name)) {
                return;
            }
            if (this.controlPanel instanceof ParamPreferences && (prefs = ((ParamPreferences)((Object)this.controlPanel)).getParamPreferences()) != null) {
                Preferences.set(this.currentRecognizer.getName(), ((ParamPreferences)((Object)this.controlPanel)).getParamPreferences(), this.viewerManager.getTranscription());
            }
            this.currentRecognizer.dispose();
            this.paramPanel.removeAll();
            this.segmentations.clear();
            this.createSegButton.setEnabled(false);
        }
        this.selPanelMap.clear();
        this.elapseTimer.resetTimer();
        this.currentRecognizer = this.recognizers.get(name);
        this.checkForOldRecognizerInterface();
        this.currentRecognizer.setRecognizerHost(this);
        this.setRecognizerResourceBundle();
        this.updateSupportedFiles();
        int mode = this.currentRecognizer.getRecognizerType();
        this.currentRecognizer.setMedia(this.supportedMediaFiles.get(mode));
        this.controlPanel = this.currentRecognizer.getControlPanel();
        if (this.controlPanel == null) {
            this.controlPanel = this.getParamPanel(this.currentRecognizer);
        }
        if (this.controlPanel != null) {
            this.jsp = new JScrollPane(this.controlPanel);
            this.jsp.getVerticalScrollBar().setUnitIncrement(20);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.paramPanel.add((Component)this.jsp, gbc);
            gbc.gridy = 1;
            gbc.anchor = 12;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this.paramPanel.add((Component)this.paramButtonPanel, gbc);
        } else {
            this.jsp = null;
            this.paramPanel.add((Component)new JLabel(ElanLocale.getString("Recognizer.RecognizerPanel.No.Parameters")), new GridBagConstraints());
            this.paramPanel.repaint();
        }
        if (this.controlPanel instanceof ParamPreferences) {
            Map<String, Object> prefs = Preferences.getMap(this.currentRecognizer.getName(), this.viewerManager.getTranscription());
            if (prefs != null) {
                ((ParamPreferences)((Object)this.controlPanel)).setParamPreferences(prefs);
            }
            this.loadParamsButton.setEnabled(true);
            this.saveParamsButton.setEnabled(true);
        } else {
            this.loadParamsButton.setEnabled(false);
            this.saveParamsButton.setEnabled(false);
        }
        if (RecogAvailabilityDetector.getHelpFile(this.currentRecognizer.getName()) == null) {
            this.helpButton.setEnabled(false);
        } else {
            this.helpButton.setEnabled(true);
        }
        this.progressBar.setString("");
        this.progressBar.setValue(0);
        this.validate();
    }

    protected void checkForOldRecognizerInterface() {
        this.needToPollProgressReport = false;
        this.getReport = null;
        try {
            this.getReport = this.currentRecognizer.getClass().getMethod("getReport", new Class[0]);
            this.needToPollProgressReport = this.getReport != null;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected JPanel getParamPanel(Recognizer recognizer) {
        List<Param> params;
        if (recognizer != null && (params = RecogAvailabilityDetector.getParamList(recognizer.getName())) != null) {
            int mode = recognizer.getRecognizerType();
            ParamPanelContainer ppc = new ParamPanelContainer(recognizer.getName(), params, this, this.viewerManager, mode);
            this.startStopButton.setEnabled(ppc.checkStartReg());
            ppc.validate();
            return ppc;
        }
        return null;
    }

    protected void updateMediaFiles() {
        if (this.currentRecognizer == null) {
            return;
        }
        this.updateSupportedFiles();
        int mode = this.currentRecognizer.getRecognizerType();
        List<String> smf = this.supportedMediaFiles.get(mode);
        if (this.controlPanel instanceof ParamPanelContainer) {
            ((ParamPanelContainer)this.controlPanel).updateMediaFiles(smf);
            this.startStopButton.setEnabled(((ParamPanelContainer)this.controlPanel).checkStartReg());
        } else if (smf.isEmpty()) {
            this.startStopButton.setEnabled(false);
        } else {
            this.startStopButton.setEnabled(true);
        }
        for (TierSelectionPanel panel : this.selPanelMap.values()) {
            if (panel == null) continue;
            panel.updateMediaFiles(smf);
        }
        if (this.currentRecognizer != null) {
            this.currentRecognizer.setMedia(smf);
        }
    }

    protected void updateTiers(int event) {
        if (this.currentRecognizer == null) {
            return;
        }
        if (this.controlPanel instanceof ParamPanelContainer) {
            ((ParamPanelContainer)this.controlPanel).updateTiers(event);
        } else {
            for (TierSelectionPanel panel : this.selPanelMap.values()) {
                if (panel == null) continue;
                panel.updateTierNames(event);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.recognizerList && e.getStateChange() == 1) {
            String selectedItem = (String)this.recognizerList.getSelectedItem();
            if (this.currentRecognizer != null && this.isBusy()) {
                JOptionPane.showMessageDialog(this, this.currentRecognizer.getName() + ": " + ElanLocale.getString("Recognizer.RecognizerPanel.Warning.Busy"), this.currentRecognizer.getName() + " " + ElanLocale.getString("Recognizer.RecognizerPanel.Warning.Busy2"), -1);
                this.recognizerList.setSelectedItem(this.currentRecognizer.getName());
                return;
            }
            if (this.detached) {
                this.detachedDialog.dispose();
            }
            this.segmentations.clear();
            this.paramPanel.removeAll();
            this.setRecognizer(selectedItem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.startStopButton)) {
            if (this.currentRecognizer == null) {
                return;
            }
            if (this.isRunning) {
                this.startStopButton.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
                this.stopRecognizers();
                if (this.progressBar.isIndeterminate()) {
                    this.progressBar.setIndeterminate(false);
                }
                this.progressBar.setString(ElanLocale.getString("Recognizer.RecognizerPanel.Canceled"));
                this.progressBar.setValue(0);
            } else {
                SignalViewer signalViewer;
                if (this.currentRecognizer.getRecognizerType() == 0 && (signalViewer = this.viewerManager.getSignalViewer()) != null) {
                    signalViewer.setSegmentationChannel1(null);
                    signalViewer.setSegmentationChannel2(null);
                }
                this.startRecognizer();
            }
        } else if (source == this.reportButton) {
            if (this.currentRecognizer != null) {
                this.showReport();
            }
        } else if (source == this.configureButton) {
            this.showConfigureDialog();
        } else if (source == this.saveParamsButton) {
            this.saveParameterFile();
        } else if (source == this.loadParamsButton) {
            this.loadParameterFile();
        } else if (source == this.detachButton) {
            this.detachParamPanel();
        } else if (source == this.helpButton) {
            this.showHelpDialog();
        } else if (source == this.createSegButton) {
            if (this.isBusy()) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("SegmentsToTierDialog.Warning.Busy"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            List<Segmentation> segments = this.getSegmentations();
            if (segments == null || segments.size() == 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("SegmentsToTierDialog.Warning.NoSegmentation"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            Command cc = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), "Seg2TierDlg");
            cc.execute(this.viewerManager.getTranscription(), new Object[]{segments});
        }
    }

    protected void startRecognizer() {
        if (this.isRunning) {
            return;
        }
        this.progressReport = new StringBuilder();
        if (this.controlPanel instanceof ParamPanelContainer) {
            Object value;
            AbstractParamPanel app;
            ArrayList<FileParamPanel> inputFPPS = new ArrayList<FileParamPanel>();
            ArrayList<FileParamPanel> outputFPPS = new ArrayList<FileParamPanel>();
            ParamPanelContainer ppc = (ParamPanelContainer)this.controlPanel;
            int numPanels = ppc.getNumPanels();
            int notFilled = 0;
            for (int i = 0; i < numPanels; ++i) {
                app = ppc.getParamPanel(i);
                if (!(app instanceof FileParamPanel) || ((FileParamPanel)app).isOptional()) continue;
                FileParamPanel ffp = (FileParamPanel)app;
                if (ffp.isInputType()) {
                    if (!ffp.isValueFilled()) {
                        ++notFilled;
                    }
                    inputFPPS.add(ffp);
                    continue;
                }
                outputFPPS.add(ffp);
            }
            if (notFilled > 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.EmptyReqdParam"), ElanLocale.getString("Recognizer.RecognizerPanel.Warning.EmptyParam"), 0);
                return;
            }
            for (FileParamPanel panel : inputFPPS) {
                value = panel.getParamValue();
                String file = null;
                if (value instanceof Map) {
                    Map map = (Map)value;
                    if (map.containsKey("Selections")) {
                        value = map.get("Selections");
                    } else if (map.containsKey("Tier")) {
                        value = map.get("Tier");
                    } else if (map.containsKey("FileName")) {
                        value = map.get("FileName");
                    }
                }
                if (value instanceof List) {
                    file = this.writeAndGetTierOrSelectionFile(panel, (List)value);
                } else if (value instanceof String) {
                    File tf = new File((String)value);
                    if (tf != null && tf.exists()) {
                        file = value.toString();
                    } else {
                        JOptionPane.showMessageDialog(this, value.toString() + " file not found.", ElanLocale.getString("Recognizer.RecognizerPanel.Warning.InValidParam"), 0);
                        return;
                    }
                }
                if (file != null && file.length() > 0) {
                    this.currentRecognizer.setParameterValue(panel.getParamName(), file);
                    continue;
                }
                return;
            }
            for (FileParamPanel panel : outputFPPS) {
                String val = (String)panel.getParamValue();
                if (val == null || val.length() == 0) {
                    if (this.reduceFilePrompt) {
                        int mode = this.currentRecognizer.getRecognizerType();
                        val = this.autoCreateOutputFile(this.mediaFilePaths.get(mode), panel.getParamName(), panel.getContentType());
                    } else {
                        FileChooser chooser = new FileChooser(this);
                        List<String[]> extensions = panel.getFileTypeExtension();
                        String[] mainFilterExt = null;
                        if (extensions != null && extensions.size() > 0) {
                            mainFilterExt = extensions.get(0);
                        }
                        chooser.createAndShowFileDialog(null, 1, extensions, mainFilterExt, "Recognizer.Path", null);
                        val = chooser.getSelectedFile().getAbsolutePath();
                    }
                    if (val == null || val.length() == 0) {
                        JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.EmptyParam") + " \"" + panel.description + "\" " + ElanLocale.getString("Recognizer.RecognizerPanel.Warning.EmptyParam2"), ElanLocale.getString("Recognizer.RecognizerPanel.Warning.EmptyParam"), 0);
                        return;
                    }
                    panel.setParamValue(val);
                } else {
                    this.createOutputFile(val);
                }
                if (val != null && val.length() > 0) {
                    this.currentRecognizer.setParameterValue(panel.getParamName(), val);
                    continue;
                }
                return;
            }
            for (int i = 0; i < numPanels; ++i) {
                app = ppc.getParamPanel(i);
                if (app instanceof FileParamPanel && !((FileParamPanel)app).isOptional()) continue;
                value = app.getParamValue();
                if (app instanceof FileParamPanel) {
                    String file = null;
                    FileParamPanel ffp = (FileParamPanel)app;
                    if (!ffp.isInputType()) {
                        if (value != null) {
                            file = value.toString();
                        }
                    } else {
                        File tf;
                        if (value instanceof Map) {
                            Map map = (Map)value;
                            if (map.containsKey("Selections")) {
                                value = map.get("Selections");
                            } else if (map.containsKey("Tier")) {
                                value = map.get("Tier");
                            } else if (map.containsKey("FileName")) {
                                value = map.get("FileName");
                            }
                        }
                        if (value instanceof List) {
                            file = this.writeAndGetTierOrSelectionFile(ffp, (List)value);
                        } else if (value instanceof String && (tf = new File((String)value)) != null && tf.exists()) {
                            file = value.toString();
                        }
                    }
                    if (file != null) {
                        this.currentRecognizer.setParameterValue(ffp.getParamName(), file);
                        continue;
                    }
                    this.currentRecognizer.setParameterValue(ffp.getParamName(), null);
                    continue;
                }
                if (value instanceof Float) {
                    this.currentRecognizer.setParameterValue(app.paramName, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    this.currentRecognizer.setParameterValue(app.paramName, ((Double)value).floatValue());
                    continue;
                }
                if (!(value instanceof String)) continue;
                this.currentRecognizer.setParameterValue(app.paramName, (String)value);
            }
        }
        try {
            this.currentRecognizer.validateParameters();
        }
        catch (RecognizerConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), ElanLocale.getString("Recognizer.RecognizerPanel.Warning.InValidParam"), 0);
            return;
        }
        if (this.controlPanel instanceof ParamPreferences) {
            // empty if block
        }
        this.segmentations.clear();
        this.progressBar.setValue(0);
        this.progressBar.setString("");
        this.startStopButton.setText(ElanLocale.getString("Button.Cancel"));
        this.reportButton.setEnabled(true);
        this.isRunning = true;
        this.progressBar.setString(ElanLocale.getString("Recognizer.RecognizerPanel.Recognizing"));
        new Thread(this).start();
        this.elapseTimer.start();
    }

    private String promptForTierFile(String title, int contentType) {
        String[] extensions = null;
        extensions = contentType == 3 ? FileExtension.CSV_EXT : FileExtension.XML_EXT;
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(title, 1, extensions, "Recognizer.Path");
        File f = chooser.getSelectedFile();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private String autoCreateOutputFile(List<String> mediaFiles, String paramName, int contentType) {
        File directory = null;
        Object prefix = paramName;
        if (mediaFiles != null && !mediaFiles.isEmpty()) {
            String firstMed = mediaFiles.get(0);
            File f = new File(firstMed);
            directory = f.getParentFile();
            prefix = FileUtility.dropExtension(f.getName()) + "_" + (String)prefix;
        }
        String suffix = null;
        if (contentType == 3 || contentType == 5) {
            suffix = ".csv";
        } else if (contentType == 2 || contentType == 7 || contentType == 4) {
            suffix = ".xml";
        }
        try {
            File tempFile = File.createTempFile((String)prefix, suffix, directory);
            if (this.currentRecognizer instanceof SharedRecognizer) {
                try {
                    this.changeFileAccess(tempFile);
                }
                catch (Exception ex) {
                    ClientLogger.LOG.warning("Cannot change the file permissions: " + ex.getMessage());
                }
            }
            return tempFile.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void createOutputFile(String path) {
        if (path == null) {
            return;
        }
        try {
            File out = new File(path);
            if (!out.exists()) {
                out.createNewFile();
                if (this.currentRecognizer instanceof SharedRecognizer) {
                    try {
                        this.changeFileAccess(out);
                    }
                    catch (Exception ex) {
                        ClientLogger.LOG.warning("Cannot change the file permissions: " + ex.getMessage());
                    }
                }
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot create the file: " + ioe.getMessage());
        }
        catch (SecurityException se) {
            ClientLogger.LOG.warning("Cannot create the file: " + se.getMessage());
        }
    }

    private void changeFileAccess(File f) {
        if (f == null) {
            return;
        }
        ArrayList<String> coms = new ArrayList<String>(5);
        if (SystemReporting.isWindows()) {
            coms.add("CACLS");
            coms.add("\"" + f.getAbsolutePath() + "\"");
            coms.add("/E");
            coms.add("/G");
            coms.add("Everyone:f");
        } else {
            coms.add("chmod");
            coms.add("a+rwx");
            coms.add("\"" + f.getAbsolutePath() + "\"");
        }
        ProcessBuilder pb = new ProcessBuilder(coms);
        pb.redirectErrorStream(true);
        try {
            Process proc = pb.start();
            int exit = proc.exitValue();
            if (exit != 0) {
                ClientLogger.LOG.warning("Could not set the file access attributes via using native tool, error: " + exit);
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot set the file access attributes via native tool");
        }
    }

    private void checkOutput() {
        if (this.isRunning) {
            return;
        }
        boolean loadTS = false;
        boolean loadTiers = false;
        boolean tsAvailable = false;
        boolean tierFileAvailable = false;
        if (this.controlPanel instanceof ParamPanelContainer) {
            File f3;
            ArrayList<File> csvFiles;
            LoadOutputPane lop;
            int option;
            Boolean pref;
            boolean tiersAvailable;
            FileParamPanel fpp;
            AbstractParamPanel app;
            ParamPanelContainer ppc = (ParamPanelContainer)this.controlPanel;
            int numPanels = ppc.getNumPanels();
            for (int i = 0; i < numPanels; ++i) {
                File f2;
                Object file;
                app = ppc.getParamPanel(i);
                if (!(app instanceof FileParamPanel)) continue;
                fpp = (FileParamPanel)app;
                if (!(fpp.isInputType() || fpp.getContentType() != 5 && fpp.getContentType() != 4)) {
                    File f22;
                    Object file2 = fpp.getParamValue();
                    if (!(file2 instanceof String) || !(f22 = new File((String)file2)).exists() || !f22.canRead() || f22.lastModified() < this.lastStartTime) continue;
                    tsAvailable = true;
                    continue;
                }
                if (fpp.isInputType() || fpp.getContentType() != 2 && fpp.getContentType() != 7 && fpp.getContentType() != 3 || !((file = fpp.getParamValue()) instanceof String) || !(f2 = new File((String)file)).exists() || !f2.canRead() || f2.lastModified() < this.lastStartTime) continue;
                tierFileAvailable = true;
            }
            boolean bl = tiersAvailable = this.segmentations.size() > 0;
            if (!(tiersAvailable || tsAvailable || tierFileAvailable)) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.NoOutput"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            ArrayList<SelectableObject<String>> resources = new ArrayList<SelectableObject<String>>(4);
            if (tiersAvailable || tierFileAvailable) {
                boolean sel = true;
                pref = Preferences.getBool("Recognizer.RecognizerPanel.Tiers", null);
                if (pref != null) {
                    sel = pref;
                }
                resources.add(new SelectableObject<String>(ElanLocale.getString("Recognizer.RecognizerPanel.Tiers"), sel));
            }
            if (tsAvailable) {
                boolean sel = true;
                pref = Preferences.getBool("Recognizer.RecognizerPanel.TimeSeries", null);
                if (pref != null) {
                    sel = pref;
                }
                resources.add(new SelectableObject<String>(ElanLocale.getString("Recognizer.RecognizerPanel.TimeSeries"), sel));
            }
            if ((option = JOptionPane.showConfirmDialog(this, lop = new LoadOutputPane(resources), "", 0, 3)) != 0) {
                return;
            }
            for (int i = 0; i < resources.size(); ++i) {
                SelectableObject selObj = (SelectableObject)resources.get(i);
                if (((String)selObj.getValue()).equals(ElanLocale.getString("Recognizer.RecognizerPanel.Tiers"))) {
                    loadTiers = selObj.isSelected();
                    Preferences.set("Recognizer.RecognizerPanel.Tiers", loadTiers, null, false, false);
                    continue;
                }
                if (!((String)selObj.getValue()).equals(ElanLocale.getString("Recognizer.RecognizerPanel.TimeSeries"))) continue;
                loadTS = selObj.isSelected();
                Preferences.set("Recognizer.RecognizerPanel.TimeSeries", loadTS, null, false, false);
            }
            if (loadTiers) {
                if (tierFileAvailable && !tiersAvailable) {
                    csvFiles = new ArrayList(4);
                    ArrayList<File> xmlFiles = new ArrayList<File>(4);
                    for (int i = 0; i < numPanels; ++i) {
                        Object object;
                        app = ppc.getParamPanel(i);
                        if (!(app instanceof FileParamPanel) || (fpp = (FileParamPanel)app).isInputType() || fpp.getContentType() != 3 && fpp.getContentType() != 2 || !((object = fpp.getParamValue()) instanceof String) || !(f3 = new File((String)object)).exists() || !f3.canRead() || f3.lastModified() < this.lastStartTime) continue;
                        if (fpp.getContentType() == 3) {
                            csvFiles.add(f3);
                            continue;
                        }
                        xmlFiles.add(f3);
                    }
                    for (File file : csvFiles) {
                        CsvTierIO cio;
                        List<Segmentation> segm;
                        if (!file.exists() || !file.canRead() || file.lastModified() < this.lastStartTime || (segm = (cio = new CsvTierIO()).read(file)) == null || segm.size() <= 0) continue;
                        for (Segmentation s : segm) {
                            this.addSegmentation(s);
                        }
                    }
                    StringBuilder mesBuf = new StringBuilder();
                    for (File xmlFile : xmlFiles) {
                        if (!xmlFile.exists() || !xmlFile.canRead() || xmlFile.lastModified() < this.lastStartTime) continue;
                        XmlTierIO xio = new XmlTierIO(xmlFile);
                        List<Segmentation> segm = null;
                        try {
                            segm = xio.parse();
                        }
                        catch (Exception e) {
                            mesBuf.append(xmlFile.getAbsolutePath() + " : " + e.getMessage() + "\n");
                        }
                        if (segm == null || segm.size() <= 0) continue;
                        for (Segmentation s : segm) {
                            this.addSegmentation(s);
                        }
                    }
                    if (mesBuf.length() > 0) {
                        JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()), mesBuf, ElanLocale.getString("Message.Error"), 2);
                        if (this.getSegmentations().size() == 0) {
                            return;
                        }
                    }
                }
                HashMap segmentationMap = new HashMap();
                List<Segmentation> segs = this.getSegmentations();
                for (Segmentation segmentation : segs) {
                    if (segmentation == null) continue;
                    ArrayList<RSelection> segments = segmentation.getSegments();
                    ArrayList<AnnotationDataRecord> records = new ArrayList<AnnotationDataRecord>();
                    for (int j = 0; j < segments.size(); ++j) {
                        Segment segment = (Segment)segments.get(j);
                        records.add(new AnnotationDataRecord("", segment.label, segment.beginTime, segment.endTime));
                    }
                    segmentationMap.put(segmentation.getName(), records);
                }
                SegmentsToTiersCommand com = (SegmentsToTiersCommand)ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), "CommandActions.SegmentsToTiers");
                com.execute(this.viewerManager.getTranscription(), new Object[]{segmentationMap});
            }
            if (loadTS) {
                csvFiles = new ArrayList<File>(4);
                ArrayList<File> xmlFiles = new ArrayList<File>(4);
                for (int i = 0; i < numPanels; ++i) {
                    Object object;
                    app = ppc.getParamPanel(i);
                    if (!(app instanceof FileParamPanel) || (fpp = (FileParamPanel)app).isInputType() || fpp.getContentType() != 5 && fpp.getContentType() != 4 || !((object = fpp.getParamValue()) instanceof String) || !(f3 = new File((String)object)).exists() || !f3.canRead() || f3.lastModified() < this.lastStartTime) continue;
                    if (fpp.getContentType() == 5) {
                        csvFiles.add(f3);
                        continue;
                    }
                    xmlFiles.add(f3);
                }
                ArrayList<Object> tracks = new ArrayList<Object>(10);
                for (File f3 : csvFiles) {
                    CsvTimeSeriesIO csvIO = new CsvTimeSeriesIO(f3);
                    List<Object> result = csvIO.getAllTracks();
                    if (result == null) continue;
                    tracks.addAll(result);
                }
                for (File f3 : xmlFiles) {
                    XmlTimeSeriesReader xmlIO = new XmlTimeSeriesReader(f3);
                    try {
                        List<Object> result = xmlIO.parse();
                        if (result == null) continue;
                        tracks.addAll(result);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.LoadFailed") + "\n" + ioe.getMessage(), ElanLocale.getString("Message.Error"), 0);
                    }
                    catch (SAXException sax) {
                        JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.LoadFailed") + "\n" + sax.getMessage(), ElanLocale.getString("Message.Error"), 0);
                    }
                }
                Command command = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), "AddTSTrackAndPanel");
                command.execute(this.viewerManager, new Object[]{tracks});
            }
        }
    }

    @Override
    public void run() {
        if (this.currentRecognizer != null) {
            this.currentRecognizer.start();
            this.lastStartTime = System.currentTimeMillis() / 1000L * 1000L;
        }
    }

    public void stopRecognizers() {
        if (this.currentRecognizer != null) {
            this.elapseTimer.stop();
            this.currentRecognizer.stop();
            this.isRunning = false;
        }
    }

    @Override
    public boolean isBusy() {
        return this.isRunning;
    }

    private void setRecognizerResourceBundle() {
        if (this.currentRecognizer != null) {
            try {
                this.currentRecognizer.getClass().getMethod("updateLocaleBundle", ResourceBundle.class);
                this.currentRecognizer.updateLocaleBundle(ElanLocale.getResourceBundle());
            }
            catch (NoSuchMethodException nme) {
                this.currentRecognizer.updateLocale(ElanLocale.getLocale());
            }
            catch (Throwable t) {
                this.currentRecognizer.updateLocale(ElanLocale.getLocale());
            }
        }
    }

    @Override
    public void updateLocale() {
        this.createSegButton.setText(ElanLocale.getString("Recognizer.SegmentationsPanel.Make.Tier"));
        this.setRecognizerResourceBundle();
        if (this.controlPanel instanceof ParamPanelContainer) {
            ((ParamPanelContainer)this.controlPanel).updateLocale();
        }
        this.helpButton.setToolTipText(ElanLocale.getString("Button.Help.ToolTip"));
        this.startStopButton.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
        this.reportButton.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Report"));
        this.recognizerLabel.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Recognizer"));
        this.progressPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.RecognizerPanel.Progress")));
        this.paramPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.RecognizerPanel.Parameters")));
        this.detachButton.setToolTipText(ElanLocale.getString("Detachable.Detach"));
        this.configureButton.setToolTipText(ElanLocale.getString("MetadataViewer.Configure"));
        this.saveParamsButton.setToolTipText(ElanLocale.getString("Recognizer.RecognizerPanel.SaveParameters"));
        this.loadParamsButton.setToolTipText(ElanLocale.getString("Recognizer.RecognizerPanel.LoadParameters"));
    }

    @Override
    public void addSegmentation(Segmentation segmentation) {
        this.segmentations.put(segmentation.getName(), segmentation);
        this.createSegButton.setEnabled(true);
        if (this.currentRecognizer.getRecognizerType() != 0) {
            return;
        }
        SignalViewer signalViewer = this.viewerManager.getSignalViewer();
        if (signalViewer != null) {
            int channel = 0;
            ArrayList<MediaDescriptor> mediaDescriptors = segmentation.getMediaDescriptors();
            String signalViewerMediaPath = signalViewer.getMediaPath();
            if (mediaDescriptors.isEmpty()) {
                ++channel;
            } else {
                for (MediaDescriptor descriptor : mediaDescriptors) {
                    if (!descriptor.mediaFilePath.equals(signalViewerMediaPath)) continue;
                    channel += descriptor.channel;
                }
            }
            if (channel == 0 && mediaDescriptors.size() >= 1) {
                if (((MediaDescriptor)mediaDescriptors.get((int)0)).mediaFilePath.equals(signalViewerMediaPath)) {
                    signalViewer.setSegmentation(new BoundarySegmentation(segmentation));
                }
            } else if (channel == 1) {
                if (this.notMono) {
                    signalViewer.setSegmentationChannel1(new BoundarySegmentation(segmentation));
                } else {
                    signalViewer.setSegmentation(new BoundarySegmentation(segmentation));
                }
            } else if (channel == 2) {
                signalViewer.setSegmentationChannel2(new BoundarySegmentation(segmentation));
            } else if (channel == 3) {
                // empty if block
            }
        }
    }

    @Override
    public List<Segmentation> getSegmentations() {
        return new ArrayList<Segmentation>(this.segmentations.values());
    }

    @Override
    public void setProgress(float progress) {
        int progPercent = (int)(100.0f * progress);
        this.setProgress(progPercent, (String)null);
    }

    @Override
    public void setProgress(float progress, String message) {
        int progPercent = (int)(100.0f * progress);
        this.setProgress(progPercent, message);
    }

    private void setProgress(int percentage, String message) {
        if (this.needToPollProgressReport) {
            this.pollProgressReport();
        }
        if (percentage < 0) {
            if (!this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(true);
            }
            if (message != null) {
                this.progressBar.setString(message);
            } else {
                this.progressBar.setString("");
            }
            this.elapseTimer.recognizerUpdate();
        } else {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
            }
            this.progressBar.setValue(percentage);
            if (percentage >= 100) {
                this.progressBar.setString(ElanLocale.getString("Recognizer.RecognizerPanel.Ready"));
                this.startStopButton.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
                this.isRunning = false;
                this.elapseTimer.stop();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractRecognizerPanel.this.checkOutput();
                    }
                });
            } else {
                if (this.isRunning) {
                    if (message != null) {
                        this.progressBar.setString(String.valueOf(percentage) + "% " + message);
                    } else {
                        this.progressBar.setString(String.valueOf(percentage) + "%");
                    }
                }
                this.elapseTimer.recognizerUpdate();
            }
        }
    }

    @Override
    public void errorOccurred(String message) {
        this.elapseTimer.stop();
        JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Error") + "\n" + message, ElanLocale.getString("Message.Error"), 0);
        if (this.isRunning) {
            this.currentRecognizer.stop();
        }
        this.setProgress(1.0f);
    }

    @Override
    public void appendToReport(String message) {
        this.needToPollProgressReport = false;
        this.elapseTimer.recognizerUpdate();
        this.updateProgressReport(message);
    }

    @Override
    public TierSelectionPanel getSelectionPanel(String paramName) {
        TierSelectionPanel panel;
        if (paramName == null || paramName.trim().length() == 0) {
            paramName = "DEFAULT";
        }
        if ((panel = this.selPanelMap.get(paramName)) == null) {
            int mode = this.currentRecognizer.getRecognizerType();
            panel = new TierSelectionPanel(mode, this.supportedMediaFiles.get(mode), this.viewerManager);
            this.selPanelMap.put(paramName, panel);
        }
        return panel;
    }

    public void attachParamPanel(JComponent paramComp) {
        if (paramComp == this.controlPanel || paramComp == this.jsp) {
            if (paramComp == this.controlPanel && this.controlPanel instanceof ParamPanelContainer) {
                ((ParamPanelContainer)this.controlPanel).doLayout(false);
                this.jsp.setViewportView(this.controlPanel);
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.paramPanel.add((Component)this.jsp, gbc);
            this.paramButtonPanel.setVisible(true);
            this.detached = false;
            this.detachedDialog = null;
        }
    }

    private void showConfigureDialog() {
        ConfigWindow cw = new ConfigWindow(ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()));
        cw.pack();
        Dimension dim = cw.getPreferredSize();
        Point p = this.configureButton.getLocationOnScreen();
        cw.setBounds(p.x - dim.width, p.y, dim.width, dim.height);
        cw.setVisible(true);
    }

    public void detachParamPanel() {
        this.paramPanel.remove(this.jsp);
        this.paramPanel.repaint();
        this.paramButtonPanel.setVisible(false);
        if (this.controlPanel instanceof ParamPanelContainer) {
            ((ParamPanelContainer)this.controlPanel).doLayout(true);
            this.detachedDialog = new ParamDialog(ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()), this, this.controlPanel);
        } else {
            this.detachedDialog = new ParamDialog(ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()), this, this.jsp);
        }
        this.detachedDialog.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle curRect = this.detachedDialog.getBounds();
        this.detachedDialog.setBounds(screen.width / 2, 10, Math.min(screen.width / 2 - 20, curRect.width), Math.min(screen.height - 30, curRect.height));
        this.detachedDialog.setVisible(true);
        this.detached = true;
    }

    public boolean isHelpAvailable() {
        return this.helpButton.isEnabled();
    }

    public void showHelpDialog() {
        try {
            String fileName = RecogAvailabilityDetector.getHelpFile(this.currentRecognizer.getName());
            HTMLViewer helpViewer = new HTMLViewer(fileName, false, ElanLocale.getString("Recognizer.RecognizerPanel.Help"));
            JDialog dialog = helpViewer.createHTMLDialog(ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()));
            dialog.pack();
            dialog.setSize(500, 600);
            dialog.setVisible(true);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Message.LoadHelpFile") + " " + ioe.getMessage(), ElanLocale.getString("Message.Error"), 0, null);
        }
    }

    protected void loadParameterFile() {
        if (this.currentRecognizer == null || this.controlPanel == null || !(this.controlPanel instanceof ParamPreferences)) {
            return;
        }
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(null, 0, FileExtension.XML_EXT, "Recognizer.Path");
        File selFile = chooser.getSelectedFile();
        if (selFile != null && selFile.canRead()) {
            try {
                ParamIO pio = new ParamIO();
                Map<String, Object> parMap = pio.read(selFile);
                ((ParamPreferences)((Object)this.controlPanel)).setParamPreferences(parMap);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.LoadFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
            }
        }
    }

    protected void saveParameterFile() {
        if (this.currentRecognizer == null || this.controlPanel == null || !(this.controlPanel instanceof ParamPreferences)) {
            return;
        }
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(null, 1, FileExtension.XML_EXT, "Recognizer.Path");
        File f = chooser.getSelectedFile();
        if (f != null) {
            ParamIO pio = new ParamIO();
            Map<String, Object> paramMap = ((ParamPreferences)((Object)this.controlPanel)).getParamPreferences();
            String recogId = null;
            recogId = this.currentRecognizer instanceof LocalRecognizer ? ((LocalRecognizer)this.currentRecognizer).getId() : this.currentRecognizer.getName();
            try {
                pio.writeParamFile(recogId, paramMap, f);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
            }
        }
    }

    private String writeAndGetTierOrSelectionFile(FileParamPanel panel, List<RSelection> selList) {
        String filePath = null;
        filePath = this.reduceFilePrompt ? this.autoCreateOutputFile(null, panel.getParamName(), panel.getContentType()) : this.promptForTierFile(panel.description, panel.getContentType());
        if (filePath == null) {
            return null;
        }
        File tf = new File(filePath);
        try {
            if (!tf.exists()) {
                JOptionPane.showMessageDialog(this, "File not exists.", ElanLocale.getString("Message.Warning"), 0);
                return null;
            }
            this.writeFile(filePath, selList, panel.getContentType());
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
            return null;
        }
        catch (Exception ex) {
            return null;
        }
        return filePath;
    }

    protected void writeFile(String filepath, Object value, int contentType) throws IOException {
        RecTierWriter xTierWriter = new RecTierWriter();
        File f = new File(filepath);
        if (value instanceof List) {
            xTierWriter.write(f, (List)value);
        } else if (value instanceof String) {
            TierImpl tier = ((TranscriptionImpl)this.viewerManager.getTranscription()).getTierWithId(value.toString());
            ArrayList<RSelection> segments = null;
            if (tier != null) {
                List<AbstractAnnotation> anns = tier.getAnnotations();
                segments = new ArrayList<RSelection>(anns.size());
                for (int j = 0; j < anns.size(); ++j) {
                    AbstractAnnotation aa = anns.get(j);
                    segments.add(new AudioSegment(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary(), aa.getValue()));
                }
            }
            ArrayList<Segmentation> segmentations = new ArrayList<Segmentation>();
            segmentations.add(new Segmentation(tier.getName(), segments, ""));
            xTierWriter.write(f, segmentations, this.viewerManager.getTranscription());
        }
    }

    protected void showReport() {
        String report = this.progressReport.toString();
        if (report.isEmpty() && this.needToPollProgressReport) {
            report = this.getPolledProgressReport();
        }
        if (report != null) {
            ClosableDialog rD = new ClosableDialog((Frame)ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()), true);
            this.progressReportTextArea = new JTextArea(report);
            this.progressReportTextArea.setLineWrap(true);
            this.progressReportTextArea.setWrapStyleWord(true);
            this.progressReportTextArea.setEditable(false);
            this.progressReportTextArea.setCaretPosition(report.length());
            this.progressReportTextArea.getCaret().setVisible(true);
            rD.getContentPane().setLayout(new BorderLayout());
            JScrollPane scroll = new JScrollPane(this.progressReportTextArea);
            rD.getContentPane().add((Component)scroll, "Center");
            rD.pack();
            rD.setSize(800, 400);
            rD.setLocationRelativeTo(this);
            rD.setVisible(true);
            this.progressReportTextArea = null;
        } else {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.No.Report"), ElanLocale.getString("Message.Warning"), 1);
        }
    }

    protected void updateProgressReport(String toAppend) {
        this.progressReport.append(toAppend);
        if (this.progressReportTextArea != null) {
            Document doc = this.progressReportTextArea.getDocument();
            int oldLen = doc.getLength();
            boolean wasAtEnd = oldLen == this.progressReportTextArea.getCaretPosition();
            try {
                doc.insertString(oldLen, toAppend, null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (wasAtEnd) {
                this.progressReportTextArea.setCaretPosition(this.progressReport.length());
            }
        }
    }

    protected String getPolledProgressReport() {
        try {
            Object res = this.getReport.invoke((Object)this.currentRecognizer, new Object[0]);
            if (res instanceof String) {
                return (String)res;
            }
            if (res == null) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.needToPollProgressReport = false;
        return null;
    }

    protected void pollProgressReport() {
        String report;
        if (this.progressReportTextArea != null && (report = this.getPolledProgressReport()) != null) {
            this.progressReportTextArea.setText(report);
        }
    }

    protected void finalize() throws Throwable {
        if (this.currentRecognizer != null) {
            if (this.isRunning) {
                this.currentRecognizer.stop();
                this.elapseTimer.stop();
                this.currentRecognizer.dispose();
            }
            this.currentRecognizer = null;
        }
        super.finalize();
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: 
            case 1: 
            case 2: {
                this.updateTiers(e.getOperation());
            }
        }
    }

    @Override
    public List<String> getMediaFiles(int mode) {
        return this.supportedMediaFiles.get(mode);
    }

    protected void setAudioVideoFilePaths(List<String> destPaths, List<String> avFilePaths) {
        destPaths.clear();
        for (String path : avFilePaths) {
            if (destPaths.contains(path = FileUtility.urlToAbsPath(path))) continue;
            destPaths.add(path);
        }
        this.segmentations = new HashMap<String, Segmentation>();
        this.updateMediaFiles();
    }

    public void setAudioFilePaths(List<String> audioFilePaths) {
        List<String> audioMediaPaths = this.mediaFilePaths.get(0);
        this.setAudioVideoFilePaths(audioMediaPaths, audioFilePaths);
    }

    public void setVideoFilePaths(List<String> videoFilePaths) {
        List<String> videoMediaPaths = this.mediaFilePaths.get(1);
        this.setAudioVideoFilePaths(videoMediaPaths, videoFilePaths);
    }

    public void setOtherFilePaths(List<String> otherFilePaths) {
        List<String> otherMediaPaths = this.mediaFilePaths.get(2);
        this.setAudioVideoFilePaths(otherMediaPaths, otherFilePaths);
    }

    private class Timer {
        private Thread internalThread;
        private boolean stopUpdate;
        private JPanel timerPanel;
        private JLabel elapseTimeLabel;
        private JLabel lastUpdateLabel;
        private long lastUpdateTime;
        SimpleDateFormat df = new SimpleDateFormat("mm:ss");

        public JPanel getTimerPanel() {
            if (this.timerPanel == null) {
                this.elapseTimeLabel = new JLabel("00:00");
                this.lastUpdateLabel = new JLabel("00:00");
                JLabel elapseLabel = new JLabel(ElanLocale.getString("Recognizer.RecognizerPanel.Timer.ElapseTime") + " ");
                JLabel updateLabel = new JLabel(ElanLocale.getString("Recognizer.RecognizerPanel.Timer.UpdateTime") + " ");
                Font font = new Font(this.elapseTimeLabel.getFont().getFontName(), 0, 10);
                this.elapseTimeLabel.setFont(font);
                this.lastUpdateLabel.setFont(font);
                elapseLabel.setFont(font);
                updateLabel.setFont(font);
                this.timerPanel = new JPanel();
                this.timerPanel.setLayout(new BoxLayout(this.timerPanel, 0));
                this.timerPanel.add(Box.createHorizontalStrut(10));
                this.timerPanel.add(elapseLabel);
                this.timerPanel.add(Box.createHorizontalStrut(10));
                this.timerPanel.add(this.elapseTimeLabel);
                this.timerPanel.add(Box.createHorizontalStrut(15));
                this.timerPanel.add(updateLabel);
                this.timerPanel.add(Box.createHorizontalStrut(10));
                this.timerPanel.add(this.lastUpdateLabel);
            }
            return this.timerPanel;
        }

        public void resetTimer() {
            this.elapseTimeLabel.setText("00:00");
            this.lastUpdateLabel.setText("00:00");
            this.stopUpdate = false;
            AbstractRecognizerPanel.this.repaint();
        }

        public void recognizerUpdate() {
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public void start() {
            this.resetTimer();
            this.internalThread = new Thread("ElapseTimer"){

                @Override
                public void run() {
                    try {
                        long startTime = System.currentTimeMillis();
                        Timer.this.lastUpdateTime = System.currentTimeMillis();
                        while (!Timer.this.stopUpdate) {
                            Thread.sleep(1000L);
                            long currTime = System.currentTimeMillis();
                            Timer.this.elapseTimeLabel.setText(Timer.this.df.format(new Date(currTime - startTime)));
                            Timer.this.lastUpdateLabel.setText(Timer.this.df.format(new Date(currTime - Timer.this.lastUpdateTime)));
                            if (!AbstractRecognizerPanel.this.needToPollProgressReport) continue;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractRecognizerPanel.this.pollProgressReport();
                                }
                            });
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            this.internalThread.start();
        }

        public void stop() {
            this.stopUpdate = true;
            if (this.internalThread != null && this.internalThread.isAlive()) {
                this.internalThread.interrupt();
            }
        }
    }

    private class ConfigWindow
    extends JWindow
    implements ActionListener {
        private JPanel compPanel;
        private JButton closeButton;
        private JCheckBox reduceFilePromptCB;

        public ConfigWindow(Window owner) {
            super(owner);
            this.initComponents();
        }

        private void initComponents() {
            ImageIcon icon = null;
            String text = null;
            try {
                icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Close16.gif"));
            }
            catch (Exception ex) {
                text = "X";
            }
            this.compPanel = new JPanel(new GridBagLayout());
            this.compPanel.setBorder(new CompoundBorder(new LineBorder(Constants.SHAREDCOLOR6, 1), new EmptyBorder(2, 4, 2, 2)));
            this.closeButton = new JButton(text, icon);
            this.closeButton.setToolTipText(ElanLocale.getString("Button.Close"));
            this.closeButton.setBorderPainted(false);
            this.closeButton.setPreferredSize(new Dimension(16, 16));
            this.closeButton.addActionListener(this);
            this.reduceFilePromptCB = new JCheckBox(ElanLocale.getString("Recognizer.RecognizerPanel.ReduceFilePrompt"));
            this.reduceFilePromptCB.setSelected(AbstractRecognizerPanel.this.reduceFilePrompt);
            this.reduceFilePromptCB.addActionListener(this);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 13;
            gbc.gridwidth = 2;
            this.compPanel.add((Component)this.closeButton, gbc);
            gbc.anchor = 17;
            gbc.gridwidth = 1;
            gbc.gridy = 1;
            this.compPanel.add((Component)this.reduceFilePromptCB, gbc);
            this.add(this.compPanel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.closeButton) {
                this.close();
            } else if (e.getSource() == this.reduceFilePromptCB) {
                AbstractRecognizerPanel.this.reduceFilePrompt = this.reduceFilePromptCB.isSelected();
            }
        }

        private void close() {
            this.setVisible(false);
            this.dispose();
        }
    }
}

