/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.util.CheckBoxBListCellRenderer;
import mpi.eudico.client.util.SelectableObject;

public class LoadOutputPane
extends JPanel {
    private List<SelectableObject<String>> options;
    private JList list;
    private DefaultListModel model;

    public LoadOutputPane(List<SelectableObject<String>> options) {
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel(ElanLocale.getString("Recognizer.RecognizerPanel.LoadOutput"));
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.add((Component)label, gbc);
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        for (int i = 0; i < this.options.size(); ++i) {
            this.model.add(i, this.options.get(i));
        }
        this.list.setCellRenderer(new CheckBoxBListCellRenderer());
        this.list.addMouseListener(new ListMouseListener());
        JScrollPane pane = new JScrollPane(this.list);
        pane.setPreferredSize(new Dimension(160, 80));
        gbc.gridy = 1;
        this.add((Component)pane, gbc);
    }

    public List<String> getSelectedItems() {
        ArrayList<String> result = new ArrayList<String>(4);
        Object obj = null;
        for (int i = 0; i < this.model.getSize(); ++i) {
            SelectableObject selObj;
            obj = this.model.get(i);
            if (!(obj instanceof SelectableObject) || !(selObj = (SelectableObject)obj).isSelected()) continue;
            result.add((String)selObj.getValue());
        }
        return result;
    }

    class ListMouseListener
    extends MouseAdapter {
        ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row = LoadOutputPane.this.list.locationToIndex(e.getPoint());
            if (row > -1) {
                SelectableObject sel;
                sel.setSelected(!(sel = (SelectableObject)LoadOutputPane.this.model.get(row)).isSelected());
                LoadOutputPane.this.list.repaint();
            }
        }
    }
}

