/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.annotator.recognizer.api.AbstractSelectionPanel;
import mpi.eudico.client.annotator.recognizer.data.AudioSegment;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.VideoSegment;
import mpi.eudico.client.annotator.recognizer.gui.SelectionListRenderer;
import mpi.eudico.client.annotator.svg.Graphics2DEditor;
import mpi.eudico.client.util.WAVSampler;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import nl.mpi.util.FileExtension;
import nl.mpi.util.FileUtility;

public class TierSelectionPanel
extends AbstractSelectionPanel
implements ActionListener {
    private static final Logger LOG = Logger.getLogger("ClientLogger");
    private JRadioButton selectionsRB;
    private JRadioButton tierRB;
    private JRadioButton fileRB;
    private JLabel tierLabel;
    private JComboBox tierComboBox;
    private DefaultComboBoxModel model;
    private SelectionPanel selectionPanel;
    private JPanel settingsPanel;
    private JTextField fileField;
    private JButton browseButton;
    private String initialPath;
    private int dialogType = -1;
    private List<String[]> fileExtensions = null;
    private boolean enableFileSelection = false;
    private ViewerManager2 vm;
    private static final String SELECT_TIER = "<select a tier>";
    private int avMode = 0;
    private Insets insets = new Insets(1, 1, 0, 1);
    private List<String> mediaFiles;
    private Map<String, Object> paramValueMap;

    public TierSelectionPanel(int mode, List<String> supportedMediaFiles, ViewerManager2 vm) {
        this(mode, supportedMediaFiles, vm, false);
    }

    public TierSelectionPanel(int mode, List<String> supportedMediaFiles, ViewerManager2 vm, boolean enableFileSelection) {
        if (vm != null) {
            this.vm = vm;
            this.enableFileSelection = enableFileSelection;
            this.mediaFiles = supportedMediaFiles;
            this.avMode = mode;
            this.paramValueMap = new HashMap<String, Object>();
            this.initComponents();
        }
    }

    public void setDefaultOption(String option) {
        if (option.equals("Selections")) {
            this.selectionsRB.doClick();
        } else if (option.equals("FileName") && this.fileRB.isEnabled()) {
            this.fileRB.doClick();
        }
    }

    @Override
    public void enableFileSelection(boolean enable) {
        this.enableFileSelection = enable;
        this.fileRB.setEnabled(this.enableFileSelection);
    }

    public void updateBackgroundColor(Color color) {
        this.settingsPanel.setBackground(color);
        this.selectionPanel.updateBackgroundColor(color);
        super.setBackground(color);
    }

    public void setFileDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    public void setFileExtensions(List<String[]> fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.selectionPanel = new SelectionPanel();
        this.selectionsRB = new JRadioButton();
        this.tierRB = new JRadioButton();
        this.fileRB = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.selectionsRB);
        group.add(this.tierRB);
        group.add(this.fileRB);
        this.selectionsRB.addActionListener(this);
        this.tierRB.addActionListener(this);
        this.fileRB.addActionListener(this);
        this.fileRB.setEnabled(this.enableFileSelection);
        this.tierLabel = new JLabel();
        this.model = new DefaultComboBoxModel();
        this.tierComboBox = new JComboBox(this.model);
        this.updateTierComboBox();
        this.fileField = new JTextField();
        this.fileField.setEditable(true);
        this.browseButton = new JButton();
        try {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif"));
            this.browseButton.setIcon(icon);
        }
        catch (Throwable t) {
            this.browseButton.setText("...");
        }
        this.browseButton.addActionListener(this);
        this.tierRB.setSelected(true);
        this.settingsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.insets = new Insets(3, 1, 0, 1);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.settingsPanel.add((Component)this.tierLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 1, 0, 1);
        this.settingsPanel.add((Component)this.tierComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = this.insets;
        this.add((Component)this.selectionsRB, gbc);
        gbc.gridx = 1;
        this.add((Component)this.tierRB, gbc);
        gbc.gridx = 2;
        this.add((Component)this.fileRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.settingsPanel, gbc);
        this.updateLocale(null);
    }

    private void updateTierComboBox() {
        if (this.model != null) {
            this.model.removeAllElements();
            this.model.addElement(SELECT_TIER);
            List<? extends Tier> tiers = this.vm.getTranscription().getTiers();
            if (tiers != null) {
                for (Tier tier : tiers) {
                    this.model.addElement(tier.getName());
                }
            }
        }
        if (this.model == null || this.model.getSize() <= 0) {
            this.tierRB.setEnabled(false);
        }
    }

    @Override
    public int getMode() {
        return this.avMode;
    }

    public void updateMediaFiles(List<String> mediaFilePaths) {
        if (this.avMode == 1) {
            this.mediaFiles = mediaFilePaths;
        }
        this.selectionPanel.updateStereoMode();
    }

    public void updateTierNames(int event) {
        switch (event) {
            case 0: 
            case 1: {
                String tierName = (String)this.model.getSelectedItem();
                this.updateTierComboBox();
                if (this.model.getIndexOf(tierName) >= 0) {
                    this.model.setSelectedItem(tierName);
                    break;
                }
                this.tierComboBox.setSelectedIndex(0);
                break;
            }
            case 2: {
                int index = this.tierComboBox.getSelectedIndex();
                this.updateTierComboBox();
                this.tierComboBox.setSelectedIndex(index);
            }
        }
    }

    @Override
    public Map<String, Object> getParamValue() {
        this.paramValueMap.clear();
        if (this.selectionsRB.isSelected()) {
            this.paramValueMap.put("Selections", this.selectionPanel.getSelections());
        } else if (this.tierRB.isSelected()) {
            Object val = this.getTierSelections();
            if (val == null) {
                this.paramValueMap.put("Tier", null);
                this.paramValueMap.put("TierName", null);
            } else {
                this.paramValueMap.put("Tier", this.getTierSelections());
                this.paramValueMap.put("TierName", this.model.getSelectedItem().toString());
            }
        } else {
            this.paramValueMap.put("FileName", this.fileField.getText());
        }
        return this.paramValueMap;
    }

    @Override
    public Object getSelectionValue() {
        this.getParamValue();
        if (this.selectionsRB.isSelected()) {
            return this.paramValueMap.get("Selections");
        }
        if (this.tierRB.isSelected()) {
            return this.paramValueMap.get("Tier");
        }
        return this.paramValueMap.get("FileName");
    }

    @Override
    public Map<String, Object> getStorableParamPreferencesMap(Map<String, Object> map) {
        HashMap<String, Object> newMap = null;
        if (map.containsKey("Selections")) {
            Object value = map.get("Selections");
            newMap = new HashMap<String, Object>();
            if (value instanceof List) {
                HashMap selectionMap = new HashMap();
                for (int i = 0; i < ((List)value).size(); ++i) {
                    Object val = ((List)value).get(i);
                    if (!(val instanceof RSelection)) continue;
                    ArrayList<Long> selection = new ArrayList<Long>();
                    selection.add(((RSelection)val).beginTime);
                    selection.add(((RSelection)val).endTime);
                    selectionMap.put(Integer.toString(selectionMap.size() + 1), selection);
                }
                newMap.put("Selections", selectionMap);
            } else if (value == null) {
                newMap.put("Selections", null);
            }
        } else if (map.containsKey("TierName")) {
            newMap = new HashMap();
            newMap.put("TierName", map.get("TierName"));
        } else if (map.containsKey("FileName")) {
            newMap = new HashMap();
            newMap.put("FileName", map.get("FileName"));
        }
        return newMap;
    }

    @Override
    public void setParamValue(String value) {
        this.fileRB.doClick();
        if (value != null) {
            this.fileField.setText(value);
        }
    }

    @Override
    public void setParamValue(Map<String, ? extends Object> map) {
        if (map.containsKey("Selections")) {
            this.selectionsRB.doClick();
            Object paramValue = map.get("Selections");
            if (paramValue != null && paramValue instanceof Map) {
                Map mapv = (Map)paramValue;
                for (Object rSel : mapv.values()) {
                    List sel;
                    if (rSel == null || !(rSel instanceof List) || ((List)rSel).size() != 2 || (Long)(sel = (List)rSel).get(0) >= (Long)sel.get(1)) continue;
                    if (this.avMode == 0) {
                        this.selectionPanel.addSelection(new AudioSegment((Long)sel.get(0), (Long)sel.get(1), null, 1));
                        continue;
                    }
                    this.selectionPanel.addSelection(new VideoSegment((Long)sel.get(0), (Long)sel.get(1), null));
                }
            }
        } else if (map.containsKey("TierName")) {
            this.tierRB.doClick();
            Object paramValue = map.get("TierName");
            if (paramValue != null && paramValue instanceof String && this.model.getIndexOf(paramValue) > 0) {
                this.model.setSelectedItem(paramValue.toString());
            }
        } else if (map.containsKey("FileName")) {
            this.fileRB.doClick();
            Object paramValue = map.get("FileName");
            if (paramValue != null && paramValue instanceof String) {
                this.fileField.setText(paramValue.toString());
            }
        }
    }

    private Object getTierSelections() {
        String tierName = this.tierComboBox.getSelectedItem().toString();
        TierImpl ti = null;
        if (!tierName.equals(SELECT_TIER)) {
            ti = (TierImpl)this.vm.getTranscription().getTierWithId(tierName);
        }
        if (ti != null) {
            List<AbstractAnnotation> anns = ti.getAnnotations();
            ArrayList<AudioSegment> segments = new ArrayList<AudioSegment>(anns.size());
            for (AbstractAnnotation aa : anns) {
                segments.add(new AudioSegment(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary(), aa.getValue()));
            }
            return segments;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JRadioButton) {
            if (source == this.selectionsRB) {
                this.settingsPanel.removeAll();
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.insets = this.insets;
                gbc.weightx = 1.0;
                this.settingsPanel.add((Component)this.selectionPanel, gbc);
            } else if (source == this.tierRB) {
                this.settingsPanel.removeAll();
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 18;
                gbc.gridx = 0;
                gbc.insets = new Insets(3, 1, 0, 1);
                gbc.weightx = 0.0;
                gbc.fill = 0;
                this.settingsPanel.add((Component)this.tierLabel, gbc);
                gbc.gridx = 1;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(0, 1, 0, 1);
                this.settingsPanel.add((Component)this.tierComboBox, gbc);
            } else if (source == this.fileRB) {
                this.settingsPanel.removeAll();
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.insets = this.insets;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.weightx = 1.0;
                this.settingsPanel.add((Component)this.fileField, gbc);
                gbc.gridx = 1;
                gbc.weightx = 0.0;
                gbc.fill = 0;
                this.settingsPanel.add((Component)this.browseButton, gbc);
            }
            this.revalidate();
        } else if (source == this.browseButton) {
            FileChooser chooser = new FileChooser(this);
            String[] mainFilterExt = null;
            if (this.fileExtensions != null && this.fileExtensions.size() > 0) {
                mainFilterExt = this.fileExtensions.get(0);
            }
            chooser.createAndShowFileDialog("Select a tier(s) file", this.dialogType, this.fileExtensions, mainFilterExt, "Recognizer.Dir", null);
            File f = chooser.getSelectedFile();
            if (f != null) {
                this.initialPath = f.getAbsolutePath();
                this.fileField.setText(this.initialPath);
            }
        }
    }

    @Override
    public void updateLocale(Locale locale) {
        if (locale == null || locale == ElanLocale.getLocale()) {
            this.selectionsRB.setText(ElanLocale.getString("Recognizer.SelectionsPanel.RB.Selection"));
            this.tierRB.setText(ElanLocale.getString("Recognizer.SelectionsPanel.RB.Tier"));
            this.fileRB.setText(ElanLocale.getString("Recognizer.SelectionsPanel.RB.File"));
            this.tierLabel.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Label.Tier"));
            if (this.selectionPanel != null) {
                this.selectionPanel.updateLocale();
            }
        }
    }

    @Override
    public void updateLocaleBundle(ResourceBundle bundle) {
        if (bundle != null) {
            this.updateLocale(bundle.getLocale());
        } else {
            this.updateLocale(null);
        }
    }

    private class SelectionPanel
    extends JPanel
    implements ActionListener {
        private Selection selection;
        protected TitledBorder border;
        protected JPanel buttonPanel;
        private JButton addSelection;
        private JButton addSelection1;
        private JButton addSelection2;
        private JButton removeSelection;
        protected JList selectionList;
        private DefaultListModel selectionModel;
        private JScrollPane scrollPane;
        private boolean stereoMode = false;

        public SelectionPanel() {
            this.selection = TierSelectionPanel.this.vm.getSelection();
            this.border = new TitledBorder(ElanLocale.getString("Recognizer.SelectionsPanel.Title"));
            this.setBorder(this.border);
            this.setLayout(new BorderLayout());
            this.buttonPanel = new JPanel();
            this.addSelection = new JButton();
            this.addSelection1 = new JButton(ElanLocale.getString("Recognizer.SelectionsPanel.Channel1"));
            this.addSelection2 = new JButton(ElanLocale.getString("Recognizer.SelectionsPanel.Channel2"));
            ImageIcon icon = null;
            String text = ElanLocale.getString("Recognizer.SelectionsPanel.Add");
            try {
                icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Plus16.gif"));
                this.addSelection.setIcon(icon);
                this.addSelection.setToolTipText(text);
                this.addSelection1.setIcon(icon);
                this.addSelection2.setIcon(icon);
                this.addSelection.setIcon(icon);
                this.addSelection.setToolTipText(text);
            }
            catch (Exception ex) {
                this.addSelection.setText(text);
                this.addSelection1.setText(text + "  " + this.addSelection1.getText());
                this.addSelection2.setText(text + "  " + this.addSelection2.getText());
            }
            this.addSelection.addActionListener(this);
            this.addSelection1.addActionListener(this);
            this.addSelection2.addActionListener(this);
            this.removeSelection = new JButton();
            text = ElanLocale.getString("Recognizer.SelectionsPanel.Remove");
            try {
                icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Minus16.gif"));
                this.removeSelection.setIcon(icon);
                this.removeSelection.setToolTipText(text);
            }
            catch (Exception ex) {
                this.removeSelection.setText(text);
            }
            this.removeSelection.addActionListener(this);
            if (this.stereoMode) {
                this.buttonPanel.add(this.addSelection1);
                this.buttonPanel.add(this.addSelection2);
                this.buttonPanel.add(this.removeSelection);
            } else {
                this.buttonPanel.add(this.addSelection);
                this.buttonPanel.add(this.removeSelection);
            }
            this.selectionModel = new DefaultListModel();
            this.selectionList = new JList(this.selectionModel);
            this.selectionList.setCellRenderer(new SelectionListRenderer());
            this.selectionList.addMouseListener(new MouseHandler());
            this.selectionList.setBackground(this.getBackground());
            this.updateStereoMode();
            this.setLayout(new GridBagLayout());
            this.setBorder(this.border);
            this.scrollPane = new JScrollPane(this.selectionList);
            this.scrollPane.getViewport().setPreferredSize(new Dimension(300, 50));
            this.buttonPanel.setLayout(new GridLayout(2, 1));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.fill = 0;
            gbc.anchor = 18;
            this.add((Component)this.scrollPane, gbc);
            gbc.gridx = 1;
            this.add((Component)this.buttonPanel, gbc);
        }

        private void updateBackgroundColor(Color color) {
            this.buttonPanel.setBackground(color);
            this.scrollPane.setBackground(color);
            this.selectionList.setBackground(color);
            super.setBackground(color);
        }

        private void updateLocale() {
            this.border.setTitle(ElanLocale.getString("Recognizer.SelectionsPanel.Title"));
            if (this.removeSelection.getText() != null && this.removeSelection.getText().length() > 0) {
                this.removeSelection.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Remove"));
            }
            if (this.addSelection1.getIcon() == null) {
                String text = ElanLocale.getString("Recognizer.SelectionsPanel.Add");
                this.addSelection.setText(text);
                this.addSelection1.setText(text + " " + ElanLocale.getString("Recognizer.SelectionsPanel.Channel1"));
                this.addSelection2.setText(text + " " + ElanLocale.getString("Recognizer.SelectionsPanel.Channel2"));
            } else {
                this.addSelection1.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Channel1"));
                this.addSelection2.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Channel2"));
            }
        }

        private void updateStereoMode() {
            boolean stereoMode;
            block6: {
                stereoMode = false;
                if (TierSelectionPanel.this.getMode() == 0 && TierSelectionPanel.this.vm.getSignalViewer() != null) {
                    try {
                        stereoMode = new WAVSampler(TierSelectionPanel.this.vm.getSignalViewer().getMediaPath()).getWavHeader().getNumberOfChannels() > 1;
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                        LOG.log(Level.FINE, "WAVSampler cannot handle file: " + e.getMessage());
                    }
                }
            }
            if (this.stereoMode == stereoMode) {
                return;
            }
            this.stereoMode = stereoMode;
            if (stereoMode) {
                this.buttonPanel.removeAll();
                this.buttonPanel.add(this.addSelection1);
                this.buttonPanel.add(this.addSelection2);
                this.buttonPanel.add(this.removeSelection);
            } else {
                this.buttonPanel.removeAll();
                this.buttonPanel.add(this.addSelection);
                this.buttonPanel.add(this.removeSelection);
            }
            this.selectionModel.removeAllElements();
        }

        public boolean getStereoMode() {
            return this.stereoMode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selIndices;
            Object source = e.getSource();
            if (source.equals(this.addSelection)) {
                if (this.selection.getBeginTime() < this.selection.getEndTime()) {
                    if (TierSelectionPanel.this.avMode == 0) {
                        this.addSelection(new AudioSegment(this.selection.getBeginTime(), this.selection.getEndTime(), null, 1));
                    } else {
                        this.addSelection(new VideoSegment(this.selection.getBeginTime(), this.selection.getEndTime(), null));
                    }
                }
            } else if (source.equals(this.addSelection1)) {
                if (this.selection.getBeginTime() < this.selection.getEndTime()) {
                    this.addSelection(new AudioSegment(this.selection.getBeginTime(), this.selection.getEndTime(), null, 1));
                }
            } else if (source.equals(this.addSelection2)) {
                if (this.selection.getBeginTime() < this.selection.getEndTime()) {
                    this.addSelection(new AudioSegment(this.selection.getBeginTime(), this.selection.getEndTime(), null, 2));
                }
            } else if (source.equals(this.removeSelection) && (selIndices = this.selectionList.getSelectedIndices()) != null) {
                for (int i = selIndices.length - 1; i >= 0; --i) {
                    this.selectionModel.remove(selIndices[i]);
                }
            }
        }

        private void addSelection(RSelection sel) {
            if (this.selectionModel.isEmpty()) {
                this.selectionModel.addElement(sel);
                return;
            }
            for (int i = 0; i < this.selectionModel.getSize(); ++i) {
                Object iter = this.selectionModel.get(i);
                if (iter instanceof RSelection) {
                    RSelection otherSel = (RSelection)iter;
                    if (otherSel.beginTime == sel.beginTime && otherSel.endTime == sel.endTime) {
                        if (otherSel instanceof AudioSegment && sel instanceof AudioSegment) {
                            if (((AudioSegment)otherSel).channel == ((AudioSegment)sel).channel) {
                                return;
                            }
                            if (((AudioSegment)sel).channel < ((AudioSegment)otherSel).channel) {
                                this.selectionModel.add(i, sel);
                                return;
                            }
                            if (i < this.selectionModel.getSize() - 1) {
                                this.selectionModel.add(i, sel);
                                return;
                            }
                            this.selectionModel.addElement(sel);
                            return;
                        }
                        return;
                    }
                    if (otherSel.beginTime == sel.beginTime && otherSel.endTime > sel.endTime) {
                        this.selectionModel.add(i, sel);
                        return;
                    }
                    if (sel.beginTime < otherSel.beginTime) {
                        this.selectionModel.add(i, sel);
                        return;
                    }
                }
                if (i != this.selectionModel.getSize() - 1) continue;
                this.selectionModel.addElement(sel);
            }
        }

        private void handlePopUp(Point p) {
            int row = this.selectionList.locationToIndex(p);
            if (row > -1) {
                Object sel = this.selectionModel.elementAt(row);
                if (sel instanceof AudioSegment) {
                    AudioSegment as = (AudioSegment)sel;
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem mi = new JMenuItem(new LabelAction(as));
                    popup.add(mi);
                    popup.show(this.selectionList, p.x, p.y);
                } else if (sel instanceof VideoSegment) {
                    VideoSegment vs = (VideoSegment)sel;
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem mi = new JMenuItem(new LabelAction(vs));
                    popup.add(mi);
                    mi = new JMenuItem(new ShapeAction(vs));
                    popup.add(mi);
                    popup.show(this.selectionList, p.x, p.y);
                } else if (!this.selectionModel.isEmpty()) {
                    // empty if block
                }
            }
        }

        private String promptForTierFile() {
            ArrayList<String[]> extensions = new ArrayList<String[]>();
            extensions.add(FileExtension.CSV_EXT);
            FileChooser chooser = new FileChooser(this);
            chooser.createAndShowFileDialog(null, 1, extensions, FileExtension.XML_EXT, "Recognizer.Path", null);
            File f = chooser.getSelectedFile();
            if (f != null) {
                return f.getAbsolutePath();
            }
            return null;
        }

        public List<RSelection> getSelections() {
            ArrayList<RSelection> selectionObjects = null;
            for (int i = 0; i < this.selectionModel.getSize(); ++i) {
                if (selectionObjects == null) {
                    selectionObjects = new ArrayList<RSelection>();
                }
                selectionObjects.add((RSelection)this.selectionModel.get(i));
            }
            return selectionObjects;
        }

        public boolean hasSelections() {
            int numSels = 0;
            for (int i = 0; i < this.selectionModel.getSize(); ++i) {
                Object iter = this.selectionModel.get(i);
                if (!(iter instanceof RSelection)) continue;
                ++numSels;
                break;
            }
            return numSels > 0;
        }

        public void clearSelections() {
            if (!this.selectionModel.isEmpty()) {
                this.selectionModel.clear();
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (this.addSelection != null) {
                this.addSelection.setEnabled(enabled);
            }
            if (this.addSelection1 != null) {
                this.addSelection1.setEnabled(enabled);
            }
            if (this.addSelection2 != null) {
                this.addSelection2.setEnabled(enabled);
            }
            if (this.removeSelection != null) {
                this.removeSelection.setEnabled(enabled);
            }
        }

        public class MouseHandler
        extends MouseAdapter {
            @Override
            public void mouseClicked(MouseEvent event) {
                Object o;
                if (event.getClickCount() > 1 && (o = SelectionPanel.this.selectionList.getSelectedValue()) instanceof RSelection) {
                    long bt = ((RSelection)o).beginTime;
                    long et = ((RSelection)o).endTime;
                    SelectionPanel.this.selection.setSelection(bt, et);
                    TierSelectionPanel.this.vm.getMasterMediaPlayer().setMediaTime(bt);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                    SelectionPanel.this.handlePopUp(e.getPoint());
                }
            }
        }

        class LabelAction
        extends AbstractAction {
            private Segment segment;

            public LabelAction(Segment segment) {
                super(ElanLocale.getString("Recognizer.SelectionsPanel.SetLabel"));
                this.segment = segment;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String val;
                String initial = "";
                if (this.segment.label != null) {
                    initial = this.segment.label;
                }
                if ((val = (String)JOptionPane.showInputDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.SelectionsPanel.SetLabelDesc"), ElanLocale.getString("Recognizer.SelectionsPanel.SetLabel"), -1, null, null, initial)) != null) {
                    this.segment.label = val;
                }
            }
        }

        class ShapeAction
        extends AbstractAction {
            private VideoSegment segment;

            public ShapeAction(VideoSegment segment) {
                super(ElanLocale.getString("Recognizer.SelectionsPanel.SetShape"));
                this.segment = segment;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String url;
                if (TierSelectionPanel.this.mediaFiles == null || TierSelectionPanel.this.mediaFiles.size() == 0) {
                    JOptionPane.showMessageDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.SelectionsPanel.WarnNoMedia"), ElanLocale.getString("Message.Warning"), 2);
                    return;
                }
                String mediaPathToUse = null;
                if (TierSelectionPanel.this.mediaFiles.size() > 1) {
                    Object[] options = new String[TierSelectionPanel.this.mediaFiles.size()];
                    for (int i = 0; i < TierSelectionPanel.this.mediaFiles.size(); ++i) {
                        String p = (String)TierSelectionPanel.this.mediaFiles.get(i);
                        p = FileUtility.fileNameFromPath(p);
                        options[i] = p;
                    }
                    String sel = (String)JOptionPane.showInputDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.SelectionsPanel.SelectMedia"), "", 3, null, options, options[0]);
                    if (sel != null) {
                        for (int i = 0; i < options.length; ++i) {
                            if (!((String)options[i]).equals(sel)) continue;
                            mediaPathToUse = (String)TierSelectionPanel.this.mediaFiles.get(i);
                            break;
                        }
                    }
                } else {
                    mediaPathToUse = (String)TierSelectionPanel.this.mediaFiles.get(0);
                }
                ElanMediaPlayer player = null;
                if (TierSelectionPanel.this.vm.getMasterMediaPlayer().getMediaDescriptor() != null && (url = ((TierSelectionPanel)TierSelectionPanel.this).vm.getMasterMediaPlayer().getMediaDescriptor().mediaURL) != null && url.endsWith(mediaPathToUse)) {
                    player = TierSelectionPanel.this.vm.getMasterMediaPlayer();
                }
                if (player == null) {
                    List<ElanMediaPlayer> connected = TierSelectionPanel.this.vm.getConnectedMediaPlayers();
                    for (ElanMediaPlayer slayer : connected) {
                        if (slayer.getMediaDescriptor() == null || (url = slayer.getMediaDescriptor().mediaURL) == null || !url.endsWith(mediaPathToUse)) continue;
                        player = slayer;
                        break;
                    }
                }
                if (player == null) {
                    JOptionPane.showMessageDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.SelectionsPanel.WarnNoPlayer"), ElanLocale.getString("Message.Warning"), 2);
                    return;
                }
                if (!(player instanceof VideoFrameGrabber)) {
                    JOptionPane.showMessageDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.SelectionsPanel.WarnNoGrabber"), ElanLocale.getString("Message.Warning"), 2);
                    return;
                }
                ArrayList<Shape> curSh = new ArrayList<Shape>(4);
                if (this.segment.getShape() != null) {
                    curSh.add(this.segment.getShape());
                }
                Graphics2DEditor editor = new Graphics2DEditor(ELANCommandFactory.getRootFrame(TierSelectionPanel.this.vm.getTranscription()), (VideoFrameGrabber)((Object)player), this.segment.beginTime, this.segment.endTime, curSh);
                editor.setVisible(true);
                List<Shape> shapes = editor.getShapes();
                if (shapes != null && !shapes.isEmpty()) {
                    this.segment.setShape(shapes.get(0));
                }
            }
        }
    }
}

