/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.TextParam;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.XMLEscape;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParamIO {
    private final String TIER_NAME = "TierName:";
    private final String SELECTIONS = "Selections";

    public Map<String, Object> read(File f) throws IOException {
        if (f == null) {
            new IOException("Cannot read from file: file is null");
        }
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(false);
            ParamHandler ph = new ParamHandler();
            parserFactory.newSAXParser().parse(f, (DefaultHandler)ph);
            return ph.getParamMap();
        }
        catch (SAXException sax) {
            ClientLogger.LOG.warning("Parsing failed: " + sax.getMessage());
            throw new IOException(sax.getMessage());
        }
        catch (ParserConfigurationException pce) {
            ClientLogger.LOG.warning("Parsing failed: " + pce.getMessage());
            throw new IOException(pce.getMessage());
        }
    }

    public void write(String recognizerID, List<Param> paramList, File f) throws IOException {
        if (f == null) {
            new IOException("Cannot write to file: file is null");
        }
        XMLEscape xmlEscape = new XMLEscape();
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8")));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<PARAM xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"file:avatech-call.xsd\">");
        String timestamp = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ssZ").format(new Date());
        writer.print("<param name=\"InvocationContext\">");
        writer.print(recognizerID != null ? xmlEscape.escape(recognizerID) : "Unknown");
        writer.print(" " + timestamp);
        writer.println("</param>");
        if (paramList != null && paramList.size() > 0) {
            for (Param p : paramList) {
                String path;
                writer.print("<param name=\"" + p.id + "\">");
                if (p instanceof NumParam) {
                    writer.print(((NumParam)p).current);
                } else if (p instanceof TextParam) {
                    String value;
                    if (((TextParam)p).curValue != null && (value = ((TextParam)p).curValue) != null && value.length() > 0) {
                        writer.print(xmlEscape.escape(value));
                    }
                } else if (p instanceof FileParam && (path = ((FileParam)p).filePath) != null && path.length() > 0) {
                    if (path.startsWith("file:")) {
                        path = path.substring(5);
                    }
                    writer.print(xmlEscape.escape(path));
                }
                writer.println("</param>");
            }
        }
        writer.println("</PARAM>");
        writer.close();
    }

    public void writeParamFile(String recognizerID, Map<String, Object> paramMap, File f) throws IOException {
        if (f == null) {
            new IOException("Cannot write to file: file is null");
        }
        XMLEscape xmlEscape = new XMLEscape();
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8")));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<PARAM xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"file:avatech-call.xsd\">");
        String timestamp = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ssZ").format(new Date());
        writer.print("<param name=\"InvocationContext\">");
        writer.print(recognizerID != null ? xmlEscape.escape(recognizerID) : "Unknown");
        writer.print(" " + timestamp);
        writer.println("</param>");
        if (paramMap != null && paramMap.size() > 0) {
            String key2 = null;
            Object val = null;
            for (String key2 : paramMap.keySet()) {
                val = paramMap.get(key2);
                writer.print("<param name=\"" + key2 + "\">");
                if (val instanceof String) {
                    writer.print(xmlEscape.escape((String)val));
                } else if (val instanceof Float) {
                    writer.print((Float)val);
                } else if (val instanceof Double) {
                    writer.print((Double)val);
                } else if (val instanceof HashMap) {
                    for (String k : ((HashMap)val).keySet()) {
                        Object obj = ((HashMap)val).get(k);
                        if (obj instanceof String) {
                            if (k.equals("TierName")) {
                                writer.print("TierName:" + xmlEscape.escape(obj.toString()));
                                continue;
                            }
                            writer.print(xmlEscape.escape(obj.toString()));
                            continue;
                        }
                        writer.print("Selections");
                    }
                }
                writer.println("</param>");
            }
        }
        writer.println("</PARAM>");
        writer.close();
    }

    class ParamHandler
    extends DefaultHandler {
        private String curContent = "";
        private String curName = null;
        private HashMap<String, Object> curMap = null;
        private final String PARAM = "param";
        private final String NAME = "name";
        private Map<String, Object> params = new HashMap<String, Object>();

        public Map<String, Object> getParamMap() {
            return this.params;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.curContent = this.curContent + new String(ch, start, length);
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            if (name.equals("param")) {
                this.curName = attributes.getValue("name");
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("param")) {
                this.curContent = this.curContent.trim();
                if (this.curContent.startsWith("TierName:")) {
                    this.curMap = new HashMap();
                    this.curMap.put("TierName", this.curContent.substring("TierName:".length()));
                } else if (this.curContent.startsWith("Selections")) {
                    this.curMap = new HashMap();
                    this.curMap.put("Selections", null);
                }
                if (this.curMap != null) {
                    this.params.put(this.curName, this.curMap);
                } else {
                    this.curContent = this.curContent.trim();
                    this.params.put(this.curName, this.curContent);
                }
                this.curContent = "";
                this.curMap = null;
            }
        }
    }
}

