/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.data.SelectionComparator;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.MutableInt;
import mpi.eudico.util.TimeFormatter;

public class RecTierWriter {
    private boolean writeInNewFormat = false;
    private final String SC = ";";

    public void setNewTierFormat(boolean newFormat) {
        this.writeInNewFormat = newFormat;
    }

    public void write(File outputFile, List<RSelection> segments) throws IOException {
        String outName;
        if (outputFile == null) {
            new IOException("Cannot write to file: file is null");
        }
        boolean xmlOut = !(outName = outputFile.getName().toLowerCase()).endsWith("csv") && !outName.endsWith("txt");
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));
        if (xmlOut) {
            if (this.writeInNewFormat) {
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.print("<TIERS xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
                writer.print("xsi:noNamespaceSchemaLocation=\"file:avatech-tiers.xsd\">");
                writer.println("<TIER ");
            } else {
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.print("<TIER xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
                writer.print("xsi:noNamespaceSchemaLocation=\"file:avatech-tier.xsd\" ");
            }
            writer.println("columns=\"tier_1\">");
        } else {
            writer.println("\"#starttime\";\"#endtime\";\"tier_1\"");
        }
        if (segments != null && segments.size() > 0) {
            for (int i = 0; i < segments.size(); ++i) {
                this.writeSpan(writer, segments.get(i), xmlOut);
            }
        }
        if (xmlOut) {
            writer.println("</TIER>");
            if (this.writeInNewFormat) {
                writer.println("</TIERS>");
            }
        }
        writer.close();
    }

    public void write(File outputFile, List<Segmentation> segments, Transcription trans) throws IOException {
        String outName;
        boolean xmlOut;
        if (outputFile == null) {
            new IOException("Cannot write to file: file is null");
        }
        if (segments != null && segments.size() > 0) {
            new IOException("No Sements available.");
        }
        boolean bl = xmlOut = !(outName = outputFile.getName().toLowerCase()).endsWith("csv") && !outName.endsWith("txt");
        if (!xmlOut || !this.writeInNewFormat) {
            this.writeInOldFormat(outputFile, segments, xmlOut);
        } else {
            this.writeInNewFormat(outputFile, segments, trans);
        }
    }

    private void writeSpan(PrintWriter writer, RSelection sel, boolean xmlOut) {
        if (xmlOut) {
            writer.print("\t<span start=\"" + TimeFormatter.toSSMSString(sel.beginTime) + "\" ");
            writer.print("end=\"" + TimeFormatter.toSSMSString(sel.endTime) + "\">");
            writer.print("<v>");
            if (sel instanceof Segment && ((Segment)sel).label != null) {
                writer.print(((Segment)sel).label);
            }
            writer.print("</v>");
            writer.println("</span>");
        } else {
            writer.print(TimeFormatter.toSSMSString(sel.beginTime) + ";");
            writer.print(TimeFormatter.toSSMSString(sel.endTime) + ";");
            if (sel instanceof Segment && ((Segment)sel).label != null) {
                writer.print("\"" + ((Segment)sel).label.trim() + "\"");
                writer.println();
            } else {
                writer.println();
            }
        }
    }

    private void writeInNewFormat(File outputFile, List<Segmentation> tiers, Transcription trans) throws IOException {
        int numTiers = tiers.size();
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.print("<TIERS xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        writer.println("xsi:noNamespaceSchemaLocation=\"file:avatech-tiers.xsd\"> ");
        if (numTiers > 1) {
            List selList;
            HashMap tierMap = new HashMap();
            HashMap selMap = new HashMap();
            HashMap spanValueMap = new HashMap();
            ArrayList<String> parentTiers = new ArrayList<String>();
            TierImpl tier = null;
            for (int i = 0; i < tiers.size(); ++i) {
                ArrayList<String> values;
                String parentName;
                tier = (TierImpl)trans.getTierWithId(tiers.get(i).getName());
                if (tier == null) continue;
                if (tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().getStereoType() == 4) {
                    TierImpl parentTier;
                    for (parentTier = tier.getParentTier(); parentTier != null && parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4; parentTier = parentTier.getParentTier()) {
                    }
                    parentName = parentTier.getName();
                } else {
                    parentName = tier.getName();
                }
                if (!parentTiers.contains(parentName)) {
                    parentTiers.add(parentName);
                    tierMap.put(parentName, new ArrayList());
                    selMap.put(parentName, new ArrayList());
                    spanValueMap.put(parentName, new HashMap());
                }
                ((List)tierMap.get(parentName)).add(tier.getName());
                selList = (List)selMap.get(parentName);
                Map spanMap = (Map)spanValueMap.get(parentName);
                ArrayList<RSelection> tempList = tiers.get(i).getSegments();
                for (RSelection sel : selList) {
                    values = (ArrayList<String>)spanMap.get(sel);
                    if (tempList.contains(sel)) {
                        int index = tempList.indexOf(sel);
                        values.add(((Segment)tempList.get((int)index)).label);
                        tempList.remove(index);
                        continue;
                    }
                    values.add(null);
                }
                for (RSelection sel : tempList) {
                    selList.add(sel);
                    values = new ArrayList<String>();
                    for (int n = 0; n < ((List)tierMap.get(parentName)).size() - 1; ++n) {
                        values.add(null);
                    }
                    values.add(((Segment)sel).label);
                    spanMap.put(sel, values);
                }
            }
            Iterator it = tierMap.entrySet().iterator();
            it = tierMap.entrySet().iterator();
            SelectionComparator comparator = new SelectionComparator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String parentName = (String)entry.getKey();
                List tierList = (List)entry.getValue();
                int numColumns = tierList.size();
                writer.print("\t<TIER columns=\"");
                for (String t : tierList) {
                    writer.print(t.replaceAll(" ", "_"));
                    if (numColumns <= 1) continue;
                    writer.print(" ");
                }
                writer.println("\">");
                selList = (List)selMap.get(parentName);
                Collections.sort(selList, comparator);
                Map spanMap = (Map)spanValueMap.get(parentName);
                for (RSelection sel : selList) {
                    List values = (List)spanMap.get(sel);
                    if (values == null) continue;
                    writer.print("\t\t<span start=\"" + TimeFormatter.toSSMSString(sel.beginTime) + "\" ");
                    writer.print("end=\"" + TimeFormatter.toSSMSString(sel.endTime) + "\">");
                    for (String val : values) {
                        writer.print("<v>");
                        if (val != null) {
                            writer.print(val);
                        }
                        writer.print("</v>");
                    }
                    for (int x = values.size(); x < tierList.size(); ++x) {
                        writer.print("<v></v>");
                    }
                    writer.println("</span>");
                }
                writer.println("\t</TIER>");
            }
        } else {
            writer.println("\t<TIER columns=\"" + tiers.get(0).getName() + "\">");
            for (RSelection sel : tiers.get(0).getSegments()) {
                writer.print("\t\t<span start=\"" + TimeFormatter.toSSMSString(sel.beginTime) + "\" ");
                writer.print("end=\"" + TimeFormatter.toSSMSString(sel.endTime) + "\">");
                writer.print("<v>");
                if (sel instanceof Segment && ((Segment)sel).label != null) {
                    writer.print(((Segment)sel).label);
                }
                writer.print("</v>");
                writer.println("</span>");
            }
            writer.println("\t</TIER>");
        }
        writer.print("</TIERS>");
        writer.close();
    }

    private void writeInOldFormat(File outputFile, List<Segmentation> tiers, boolean xmlOut) throws IOException {
        int numTiers = 0;
        int numColumns = 1;
        HashMap<RSelection, MutableInt> selMap = null;
        numTiers = tiers.size();
        if (numTiers > 1) {
            selMap = new HashMap<RSelection, MutableInt>();
            Segmentation seg = tiers.get(0);
            for (RSelection sel : seg.getSegments()) {
                selMap.put(sel, new MutableInt(1));
            }
            for (int i = 1; i < tiers.size(); ++i) {
                seg = tiers.get(i);
                for (RSelection sel : seg.getSegments()) {
                    Iterator keyIt = selMap.keySet().iterator();
                    boolean found = false;
                    while (keyIt.hasNext()) {
                        RSelection key = (RSelection)keyIt.next();
                        if (key.beginTime != sel.beginTime || key.endTime != sel.endTime) continue;
                        found = true;
                        ++((MutableInt)selMap.get((Object)key)).intValue;
                        break;
                    }
                    if (found) continue;
                    selMap.put(sel, new MutableInt(1));
                }
            }
            int numKeys = selMap.size();
            int numOccur = 0;
            Iterator iter = selMap.values().iterator();
            while (iter.hasNext()) {
                numOccur += ((MutableInt)iter.next()).intValue;
            }
            if (numKeys > 0 && (double)((float)numOccur / (float)numKeys) >= 1.5) {
                numColumns = numTiers;
            }
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));
        if (xmlOut) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.print("<TIER xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            writer.print("xsi:noNamespaceSchemaLocation=\"file:avatech-tier.xsd\" ");
            writer.print("columns=\"");
        } else {
            writer.print("\"#starttime\";\"#endtime\";");
        }
        if (numColumns == 1) {
            if (xmlOut) {
                if (tiers.size() > 0) {
                    writer.println("all_tiers\">");
                } else {
                    writer.print(tiers.get(0).getName().replaceAll(" ", "_"));
                    writer.println("\">");
                }
            } else if (tiers.size() > 0) {
                writer.println("\"all_tiers\"");
            } else {
                writer.print("\"" + tiers.get(0).getName() + "\"");
                writer.println();
            }
            ArrayList<RSelection> segs = new ArrayList<RSelection>();
            for (Segmentation s : tiers) {
                segs.addAll(s.getSegments());
            }
            Collections.sort(segs, new SelectionComparator());
            for (int i = 0; i < segs.size(); ++i) {
                this.writeSpan(writer, (RSelection)segs.get(i), xmlOut);
            }
        } else if (numColumns > 1) {
            for (int i = 0; i < numColumns; ++i) {
                if (xmlOut) {
                    writer.print(tiers.get(i).getName().replaceAll(" ", "_"));
                } else {
                    writer.print("\"" + tiers.get(i).getName() + "\"");
                }
                if (i == numColumns - 1) continue;
                if (xmlOut) {
                    writer.print(" ");
                    continue;
                }
                writer.print(";");
            }
            if (xmlOut) {
                writer.println("\">");
            } else {
                writer.println();
            }
            ArrayList segs = new ArrayList(selMap.size());
            segs.addAll(selMap.keySet());
            Collections.sort(segs, new SelectionComparator());
            int[] counters = new int[numTiers];
            Arrays.fill(counters, 0);
            for (int i = 0; i < segs.size(); ++i) {
                RSelection iter = (RSelection)segs.get(i);
                if (xmlOut) {
                    writer.print("\t<span start=\"" + TimeFormatter.toSSMSString(iter.beginTime) + "\" ");
                    writer.print("end=\"" + TimeFormatter.toSSMSString(iter.endTime) + "\">");
                } else {
                    writer.print(TimeFormatter.toSSMSString(iter.beginTime) + ";");
                    writer.print(TimeFormatter.toSSMSString(iter.endTime) + ";");
                }
                for (int j = 0; j < numTiers; ++j) {
                    Segmentation curTier = tiers.get(j);
                    ArrayList<RSelection> curSelList = curTier.getSegments();
                    if (counters[j] < curSelList.size()) {
                        RSelection curSel = (RSelection)curSelList.get(counters[j]);
                        if (curSel.beginTime == iter.beginTime && curSel.endTime == iter.endTime) {
                            if (curSel instanceof Segment && ((Segment)curSel).label != null) {
                                if (xmlOut) {
                                    writer.print("<v>" + ((Segment)curSel).label + "</v>");
                                } else {
                                    writer.print("\"" + ((Segment)curSel).label + "\"");
                                }
                            } else if (xmlOut) {
                                writer.print("<v></v>");
                            }
                            int n = j;
                            counters[n] = counters[n] + 1;
                        } else if (xmlOut) {
                            writer.print("<v></v>");
                        }
                    } else if (xmlOut) {
                        writer.print("<v></v>");
                    }
                    if (xmlOut || j >= numTiers - 1) continue;
                    writer.print(";");
                }
                if (xmlOut) {
                    writer.println("</span>");
                    continue;
                }
                writer.println();
            }
        }
        if (xmlOut) {
            writer.println("</TIER>");
        }
        writer.close();
    }

    public void write(File outputFile, List<Segmentation> tiers, boolean includeSelections, boolean xmlOut) throws IOException {
        int i;
        int numTiers = 0;
        int numColumns = 1;
        HashMap<RSelection, MutableInt> selMap = null;
        numTiers = tiers.size();
        if (numTiers > 1) {
            selMap = new HashMap<RSelection, MutableInt>();
            Segmentation seg = tiers.get(0);
            for (RSelection sel : seg.getSegments()) {
                selMap.put(sel, new MutableInt(1));
            }
            for (i = 1; i < tiers.size(); ++i) {
                seg = tiers.get(i);
                for (RSelection sel : seg.getSegments()) {
                    Iterator keyIt = selMap.keySet().iterator();
                    boolean found = false;
                    while (keyIt.hasNext()) {
                        RSelection key = (RSelection)keyIt.next();
                        if (key.beginTime != sel.beginTime || key.endTime != sel.endTime) continue;
                        found = true;
                        ++((MutableInt)selMap.get((Object)key)).intValue;
                        break;
                    }
                    if (found) continue;
                    selMap.put(sel, new MutableInt(1));
                }
            }
            int numKeys = selMap.size();
            int numOccur = 0;
            Iterator iter = selMap.values().iterator();
            while (iter.hasNext()) {
                numOccur += ((MutableInt)iter.next()).intValue;
            }
            if (numKeys > 0 && (double)((float)numOccur / (float)numKeys) >= 1.5) {
                numColumns = numTiers;
            }
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));
        if (xmlOut) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.print("<TIER xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            writer.print("xsi:noNamespaceSchemaLocation=\"file:avatech-tier.xsd\" ");
            writer.print("columns=\"");
        } else {
            writer.print("\"#starttime\";\"#endtime\";");
        }
        if (numColumns > 1) {
            for (int i2 = 0; i2 < numColumns; ++i2) {
                if (xmlOut) {
                    writer.print(tiers.get(i2).getName().replaceAll(" ", "_"));
                } else {
                    writer.print("\"" + tiers.get(i2).getName() + "\"");
                }
                if (i2 == numColumns - 1) continue;
                if (xmlOut) {
                    writer.print(" ");
                    continue;
                }
                writer.print(";");
            }
            if (xmlOut) {
                writer.println("\">");
            } else {
                writer.println();
            }
        } else if (xmlOut) {
            if (tiers.size() > 0) {
                writer.println("all_tiers\">");
            } else {
                writer.println("tier_1\">");
            }
        } else if (tiers.size() > 0) {
            writer.println("\"all_tiers\"");
        } else {
            writer.println("\"tier_1\"");
        }
        if (numColumns == 1) {
            ArrayList<RSelection> segs = new ArrayList<RSelection>();
            for (Segmentation s : tiers) {
                segs.addAll(s.getSegments());
            }
            Collections.sort(segs, new SelectionComparator());
            for (i = 0; i < segs.size(); ++i) {
                RSelection iter = (RSelection)segs.get(i);
            }
        } else if (numColumns > 1) {
            ArrayList segs = new ArrayList(selMap.size());
            segs.addAll(selMap.keySet());
            Collections.sort(segs, new SelectionComparator());
            int[] counters = new int[numTiers];
            Arrays.fill(counters, 0);
            for (int i3 = 0; i3 < segs.size(); ++i3) {
                RSelection iter = (RSelection)segs.get(i3);
                if (xmlOut) {
                    writer.print("\t<span start=\"" + TimeFormatter.toSSMSString(iter.beginTime) + "\" ");
                    writer.print("end=\"" + TimeFormatter.toSSMSString(iter.endTime) + "\">");
                } else {
                    writer.print(TimeFormatter.toSSMSString(iter.beginTime) + ";");
                    writer.print(TimeFormatter.toSSMSString(iter.endTime) + ";");
                }
                for (int j = 0; j < numTiers; ++j) {
                    Segmentation curTier = tiers.get(j);
                    ArrayList<RSelection> curSelList = curTier.getSegments();
                    if (counters[j] < curSelList.size()) {
                        RSelection curSel = (RSelection)curSelList.get(counters[j]);
                        if (curSel.beginTime == iter.beginTime && curSel.endTime == iter.endTime) {
                            if (curSel instanceof Segment && ((Segment)curSel).label != null) {
                                if (xmlOut) {
                                    writer.print("<v>" + ((Segment)curSel).label + "</v>");
                                } else {
                                    writer.print("\"" + ((Segment)curSel).label + "\"");
                                }
                            } else if (xmlOut) {
                                writer.print("<v></v>");
                            }
                            int n = j;
                            counters[n] = counters[n] + 1;
                        } else if (xmlOut) {
                            writer.print("<v></v>");
                        }
                    } else if (xmlOut) {
                        writer.print("<v></v>");
                    }
                    if (xmlOut || j >= numTiers - 1) continue;
                    writer.print(";");
                }
                if (xmlOut) {
                    writer.println("</span>");
                    continue;
                }
                writer.println();
            }
        }
        if (xmlOut) {
            writer.println("</TIER>");
        }
        writer.close();
    }
}

