/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.model;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mpi.eudico.client.annotator.search.model.EAFType;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.search.SearchLocale;

public class ElanType
extends EAFType {
    private Map<String, Locale> langHash = new HashMap<String, Locale>();
    private final TranscriptionImpl transcription;

    public ElanType(TranscriptionImpl transcription) {
        this.transcription = transcription;
        List<TierImpl> tierVector = transcription.getTiers();
        this.tierNames = new String[tierVector.size()];
        for (int i = 0; i < tierVector.size(); ++i) {
            TierImpl tier = tierVector.get(i);
            this.tierNames[i] = tier.getName();
            Locale loc = tier.getDefaultLocale();
            if (loc == null) continue;
            this.langHash.put(this.tierNames[i], loc);
        }
    }

    @Override
    public List<CVEntry> getClosedVoc(String tierName) {
        TierImpl tier = this.transcription.getTierWithId(tierName);
        String cvName = tier.getLinguisticType().getControlledVocabularyName();
        ControlledVocabulary cv = this.transcription.getControlledVocabulary(cvName);
        return cv != null ? Arrays.asList(cv.getEntries()) : null;
    }

    @Override
    public boolean isClosedVoc(String tierName) {
        TierImpl tier = this.transcription.getTierWithId(tierName);
        if (tier == null) {
            return false;
        }
        String cvName = tier.getLinguisticType().getControlledVocabularyName();
        return this.transcription.getControlledVocabulary(cvName) != null;
    }

    @Override
    public Locale getDefaultLocale(String tierName) {
        return this.langHash.get(tierName);
    }

    @Override
    public String[] getPossibleUnitsFor(String tierName1, String tierName2) {
        ArrayList<CallSite> commonAncestors = new ArrayList<CallSite>();
        String[] possibleUnits = new String[]{};
        TierImpl tier1 = this.transcription.getTierWithId(tierName1);
        TierImpl tier2 = this.transcription.getTierWithId(tierName2);
        TierImpl loopTier = tier1;
        do {
            if (!loopTier.equals(tier2) && !tier2.hasAncestor(loopTier)) continue;
            commonAncestors.add((CallSite)((Object)(loopTier.getName() + " " + SearchLocale.getString("Search.Annotation_PL"))));
        } while ((loopTier = loopTier.getParentTier()) != null);
        possibleUnits = commonAncestors.toArray(new String[0]);
        this.standardUnit = possibleUnits.length > 0 ? (String)commonAncestors.get(0) : null;
        return possibleUnits;
    }

    @Override
    public String[] getRelatedTiers(String tierName) {
        String[] relatedTiers = new String[]{};
        try {
            TierImpl tier = this.transcription.getTierWithId(tierName);
            TierImpl rootTier = tier.getRootTier();
            List<TierImpl> dependentTiers = rootTier.getDependentTiers();
            relatedTiers = new String[dependentTiers.size() + 1];
            relatedTiers[0] = rootTier.getName();
            for (int i = 0; i < dependentTiers.size(); ++i) {
                relatedTiers[i + 1] = dependentTiers.get(i).getName();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return relatedTiers;
    }

    public Transcription getTranscription() {
        return this.transcription;
    }
}

