/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.eudico.client.annotator.search.model.FASTSearchHandler;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.model.ProgressListener;
import mpi.search.model.SearchEngine;
import mpi.search.query.model.Query;
import org.xml.sax.helpers.DefaultHandler;

public class FASTSearchEngine
implements SearchEngine {
    private final ProgressListener progressListener;
    private final xmlParserThreadExecutor threadPool;

    public FASTSearchEngine(ProgressListener p) {
        this.progressListener = p;
        this.threadPool = xmlParserThreadExecutor.newThreadPool();
    }

    public void closeEngine() {
        this.threadPool.shutdown();
    }

    @Override
    public void performSearch(Query query) throws Exception {
        File[] files = ((ContentQuery)query).getFiles();
        this.threadPool.newQuery((ContentQuery)query);
        AnchorConstraint search = ((ContentQuery)query).getAnchorConstraint();
        AtomicInteger pendingTasks = new AtomicInteger();
        try {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                pendingTasks.incrementAndGet();
                this.threadPool.execute(new xmlParserTask(file, search, pendingTasks));
                if (this.progressListener == null || files.length == i + 1) continue;
                this.progressListener.setProgress((int)((double)(i + 1) * 100.0 / (double)files.length));
            }
            while (pendingTasks.get() != 0) {
                Thread.sleep(5L);
            }
            if (this.progressListener != null) {
                this.progressListener.setProgress(100);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private static class xmlParserThreadExecutor
    extends ThreadPoolExecutor {
        private ContentQuery query = null;

        public xmlParserThreadExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        public static xmlParserThreadExecutor newThreadPool() {
            int numThreads = Runtime.getRuntime().availableProcessors() * 2;
            xmlParserThreadExecutor threadpool = new xmlParserThreadExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(numThreads), new xmlParserThreadFactory());
            threadpool.setRejectedExecutionHandler(new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    try {
                        executor.getQueue().put(r);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            return threadpool;
        }

        public void newQuery(ContentQuery q) {
            this.query = q;
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            ((xmlParserTask)r).setSAXParser(((xmlParserThread)t).getSAXParser());
            if (((xmlParserThread)t).getHandler() == null || !((xmlParserThread)t).getHandler().getQuery().equals(this.query) || !((xmlParserThread)t).getHandler().getQuery().getResult().equals(this.query.getResult())) {
                ((xmlParserThread)t).setHandler(new FASTSearchHandler(this.query));
            }
            ((xmlParserTask)r).setHandler(((xmlParserThread)t).getHandler());
        }

        private static class xmlParserThreadFactory
        implements ThreadFactory {
            private final SAXParserFactory factory = SAXParserFactory.newInstance();
            private Integer numThreadsCreated = 0;

            public xmlParserThreadFactory() {
                this.factory.setValidating(false);
                this.factory.setNamespaceAware(false);
            }

            @Override
            public Thread newThread(Runnable r) {
                SAXParser p;
                try {
                    p = this.factory.newSAXParser();
                }
                catch (Exception e) {
                    System.out.println("XML Factory error: " + e.toString());
                    return null;
                }
                this.numThreadsCreated = this.numThreadsCreated + 1;
                return new xmlParserThread(r, p, this.numThreadsCreated);
            }
        }

        private static class xmlParserThread
        extends Thread {
            private final SAXParser saxParser;
            private FASTSearchHandler handler = null;

            public xmlParserThread(Runnable r, SAXParser p, Integer id) {
                super(null, r, "xmlParserThread-" + id);
                this.saxParser = p;
            }

            public SAXParser getSAXParser() {
                return this.saxParser;
            }

            public FASTSearchHandler getHandler() {
                return this.handler;
            }

            public void setHandler(FASTSearchHandler h) {
                this.handler = h;
            }
        }
    }

    private static class xmlParserTask
    implements Runnable {
        private final File file;
        private final AtomicInteger pendingTasks;
        private final AnchorConstraint search;
        private SAXParser saxParser;
        private FASTSearchHandler handler;

        public xmlParserTask(File f, AnchorConstraint s, AtomicInteger c) {
            this.file = f;
            this.search = s;
            this.pendingTasks = c;
        }

        public void setSAXParser(SAXParser s) {
            this.saxParser = s;
        }

        public void setHandler(FASTSearchHandler h) {
            this.handler = h;
        }

        @Override
        public void run() {
            try {
                byte[] fileContents = this.preFetch(this.file);
                if (this.fullTextSearch(fileContents, this.search)) {
                    this.handler.newFile(this.file);
                    this.saxParser.parse((InputStream)new ByteArrayInputStream(fileContents), (DefaultHandler)this.handler);
                }
                this.pendingTasks.decrementAndGet();
            }
            catch (Exception e) {
                System.out.println("xmlParserThread (ID:" + Thread.currentThread().getId() + ") error: " + e.toString());
                this.pendingTasks.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] preFetch(File file) {
            FileInputStream reader = null;
            byte[] fileContents = new byte[(int)file.length()];
            try {
                reader = new FileInputStream(file);
                reader.read(fileContents);
            }
            catch (Exception e) {
                System.out.println("Error in reading file:" + e.toString());
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        System.out.println("Error in closing file:" + e.toString());
                    }
                }
            }
            return fileContents;
        }

        private boolean fullTextSearch(byte[] fileContents, AnchorConstraint search) {
            if (!search.isRegEx() && search.isCaseSensitive()) {
                String str = new String(fileContents);
                return str.indexOf(search.getPattern()) >= 0;
            }
            return true;
        }
    }
}

