/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.result.viewer;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.grid.AbstractEditableGridViewer;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.search.result.viewer.EAFResultViewerGridRenderer;
import mpi.eudico.client.annotator.search.result.viewer.EAFResultViewerPopupMenu;
import mpi.eudico.client.annotator.search.result.viewer.EAFResultViewerTableModel;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.util.AnnotationValueComparator;
import mpi.eudico.util.EmptyStringComparator;
import mpi.eudico.util.IntStringComparator;
import mpi.eudico.util.TimeStringComparator;
import mpi.search.content.result.model.ContentMatch;
import mpi.search.content.result.model.ContentResult;
import mpi.search.result.model.Result;
import mpi.search.result.model.ResultEvent;
import mpi.search.result.viewer.ResultViewer;

public class ElanResultViewer
extends AbstractEditableGridViewer
implements ResultViewer,
ListDataListener {
    private ContentResult result;
    private TableRowSorter<EAFResultViewerTableModel> rowSorter;

    public ElanResultViewer() {
        super(new AnnotationTable(new EAFResultViewerTableModel()));
        this.rowSorter = new TableRowSorter<EAFResultViewerTableModel>((EAFResultViewerTableModel)this.table.getModel());
        EmptyStringComparator emptyComp = new EmptyStringComparator();
        IntStringComparator indexComparator = new IntStringComparator();
        AnnotationValueComparator annValComp = new AnnotationValueComparator();
        TimeStringComparator timeComp = new TimeStringComparator();
        this.rowSorter.setComparator(1, indexComparator);
        this.rowSorter.setComparator(2, emptyComp);
        this.rowSorter.setComparator(3, emptyComp);
        this.rowSorter.setComparator(4, annValComp);
        this.rowSorter.setComparator(5, annValComp);
        this.rowSorter.setComparator(6, annValComp);
        this.rowSorter.setComparator(7, annValComp);
        this.rowSorter.setComparator(8, emptyComp);
        this.rowSorter.setComparator(9, timeComp);
        this.rowSorter.setComparator(10, timeComp);
        this.rowSorter.setComparator(11, timeComp);
        this.table.setRowSorter(this.rowSorter);
    }

    @Override
    public void setViewerManager(ViewerManager2 viewerManager) {
        super.setViewerManager(viewerManager);
        if (viewerManager != null) {
            this.preferencesChanged();
        }
    }

    @Override
    protected TableCellRenderer createTableCellRenderer() {
        return new EAFResultViewerGridRenderer(this, this.dataModel);
    }

    public void setColumnVisible(String columnName, boolean visible) {
        this.table.setColumnVisible(columnName, visible);
    }

    public void setData(List<? extends AnnotationCore> list) {
        this.updateDataModel(list);
        this.updateSelection();
        this.doUpdate();
    }

    @Override
    protected void doUpdate() {
        this.checkScroll();
        this.repaint();
    }

    private void checkScroll() {
        Annotation ac = this.getActiveAnnotation();
        if (ac != null) {
            int modelRow = this.table.getModel().getRowForAnnotation(ac);
            if (modelRow > -1) {
                Rectangle viewRect;
                int viewRow = this.table.convertRowIndexToView(modelRow);
                Rectangle rowRect = this.table.getCellRect(viewRow, 0, true);
                if (this.table.getParent() instanceof JScrollPane && !(viewRect = ((JScrollPane)this.table.getParent()).getViewport().getViewRect()).contains(rowRect)) {
                    rowRect.height = viewRect.height - rowRect.height;
                }
                this.table.scrollRectToVisible(rowRect);
            }
        } else {
            this.table.repaint();
        }
    }

    @Override
    public void resultChanged(ResultEvent e) {
        this.result = (ContentResult)e.getSource();
        if (this.result.getRealSize() == 0) {
            this.reset();
        }
        if (e.getType() == 1 && this.result.getStatus() == 0) {
            this.result.addListDataListener(this);
        }
    }

    @Override
    public void showResult(Result result) {
        this.result = (ContentResult)result;
        this.setData(result.getMatches());
    }

    @Override
    public void reset() {
        this.setData(new ArrayList(0));
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.dataModel.updateAnnotations(this.result.getSubList());
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
            this.dataModel.addAnnotation((ContentMatch)this.result.getElementAt(i));
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void updateLocale() {
        super.updateLocale();
        this.popup = new EAFResultViewerPopupMenu(this.table);
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        if (this.result == null || this.result.getTierNames().length == 0) {
            return;
        }
        block1 : switch (e.getOperation()) {
            case 0: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 14: {
                this.repaint();
                break;
            }
            case 2: {
                TierImpl tierImpl = (TierImpl)e.getInvalidatedObject();
            }
            case 1: {
                TierImpl changedTier = (TierImpl)e.getModification();
                for (int i = 0; i < this.result.getTierNames().length; ++i) {
                    try {
                        if (!this.result.getTierNames()[i].equals(changedTier.getName())) continue;
                        this.result.reset();
                        break block1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
            default: {
                super.ACMEdited(e);
            }
        }
    }
}

