/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.viewer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.CtrlWCloseAction;
import mpi.eudico.client.annotator.gui.HTMLViewer;
import mpi.eudico.client.annotator.search.viewer.ElanSearchPanel;
import mpi.eudico.client.annotator.util.WindowLocationAndSizeManager;
import mpi.search.SearchLocale;
import mpi.search.content.viewer.AbstractComplexSearchFrame;

public class ElanSearchFrame
extends AbstractComplexSearchFrame {
    public ElanSearchFrame(ViewerManager2 viewerManager) {
        super(new ElanSearchPanel(viewerManager));
        try {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN16.png"));
            this.setIconImage(icon.getImage());
        }
        catch (Throwable t) {
            this.setIconImage(null);
        }
        JMenu editMenu = new JMenu(SearchLocale.getString("SearchDialog.Edit"));
        editMenu.add(ELANCommandFactory.getUndoCA(viewerManager.getTranscription()));
        editMenu.add(ELANCommandFactory.getRedoCA(viewerManager.getTranscription()));
        editMenu.addSeparator();
        editMenu.add(((ElanSearchPanel)this.searchPanel).replaceAction);
        ((ElanSearchPanel)this.searchPanel).replaceAction.setEnabled(false);
        Container c = this.getToolBar(this.searchPanel);
        if (c instanceof JToolBar) {
            ((JToolBar)c).addSeparator();
            ((JToolBar)c).add(((ElanSearchPanel)this.searchPanel).replaceAction);
        }
        this.getJMenuBar().add((Component)editMenu, 1);
        this.pack();
        Rectangle bounds = Preferences.getRect("SearchAndReplaceFrame.Bounds", null);
        if (bounds == null) {
            this.setSize(660, 600);
            this.setLocationRelativeTo(this.getParent());
        } else {
            this.setBounds(bounds);
        }
        this.validate();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                Preferences.set("SearchAndReplaceFrame.Bounds", we.getWindow().getBounds(), null);
                ((ElanSearchPanel)ElanSearchFrame.this.searchPanel).close();
            }
        });
        this.addCloseActions();
        this.setVisible(true);
    }

    protected void addCloseActions() {
        CtrlWCloseAction wAction = new CtrlWCloseAction(this);
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        if (inputMap instanceof ComponentInputMap && actionMap != null) {
            String wcl = "cw";
            inputMap.put((KeyStroke)wAction.getValue("AcceleratorKey"), wcl);
            actionMap.put(wcl, wAction);
        }
    }

    protected Container getToolBar(Container container) {
        Component c = null;
        Container c2 = null;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            c = container.getComponent(i);
            if (c instanceof JToolBar) {
                return (Container)c;
            }
            if (!(c instanceof Container) || !((c2 = this.getToolBar((Container)c)) instanceof JToolBar)) continue;
            return c2;
        }
        return null;
    }

    @Override
    protected void showInfoDialog() {
        try {
            HTMLViewer viewer = new HTMLViewer("/mpi/eudico/client/annotator/resources/SearchHelp.html", false, "Search Info");
            final JDialog infoDialog = viewer.createHTMLDialog(this);
            infoDialog.pack();
            infoDialog.setSize(600, 400);
            WindowLocationAndSizeManager.postInit(infoDialog, "SearchHelpDialog");
            infoDialog.setVisible(true);
            infoDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    WindowLocationAndSizeManager.storeLocationAndSizePreferences(infoDialog, "SearchHelpDialog");
                }
            });
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to load the Search help file " + ioe.getMessage(), "Warning", 2, null);
        }
    }
}

