/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.EditTypeDialog2;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public abstract class AbstractDestTierAndTypeSpecStepPane
extends StepPane
implements ListSelectionListener,
ActionListener,
KeyListener {
    private JLabel tierNameDesLabel;
    private JLabel decideRootOrChildLabel;
    private JLabel lingTypeLabel;
    private JLabel destTypeLabel;
    private JLabel typeDesLabel;
    private JScrollPane lingTypeTableScrollPane;
    private JPanel destinationTierConfigurationPanel;
    private ButtonGroup rootChildButtonGroup;
    private JTextField newTierNameField;
    private JTable linguisticTypeTable;
    private Insets globalInset = new Insets(5, 10, 5, 10);
    private Insets singleTabInset = new Insets(0, 30, 0, 10);
    private TreeSet<String> tierSet;
    protected JRadioButton rootTierRB;
    protected JRadioButton childTierRB;
    protected JComboBox parentTierCB;
    protected JCheckBox hideTypesWithCVCB;
    protected JButton createTypesButton;
    protected CreateTypeDialog createTypeDialog;
    private TranscriptionImpl transcription;
    protected List<String> rootTierTypeNames;
    protected List<String> childTierTypeNames;
    protected List<String> newRootTypeList;
    protected List<String> newChildypeList;
    protected List<String> completeTypeNamesList;
    private boolean validName = true;
    private boolean validType = true;
    private boolean multiFileMode = false;

    public AbstractDestTierAndTypeSpecStepPane(MultiStepPane mp, TranscriptionImpl trans) {
        super(mp);
        this.transcription = trans;
        this.multiFileMode = this.transcription == null;
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.newRootTypeList = new ArrayList<String>();
        this.newChildypeList = new ArrayList<String>();
        JLabel newTierNameLabel = new JLabel(ElanLocale.getString("DestTierAndType.Label.NewTierNameLabel"));
        this.destTypeLabel = new JLabel(ElanLocale.getString("DestTierAndType.Label.LingTypeLabel.IncludedIn"));
        this.destTypeLabel.setFont(new Font(this.destTypeLabel.getFont().getFontName(), 0, 10));
        this.lingTypeLabel = new JLabel(ElanLocale.getString("DestTierAndType.Label.LingTypeLabel"));
        this.tierNameDesLabel = new JLabel();
        this.tierNameDesLabel.setForeground(Color.RED);
        this.typeDesLabel = new JLabel();
        this.typeDesLabel.setForeground(Color.RED);
        this.newTierNameField = new JTextField();
        this.decideRootOrChildLabel = new JLabel(ElanLocale.getString("DestTierAndType.Label.RootChildLabel"));
        this.rootTierRB = new JRadioButton(ElanLocale.getString("DestTierAndType.Radio.RootTier"), true);
        this.rootTierRB.addActionListener(this);
        this.childTierRB = new JRadioButton(ElanLocale.getString("DestTierAndType.Radio.ChildTier"));
        this.childTierRB.addActionListener(this);
        this.rootChildButtonGroup = new ButtonGroup();
        this.rootChildButtonGroup.add(this.rootTierRB);
        this.rootChildButtonGroup.add(this.childTierRB);
        this.hideTypesWithCVCB = new JCheckBox(ElanLocale.getString("DestTierAndType.Label.HideTypesWithCV"), false);
        this.createTypesButton = new JButton(ElanLocale.getString("DestTierAndType.Button.AddType"));
        this.parentTierCB = new JComboBox();
        this.linguisticTypeTable = new JTable();
        this.linguisticTypeTable.setSelectionMode(0);
        this.linguisticTypeTable.setModel(new LinguisticTypeTableModel());
        this.linguisticTypeTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("DestTierAndType.Column.LinguisticType"));
        this.linguisticTypeTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("DestTierAndType.Column.Stereotype"));
        this.lingTypeTableScrollPane = new JScrollPane(this.linguisticTypeTable);
        this.destinationTierConfigurationPanel = new JPanel(new GridBagLayout());
        this.destinationTierConfigurationPanel.setBorder(new TitledBorder(ElanLocale.getString("DestTierAndType.Panel.Title.DestTierConfiguration")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.insets = this.globalInset;
        this.destinationTierConfigurationPanel.add((Component)newTierNameLabel, gbc);
        gbc.gridx = 1;
        this.destinationTierConfigurationPanel.add((Component)this.tierNameDesLabel, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.destinationTierConfigurationPanel.add((Component)this.newTierNameField, gbc);
        gbc.gridy = 2;
        this.destinationTierConfigurationPanel.add((Component)this.decideRootOrChildLabel, gbc);
        gbc.gridy = 3;
        gbc.insets = this.singleTabInset;
        this.destinationTierConfigurationPanel.add((Component)this.rootTierRB, gbc);
        JPanel childTierPanel = new JPanel(new GridBagLayout());
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.destinationTierConfigurationPanel.add((Component)childTierPanel, gbc);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 18;
        gbc.fill = 2;
        childTierPanel.add((Component)this.childTierRB, gbc1);
        gbc1.gridx = 1;
        gbc1.fill = 0;
        gbc1.weightx = 0.0;
        childTierPanel.add((Component)this.parentTierCB, gbc1);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 60, 5, 10);
        this.destinationTierConfigurationPanel.add((Component)this.destTypeLabel, gbc);
        gbc.gridy = 6;
        gbc.insets = this.globalInset;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.destinationTierConfigurationPanel.add((Component)this.lingTypeLabel, gbc);
        gbc.gridx = 1;
        this.destinationTierConfigurationPanel.add((Component)this.typeDesLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        this.destinationTierConfigurationPanel.add((Component)this.lingTypeTableScrollPane, gbc);
        gbc.gridy = 8;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, this.globalInset.left, 2, 0);
        this.destinationTierConfigurationPanel.add((Component)this.createTypesButton, gbc);
        this.createTypesButton.addActionListener(this);
        if (!this.multiFileMode) {
            gbc.gridy = 9;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.destinationTierConfigurationPanel.add((Component)this.hideTypesWithCVCB, gbc);
            Boolean storedPref = Preferences.getBool("DestinationType.HideTypesWithCV", null);
            if (storedPref != null) {
                this.hideTypesWithCVCB.setSelected(storedPref);
            }
            this.hideTypesWithCVCB.addActionListener(this);
        }
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.insets = this.globalInset;
        this.add((Component)this.destinationTierConfigurationPanel, gbc);
    }

    @Override
    public abstract String getStepTitle();

    @Override
    public void enterStepForward() {
        this.tierSet = (TreeSet)this.multiPane.getStepProperty("AllTiers");
        if (this.multiFileMode) {
            this.rootTierTypeNames = (List)this.multiPane.getStepProperty("RootTierTypes");
            this.childTierTypeNames = (List)this.multiPane.getStepProperty("ChildTierTypes");
            this.completeTypeNamesList = (List)this.multiPane.getStepProperty("CompleteTierTypes");
            if (this.completeTypeNamesList == null) {
                this.completeTypeNamesList = new ArrayList<String>();
            }
            if (this.newRootTypeList.size() > 0) {
                if (this.rootTierTypeNames == null) {
                    this.rootTierTypeNames = new ArrayList<String>();
                }
                for (String type : this.newRootTypeList) {
                    if (!this.rootTierTypeNames.contains(type)) {
                        this.rootTierTypeNames.add(type);
                    }
                    if (this.completeTypeNamesList.contains(type)) continue;
                    this.completeTypeNamesList.add(type);
                }
            }
            if (this.newChildypeList.size() > 0) {
                if (this.childTierTypeNames == null) {
                    this.childTierTypeNames = new ArrayList<String>();
                }
                for (String type : this.newChildypeList) {
                    if (!this.childTierTypeNames.contains(type)) {
                        this.childTierTypeNames.add(type);
                    }
                    if (this.completeTypeNamesList.contains(type)) continue;
                    this.completeTypeNamesList.add(type);
                }
            }
        }
        String selectedParentTier = null;
        if (this.childTierRB.isSelected()) {
            selectedParentTier = (String)this.parentTierCB.getSelectedItem();
        }
        List tierList = (List)this.multiPane.getStepProperty("SelectedTiers");
        this.parentTierCB.removeAllItems();
        for (int i = 0; i < tierList.size(); ++i) {
            this.parentTierCB.addItem(tierList.get(i));
        }
        if (tierList.contains(selectedParentTier)) {
            this.parentTierCB.setSelectedItem(selectedParentTier);
        } else if (this.childTierRB.isSelected()) {
            selectedParentTier = (String)this.parentTierCB.getSelectedItem();
        }
        ((LinguisticTypeTableModel)this.linguisticTypeTable.getModel()).updateLinguisticTypes(selectedParentTier);
        if (this.linguisticTypeTable.getRowCount() == 1) {
            this.linguisticTypeTable.setRowSelectionInterval(0, 0);
        }
        this.updateButtonStates();
        if (!this.validName) {
            this.validateTierName();
        }
        if (!this.validType) {
            this.validateType();
        }
        this.newTierNameField.requestFocusInWindow();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        this.validateTierName();
        this.validateType();
        if (!this.validName) {
            this.newTierNameField.addKeyListener(this);
        }
        if (!this.validType) {
            this.linguisticTypeTable.getSelectionModel().addListSelectionListener(this);
        }
        if (!this.validType || !this.validName) {
            this.updateButtonStates();
            return false;
        }
        this.multiPane.putStepProperty("DestinationTierName", this.newTierNameField.getText().trim());
        int selectedRow = this.linguisticTypeTable.getSelectedRow();
        String linguisticType = (String)this.linguisticTypeTable.getModel().getValueAt(selectedRow, 0);
        this.multiPane.putStepProperty("linguisticType", linguisticType);
        String parentTierName = null;
        if (this.childTierRB.isSelected()) {
            parentTierName = (String)this.parentTierCB.getSelectedItem();
        }
        this.multiPane.putStepProperty("ParentTierName", parentTierName);
        if (!this.multiFileMode) {
            Preferences.set("DestinationType.HideTypesWithCV", this.hideTypesWithCVCB.isSelected(), null, false, false);
        }
        return true;
    }

    private void validateTierName() {
        String newTierName = this.newTierNameField.getText().trim();
        Object message = null;
        if (newTierName.length() > 0 && !this.tierSet.contains(newTierName)) {
            this.validName = true;
            this.newTierNameField.setForeground(Color.BLACK);
            this.tierNameDesLabel.setText("");
        } else {
            this.validName = false;
            this.newTierNameField.setForeground(Color.RED);
            message = newTierName.length() <= 0 ? ElanLocale.getString("DestTierAndType.Message2") : ElanLocale.getString("DestTierAndType.Message1.Part1") + newTierName + ElanLocale.getString("DestTierAndType.Message1.Part2");
            this.tierNameDesLabel.setText(" - " + (String)message);
        }
    }

    private void validateType() {
        if (this.linguisticTypeTable.getRowCount() > 0) {
            if (this.linguisticTypeTable.getSelectedRowCount() > 0) {
                this.validType = true;
                this.lingTypeLabel.setForeground(Color.BLACK);
            } else {
                this.lingTypeLabel.setForeground(Color.RED);
                this.validType = false;
            }
        } else {
            this.validType = false;
        }
    }

    public void updateButtonStates() {
        this.parentTierCB.setEnabled(this.childTierRB.isSelected());
        this.destTypeLabel.setVisible(this.childTierRB.isSelected());
        this.multiPane.setButtonEnabled(1, this.validName && this.validType);
        this.multiPane.setButtonEnabled(2, true);
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.validateType();
        this.updateButtonStates();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.validateTierName();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.validateTierName();
        this.updateButtonStates();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.validateTierName();
        this.updateButtonStates();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.createTypesButton) {
            if (this.multiFileMode) {
                if (this.createTypeDialog == null) {
                    this.createTypeDialog = new CreateTypeDialog();
                    this.createTypeDialog.updateStereoType();
                }
                this.createTypeDialog.setVisible(true);
                String typeName = this.createTypeDialog.getTypeName();
                if (typeName != null && typeName.trim().length() > 0) {
                    if (this.rootTierRB.isSelected()) {
                        if (this.rootTierTypeNames == null) {
                            this.rootTierTypeNames = new ArrayList<String>();
                        }
                        this.newRootTypeList.add(typeName);
                        this.rootTierTypeNames.add(typeName);
                    } else {
                        if (this.childTierTypeNames == null) {
                            this.childTierTypeNames = new ArrayList<String>();
                        }
                        this.newChildypeList.add(typeName);
                        this.childTierTypeNames.add(typeName);
                    }
                    this.completeTypeNamesList.add(typeName);
                    this.updateTypeList();
                }
            } else {
                int types = this.transcription.getLinguisticTypes().size();
                if (this.transcription.getLinguisticTypes() != null) {
                    types = this.transcription.getLinguisticTypes().size();
                }
                new EditTypeDialog2((Frame)ELANCommandFactory.getRootFrame(this.transcription), true, this.transcription, 0).setVisible(true);
                this.updateTypeList();
            }
        } else {
            if (this.createTypeDialog != null) {
                this.createTypeDialog.updateStereoType();
            }
            this.updateTypeList();
        }
    }

    private void updateTypeList() {
        String parentTierName = null;
        LinguisticTypeTableModel model = (LinguisticTypeTableModel)this.linguisticTypeTable.getModel();
        if (this.childTierRB.isSelected()) {
            parentTierName = (String)this.parentTierCB.getSelectedItem();
        }
        int selectedRow = this.linguisticTypeTable.getSelectedRow();
        String curSelType = null;
        if (selectedRow > -1) {
            curSelType = (String)this.linguisticTypeTable.getValueAt(selectedRow, 0);
        }
        model.updateLinguisticTypes(parentTierName);
        if (model.getRowCount() == 1) {
            this.linguisticTypeTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (curSelType != null) {
            for (int i = 0; i < this.linguisticTypeTable.getRowCount(); ++i) {
                String name = (String)this.linguisticTypeTable.getValueAt(i, 0);
                if (!curSelType.equals(name)) continue;
                this.linguisticTypeTable.setRowSelectionInterval(i, i);
                break;
            }
        }
        if (!this.validType) {
            this.validateType();
        }
        this.updateButtonStates();
    }

    private class LinguisticTypeTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[2];
        private String[][] rowData;

        public LinguisticTypeTableModel() {
            this.columnNames[0] = new String(ElanLocale.getString("DestTierAndType.Column.LinguisticType"));
            this.columnNames[1] = new String(ElanLocale.getString("DestTierAndType.Column.Stereotype"));
            this.updateLinguisticTypes(null);
        }

        public void updateLinguisticTypes(String parentTierName) {
            ArrayList<String> linguisticTypeNames = new ArrayList<String>();
            String stereotypeName = null;
            if (!AbstractDestTierAndTypeSpecStepPane.this.multiFileMode) {
                boolean hideTypesWithCV = AbstractDestTierAndTypeSpecStepPane.this.hideTypesWithCVCB.isSelected();
                List<LinguisticType> linguisticTypeList = AbstractDestTierAndTypeSpecStepPane.this.transcription.getLinguisticTypes();
                if (parentTierName == null) {
                    for (LinguisticType lt : linguisticTypeList) {
                        if (lt.hasConstraints() || lt.isUsingControlledVocabulary() && hideTypesWithCV) continue;
                        linguisticTypeNames.add(lt.getLinguisticTypeName());
                    }
                    stereotypeName = "";
                } else {
                    for (LinguisticType lt : linguisticTypeList) {
                        if (lt.isUsingControlledVocabulary() && hideTypesWithCV) continue;
                        if (lt.hasConstraints() && lt.getConstraints().getStereoType() == 1) {
                            linguisticTypeNames.add(lt.getLinguisticTypeName());
                            continue;
                        }
                        stereotypeName = Constraint.stereoTypes[1];
                    }
                }
            } else if (parentTierName == null && AbstractDestTierAndTypeSpecStepPane.this.rootTierTypeNames != null) {
                linguisticTypeNames.addAll(AbstractDestTierAndTypeSpecStepPane.this.rootTierTypeNames);
                stereotypeName = "";
            } else if (AbstractDestTierAndTypeSpecStepPane.this.childTierTypeNames != null) {
                linguisticTypeNames.addAll(AbstractDestTierAndTypeSpecStepPane.this.childTierTypeNames);
                stereotypeName = Constraint.stereoTypes[1];
            }
            int SIZE = linguisticTypeNames.size();
            this.rowData = new String[SIZE][];
            for (int i = 0; i < SIZE; ++i) {
                this.rowData[i] = new String[]{(String)linguisticTypeNames.get(i), stereotypeName};
            }
            if (SIZE == 0) {
                AbstractDestTierAndTypeSpecStepPane.this.typeDesLabel.setText(ElanLocale.getString("DestTierAndType.Message.LingType"));
                AbstractDestTierAndTypeSpecStepPane.this.lingTypeLabel.setForeground(Color.BLACK);
            } else {
                AbstractDestTierAndTypeSpecStepPane.this.typeDesLabel.setText("");
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.rowData != null) {
                return this.rowData.length;
            }
            return 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.rowData[row][col];
        }
    }

    private class CreateTypeDialog
    extends JDialog {
        private JLabel stereotypeLabel;
        private JLabel errLabel;
        private JTextField typeField;
        private JButton okButton;
        private JButton cancelButton;
        private String newTypeName;

        public CreateTypeDialog() {
            super(AbstractDestTierAndTypeSpecStepPane.this.multiPane.getDialog(), ElanLocale.getString("EditTypeDialog.Title.Add"), true);
            this.newTypeName = null;
            this.initialize();
            this.setLocationRelativeTo(this.getParent());
            this.pack();
        }

        private void initialize() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.stereotypeLabel = new JLabel();
            this.updateStereoType();
            this.errLabel = new JLabel(ElanLocale.getString("EditTypeDialog.Message.Exists"));
            this.errLabel.setFont(new Font(this.errLabel.getFont().getFontName(), 0, 10));
            this.errLabel.setForeground(Color.RED);
            this.okButton = new JButton(ElanLocale.getString("Button.OK"));
            this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
            this.typeField = new JTextField();
            this.typeField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    CreateTypeDialog.this.validateTypeName();
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    CreateTypeDialog.this.validateTypeName();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    CreateTypeDialog.this.validateTypeName();
                }
            });
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == CreateTypeDialog.this.okButton) {
                        CreateTypeDialog.this.newTypeName = CreateTypeDialog.this.typeField.getText().trim();
                    } else {
                        CreateTypeDialog.this.newTypeName = null;
                    }
                    CreateTypeDialog.this.dispose();
                }
            };
            this.okButton.addActionListener(listener);
            this.cancelButton.addActionListener(listener);
            JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 10, 5, 10);
            this.getContentPane().add((Component)new JLabel(ElanLocale.getString("EditTypeDialog.Label.Stereotype") + " : "), gbc);
            gbc.gridx = 1;
            this.getContentPane().add((Component)this.stereotypeLabel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.getContentPane().add((Component)new JLabel(ElanLocale.getString("EditTypeDialog.Label.Type")), gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)this.typeField, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)this.typeField, gbc);
            gbc.gridy = 2;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            this.getContentPane().add((Component)this.errLabel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            gbc.anchor = 13;
            this.getContentPane().add((Component)buttonPanel, gbc);
        }

        private void validateTypeName() {
            String typeName = this.typeField.getText();
            if (typeName == null || typeName.trim().length() <= 0) {
                this.typeField.setForeground(Color.BLACK);
                this.okButton.setEnabled(false);
                return;
            }
            if (AbstractDestTierAndTypeSpecStepPane.this.completeTypeNamesList.contains(typeName)) {
                this.typeField.setForeground(Color.RED);
                this.errLabel.setText(ElanLocale.getString("EditTypeDialog.Message.Exists"));
                this.okButton.setEnabled(false);
            } else {
                this.typeField.setForeground(Color.BLACK);
                this.errLabel.setText("");
                this.okButton.setEnabled(true);
            }
        }

        public String getTypeName() {
            return this.newTypeName;
        }

        @Override
        public void setVisible(boolean b) {
            this.newTypeName = null;
            this.typeField.setText("");
            this.errLabel.setText("");
            super.setVisible(b);
            if (b) {
                this.typeField.requestFocusInWindow();
            }
        }

        public void updateStereoType() {
            String stereotype = AbstractDestTierAndTypeSpecStepPane.this.rootTierRB.isSelected() ? "None" : "Included In";
            this.stereotypeLabel.setText(stereotype);
        }
    }
}

