/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AbstractTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.TranscriptionTierSortAndSelectPanel;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ChangeCaseDlg
extends ClosableDialog
implements ActionListener {
    private TranscriptionImpl transcription;
    private JPanel titlePanel;
    private JPanel tierPanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton startButton;
    private JLabel titleLabel;
    private AbstractTierSortAndSelectPanel tierSelectPanel;
    private JRadioButton upperCaseRB;
    private JRadioButton lowerCaseRB;
    private JCheckBox beginCapCheckBox;
    private JCheckBox onlyBeginCapCheckBox;

    public ChangeCaseDlg(TranscriptionImpl transcription, Frame frame) {
        super(frame);
        this.transcription = transcription;
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.tierPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.closeButton = new JButton();
        this.titleLabel = new JLabel();
        this.tierSelectPanel = new TranscriptionTierSortAndSelectPanel(this.transcription, null, null, true, true, AbstractTierSortAndSelectPanel.Modes.ALL_TIERS);
        this.upperCaseRB = new JRadioButton();
        this.upperCaseRB.setSelected(true);
        this.onlyBeginCapCheckBox = new JCheckBox();
        this.onlyBeginCapCheckBox.setEnabled(true);
        this.lowerCaseRB = new JRadioButton();
        this.beginCapCheckBox = new JCheckBox();
        this.beginCapCheckBox.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.upperCaseRB);
        group.add(this.lowerCaseRB);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel.setLayout(new BorderLayout(0, 4));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        JPanel titleLabelPanel = new JPanel();
        titleLabelPanel.add(this.titleLabel);
        this.titlePanel.add((Component)titleLabelPanel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.tierPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.tierPanel.add((Component)this.tierSelectPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.tierPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.upperCaseRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 20, 2, 6);
        this.optionsPanel.add((Component)this.onlyBeginCapCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.lowerCaseRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 20, 2, 6);
        this.optionsPanel.add((Component)this.beginCapCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 2, 6);
        this.getContentPane().add((Component)this.optionsPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.updateLocale();
        this.upperCaseRB.addActionListener(this);
        this.lowerCaseRB.addActionListener(this);
    }

    private void postInit() {
        this.pack();
        int minimalWidth = 500;
        int minimalHeight = 400;
        this.setSize(this.getSize().width < minimalWidth ? minimalWidth : this.getSize().width, this.getSize().height < minimalHeight ? minimalHeight : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("ChangeCaseDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ChangeCaseDialog.Title"));
        this.tierPanel.setBorder(new TitledBorder(ElanLocale.getString("LabelAndNumberDialog.Label.Tier")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("LabelAndNumberDialog.Label.Options")));
        this.upperCaseRB.setText(ElanLocale.getString("ChangeCaseDialog.UpperCase"));
        this.lowerCaseRB.setText(ElanLocale.getString("ChangeCaseDialog.LowerCase"));
        this.onlyBeginCapCheckBox.setText(ElanLocale.getString("ChangeCaseDialog.InitialCapitalize"));
        this.beginCapCheckBox.setText(ElanLocale.getString("ChangeCaseDialog.Capital"));
        this.startButton.setText(ElanLocale.getString("Button.OK"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    private void startOperation() {
        List<String> tierNames = null;
        tierNames = this.getSelectedTiers();
        if (tierNames.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("LabelAndNumberDialog.Warning.NoTier"), ElanLocale.getString("Message.Error"), 2);
            return;
        }
        boolean initial = this.upperCaseRB.isSelected() && this.onlyBeginCapCheckBox.isSelected() || this.lowerCaseRB.isSelected() && this.beginCapCheckBox.isSelected();
        Object[] args = new Object[]{tierNames, this.upperCaseRB.isSelected(), initial};
        Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.ChangeCase");
        command.execute(this.transcription, args);
    }

    private List<String> getSelectedTiers() {
        return this.tierSelectPanel.getSelectedTiers();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.startButton) {
            this.startOperation();
        } else if (source == this.closeButton) {
            this.closeDialog();
        } else if (source == this.upperCaseRB || source == this.lowerCaseRB) {
            this.onlyBeginCapCheckBox.setEnabled(this.upperCaseRB.isSelected());
            this.beginCapCheckBox.setEnabled(this.lowerCaseRB.isSelected());
        }
    }
}

