/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import nl.mpi.util.FileExtension;

public class CompareAnnotatorResultsDlg
extends ClosableDialog
implements ActionListener {
    private TableModel model;
    private JButton saveButton;
    private JButton closeButton;
    private JLabel averageLabel;

    public CompareAnnotatorResultsDlg(Frame parent, TableModel model) throws HeadlessException {
        super(parent, false);
        this.model = model;
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public CompareAnnotatorResultsDlg(Dialog parent, TableModel model) throws HeadlessException {
        super(parent, false);
        this.model = model;
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        JPanel infoPanel = new JPanel(new GridBagLayout());
        JLabel t1Label = new JLabel(ElanLocale.getString("CompareAnnotatorsDialog.Label.FirstTier"));
        JLabel t2Label = new JLabel(ElanLocale.getString("CompareAnnotatorsDialog.Label.SecondTier"));
        JLabel avLabel = new JLabel(ElanLocale.getString("CompareAnnotatorsDialog.Label.Average"));
        this.averageLabel = new JLabel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 6, 2, 6);
        infoPanel.add((Component)t1Label, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        infoPanel.add((Component)new JLabel(this.model.getColumnName(0)), gbc);
        gbc.gridy = 1;
        infoPanel.add((Component)new JLabel(this.model.getColumnName(3)), gbc);
        gbc.gridx = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        infoPanel.add((Component)t2Label, gbc);
        gbc.gridy = 2;
        infoPanel.add((Component)avLabel, gbc);
        gbc.gridx = 1;
        infoPanel.add((Component)this.averageLabel, gbc);
        this.getContentPane().setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)infoPanel, gbc);
        JTable table = new JTable(this.model);
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(580, 300));
        table.getTableHeader().setReorderingAllowed(false);
        table.setEnabled(false);
        gbc.insets = new Insets(12, 6, 2, 6);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)scroll, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        this.saveButton = new JButton(ElanLocale.getString("Button.Save"));
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        this.saveButton.addActionListener(this);
        buttonPanel.add(this.saveButton);
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        gbc.gridy = 2;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.calcAverage();
    }

    private void calcAverage() {
        if (this.model.getRowCount() == 0) {
            this.averageLabel.setText("0.00");
            return;
        }
        int column = this.model.getColumnCount() - 1;
        float totalQ = 0.0f;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String val = (String)this.model.getValueAt(i, column);
            try {
                float curVal = Float.parseFloat(val);
                totalQ += curVal;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        float average = totalQ / (float)this.model.getRowCount();
        this.averageLabel.setText(String.valueOf(average));
    }

    private void saveModel() throws IOException {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileAndEncodingDialog(null, 1, FileExtension.TEXT_EXT, "LastUsedExportDir", "UTF-8");
        File exportFile = chooser.getSelectedFile();
        String encoding = chooser.getSelectedEncoding();
        if (exportFile != null) {
            int i;
            BufferedWriter writer = null;
            try {
                FileOutputStream out = new FileOutputStream(exportFile);
                OutputStreamWriter osw = null;
                try {
                    osw = new OutputStreamWriter((OutputStream)out, encoding);
                }
                catch (UnsupportedCharsetException uce) {
                    osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
                }
                writer = new BufferedWriter(osw);
            }
            catch (Exception ex) {
                if (writer != null) {
                    writer.close();
                }
                throw new IOException("Cannot write to file: " + ex.getMessage());
            }
            String TAB = "\t";
            String NL = "\n";
            for (i = 0; i < this.model.getColumnCount(); ++i) {
                writer.write(this.model.getColumnName(i));
                if (i >= this.model.getColumnCount() - 1) continue;
                writer.write(TAB);
            }
            writer.write(NL);
            writer.write(NL);
            for (i = 0; i < this.model.getRowCount(); ++i) {
                for (int j = 0; j < this.model.getColumnCount(); ++j) {
                    writer.write((String)this.model.getValueAt(i, j));
                    if (j < this.model.getColumnCount() - 1) {
                        writer.write(TAB);
                        continue;
                    }
                    writer.write(NL);
                }
            }
            writer.write(NL);
            writer.write(ElanLocale.getString("CompareAnnotatorsDialog.Label.Average"));
            for (i = 0; i < this.model.getColumnCount() - 1; ++i) {
                writer.write(TAB);
            }
            writer.write(this.averageLabel.getText());
            try {
                writer.close();
            }
            catch (IOException iioo) {
                iioo.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.saveButton) {
            try {
                this.saveModel();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error") + "\n(" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
        }
    }
}

