/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

public class CopyAnnotationsOfTierStep3
extends StepPane
implements ChangeListener {
    private JPanel optionsPanel;
    private JRadioButton allAnnotationsRB;
    private JRadioButton withValueRB;
    private ButtonGroup buttonGroup;
    private JTextField valuePatternTF;
    private JCheckBox regexCB;
    private JCheckBox overwriteCB;

    public CopyAnnotationsOfTierStep3(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        Insets globalInsets;
        this.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.setLayout(new BorderLayout());
        this.optionsPanel = new JPanel(new GridBagLayout());
        this.allAnnotationsRB = new JRadioButton(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.RadioButton.AllAnnotations"), true);
        this.withValueRB = new JRadioButton(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.RadioButton.AnnotationsWithValues"));
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.allAnnotationsRB);
        this.buttonGroup.add(this.withValueRB);
        this.valuePatternTF = new JTextField();
        this.regexCB = new JCheckBox(ElanLocale.getString("CopyAnnotationsDialog.CopyOptions.RegularExpression"), true);
        this.overwriteCB = new JCheckBox(ElanLocale.getString("MergeTranscriptionDialog.Label.Overwrite"));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("Menu.Options")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = globalInsets = new Insets(10, 10, 5, 10);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)this.allAnnotationsRB, gbc);
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.withValueRB, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(5, 35, 5, 10);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)this.valuePatternTF, gbc);
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.regexCB, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(10, 10, 5, 10);
        this.optionsPanel.add((Component)this.overwriteCB, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridy;
        this.optionsPanel.add((Component)new JPanel(), gbc);
        this.add((Component)this.optionsPanel, "Center");
        this.allAnnotationsRB.addChangeListener(this);
        this.withValueRB.addChangeListener(this);
        this.loadPreferences();
        this.updateUIState();
    }

    private void loadPreferences() {
        Boolean overwritePref;
        Boolean regexPref;
        Boolean withValuePref;
        Boolean allAnnPref = Preferences.getBool("CopyAnnotationsFromTier.All", null);
        if (allAnnPref != null && allAnnPref.booleanValue()) {
            this.allAnnotationsRB.setSelected(true);
        }
        if ((withValuePref = Preferences.getBool("CopyAnnotationsFromTier.WithValue", null)) != null && withValuePref.booleanValue()) {
            this.withValueRB.setSelected(true);
        }
        if ((regexPref = Preferences.getBool("CopyAnnotationsFromTier.Regex", null)) != null) {
            this.regexCB.setSelected(regexPref);
        }
        if ((overwritePref = Preferences.getBool("CopyAnnotationsFromTier.Overwrite", null)) != null) {
            this.overwriteCB.setSelected(overwritePref);
        }
    }

    private void storePreferences() {
        Preferences.set("CopyAnnotationsFromTier.All", this.allAnnotationsRB.isSelected(), null);
        Preferences.set("CopyAnnotationsFromTier.WithValue", this.withValueRB.isSelected(), null);
        Preferences.set("CopyAnnotationsFromTier.Regex", this.regexCB.isSelected(), null);
        Preferences.set("CopyAnnotationsFromTier.Overwrite", this.overwriteCB.isSelected(), null);
    }

    private void updateUIState() {
        boolean allAnns = this.allAnnotationsRB.isSelected();
        this.valuePatternTF.setEnabled(!allAnns);
        this.valuePatternTF.setEditable(!allAnns);
        this.regexCB.setEnabled(!allAnns);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CopyAnnotationsDialog.SetCriteria");
    }

    @Override
    public void enterStepForward() {
        this.multiPane.setButtonEnabled(3, true);
    }

    @Override
    public boolean leaveStepForward() {
        String copyMode = "ALL";
        if (this.withValueRB.isSelected()) {
            copyMode = "WithValue";
            this.multiPane.putStepProperty("QueryValue", this.valuePatternTF.getText().trim());
            this.multiPane.putStepProperty("UseRegex", this.regexCB.isSelected());
        }
        this.multiPane.putStepProperty("CopyMode", copyMode);
        this.multiPane.putStepProperty("Overwrite", this.overwriteCB.isSelected());
        this.storePreferences();
        return true;
    }

    @Override
    public boolean doFinish() {
        this.multiPane.nextStep();
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateUIState();
    }
}

