/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CopyTierStep1
extends StepPane
implements TreeSelectionListener,
ActionListener {
    private TranscriptionImpl transcription;
    private JTree tierTree;
    private JScrollPane scrollPane;
    private JCheckBox depTiersCB;
    private JCheckBox renameTiersCB;
    private TierTree tree;
    JButton sortButton;
    JButton reverseButton;
    JPanel sortButtonsPanel;
    private boolean copyMode = false;
    private boolean selectedTierChanged = false;

    public CopyTierStep1(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        if (multiPane.getStepProperty("CopyMode") != null) {
            this.copyMode = true;
        }
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.sortButton = new JButton(ElanLocale.getString("EditCVDialog.Button.SortAZ"));
        this.reverseButton = new JButton(ElanLocale.getString("EditCVDialog.Button.SortZA"));
        this.sortButton.setEnabled(true);
        this.reverseButton.setEnabled(true);
        this.sortButton.addActionListener(this);
        this.reverseButton.addActionListener(this);
        if (this.transcription != null) {
            this.tree = new TierTree(this.transcription);
            this.tierTree = new JTree(this.tree.getTree());
        } else {
            this.tierTree = new JTree();
        }
        DefaultTreeSelectionModel model = new DefaultTreeSelectionModel();
        model.setSelectionMode(1);
        model.addTreeSelectionListener(this);
        this.tierTree.setSelectionModel(model);
        this.tierTree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.tierTree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.tierTree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        this.scrollPane = new JScrollPane(this.tierTree);
        for (int i = 0; i < this.tierTree.getRowCount(); ++i) {
            this.tierTree.expandRow(i);
        }
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        if (this.copyMode) {
            this.add((Component)new JLabel("<html>" + ElanLocale.getString("MultiStep.Copy.SelectTier") + "</html>"), gbc);
        } else {
            this.add((Component)new JLabel("<html>" + ElanLocale.getString("MultiStep.Reparent.SelectTier") + " " + ElanLocale.getString("MultiStep.Reparent.Depending") + "</html>"), gbc);
        }
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)this.scrollPane, gbc);
        this.sortButtonsPanel = new JPanel(new GridLayout(1, 2, 4, 2));
        this.sortButtonsPanel.add(this.sortButton);
        this.sortButtonsPanel.add(this.reverseButton);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.sortButtonsPanel, gbc);
        if (this.copyMode) {
            this.depTiersCB = new JCheckBox(ElanLocale.getString("MultiStep.Copy.Depending"));
            gbc.gridy = 3;
            gbc.fill = 2;
            gbc.weighty = 0.0;
            this.add((Component)this.depTiersCB, gbc);
            this.renameTiersCB = new JCheckBox(ElanLocale.getString("MultiStep.Copy.RenameOriginalTiers"));
            gbc.gridy = 4;
            gbc.fill = 2;
            gbc.weighty = 0.0;
            this.add((Component)this.renameTiersCB, gbc);
        }
    }

    @Override
    public String getStepTitle() {
        if (this.copyMode) {
            return ElanLocale.getString("MultiStep.Copy.SelectTier");
        }
        return ElanLocale.getString("MultiStep.Reparent.SelectTier");
    }

    @Override
    public void enterStepForward() {
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
        this.selectedTierChanged = false;
    }

    @Override
    public boolean leaveStepForward() {
        if (this.tierTree.getSelectionModel().getSelectionCount() > 0) {
            Object o = this.tierTree.getLastSelectedPathComponent();
            if (o instanceof DefaultMutableTreeNode) {
                this.multiPane.putStepProperty("SelTier", ((DefaultMutableTreeNode)o).getUserObject());
                this.multiPane.putStepProperty("SelTierChanged", this.selectedTierChanged);
            }
            if (this.copyMode) {
                this.multiPane.putStepProperty("IncludeDepTiers", this.depTiersCB.isSelected());
                this.multiPane.putStepProperty("RenameOriginalTiers", this.renameTiersCB.isSelected());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean leaveStepBackward() {
        return true;
    }

    @Override
    public boolean doFinish() {
        return true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.tierTree.getSelectionCount() > 0 && this.tierTree.getSelectionModel().getMinSelectionRow() > 0) {
            this.multiPane.setButtonEnabled(1, true);
            this.selectedTierChanged = true;
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
    }

    private JTree redrawTree(DefaultMutableTreeNode rootNode) {
        JTree tree = new JTree(rootNode);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)tree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
        tree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        return tree;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.sortButton) {
            TreeModel model = this.tierTree.getModel();
            Object root = model.getRoot();
            Object[] path = new Object[]{root};
            TreePath pathRoot = new TreePath(path);
            Enumeration<TreePath> expandedDescendants = this.tierTree.getExpandedDescendants(pathRoot);
            TreePath[] selectedNodes = this.tierTree.getSelectionPaths();
            this.tierTree = this.redrawTree(this.tree.sortAlphabetically());
            DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
            selectionModel.setSelectionMode(1);
            selectionModel.addTreeSelectionListener(this);
            this.tierTree.setSelectionModel(selectionModel);
            while (expandedDescendants.hasMoreElements()) {
                TreePath pathToNode = expandedDescendants.nextElement();
                this.tierTree.expandPath(pathToNode);
            }
            this.tierTree.setSelectionPaths(selectedNodes);
            this.remove(this.scrollPane);
            this.scrollPane = new JScrollPane(this.tierTree);
            Insets insets = new Insets(4, 6, 4, 6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets;
            gbc.weightx = 1.0;
            gbc.gridy = 1;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add((Component)this.scrollPane, gbc);
            this.revalidate();
            this.repaint();
        } else if (ae.getSource() == this.reverseButton) {
            TreeModel model = this.tierTree.getModel();
            Object root = model.getRoot();
            Object[] path = new Object[]{root};
            TreePath pathRoot = new TreePath(path);
            Enumeration<TreePath> expandedDescendants = this.tierTree.getExpandedDescendants(pathRoot);
            TreePath[] selectedNodes = this.tierTree.getSelectionPaths();
            this.tierTree = this.redrawTree(this.tree.sortReverseAlphabetically());
            DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
            selectionModel.setSelectionMode(1);
            selectionModel.addTreeSelectionListener(this);
            this.tierTree.setSelectionModel(selectionModel);
            while (expandedDescendants.hasMoreElements()) {
                TreePath pathToNode = expandedDescendants.nextElement();
                this.tierTree.expandPath(pathToNode);
            }
            this.tierTree.setSelectionPaths(selectedNodes);
            this.remove(this.scrollPane);
            this.scrollPane = new JScrollPane(this.tierTree);
            Insets insets = new Insets(4, 6, 4, 6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets;
            gbc.weightx = 1.0;
            gbc.gridy = 1;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add((Component)this.scrollPane, gbc);
            this.revalidate();
            this.repaint();
        }
    }
}

