/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExportOverlapsStep1
extends StepPane
implements MouseListener {
    private ArrayList<String> tierNames;
    protected DefaultTableModel model1;
    protected TierExportTableModel model2;
    protected JTable table1;
    protected JTable table2;
    protected JLabel firstLabel;
    protected JLabel secLabel;
    protected final String SELECT_COLUMN = "select";
    protected final String TIER_NAME_COLUMN = "tier";

    public ExportOverlapsStep1(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
        SwingUtilities.invokeLater(new LoadThread());
    }

    @Override
    protected void initComponents() {
        this.model1 = new DefaultTableModel();
        this.model2 = new TierExportTableModel();
        this.model1.setColumnIdentifiers(new String[]{"tier"});
        this.model2.setColumnIdentifiers(new String[]{"select", "tier"});
        this.table1 = new JTable(this.model1);
        this.table1.getSelectionModel().setSelectionMode(0);
        this.table1.setTableHeader(null);
        this.table1.addMouseListener(this);
        this.table2 = new TierExportTable(this.model2);
        this.table2.addMouseListener(this);
        this.model1.addRow(new Object[]{"Loading tiers..."});
        Dimension prdim = new Dimension(120, 80);
        JScrollPane p1 = new JScrollPane(this.table1);
        p1.setPreferredSize(prdim);
        JScrollPane p2 = new JScrollPane(this.table2);
        p2.setPreferredSize(prdim);
        this.firstLabel = new JLabel(ElanLocale.getString("ExportOverlapsDialog.Label.RefTier"));
        this.secLabel = new JLabel(ElanLocale.getString("ExportOverlapsDialog.Label.OtherTiers"));
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)this.firstLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)p1, gbc);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.add((Component)this.secLabel, gbc);
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)p2, gbc);
    }

    private void extractTierNames() {
        List files = (List)this.multiPane.getStepProperty("files");
        this.tierNames = new ArrayList();
        if (files == null || files.size() == 0) {
            return;
        }
        for (File f : files) {
            if (f == null) continue;
            try {
                TranscriptionImpl trans = new TranscriptionImpl(f.getAbsolutePath());
                List<TierImpl> tiers = trans.getTiers();
                for (int i = 0; i < tiers.size(); ++i) {
                    Tier tier = tiers.get(i);
                    String name = tier.getName();
                    if (this.tierNames.contains(name)) continue;
                    this.tierNames.add(name);
                }
            }
            catch (Exception exception) {
            }
        }
        Collections.sort(this.tierNames);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportOverlapsStep1.this.model1.removeRow(0);
                for (String tname : ExportOverlapsStep1.this.tierNames) {
                    ExportOverlapsStep1.this.model1.addRow(new Object[]{tname});
                    ExportOverlapsStep1.this.model2.addRow(Boolean.FALSE, tname);
                }
            }
        });
    }

    private List<String> getSelectedTiers2() {
        return this.model2.getSelectedTiers();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ExportOverlapsDialog.SelectTiers");
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
    }

    @Override
    public boolean leaveStepForward() {
        int row1 = this.table1.getSelectedRow();
        if (row1 < 0) {
            return false;
        }
        String refTier = (String)this.table1.getValueAt(row1, 0);
        List<String> selTiers2 = this.getSelectedTiers2();
        selTiers2.remove(refTier);
        if (selTiers2.size() > 0) {
            this.multiPane.putStepProperty("Tier-1", refTier);
            this.multiPane.putStepProperty("Tiers-2", selTiers2);
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int row1 = this.table1.getSelectedRow();
        boolean different = false;
        if (row1 >= 0) {
            int includeCol = this.model2.findColumn("select");
            int rowCount = this.model2.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Boolean include = (Boolean)this.model2.getValueAt(i, includeCol);
                if (!include.booleanValue() || i == row1) continue;
                different = true;
                break;
            }
        }
        this.multiPane.setButtonEnabled(1, different);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class LoadThread
    extends Thread {
        LoadThread() {
        }

        @Override
        public void run() {
            ExportOverlapsStep1.this.extractTierNames();
        }
    }
}

