/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class RemoveAnnotationsOrValuesDlg
extends ClosableDialog
implements ActionListener,
ChangeListener {
    private TranscriptionImpl transcription;
    private JPanel tierPanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton startButton;
    private JLabel titleLabel;
    private JLabel optionsTitleLabel;
    private JTable tierTable;
    private TierExportTableModel model;
    private JRadioButton annotationsRadioButton;
    private JRadioButton annotationValuesRadioButton;
    private JRadioButton allAnnotationsRadioButton;
    private JRadioButton emptyAnnotationsRadioButton;
    private JRadioButton annotationsWithValRadioButton;
    private JTextField annotationsWithValTextField;
    private JRadioButton allAnnotationsRadioButton1;
    private JRadioButton annotationsWithValRadioButton1;
    private JTextField annotationsWithValTextField1;

    public RemoveAnnotationsOrValuesDlg(TranscriptionImpl transcription, Frame frame) {
        super(frame);
        this.transcription = transcription;
        this.initComponents();
        this.extractTiers();
        this.postInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RemoveAnnotationsOrValuesDlg.this.closeDialog(evt);
            }
        });
        this.tierPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.closeButton = new JButton();
        this.titleLabel = new JLabel();
        this.optionsTitleLabel = new JLabel();
        this.model = new TierExportTableModel();
        this.tierTable = new TierExportTable(this.model);
        JScrollPane tierScroll = new JScrollPane(this.tierTable);
        tierScroll.setPreferredSize(new Dimension(100, 100));
        this.annotationsRadioButton = new JRadioButton();
        this.emptyAnnotationsRadioButton = new JRadioButton();
        this.annotationValuesRadioButton = new JRadioButton();
        this.annotationsWithValTextField = new JTextField();
        this.allAnnotationsRadioButton = new JRadioButton();
        this.annotationsWithValRadioButton = new JRadioButton();
        this.annotationsWithValTextField1 = new JTextField();
        this.allAnnotationsRadioButton1 = new JRadioButton();
        this.annotationsWithValRadioButton1 = new JRadioButton();
        ButtonGroup optionsGroup = new ButtonGroup();
        optionsGroup.add(this.annotationsRadioButton);
        optionsGroup.add(this.annotationValuesRadioButton);
        ButtonGroup subOptionsGroup = new ButtonGroup();
        subOptionsGroup.add(this.allAnnotationsRadioButton);
        subOptionsGroup.add(this.emptyAnnotationsRadioButton);
        subOptionsGroup.add(this.annotationsWithValRadioButton);
        ButtonGroup subOptionsGroup1 = new ButtonGroup();
        subOptionsGroup1.add(this.allAnnotationsRadioButton1);
        subOptionsGroup1.add(this.annotationsWithValRadioButton1);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titleLabel, gridBagConstraints);
        this.tierPanel.setLayout(new GridBagLayout());
        Dimension tableDim = new Dimension(50, 100);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tierPanel.add((Component)tierScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.tierPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        insets.bottom = 3;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.optionsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.optionsPanel.add((Component)this.optionsTitleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 6, 4, 6);
        gridBagConstraints.weightx = 1.0;
        this.optionsPanel.add((Component)this.annotationsRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.allAnnotationsRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.emptyAnnotationsRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.annotationsWithValRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 2, 4, 6);
        this.optionsPanel.add((Component)this.annotationsWithValTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.annotationValuesRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.allAnnotationsRadioButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.annotationsWithValRadioButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 2, 4, 6);
        this.optionsPanel.add((Component)this.annotationsWithValTextField1, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        this.setDefaultOrPreferredSettings();
        this.updateLocale();
        this.annotationsRadioButton.addChangeListener(this);
        this.annotationValuesRadioButton.addChangeListener(this);
        this.annotationsWithValRadioButton.addChangeListener(this);
        this.annotationsWithValRadioButton1.addChangeListener(this);
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void setDefaultOrPreferredSettings() {
        this.annotationsRadioButton.setSelected(true);
        this.annotationValuesRadioButton.setSelected(false);
        this.allAnnotationsRadioButton.setSelected(true);
        this.emptyAnnotationsRadioButton.setSelected(false);
        this.annotationsWithValRadioButton.setSelected(false);
        this.annotationsWithValTextField.setEnabled(false);
        this.allAnnotationsRadioButton1.setSelected(true);
        this.allAnnotationsRadioButton1.setEnabled(false);
        this.annotationsWithValRadioButton1.setSelected(false);
        this.annotationsWithValRadioButton1.setEnabled(false);
        this.annotationsWithValTextField1.setEnabled(false);
        Boolean boolPref = Preferences.getBool("RemoveAnnotationsOrValuesDlg.annotationsRadioButton", null);
        if (boolPref != null) {
            this.annotationsRadioButton.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("RemoveAnnotationsOrValuesDlg.annotationValuesRadioButton", null)) != null) {
            this.annotationValuesRadioButton.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("RemoveAnnotationsOrValuesDlg.allAnnotationsRadioButton", null)) != null) {
            this.allAnnotationsRadioButton.setEnabled(this.annotationsRadioButton.isSelected());
            this.allAnnotationsRadioButton.setSelected(boolPref);
        }
        boolPref = Preferences.getBool("RemoveAnnotationsOrValuesDlg.emptyAnnotationsRadioButton", null);
        this.emptyAnnotationsRadioButton.setEnabled(this.annotationsRadioButton.isSelected());
        if (boolPref != null) {
            this.emptyAnnotationsRadioButton.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("RemoveAnnotationsOrValuesDlg.annotationsWithValRadioButton", null)) != null) {
            this.annotationsWithValRadioButton.setEnabled(this.annotationsRadioButton.isSelected());
            this.annotationsWithValRadioButton.setSelected(boolPref);
            this.annotationsWithValTextField.setEnabled(this.annotationsWithValRadioButton.isSelected());
        }
        if ((boolPref = Preferences.getBool("RemoveAnnotationsOrValuesDlg.allAnnotationsRadioButton1", null)) != null) {
            this.allAnnotationsRadioButton1.setSelected(boolPref);
            this.allAnnotationsRadioButton1.setEnabled(this.annotationValuesRadioButton.isSelected());
        }
        if ((boolPref = Preferences.getBool("RemoveAnnotationsOrValuesDlg.annotationsWithValRadioButton1", null)) != null) {
            this.annotationsWithValRadioButton1.setSelected(boolPref);
            this.annotationsWithValRadioButton1.setEnabled(this.annotationValuesRadioButton.isSelected());
            this.annotationsWithValTextField1.setEnabled(this.annotationsWithValRadioButton1.isSelected());
        }
    }

    private void savePreferredSettings() {
        Preferences.set("RemoveAnnotationsOrValuesDlg.annotationsRadioButton", this.annotationsRadioButton.isSelected(), null);
        Preferences.set("RemoveAnnotationsOrValuesDlg.annotationValuesRadioButton", this.annotationValuesRadioButton.isSelected(), null);
        Preferences.set("RemoveAnnotationsOrValuesDlg.allAnnotationsRadioButton", this.allAnnotationsRadioButton.isSelected(), null);
        Preferences.set("RemoveAnnotationsOrValuesDlg.emptyAnnotationsRadioButton", this.emptyAnnotationsRadioButton.isSelected(), null);
        Preferences.set("RemoveAnnotationsOrValuesDlg.annotationsWithValRadioButton", this.annotationsWithValRadioButton.isSelected(), null);
        Preferences.set("RemoveAnnotationsOrValuesDlg.allAnnotationsRadioButton1", this.allAnnotationsRadioButton1.isSelected(), null);
        Preferences.set("RemoveAnnotationsOrValuesDlg.annotationsWithValRadioButton1", this.annotationsWithValRadioButton1.isSelected(), null);
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.Title"));
        this.titleLabel.setText(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.Title"));
        this.tierPanel.setBorder(new TitledBorder(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.Label.Tier")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.Label.Options")));
        this.optionsTitleLabel.setText(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.Label.Options.Title"));
        this.annotationsRadioButton.setText(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.RadioButton.Annotations"));
        this.annotationValuesRadioButton.setText(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.RadioButton.AnnotationValues"));
        this.allAnnotationsRadioButton.setText(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.RadioButton.AllAnnotations"));
        this.emptyAnnotationsRadioButton.setText(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.RadioButton.EmptyAnnotations"));
        this.annotationsWithValRadioButton.setText(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.RadioButton.AnnotationsWithValues"));
        this.allAnnotationsRadioButton1.setText(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.RadioButton.AllAnnotations"));
        this.annotationsWithValRadioButton1.setText(ElanLocale.getString("RemoveAnnotationsOrValuesDlg.RadioButton.AnnotationsWithValues"));
        this.startButton.setText(ElanLocale.getString("Button.OK"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    private void extractTiers() {
        if (this.transcription != null) {
            List<TierImpl> v = this.transcription.getTiers();
            this.model.extractTierNames(v);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.startButton) {
            this.startOperation();
        } else if (source == this.closeButton) {
            this.closeDialog(null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.annotationsRadioButton) {
            this.allAnnotationsRadioButton.setEnabled(this.annotationsRadioButton.isSelected());
            this.emptyAnnotationsRadioButton.setEnabled(this.annotationsRadioButton.isSelected());
            this.annotationsWithValRadioButton.setEnabled(this.annotationsRadioButton.isSelected());
        } else if (e.getSource() == this.annotationValuesRadioButton) {
            this.allAnnotationsRadioButton1.setEnabled(this.annotationValuesRadioButton.isSelected());
            this.annotationsWithValRadioButton1.setEnabled(this.annotationValuesRadioButton.isSelected());
        } else if (e.getSource() == this.annotationsWithValRadioButton) {
            this.annotationsWithValTextField.setEnabled(this.annotationsRadioButton.isSelected());
        } else if (e.getSource() == this.annotationsWithValRadioButton1) {
            this.annotationsWithValTextField1.setEnabled(this.annotationValuesRadioButton.isSelected());
        }
    }

    private List<String> getSelectedTiers() {
        return this.model.getSelectedTiers();
    }

    private void startOperation() {
        this.savePreferredSettings();
        List<String> tierNames = null;
        boolean annotations = false;
        boolean annotationValues = false;
        boolean allAnnotations = false;
        boolean annotationWithVal = false;
        String value = null;
        tierNames = this.getSelectedTiers();
        if (tierNames.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("RemoveAnnotationsOrValuesDlg.Warning.NoTier"), ElanLocale.getString("Message.Error"), 2);
            return;
        }
        if (this.annotationsRadioButton.isSelected()) {
            annotations = true;
            if (this.allAnnotationsRadioButton.isSelected()) {
                allAnnotations = true;
            } else if (this.emptyAnnotationsRadioButton.isSelected()) {
                annotationWithVal = true;
                value = "";
            } else if (this.annotationsWithValRadioButton.isSelected()) {
                annotationWithVal = true;
                value = this.annotationsWithValTextField.getText() != null && this.annotationsWithValTextField.getText().length() > 0 ? this.annotationsWithValTextField.getText().trim() : "";
            }
        } else if (this.annotationValuesRadioButton.isSelected()) {
            annotationValues = true;
            if (this.allAnnotationsRadioButton1.isSelected()) {
                allAnnotations = true;
            } else if (this.annotationsWithValRadioButton1.isSelected()) {
                annotationWithVal = true;
                if (this.annotationsWithValTextField1.getText() != null && this.annotationsWithValTextField1.getText().length() > 0) {
                    value = this.annotationsWithValTextField1.getText().trim();
                } else {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("RemoveAnnotationsOrValuesDlg.Warning.EmptyValue"), ElanLocale.getString("Message.Error"), 2);
                    return;
                }
            }
        }
        Object[] args = new Object[]{tierNames, annotations, annotationValues, allAnnotations, annotationWithVal, value};
        Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.RemoveAnnotationsOrValues");
        command.execute(this.transcription, args);
    }
}

