/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class SelectableContentTableModel
extends AbstractTableModel {
    public static final String SELECT_ID = "Select_ID";
    private List<String> columnNameList;
    private List<List<Object>> rowDataList;

    public SelectableContentTableModel(Set<? extends Object> content) {
        this(content, null);
    }

    public SelectableContentTableModel(Set<? extends Object> content, String columnName) {
        this.columnNameList = new ArrayList<String>(2);
        this.columnNameList.add(SELECT_ID);
        this.columnNameList.add(columnName);
        this.rowDataList = new ArrayList<List<Object>>(content.size());
        for (Object object : content) {
            ArrayList<Object> row = new ArrayList<Object>(2);
            row.add(Boolean.FALSE);
            row.add(object);
            this.rowDataList.add(row);
        }
    }

    public SelectableContentTableModel(Object[][] columnData, String[] columnNames) {
        int i;
        int numCols = columnData.length + 1;
        int numRows = 0;
        this.columnNameList = new ArrayList<String>(numCols);
        this.columnNameList.add(SELECT_ID);
        for (i = 0; i < columnData.length; ++i) {
            Object[] obja = columnData[i];
            numRows = Math.max(numRows, obja.length);
            if (columnNames != null && i < columnNames.length) {
                this.columnNameList.add(columnNames[i]);
                continue;
            }
            this.columnNameList.add(null);
        }
        this.rowDataList = new ArrayList<List<Object>>(numRows);
        for (i = 0; i < numRows; ++i) {
            ArrayList<Object> row = new ArrayList<Object>(numCols);
            row.add(Boolean.FALSE);
            for (Object[] obja : columnData) {
                if (i < obja.length) {
                    row.add(obja[i]);
                    continue;
                }
                row.add(null);
            }
            this.rowDataList.add(row);
        }
    }

    @Override
    public int getRowCount() {
        return this.rowDataList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNameList.size();
    }

    @Override
    public String getColumnName(int column) {
        if (column > 0 && column < this.columnNameList.size()) {
            String name = this.columnNameList.get(column);
            return name != null ? name : "";
        }
        return "";
    }

    public void setColumnName(int column, String name) {
        if (column > 0 && column < this.columnNameList.size()) {
            this.columnNameList.set(column, name);
        }
    }

    @Override
    public int findColumn(String columnName) {
        return this.columnNameList.indexOf(columnName);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.rowDataList.size() && column < this.columnNameList.size()) {
            return this.rowDataList.get(row).get(column);
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int row, int column) {
        if (row < this.rowDataList.size() && column < this.columnNameList.size()) {
            if (column == 0 && object.getClass() != Boolean.class) {
                return;
            }
            this.rowDataList.get(row).set(column, object);
            this.fireTableRowsUpdated(row, row);
        }
    }

    public void selectAll() {
        if (this.getColumnCount() > 0) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(Boolean.TRUE, i, 0);
            }
        }
        this.fireTableDataChanged();
    }

    public void selectNone() {
        if (this.getColumnCount() > 0) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(Boolean.FALSE, i, 0);
            }
        }
        this.fireTableDataChanged();
    }

    public List<Object> getSelectedValues() {
        ArrayList<Object> selectedValues = new ArrayList<Object>();
        if (this.getColumnCount() > 1) {
            for (List<Object> rowData : this.rowDataList) {
                Object val;
                if (!((Boolean)rowData.get(0)).booleanValue() || (val = rowData.get(1)) == null) continue;
                selectedValues.add(val);
            }
        }
        return selectedValues;
    }

    public void moveUp(int row) {
        if (row > 0 && row < this.rowDataList.size()) {
            List<Object> rowData = this.rowDataList.remove(row);
            this.rowDataList.add(row - 1, rowData);
            this.fireTableRowsUpdated(row - 1, row);
        }
    }

    public void moveDown(int row) {
        if (row < this.rowDataList.size() - 1 && row >= 0) {
            List<Object> rowData = this.rowDataList.remove(row);
            this.rowDataList.add(row + 1, rowData);
            this.fireTableRowsUpdated(row, row + 1);
        }
    }

    public boolean nothingSelected() {
        for (List<Object> rowData : this.rowDataList) {
            if (!((Boolean)rowData.get(0)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    public Class<? extends Object> getColumnClass(int col) {
        Object val;
        if (col == 0) {
            return Boolean.class;
        }
        if (col < this.columnNameList.size() && this.rowDataList.size() > 0 && (val = this.rowDataList.get(0).get(col)) != null) {
            return val.getClass();
        }
        return Object.class;
    }
}

