/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class TierTableModel
extends AbstractTableModel {
    public static final String LABEL_PREF = "EditTierDialog.Label.";
    public static final String NAME = "TierName";
    public static final String PARENT = "Parent";
    public static final String PARTICIPANT = "Participant";
    public static final String ANNOTATOR = "Annotator";
    public static final String TYPE = "LinguisticType";
    public static final String INPUT_METHOD = "Language";
    public static final String CONTENT_LANGUAGE = "ContentLanguage";
    public static final String N_A = "-";
    private List<TierImpl> tierList;
    private List<String> columnIds;
    private List<List<String>> tableData;
    private List<Class<String>> classes;

    public TierTableModel() {
        this(null);
    }

    public TierTableModel(List<TierImpl> tiers) {
        this(tiers, null);
    }

    public TierTableModel(List<TierImpl> tiers, String[] columns) {
        this.tierList = tiers == null ? new ArrayList<TierImpl>(0) : new ArrayList<TierImpl>(tiers);
        this.columnIds = new ArrayList<String>();
        this.classes = new ArrayList<Class<String>>();
        if (columns != null) {
            for (String column : columns) {
                if (column.equals(NAME)) {
                    this.columnIds.add(NAME);
                    this.classes.add(String.class);
                    continue;
                }
                if (column.equals(PARENT)) {
                    this.columnIds.add(PARENT);
                    this.classes.add(String.class);
                    continue;
                }
                if (column.equals(TYPE)) {
                    this.columnIds.add(TYPE);
                    this.classes.add(String.class);
                    continue;
                }
                if (column.equals(PARTICIPANT)) {
                    this.columnIds.add(PARTICIPANT);
                    this.classes.add(String.class);
                    continue;
                }
                if (column.equals(ANNOTATOR)) {
                    this.columnIds.add(ANNOTATOR);
                    this.classes.add(String.class);
                    continue;
                }
                if (column.equals(INPUT_METHOD)) {
                    this.columnIds.add(INPUT_METHOD);
                    this.classes.add(String.class);
                    continue;
                }
                if (!column.equals(CONTENT_LANGUAGE)) continue;
                this.columnIds.add(CONTENT_LANGUAGE);
                this.classes.add(String.class);
            }
        } else {
            this.columnIds.add(NAME);
            this.columnIds.add(PARENT);
            this.columnIds.add(TYPE);
            this.columnIds.add(PARTICIPANT);
            this.columnIds.add(ANNOTATOR);
            this.columnIds.add(INPUT_METHOD);
            this.columnIds.add(CONTENT_LANGUAGE);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
        }
        this.initData();
    }

    private void initData() {
        this.tableData = new ArrayList<List<String>>(this.tierList.size());
        for (int i = 0; i < this.tierList.size(); ++i) {
            TierImpl tier = this.tierList.get(i);
            this.addRowData(tier);
        }
        this.fireTableDataChanged();
    }

    private void addRowData(TierImpl tier) {
        if (tier == null) {
            return;
        }
        ArrayList<String> rowData = new ArrayList<String>(6);
        int index = this.columnIds.indexOf(NAME);
        if (index > -1) {
            rowData.add(index, tier.getName());
        }
        if ((index = this.columnIds.indexOf(PARENT)) > -1) {
            if (tier.getParentTier() == null) {
                rowData.add(index, N_A);
            } else {
                rowData.add(index, tier.getParentTier().getName());
            }
        }
        if ((index = this.columnIds.indexOf(TYPE)) > -1) {
            rowData.add(index, tier.getLinguisticType().getLinguisticTypeName());
        }
        if ((index = this.columnIds.indexOf(PARTICIPANT)) > -1) {
            rowData.add(index, tier.getParticipant());
        }
        if ((index = this.columnIds.indexOf(ANNOTATOR)) > -1) {
            rowData.add(index, tier.getAnnotator());
        }
        if ((index = this.columnIds.indexOf(INPUT_METHOD)) > -1) {
            Locale loc = tier.getDefaultLocale();
            if (loc != null) {
                rowData.add(index, loc.getDisplayName());
            } else {
                rowData.add(index, N_A);
            }
        }
        this.tableData.add(rowData);
        index = this.columnIds.indexOf(CONTENT_LANGUAGE);
        if (index > -1) {
            String lang = tier.getLangRef();
            rowData.add(index, lang == null ? N_A : lang);
        }
    }

    @Override
    public int getRowCount() {
        return this.tableData.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnIds.size();
    }

    @Override
    public String getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.tableData.size() || columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return null;
        }
        List<String> row = this.tableData.get(rowIndex);
        return row.get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int findColumn(String columnName) {
        return this.columnIds.indexOf(columnName);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.classes.size()) {
            return null;
        }
        return this.classes.get(columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return "";
        }
        return ElanLocale.getString(LABEL_PREF + this.columnIds.get(columnIndex));
    }

    public void removeRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.tableData.size()) {
            this.tableData.remove(rowIndex);
            this.tierList.remove(rowIndex);
            this.fireTableDataChanged();
        }
    }

    public void removeAllRows() {
        this.tableData.clear();
        this.tierList.clear();
        this.fireTableDataChanged();
    }

    public void addRow(TierImpl tier) {
        if (tier == null || this.tierList.contains(tier)) {
            return;
        }
        this.tierList.add(tier);
        this.addRowData(tier);
        this.fireTableDataChanged();
    }

    public void addTier(TierImpl tier) {
        this.addRow(tier);
    }

    public void rowDataChanged() {
        this.initData();
        this.fireTableDataChanged();
    }
}

