/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tiersets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AbstractTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.FilesTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.TranscriptionTierSortAndSelectPanel;
import mpi.eudico.client.annotator.tier.DisplayableContentTableModel;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tiersets.ManageTierSetDlg;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.WindowLocationAndSizeManager;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import nl.mpi.util.FileExtension;

public class AddTiersDlg
extends ClosableDialog
implements ActionListener {
    private AbstractTierSortAndSelectPanel tierSelectPanel;
    private JButton addButton;
    private JButton cancelButton;
    private JPanel fileSelectionPanel;
    private JRadioButton currentlyOpenedFileRB;
    private JRadioButton selectedFilesFromDiskRB;
    private JRadioButton filesFromDomainRB;
    private JButton selectFilesBtn;
    private JButton selectDomainBtn;
    private String prefixString = "TierSet.AddTiersDlg";
    private List<String> selectedTierList = null;
    private ManageTierSetDlg manageTSDlg;
    private Insets globalInsets = new Insets(2, 4, 2, 4);
    private JPanel tierSelectionPanel;
    private JTextArea textArea;
    private List<String> openedFileNames;

    public AddTiersDlg(Dialog owner, ManageTierSetDlg manageTierSetDlg, List<String> tierList) {
        super(owner, ElanLocale.getString("TierSet.Title.AddTiers"), true);
        this.manageTSDlg = manageTierSetDlg;
        this.selectedTierList = new ArrayList<String>();
        this.initComponents();
        WindowLocationAndSizeManager.postInit(this, this.prefixString);
    }

    public void closeDialog() {
        this.storePreferences();
        WindowLocationAndSizeManager.storeLocationAndSizePreferences(this, this.prefixString);
        this.setVisible(false);
        this.dispose();
    }

    protected void initFileSelectionPanel() {
        this.fileSelectionPanel = new JPanel(new GridBagLayout());
        this.fileSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("FileAndTierSelectionStepPane.Panel.Title.FileSelection")));
        RadioButtonHandler radioButtonListener = new RadioButtonHandler();
        this.currentlyOpenedFileRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.CurrentlyOpenedFile"), false);
        this.currentlyOpenedFileRB.addActionListener(radioButtonListener);
        this.selectedFilesFromDiskRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.FilesFromFileBrowser"), false);
        this.selectedFilesFromDiskRB.addActionListener(radioButtonListener);
        this.filesFromDomainRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.FilesFromDomain"), false);
        this.filesFromDomainRB.addActionListener(radioButtonListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.currentlyOpenedFileRB);
        buttonGroup.add(this.selectedFilesFromDiskRB);
        buttonGroup.add(this.filesFromDomainRB);
        ButtonHandler buttonHandler = new ButtonHandler();
        this.selectFilesBtn = new JButton(ElanLocale.getString("Button.Browse"));
        this.selectFilesBtn.addActionListener(buttonHandler);
        this.selectFilesBtn.setEnabled(false);
        this.selectDomainBtn = new JButton(ElanLocale.getString("FileAndTierSelectionStepPane.Button.Domain"));
        this.selectDomainBtn.addActionListener(buttonHandler);
        this.selectDomainBtn.setEnabled(false);
        if (this.manageTSDlg.getTranscription() == null) {
            this.currentlyOpenedFileRB.setEnabled(false);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 30, 0, 10);
        this.fileSelectionPanel.add((Component)this.currentlyOpenedFileRB, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.fileSelectionPanel.add((Component)this.selectedFilesFromDiskRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.fileSelectionPanel.add((Component)this.selectFilesBtn, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        this.fileSelectionPanel.add((Component)this.filesFromDomainRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.fileSelectionPanel.add((Component)this.selectDomainBtn, gbc);
        this.readPreferences();
    }

    protected void initTierSelectionPanel() {
        this.tierSelectionPanel = new JPanel(new GridBagLayout());
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("MultiFileExport.Panel.Title.TierSelection")));
        this.textArea = new JTextArea(ElanLocale.getString("FileAndTierSelectionStepPane.Panel.Title.FileSelection"));
        this.textArea.setEditable(false);
        this.textArea.setBorder(new LineBorder(Color.LIGHT_GRAY));
        if (this.tierSelectPanel == null) {
            if (this.currentlyOpenedFileRB.isSelected()) {
                this.initializeTierSelectPanel(null);
            } else if (this.openedFileNames != null && this.openedFileNames.size() > 0) {
                this.initializeTierSelectPanel(this.getMultipleFiles(this.openedFileNames));
            }
        } else {
            this.tierSelectPanel.setSelectedTiers(this.selectedTierList);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInsets;
        if (this.tierSelectPanel != null) {
            this.tierSelectionPanel.add((Component)this.tierSelectPanel, gbc);
        } else {
            this.tierSelectionPanel.add((Component)this.textArea, gbc);
        }
    }

    private void removeTierSelectPanel() {
        if (this.tierSelectPanel != null) {
            this.tierSelectionPanel.remove(this.tierSelectPanel);
            this.tierSelectPanel = null;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInsets;
        this.tierSelectionPanel.add((Component)this.textArea, gbc);
        this.updateButtonStates();
        this.validate();
        this.repaint();
    }

    private void initializeTierSelectPanel(ArrayList<File> files) {
        if (this.tierSelectPanel != null) {
            this.tierSelectionPanel.remove(this.tierSelectPanel);
        } else {
            this.tierSelectionPanel.remove(this.textArea);
        }
        this.tierSelectPanel = files == null ? new TranscriptionTierSortAndSelectPanel(this.manageTSDlg.getTranscription(), null, this.selectedTierList, false, true){

            @Override
            protected void initTables() {
                super.initTables();
                ModelClickedHandler listener = new ModelClickedHandler();
                this.model.addTableModelListener(listener);
                this.typeModel.addTableModelListener(listener);
                this.partModel.addTableModelListener(listener);
                this.annotModel.addTableModelListener(listener);
                this.langModel.addTableModelListener(listener);
            }
        } : new ExtentedFilesTierSortAndSelectPanel(files, null, this.selectedTierList, false, true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInsets;
        this.tierSelectionPanel.add((Component)this.tierSelectPanel, gbc);
        this.updateButtonStates();
        this.validate();
        this.repaint();
    }

    private void initComponents() {
        this.addButton = new JButton(ElanLocale.getString("Button.Add"));
        this.addButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.initFileSelectionPanel();
        this.initTierSelectionPanel();
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.insets = this.globalInsets;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.fileSelectionPanel, gbc);
        gbc.gridy = y++;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.tierSelectionPanel, gbc);
        gbc.gridy = y;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.updateButtonStates();
    }

    public void readPreferences() {
        boolean currentFile = false;
        boolean domain = false;
        boolean disk = false;
        Object val = Preferences.get("TierSetDlgFileSelection.CurrentTranscription", null);
        if (val instanceof Boolean) {
            currentFile = (Boolean)val;
        }
        if ((val = Preferences.get("TierSetDlgFileSelection.Filesfromdomain", null)) instanceof Boolean) {
            domain = (Boolean)val;
        }
        if ((val = Preferences.get("TierSetDlgFileSelection.FilesfromDisk", null)) instanceof Boolean) {
            disk = (Boolean)val;
        }
        if (domain || disk) {
            this.filesFromDomainRB.setSelected(domain);
            this.selectDomainBtn.setEnabled(domain);
            this.selectFilesBtn.setEnabled(disk);
            this.selectedFilesFromDiskRB.setSelected(disk);
        } else if (this.manageTSDlg.getTranscription() != null && currentFile) {
            this.currentlyOpenedFileRB.setSelected(currentFile);
        }
        val = Preferences.get("TierSetDlg.SelectedFiles", null);
        if (val instanceof List) {
            this.openedFileNames = (List)val;
        }
    }

    public void storePreferences() {
        Preferences.set("TierSetDlgFileSelection.Filesfromdomain", this.filesFromDomainRB.isSelected(), null);
        Preferences.set("TierSetDlgFileSelection.FilesfromDisk", this.selectedFilesFromDiskRB.isSelected(), null);
        Preferences.set("TierSetDlgFileSelection.CurrentTranscription", this.currentlyOpenedFileRB.isSelected(), null);
        Preferences.set("TierSetDlg.SelectedFiles", this.openedFileNames, null);
    }

    public List<String> getSelectedTierNames() {
        return this.selectedTierList;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.addButton) {
            this.selectedTierList = this.tierSelectPanel.getSelectedTiers();
            this.closeDialog();
        } else if (source == this.cancelButton) {
            this.selectedTierList.clear();
            this.closeDialog();
        }
    }

    protected ArrayList<File> getMultipleFiles(List<String> fileNames) {
        if (fileNames == null) {
            return null;
        }
        if (fileNames.size() > 0) {
            ArrayList<File> files = new ArrayList<File>();
            for (int i = 0; i < fileNames.size(); ++i) {
                File f = new File(fileNames.get(i));
                if (f.isFile() && f.canRead()) {
                    files.add(f);
                    continue;
                }
                if (!f.isDirectory() || !f.canRead()) continue;
                this.addFiles(f, files);
            }
            if (files.size() > 0) {
                return files;
            }
        }
        return null;
    }

    protected void addFiles(File dir, ArrayList<File> files) {
        if (dir == null && files == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFiles(allSubs[i], files);
                continue;
            }
            if (!allSubs[i].canRead() || !allSubs[i].getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0]) || files.contains(allSubs[i])) continue;
            files.add(allSubs[i]);
        }
    }

    protected void addFileNames(File dir, List<String> files) {
        if (dir == null && files == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFileNames(allSubs[i], files);
                continue;
            }
            if (!allSubs[i].canRead() || !allSubs[i].getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0]) || files.contains(allSubs[i].getAbsolutePath())) continue;
            files.add(allSubs[i].getAbsolutePath());
        }
    }

    private List<String> showMultiFileChooser() {
        ArrayList<CallSite> fileNames = null;
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowMultiFileDialog(ElanLocale.getString("ExportDialog.Multi"), 0, FileExtension.EAF_EXT, "LastUsedEAFDir");
        Object[] objects = chooser.getSelectedFiles();
        if (objects != null && objects.length > 0) {
            fileNames = new ArrayList<CallSite>();
            for (Object object : objects) {
                if (fileNames.contains(object)) continue;
                fileNames.add((CallSite)((Object)("" + object)));
            }
        }
        return fileNames;
    }

    public void updateButtonStates() {
        if (this.tierSelectPanel != null && this.tierSelectPanel.getSelectedTiers().size() > 0) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    private class RadioButtonHandler
    implements ActionListener {
        private JRadioButton previouslySelectedRadioButton;

        private RadioButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton rb = (JRadioButton)e.getSource();
            if (rb == AddTiersDlg.this.currentlyOpenedFileRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    this.previouslySelectedRadioButton = rb;
                    AddTiersDlg.this.openedFileNames = null;
                    AddTiersDlg.this.initializeTierSelectPanel(null);
                }
                AddTiersDlg.this.selectFilesBtn.setEnabled(false);
                AddTiersDlg.this.selectDomainBtn.setEnabled(false);
            } else if (rb == AddTiersDlg.this.selectedFilesFromDiskRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    this.previouslySelectedRadioButton = rb;
                    AddTiersDlg.this.openedFileNames = null;
                    AddTiersDlg.this.removeTierSelectPanel();
                }
                AddTiersDlg.this.selectFilesBtn.setEnabled(true);
                AddTiersDlg.this.selectDomainBtn.setEnabled(false);
            } else if (rb == AddTiersDlg.this.filesFromDomainRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    this.previouslySelectedRadioButton = rb;
                    AddTiersDlg.this.openedFileNames = null;
                    AddTiersDlg.this.removeTierSelectPanel();
                }
                AddTiersDlg.this.selectFilesBtn.setEnabled(false);
                AddTiersDlg.this.selectDomainBtn.setEnabled(true);
            }
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddTiersDlg.this.updateButtonStates();
            if (e != null) {
                JButton button = (JButton)e.getSource();
                if (button == AddTiersDlg.this.selectFilesBtn) {
                    List filenames = AddTiersDlg.this.showMultiFileChooser();
                    if (filenames != null && !filenames.isEmpty()) {
                        AddTiersDlg.this.initializeTierSelectPanel(AddTiersDlg.this.getMultipleFiles(filenames));
                        AddTiersDlg.this.openedFileNames = filenames;
                    }
                } else if (button == AddTiersDlg.this.selectDomainBtn) {
                    MFDomainDialog domainDialog = new MFDomainDialog(ELANCommandFactory.getRootFrame(null), ElanLocale.getString("ExportDialog.Multi"), true);
                    domainDialog.setVisible(true);
                    List<String> searchPaths = domainDialog.getSearchPaths();
                    List<String> searchDirs = domainDialog.getSearchDirs();
                    ArrayList<String> filenames = new ArrayList<String>();
                    ArrayList<File> files = null;
                    if (!searchPaths.isEmpty()) {
                        files = AddTiersDlg.this.getMultipleFiles(searchPaths);
                        filenames.addAll(searchPaths);
                    }
                    if (!searchDirs.isEmpty()) {
                        if (files == null) {
                            files = AddTiersDlg.this.getMultipleFiles(searchDirs);
                        } else {
                            files.addAll(AddTiersDlg.this.getMultipleFiles(searchDirs));
                        }
                        for (int i = 0; i < searchDirs.size(); ++i) {
                            File f = new File(searchDirs.get(i));
                            if (f.isFile() && f.canRead()) {
                                if (filenames.contains(searchDirs.get(i))) continue;
                                filenames.add(searchDirs.get(i));
                                continue;
                            }
                            if (!f.isDirectory() || !f.canRead()) continue;
                            AddTiersDlg.this.addFileNames(f, filenames);
                        }
                    }
                    if (files != null) {
                        AddTiersDlg.this.initializeTierSelectPanel(files);
                        AddTiersDlg.this.openedFileNames = filenames;
                    }
                }
            }
        }
    }

    private class ExtentedFilesTierSortAndSelectPanel
    extends FilesTierSortAndSelectPanel {
        public ExtentedFilesTierSortAndSelectPanel(ArrayList<File> files, List<String> tierOrder, List<String> selectedTiers, boolean allowReOrdering, boolean allowSorting) {
            super(files, tierOrder, selectedTiers, allowReOrdering, allowSorting);
        }

        @Override
        protected void initTables() {
            if (this.allTierNames == null) {
                this.allTierNames = new ArrayList();
            }
            LoadTableThread lt = new LoadTableThread(this.files, this.tierTable);
            lt.start();
            ModelClickedHandler listener = new ModelClickedHandler();
            this.model.addTableModelListener(listener);
            this.typeModel.addTableModelListener(listener);
            this.partModel.addTableModelListener(listener);
            this.annotModel.addTableModelListener(listener);
            this.langModel.addTableModelListener(listener);
        }

        private class LoadTableThread
        extends Thread {
            protected List<File> files;
            protected JTable tierTable;
            private DisplayableContentTableModel displaymodel;

            public LoadTableThread(List<File> files, JTable tierTable) {
                this.files = files;
                this.tierTable = tierTable;
                String[] msg = files == null || files.size() == 0 ? new String[]{ElanLocale.getString("FileAndTierSelectionStepPane.Panel.Title.FileSelection")} : new String[]{ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part1"), "0 " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part2") + " " + files.size() + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part3") + " (0%)"};
                this.displaymodel = new DisplayableContentTableModel(msg);
                this.displaymodel.connectTable(tierTable);
                tierTable.setModel(this.displaymodel);
            }

            @Override
            public void run() {
                ExtentedFilesTierSortAndSelectPanel.this.tierTypeMap.clear();
                ExtentedFilesTierSortAndSelectPanel.this.tierParticipantMap.clear();
                ExtentedFilesTierSortAndSelectPanel.this.tierAnnotatorMap.clear();
                ExtentedFilesTierSortAndSelectPanel.this.tierLanguageMap.clear();
                if (this.files != null) {
                    List<TierImpl> pts = null;
                    EAFSkeletonParser parser = null;
                    for (int i = 0; i < this.files.size(); ++i) {
                        File file = this.files.get(i);
                        if (file == null) continue;
                        String path = file.getAbsolutePath();
                        try {
                            parser = new EAFSkeletonParser(path);
                            parser.parse();
                            pts = parser.getTiers();
                            for (int j = 0; j < pts.size(); ++j) {
                                List list;
                                String value;
                                TierImpl tier = pts.get(j);
                                String tierName = tier.getName();
                                if (!ExtentedFilesTierSortAndSelectPanel.this.allTierNames.contains(tierName)) {
                                    ExtentedFilesTierSortAndSelectPanel.this.allTierNames.add(tierName);
                                }
                                if (tier.getParentTier() == null && !ExtentedFilesTierSortAndSelectPanel.this.rootTiers.contains(tierName)) {
                                    ExtentedFilesTierSortAndSelectPanel.this.rootTiers.add(tierName);
                                }
                                if ((value = tier.getParticipant()).isEmpty()) {
                                    value = "not specified";
                                }
                                if (ExtentedFilesTierSortAndSelectPanel.this.tierParticipantMap.get(value) == null) {
                                    ExtentedFilesTierSortAndSelectPanel.this.tierParticipantMap.put(value, new ArrayList());
                                }
                                if (!(list = (List)ExtentedFilesTierSortAndSelectPanel.this.tierParticipantMap.get(value)).contains(tierName)) {
                                    list.add(tierName);
                                }
                                if ((value = tier.getAnnotator()).isEmpty()) {
                                    value = "not specified";
                                }
                                if (ExtentedFilesTierSortAndSelectPanel.this.tierAnnotatorMap.get(value) == null) {
                                    ExtentedFilesTierSortAndSelectPanel.this.tierAnnotatorMap.put(value, new ArrayList());
                                }
                                if (!(list = (List)ExtentedFilesTierSortAndSelectPanel.this.tierAnnotatorMap.get(value)).contains(tierName)) {
                                    list.add(tierName);
                                }
                                value = tier.getLinguisticType().getLinguisticTypeName();
                                if (ExtentedFilesTierSortAndSelectPanel.this.tierTypeMap.get(value) == null) {
                                    ExtentedFilesTierSortAndSelectPanel.this.tierTypeMap.put(value, new ArrayList());
                                }
                                if (!(list = (List)ExtentedFilesTierSortAndSelectPanel.this.tierTypeMap.get(value)).contains(tierName)) {
                                    list.add(tierName);
                                }
                                if (tier.getParentTier() == null && !ExtentedFilesTierSortAndSelectPanel.this.rootTypes.contains(value)) {
                                    ExtentedFilesTierSortAndSelectPanel.this.rootTypes.add(value);
                                }
                                if ((value = tier.getLangRef()) == null || value.isEmpty()) {
                                    value = "not specified";
                                }
                                if (ExtentedFilesTierSortAndSelectPanel.this.tierLanguageMap.get(value) == null) {
                                    ExtentedFilesTierSortAndSelectPanel.this.tierLanguageMap.put(value, new ArrayList());
                                }
                                if ((list = (List)ExtentedFilesTierSortAndSelectPanel.this.tierLanguageMap.get(value)).contains(tierName)) continue;
                                list.add(tierName);
                            }
                        }
                        catch (ParseException pe) {
                            ClientLogger.LOG.warning(pe.getMessage());
                        }
                        catch (Exception ex) {
                            ClientLogger.LOG.warning("Could not load file: " + path);
                        }
                        final String msg = i + 1 + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part2") + " " + this.files.size() + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part3") + " (" + Math.round((float)(i + 1) / (float)this.files.size() * 100.0f) + "%)";
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LoadTableThread.this.displaymodel.updateMessage(1, msg);
                            }
                        });
                    }
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (ExtentedFilesTierSortAndSelectPanel.this.allTierNames.isEmpty()) {
                                LoadTableThread.this.displaymodel.setValueAt(ElanLocale.getString("FileAndTierSelectionStepPane.Message1"), 0, 0);
                            } else {
                                int i;
                                LoadTableThread.this.tierTable.setModel(ExtentedFilesTierSortAndSelectPanel.this.model);
                                if (LoadTableThread.this.tierTable instanceof TierExportTable) {
                                    ((TierExportTable)LoadTableThread.this.tierTable).init(1, false);
                                } else {
                                    ClientLogger.LOG.warning("tierTable is not of class TierExportTable");
                                }
                                for (i = ExtentedFilesTierSortAndSelectPanel.this.model.getRowCount() - 1; i >= 0; --i) {
                                    ExtentedFilesTierSortAndSelectPanel.this.model.removeRow(i);
                                }
                                for (i = 0; i < ExtentedFilesTierSortAndSelectPanel.this.allTierNames.size(); ++i) {
                                    if (ExtentedFilesTierSortAndSelectPanel.this.selectedTierNames.size() > 0) {
                                        if (ExtentedFilesTierSortAndSelectPanel.this.selectedTierNames.contains(ExtentedFilesTierSortAndSelectPanel.this.allTierNames.get(i))) {
                                            ExtentedFilesTierSortAndSelectPanel.this.model.addRow(Boolean.TRUE, (String)ExtentedFilesTierSortAndSelectPanel.this.allTierNames.get(i));
                                            continue;
                                        }
                                        ExtentedFilesTierSortAndSelectPanel.this.model.addRow(Boolean.FALSE, (String)ExtentedFilesTierSortAndSelectPanel.this.allTierNames.get(i));
                                        continue;
                                    }
                                    ExtentedFilesTierSortAndSelectPanel.this.model.addRow(Boolean.FALSE, (String)ExtentedFilesTierSortAndSelectPanel.this.allTierNames.get(i));
                                }
                                if (ExtentedFilesTierSortAndSelectPanel.this.model.getRowCount() > 0) {
                                    LoadTableThread.this.tierTable.setRowSelectionInterval(0, 0);
                                }
                                ExtentedFilesTierSortAndSelectPanel.this.fillModel(ExtentedFilesTierSortAndSelectPanel.this.typeModel, ExtentedFilesTierSortAndSelectPanel.this.tierTypeMap.keySet());
                                ExtentedFilesTierSortAndSelectPanel.this.fillModel(ExtentedFilesTierSortAndSelectPanel.this.partModel, ExtentedFilesTierSortAndSelectPanel.this.tierParticipantMap.keySet());
                                ExtentedFilesTierSortAndSelectPanel.this.fillModel(ExtentedFilesTierSortAndSelectPanel.this.annotModel, ExtentedFilesTierSortAndSelectPanel.this.tierAnnotatorMap.keySet());
                                ExtentedFilesTierSortAndSelectPanel.this.fillModel(ExtentedFilesTierSortAndSelectPanel.this.langModel, ExtentedFilesTierSortAndSelectPanel.this.tierLanguageMap.keySet());
                            }
                            AddTiersDlg.this.updateButtonStates();
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class ModelClickedHandler
    implements TableModelListener {
        private ModelClickedHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            AddTiersDlg.this.updateButtonStates();
        }
    }
}

