/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tiersets;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.annotator.tiersets.AddTiersDlg;
import mpi.eudico.client.annotator.tiersets.ManageTierSetDlg;
import mpi.eudico.client.annotator.tiersets.TierSet;
import mpi.eudico.client.annotator.tiersets.TierSetUtil;
import mpi.eudico.client.annotator.util.WindowLocationAndSizeManager;

public class EditTierSetDlg
extends ClosableDialog
implements ActionListener {
    private JTextArea nameTextArea;
    private JTextArea descTextArea;
    private JButton showOrHideButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private JTable tierTable;
    private DefaultTableModel tierModel;
    private JButton changeButton;
    private JButton cancelButton;
    private TierSetUtil tierSetUtil;
    private TierSet tierSet = null;
    private ManageTierSetDlg manageTierSetDlg;
    private final int ADD = 0;
    private final int EDIT = 1;
    private int mode;
    private Insets globalInsets = new Insets(2, 4, 2, 4);

    public EditTierSetDlg(ManageTierSetDlg owner, String title) {
        this(owner, null, title);
    }

    public EditTierSetDlg(ManageTierSetDlg owner, TierSet tierSet, String title) {
        super(owner, title, true);
        this.manageTierSetDlg = owner;
        this.tierSet = tierSet;
        this.mode = tierSet == null ? 0 : 1;
        this.tierSetUtil = TierSetUtil.getTierSetUtilInstance();
        this.initComponents();
        WindowLocationAndSizeManager.postInit(this, "EditTierSetDlg");
    }

    private JPanel getTierPanel() {
        this.showOrHideButton = new JButton(ElanLocale.getString("Button.Hide"));
        this.showOrHideButton.addActionListener(this);
        this.tierModel = new TierExportTableModel();
        this.tierTable = new JTable(this.tierModel);
        this.manageTierSetDlg.initTableAndModel(this.tierTable, this.tierModel);
        this.tierTable.setDragEnabled(true);
        this.tierTable.setDropMode(DropMode.USE_SELECTION);
        this.tierTable.setTransferHandler(ManageTierSetDlg.tableDragAndDropHandler());
        JPanel tierPanel = new JPanel();
        tierPanel.setLayout(new GridBagLayout());
        tierPanel.setBorder(new TitledBorder(ElanLocale.getString("TierSet.TierList")));
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.insets = this.globalInsets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        tierPanel.add((Component)new JScrollPane(this.tierTable), gbc);
        gbc.gridy = y;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        tierPanel.add((Component)this.getTierButtonPanel(), gbc);
        return tierPanel;
    }

    private JPanel getTierButtonPanel() {
        this.addButton = new JButton();
        this.addButton.setToolTipText(ElanLocale.getString("Button.Add"));
        this.addButton.addActionListener(this);
        this.removeButton = new JButton();
        this.removeButton.setToolTipText(ElanLocale.getString("Button.Delete"));
        this.removeButton.addActionListener(this);
        try {
            ImageIcon addIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Plus16.gif"));
            ImageIcon removeIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Minus16.gif"));
            this.addButton.setIcon(addIcon);
            this.removeButton.setIcon(removeIcon);
        }
        catch (Exception ex) {
            this.addButton.setText("+");
            this.removeButton.setText("-");
        }
        this.upButton = new JButton();
        this.upButton.setToolTipText(ElanLocale.getString("EditCVDialog.Button.Up"));
        this.downButton = new JButton();
        this.downButton.setToolTipText(ElanLocale.getString("EditCVDialog.Button.Down"));
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        try {
            ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
            this.upButton.setIcon(upIcon);
            this.downButton.setIcon(downIcon);
        }
        catch (Exception ex) {
            this.upButton.setText("Up");
            this.downButton.setText("Down");
        }
        JPanel tierButtonPanel = new JPanel();
        tierButtonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInsets;
        gbc.anchor = 18;
        gbc.fill = 0;
        tierButtonPanel.add((Component)this.upButton, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        tierButtonPanel.add((Component)this.downButton, gbc);
        gbc.gridx = 2;
        gbc.anchor = 13;
        tierButtonPanel.add(this.addButton);
        gbc.gridx = 3;
        tierButtonPanel.add(this.removeButton);
        return tierButtonPanel;
    }

    public void initComponents() {
        this.changeButton = new JButton();
        this.changeButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        if (this.mode == 0) {
            this.changeButton.setText(ElanLocale.getString("SegmentsToTierDialog.Button.Create"));
        } else if (this.mode == 1) {
            this.changeButton.setText(ElanLocale.getString("Button.Change"));
        }
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if (e.getSource() == EditTierSetDlg.this.nameTextArea) {
                        EditTierSetDlg.this.descTextArea.requestFocus();
                    } else {
                        EditTierSetDlg.this.nameTextArea.requestFocus();
                    }
                }
            }
        };
        this.nameTextArea = new JTextArea(1, 1);
        this.nameTextArea.addKeyListener(keyListener);
        this.descTextArea = new JTextArea(5, 1);
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.addKeyListener(keyListener);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(this.changeButton);
        buttonPanel.add(this.cancelButton);
        this.setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.insets = new Insets(4, 6, 4, 6);
        this.add((Component)new JLabel(ElanLocale.getString("TierSet.Name")), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.nameTextArea, gbc);
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.weightx = 0.0;
        this.add((Component)new JLabel(ElanLocale.getString("TierSet.Description")), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.descTextArea, gbc);
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.getTierPanel(), gbc);
        gbc.gridy = y;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.add((Component)buttonPanel, gbc);
        if (this.mode == 1) {
            this.nameTextArea.setText(this.tierSet.getName());
            this.descTextArea.setText(this.tierSet.getDescription());
            List<String> visibleTiersList = this.tierSet.getVisibleTierList();
            for (String tier : this.tierSet.getTierList()) {
                this.tierModel.addRow(new Object[]{visibleTiersList.contains(tier), tier});
            }
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (EditTierSetDlg.this.mode == 0) {
                    EditTierSetDlg.this.tierSet = null;
                }
                EditTierSetDlg.this.closeDialog();
            }
        });
    }

    private void closeDialog() {
        WindowLocationAndSizeManager.storeLocationAndSizePreferences(this, "EditTierSetDlg");
        this.setVisible(false);
        this.dispose();
    }

    public TierSet getTierSet() {
        return this.tierSet;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createTierSet() {
        if (this.nameTextArea.getText() != null && this.nameTextArea.getText().trim().length() > 0) {
            int i;
            String tierSetName = this.nameTextArea.getText().trim();
            if (this.tierSetUtil.checkIfTierSetExists(tierSetName)) {
                JOptionPane.showMessageDialog(this, "Tier Set name already exist!", ElanLocale.getString("Message.Error"), 0);
                this.nameTextArea.requestFocusInWindow();
                return;
            }
            ArrayList<String> tierList = new ArrayList<String>();
            for (i = 0; i < this.tierTable.getRowCount(); ++i) {
                tierList.add((String)this.tierTable.getValueAt(i, 1));
            }
            this.tierSet = this.tierSetUtil.createTierSet(tierSetName, tierList);
            for (i = 0; i < this.tierTable.getRowCount(); ++i) {
                this.tierSet.setTierVisiblity((String)this.tierTable.getValueAt(i, 1), (Boolean)this.tierTable.getValueAt(i, 0));
            }
            if (this.descTextArea.getText() != null) {
                this.tierSet.setDescription(this.descTextArea.getText());
            }
            this.closeDialog();
            return;
        }
        JOptionPane.showMessageDialog(this, "Please enter a valid name for the tier set", ElanLocale.getString("Message.Error"), 0);
        this.nameTextArea.requestFocusInWindow();
    }

    private void updateTierSet() {
        ArrayList<String> tierList = new ArrayList<String>();
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            tierList.add((String)this.tierTable.getValueAt(i, 1));
        }
        if (tierList.size() == 0) {
            JOptionPane.showMessageDialog(this, "A tier set should have at least one tier. Please add tiers to tier set.", ElanLocale.getString("Message.Error"), 0);
            this.tierTable.requestFocusInWindow();
            return;
        }
        if (this.nameTextArea.getText() != null && this.nameTextArea.getText().trim().length() > 0) {
            String tierSetName = this.nameTextArea.getText().trim();
            String oldName = this.tierSet.getName();
            if (!this.tierSet.getName().equals(tierSetName)) {
                if (!this.tierSetUtil.checkIfTierSetExists(tierSetName)) {
                    this.tierSet.setName(tierSetName);
                    this.tierSetUtil.updateTierSet(oldName, this.tierSet);
                } else {
                    JOptionPane.showMessageDialog(this, "Tier Set name already exist!", ElanLocale.getString("Message.Error"), 0);
                    this.nameTextArea.requestFocusInWindow();
                    return;
                }
            }
            if (this.descTextArea.getText() != null) {
                this.tierSet.setDescription(this.descTextArea.getText());
            }
            this.tierSet.setTierList(tierList);
            for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                this.tierSet.setTierVisiblity((String)this.tierTable.getValueAt(i, 1), (Boolean)this.tierTable.getValueAt(i, 0));
            }
            this.closeDialog();
        } else {
            JOptionPane.showMessageDialog(this, "Please enter a valid name for the tier set", ElanLocale.getString("Message.Error"), 0);
            this.nameTextArea.requestFocusInWindow();
        }
    }

    protected void moveUp() {
        if (this.tierTable == null || this.tierModel == null || this.tierModel.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            int row = selected[i];
            if (row <= 0 || this.tierTable.isRowSelected(row - 1)) continue;
            this.tierModel.moveRow(row, row, row - 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row - 1, 0, true, false);
        }
    }

    protected void moveDown() {
        if (this.tierTable == null || this.tierModel == null || this.tierModel.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = selected.length - 1; i >= 0; --i) {
            int row = selected[i];
            if (row >= this.tierModel.getRowCount() - 1 || this.tierTable.isRowSelected(row + 1)) continue;
            this.tierModel.moveRow(row, row, row + 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row + 1, 0, true, false);
        }
    }

    private void showAddTiersDlg() {
        ArrayList<String> tierList = new ArrayList<String>();
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            tierList.add((String)this.tierTable.getValueAt(i, 1));
        }
        AddTiersDlg dlg = new AddTiersDlg((Dialog)this, this.manageTierSetDlg, tierList);
        dlg.setVisible(true);
        List<String> selectedTiers = dlg.getSelectedTierNames();
        ArrayList<String> curTierList = new ArrayList<String>();
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            curTierList.add((String)this.tierTable.getValueAt(i, 1));
        }
        for (String tier : selectedTiers) {
            if (curTierList.contains(tier)) continue;
            this.tierModel.addRow(new Object[]{Boolean.TRUE, tier});
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.addButton) {
            this.showAddTiersDlg();
        } else if (source == this.removeButton) {
            int[] rows = this.tierTable.getSelectedRows();
            while (rows.length > 0) {
                this.tierModel.removeRow(this.tierTable.convertRowIndexToModel(rows[0]));
                rows = this.tierTable.getSelectedRows();
            }
        } else if (source == this.upButton) {
            this.moveUp();
        } else if (source == this.downButton) {
            this.moveDown();
        }
        if (ae.getSource() == this.changeButton) {
            if (this.mode == 0) {
                this.createTierSet();
            } else {
                this.updateTierSet();
            }
        } else if (ae.getSource() == this.cancelButton) {
            this.tierSet = null;
            this.closeDialog();
        }
    }
}

