/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tiersets;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.tiersets.TierSet;
import mpi.eudico.client.annotator.tiersets.TierSetIO;
import mpi.eudico.client.annotator.tiersets.TierSetListener;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import nl.mpi.util.FileUtility;

public class TierSetUtil
implements PreferencesListener {
    private List<String> tierSetSortOrder;
    private List<String> tierSortOrder;
    private List<String> visibleTierSetList;
    private HashMap<String, TierSet> tierSetMap = new HashMap();
    private static TierSetUtil tierSetUtil;
    private static String fileURL;
    private TierSetIO tierSetIO;
    private static Map<Transcription, ArrayList<TierSetListener>> listenerGroups;

    private TierSetUtil() {
        this.tierSetSortOrder = new ArrayList<String>();
        this.tierSortOrder = new ArrayList<String>();
        this.visibleTierSetList = new ArrayList<String>();
        this.tierSetIO = new TierSetIO();
        Object val = Preferences.get("DefaultTierSetFilePath", null);
        fileURL = val != null && val instanceof String ? val.toString() : Constants.ELAN_DATA_DIR + File.separator + "TierSet.xml";
        this.readTierSetsFromFile();
    }

    private void readTierSetsFromFile() {
        List<TierSet> tierSetList = null;
        try {
            tierSetList = this.tierSetIO.read(new File(FileUtility.urlToAbsPath(fileURL)));
        }
        catch (IOException e) {
            ClientLogger.LOG.info(ElanLocale.getString("TierSet.Error.FileNotFound"));
        }
        if (tierSetList != null) {
            for (TierSet tierSet : tierSetList) {
                this.tierSetMap.put(tierSet.getName(), tierSet);
                this.tierSetSortOrder.add(tierSet.getName());
            }
            this.updateVisibleTierSetList();
        }
    }

    public void writeTierSetsToFile() {
        ArrayList<TierSet> tierSetList = new ArrayList<TierSet>();
        for (String name : this.tierSetSortOrder) {
            tierSetList.add(this.tierSetMap.get(name));
        }
        try {
            this.tierSetIO.writeLS(new File(FileUtility.urlToAbsPath(fileURL)), tierSetList);
            this.updateVisibleTierSetList();
        }
        catch (IOException e) {
            ClientLogger.LOG.warning("Error while writing the tier set file: " + e.getMessage());
        }
    }

    public static TierSetUtil getTierSetUtilInstance() {
        if (tierSetUtil == null) {
            tierSetUtil = new TierSetUtil();
        } else {
            TierSetUtil.checkTierSetFile();
        }
        return tierSetUtil;
    }

    private static void checkTierSetFile() {
        String f = null;
        Object val = Preferences.get("DefaultTierSetFilePath", null);
        if (val != null && val instanceof String) {
            f = val.toString();
        }
        if (f != null && !f.equals(fileURL)) {
            fileURL = f;
            tierSetUtil = new TierSetUtil();
        }
    }

    public List<String> getTierOrder(Transcription transcription) {
        ArrayList<String> tierOrder = new ArrayList<String>();
        for (String tier : this.tierSortOrder) {
            if (transcription.getTierWithId(tier) == null) continue;
            tierOrder.add(tier);
        }
        return tierOrder;
    }

    private void updateTierOrder() {
        this.tierSortOrder.clear();
        for (int i = 0; i < this.tierSetSortOrder.size(); ++i) {
            TierSet tierSet = this.tierSetMap.get(this.tierSetSortOrder.get(i));
            if (!tierSet.isVisible()) continue;
            for (String tierName : tierSet.getTierList()) {
                if (this.tierSortOrder.contains(tierName)) continue;
                this.tierSortOrder.add(tierName);
            }
        }
    }

    public List<String> getTierSetList() {
        return this.tierSetSortOrder;
    }

    public TierSet getTierSet(String tierSetName) {
        return this.tierSetMap.get(tierSetName);
    }

    private void updateVisibleTierSetList() {
        this.visibleTierSetList.clear();
        for (int i = 0; i < this.tierSetSortOrder.size(); ++i) {
            TierSet tierSet = this.tierSetMap.get(this.tierSetSortOrder.get(i));
            if (!tierSet.isVisible()) continue;
            this.visibleTierSetList.add(tierSet.getName());
        }
        this.updateTierOrder();
    }

    public List<String> getVisibleTierSets() {
        return this.visibleTierSetList;
    }

    public boolean checkIfTierSetExists(String tierSetName) {
        return this.tierSetSortOrder.contains(tierSetName);
    }

    public TierSet createTierSet(String name, List<String> tierList) {
        if (name == null || tierList == null) {
            return null;
        }
        if (!this.checkIfTierSetExists(name)) {
            TierSet tierSet = new TierSet(name, tierList);
            this.tierSetSortOrder.add(name);
            this.tierSetMap.put(name, tierSet);
            this.updateVisibleTierSetList();
            return tierSet;
        }
        return null;
    }

    public void updateTierSet(String oldName, TierSet tierSet) {
        this.tierSetSortOrder.set(this.tierSetSortOrder.indexOf(oldName), tierSet.getName());
        if (this.visibleTierSetList.contains(oldName)) {
            this.visibleTierSetList.remove(oldName);
            this.visibleTierSetList.add(tierSet.getName());
        }
        this.tierSetMap.remove(oldName);
        this.tierSetMap.put(tierSet.getName(), tierSet);
    }

    public void deleteTierSet(String name) {
        if (this.tierSetSortOrder.contains(name)) {
            this.tierSetSortOrder.remove(name);
        }
        if (this.tierSetMap.containsKey(name)) {
            this.tierSetMap.remove(name);
        }
        this.updateVisibleTierSetList();
    }

    public void updateTierSetSortOrder(List<String> tierSetOrder) {
        if (tierSetOrder != null) {
            this.tierSetSortOrder = tierSetOrder;
        }
    }

    public void updateTierSet(String name) {
    }

    public void addTierSetListener(Transcription document, TierSetListener listener) {
        if (listenerGroups.containsKey(document)) {
            ArrayList<TierSetListener> listeners = listenerGroups.get(document);
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        } else {
            ArrayList<TierSetListener> list = new ArrayList<TierSetListener>();
            list.add(listener);
            listenerGroups.put(document, list);
        }
    }

    public void removeTierSetListener(Transcription document, TierSetListener listener) {
        ArrayList<TierSetListener> listeners;
        if (listenerGroups.containsKey(document) && (listeners = listenerGroups.get(document)).contains(listener)) {
            listeners.remove(listener);
        }
    }

    public void notifyAllListeners(TierSet tierSet) {
        this.updateVisibleTierSetList();
        ArrayList<TierSetListener> listeners2 = null;
        for (ArrayList<TierSetListener> listeners2 : listenerGroups.values()) {
            if (listeners2 == null) continue;
            for (int i = 0; i < listeners2.size(); ++i) {
                listeners2.get(i).tierSetVisibilityChanged(tierSet);
            }
        }
    }

    public void notifyAllListeners(String tierName, boolean isVisible) {
        ArrayList<TierSetListener> listeners2 = null;
        for (ArrayList<TierSetListener> listeners2 : listenerGroups.values()) {
            if (listeners2 == null) continue;
            for (int i = 0; i < listeners2.size(); ++i) {
                listeners2.get(i).tierVisibilityChanged(tierName, isVisible);
            }
        }
    }

    public void notifyAllListeners() {
        this.updateVisibleTierSetList();
        ArrayList<TierSetListener> listeners2 = null;
        for (ArrayList<TierSetListener> listeners2 : listenerGroups.values()) {
            if (listeners2 == null) continue;
            for (int i = 0; i < listeners2.size(); ++i) {
                listeners2.get(i).tierSetChanged();
            }
        }
    }

    @Override
    public void preferencesChanged() {
    }

    public Boolean isVisibleTier(String name) {
        return this.getVisibleTiers().contains(name);
    }

    public List<String> getVisibleTiers() {
        ArrayList<String> tierList = new ArrayList<String>();
        for (String tierSetName : this.getVisibleTierSets()) {
            for (String tierName : this.getTierSet(tierSetName).getVisibleTierList()) {
                if (tierList.contains(tierName)) continue;
                tierList.add(tierName);
            }
        }
        return tierList;
    }

    public Boolean isTierInVisibleTierSets(String name) {
        return this.getTiersInVisibleTierSets().contains(name);
    }

    public List<String> getTiersInVisibleTierSets() {
        ArrayList<String> tierList = new ArrayList<String>();
        for (String tierSetName : this.getVisibleTierSets()) {
            for (String tierName : this.getTierSet(tierSetName).getTierList()) {
                if (tierList.contains(tierName)) continue;
                tierList.add(tierName);
            }
        }
        return tierList;
    }

    static {
        listenerGroups = new HashMap<Transcription, ArrayList<TierSetListener>>();
    }
}

