/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.csv.CSVWriter;
import mpi.eudico.client.annotator.timeseries.xml.XMLWriter;
import nl.mpi.util.FileExtension;

public class ExportTrack {
    public void exportTrack(AbstractTSTrack track) {
        this.exportTrack(null, track);
    }

    public void exportTrack(Component parent, AbstractTSTrack track) {
        if (track == null) {
            return;
        }
        String savePath = this.promptForTierFile(parent, track.getSource());
        if (savePath != null) {
            File tf = new File(savePath);
            try {
                int answer;
                if (tf.exists() && (answer = JOptionPane.showConfirmDialog(parent, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0, 2)) == 1) {
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
            String lower = savePath.toLowerCase();
            if (lower.endsWith("csv")) {
                try {
                    new CSVWriter().writeTrackToCSV(tf, track);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(parent, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
                }
            } else {
                try {
                    new XMLWriter().writeTrackToXML(tf, track);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(parent, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
                }
            }
        }
    }

    private String promptForTierFile(Component parent, String source) {
        int index;
        String prefPath = null;
        if (source != null && (index = (source = source.replaceAll("\\", "/")).lastIndexOf(47)) > -1) {
            prefPath = source.substring(index);
        }
        ArrayList<String[]> extensions = new ArrayList<String[]>();
        extensions.add(FileExtension.CSV_EXT);
        FileChooser chooser = new FileChooser(parent);
        if (prefPath != null) {
            chooser.setCurrentDirectory(prefPath);
        }
        chooser.createAndShowFileDialog(null, 1, extensions, FileExtension.XML_EXT, "LinkedFileDir", null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }
}

